/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import org.jacorb.idl.IntType;
import org.jacorb.idl.TypeSpec;

class ShortType
extends IntType {
    public ShortType(int n) {
        super(n);
    }

    public String typeName() {
        return "short";
    }

    public TypeSpec typeSpec() {
        return this;
    }

    public boolean basic() {
        return true;
    }

    public int getTCKind() {
        return 2;
    }

    public String toString() {
        return this.typeName();
    }

    public String holderName() {
        return "org.omg.CORBA.ShortHolder";
    }

    public String signature() {
        return "S";
    }

    public String printReadExpression(String string) {
        return string + ".read_short()";
    }

    public String printReadStatement(String string, String string2) {
        return string + "=" + string2 + ".read_short();";
    }

    public String printWriteStatement(String string, String string2) {
        return string2 + ".write_short(" + string + ");";
    }

    public String printInsertExpression() {
        return "insert_short";
    }

    public String printExtractExpression() {
        return "extract_short";
    }
}

