/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java_cup.runtime.symbol;
import org.jacorb.idl.Environment;
import org.jacorb.idl.Module;
import org.jacorb.idl.ParseException;
import org.jacorb.idl.Scope;
import org.jacorb.idl.ScopeData;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.lexer;
import org.jacorb.idl.parser;
import org.jacorb.idl.str_token;

class IdlSymbol
extends symbol
implements Serializable {
    private static int num = 10000;
    public String pack_name = "";
    String name = "";
    protected boolean is_pseudo = false;
    protected boolean included = false;
    protected boolean inhibitionFlag = parser.getInhibitionState();
    str_token token;
    private String _id;
    private String _version;
    protected IdlSymbol enclosing_symbol;
    protected String omg_package_prefix = "";
    String typeName;
    protected static final char fileSeparator = System.getProperty("file.separator").charAt(0);

    public IdlSymbol(int n) {
        super(n);
    }

    public void set_included(boolean bl) {
        this.included = bl;
    }

    public boolean is_included() {
        return this.included;
    }

    public void set_pseudo() {
        this.is_pseudo = true;
    }

    public boolean is_pseudo() {
        return this.is_pseudo;
    }

    public void set_token(str_token str_token2) {
        this.token = str_token2;
        if (this.token != null) {
            if (this.token.pragma_prefix.equals("omg.org")) {
                this.omg_package_prefix = "org.omg.";
            }
            this.set_name(this.token.str_val);
        }
    }

    public str_token get_token() {
        return this.token;
    }

    public void escapeName() {
        if (!this.name.startsWith("_") && lexer.strictJavaEscapeCheck(this.name)) {
            this.name = "_" + this.name;
        }
    }

    public void setPackage(String string) {
        string = parser.pack_replace(string);
        this.pack_name = this.pack_name.length() > 0 ? string + "." + this.pack_name : string;
    }

    public void setEnclosingSymbol(IdlSymbol idlSymbol) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != idlSymbol) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        Environment.output(5, "Symbol " + this.name + " of type " + this.getClass().getName() + " enclosed by symbol " + idlSymbol.getClass().getName());
        this.enclosing_symbol = idlSymbol;
    }

    public IdlSymbol getEnclosingSymbol() {
        return this.enclosing_symbol;
    }

    public static int new_num() {
        return num++;
    }

    public void set_name(String string) {
        this.name = string;
    }

    String full_name() {
        if (this.name.length() == 0) {
            return null;
        }
        if (this.pack_name.length() > 0) {
            return this.pack_name + "." + this.name;
        }
        return this.name;
    }

    String javaName() {
        if (this.name.length() == 0) {
            return null;
        }
        if (this.pack_name.length() > 0) {
            if (!this.pack_name.startsWith("org.omg")) {
                return this.omg_package_prefix + this.pack_name + "." + this.name;
            }
            return this.pack_name + "." + this.name;
        }
        return this.name;
    }

    public String omgPrefix() {
        return this.omg_package_prefix;
    }

    public void parse() throws ParseException {
    }

    public void print(PrintWriter printWriter) {
        throw new RuntimeException("--abstract--!");
    }

    public void printImport(PrintWriter printWriter) {
        if (!this.pack_name.equals("")) {
            Enumeration enumeration = parser.import_list.elements();
            while (enumeration.hasMoreElements()) {
                printWriter.println("import " + (String)enumeration.nextElement() + ";");
            }
        }
    }

    public void setPrintPhaseNames() {
        if (this.pack_name.length() > 0) {
            this.typeName = ScopedName.unPseudoName(this.pack_name + "." + this.name);
            if (!this.typeName.startsWith("org.omg")) {
                this.typeName = this.omg_package_prefix + this.typeName;
            }
            this.pack_name = this.typeName.substring(0, this.typeName.lastIndexOf("."));
        } else {
            this.typeName = ScopedName.unPseudoName(this.name);
        }
        Environment.output(2, "setPrintPhaseNames: pack_name " + this.pack_name + ", name " + this.name + " typename " + this.typeName);
    }

    public void printIdMethod(PrintWriter printWriter) {
        printWriter.println("\tpublic static String id()");
        printWriter.println("\t{");
        printWriter.println("\t\treturn \"" + this.id() + "\";");
        printWriter.println("\t}");
    }

    String id() {
        Environment.output(2, "Id for name " + this.name);
        IdlSymbol idlSymbol = this.enclosing_symbol;
        StringBuffer stringBuffer = new StringBuffer();
        if (this._id == null) {
            while (idlSymbol != null) {
                String string;
                str_token str_token2 = idlSymbol.get_token();
                if (str_token2 == null) {
                    idlSymbol = idlSymbol.getEnclosingSymbol();
                    continue;
                }
                if (this.token == null || !str_token2.pragma_prefix.equals(this.token.pragma_prefix)) break;
                String string2 = idlSymbol.name;
                if (idlSymbol instanceof Module && !(string = ((Module)idlSymbol).originalModuleName()).startsWith("org")) {
                    string2 = ((Module)idlSymbol).originalModuleName();
                }
                stringBuffer.insert(0, string2 + "/");
                idlSymbol = idlSymbol.getEnclosingSymbol();
            }
            stringBuffer.append(this.name);
            this._id = this.token != null && this.token.pragma_prefix.length() > 0 ? "IDL:" + this.token.pragma_prefix + "/" + stringBuffer.toString().replace('.', '/') + ":" + this.version() : "IDL:" + stringBuffer.toString().replace('.', '/') + ":" + this.version();
        }
        return this._id;
    }

    private String version() {
        IdlSymbol idlSymbol = this;
        if (this._version == null) {
            String string;
            Object object;
            block9: {
                while (true) {
                    Hashtable hashtable;
                    if (idlSymbol != null && !(idlSymbol instanceof Scope)) {
                        idlSymbol = idlSymbol.getEnclosingSymbol();
                        continue;
                    }
                    if (idlSymbol == null) break;
                    object = ((Scope)((Object)idlSymbol)).getScopeData();
                    if (object == null) {
                        System.err.println("ScopeDate null for " + this.name + " " + this.getClass().getName());
                        System.exit(1);
                    }
                    if ((string = (String)(hashtable = ((ScopeData)object).versionMap).get(this.name)) != null) {
                        this._version = string;
                        break block9;
                    }
                    idlSymbol = idlSymbol.getEnclosingSymbol();
                }
                this._version = "1.0";
            }
            if (idlSymbol != null) {
                idlSymbol = idlSymbol.getEnclosingSymbol();
            }
            while (true) {
                if (idlSymbol != null && !(idlSymbol instanceof Scope)) {
                    idlSymbol = idlSymbol.getEnclosingSymbol();
                    continue;
                }
                if (idlSymbol == null) break;
                object = ((Scope)((Object)idlSymbol)).getScopeData().versionMap;
                string = (String)((Hashtable)object).get(this.name);
                if (string != null) {
                    lexer.emit_error("Version for " + this.name + " already declared!", idlSymbol.get_token());
                    break;
                }
                idlSymbol = idlSymbol.getEnclosingSymbol();
            }
        }
        return this._version;
    }

    protected boolean generateIncluded() {
        return parser.generateIncluded() && !this.inhibitionFlag;
    }
}

