/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

public final class Environment {
    private static int _verbosity = 0;

    public static final int verbosityLevel() {
        return _verbosity;
    }

    public static final void verbosityLevel(int n) {
        _verbosity = n;
    }

    public static final void output(int n, String string) {
        if (n > _verbosity) {
            return;
        }
        System.out.println("   [ " + string + " ]");
    }

    public static void output(int n, String string, byte[] byArray) {
        Environment.output(n, string, byArray, byArray.length);
    }

    public static void output(int n, String string, byte[] byArray, int n2) {
        if (n > _verbosity) {
            return;
        }
        System.out.print("\nHexdump [" + string + "] len=" + n2 + "," + byArray.length);
        String string2 = "";
        int n3 = 0;
        while (n3 < n2) {
            if (0 == n3 % 16) {
                System.out.println(string2);
                string2 = "";
            }
            string2 = string2 + Environment.toAscii(byArray[n3]);
            System.out.print(Environment.toHex(byArray[n3]));
            if (3 == n3 % 4) {
                string2 = string2 + " ";
                System.out.print(" ");
            }
            ++n3;
        }
        System.out.println(string2);
    }

    public static final String toHex(byte by) {
        int n = (by & 0xFF) / 16;
        int n2 = (by & 0xFF) % 16;
        char c = n > 9 ? (char)(65 + (n - 10)) : (char)(48 + n);
        char c2 = n2 > 9 ? (char)(65 + (n2 - 10)) : (char)(48 + n2);
        return "" + c + c2 + " ";
    }

    public static final char toAscii(byte by) {
        if (by > 31 && by < 127) {
            return (char)by;
        }
        return '.';
    }

    public static final void output(int n, Throwable throwable) {
        if (n > _verbosity) {
            return;
        }
        System.out.println("############################ StackTrace ############################");
        throwable.printStackTrace(System.out);
        System.out.println("####################################################################");
    }
}

