/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.Enumeration;
import java.util.Vector;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.poa.EventMulticaster;
import org.jacorb.poa.RequestController;
import org.jacorb.poa.RequestQueueListener;
import org.jacorb.poa.except.ResourceLimitReachedException;
import org.jacorb.poa.util.LogTrace;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.poa.util.StringPair;
import org.jacorb.util.Environment;

public class RequestQueue {
    private RequestQueueListener queueListener;
    private RequestController controller;
    private LogTrace logTrace;
    private Vector queue = new Vector(10, 10);

    private RequestQueue() {
    }

    protected RequestQueue(RequestController requestController, LogTrace logTrace) {
        this.controller = requestController;
        this.logTrace = logTrace;
    }

    protected synchronized void add(ServerRequest serverRequest) throws ResourceLimitReachedException {
        if (this.queue.size() == Environment.queueMax()) {
            throw new ResourceLimitReachedException();
        }
        this.queue.addElement(serverRequest);
        if (this.queue.size() == 1) {
            this.controller.continueToWork();
        }
        this.logTrace.printLog(3, serverRequest, "is queued (queue size: " + this.queue.size() + ")");
        if (this.queueListener != null) {
            this.queueListener.requestAddedToQueue(serverRequest, this.queue.size());
        }
    }

    protected synchronized void addRequestQueueListener(RequestQueueListener requestQueueListener) {
        this.queueListener = EventMulticaster.add(this.queueListener, requestQueueListener);
    }

    protected synchronized StringPair[] deliverContent() {
        StringPair[] stringPairArray = new StringPair[this.queue.size()];
        Enumeration enumeration = this.queue.elements();
        int n = 0;
        while (n < stringPairArray.length) {
            ServerRequest serverRequest = (ServerRequest)enumeration.nextElement();
            stringPairArray[n] = new StringPair(serverRequest.requestId() + "", POAUtil.objectId_to_string(serverRequest.objectId()));
            ++n;
        }
        return stringPairArray;
    }

    protected synchronized ServerRequest getElementAndRemove(int n) {
        if (!this.queue.isEmpty()) {
            Enumeration enumeration = this.queue.elements();
            while (enumeration.hasMoreElements()) {
                ServerRequest serverRequest = (ServerRequest)enumeration.nextElement();
                if (serverRequest.requestId() != n) continue;
                this.queue.removeElement(serverRequest);
                if (this.queueListener != null) {
                    this.queueListener.requestRemovedFromQueue(serverRequest, this.queue.size());
                }
                return serverRequest;
            }
        }
        return null;
    }

    protected synchronized ServerRequest getFirst() {
        if (!this.queue.isEmpty()) {
            return (ServerRequest)this.queue.firstElement();
        }
        return null;
    }

    protected boolean isEmpty() {
        return this.queue.isEmpty();
    }

    protected synchronized ServerRequest removeFirst() {
        if (!this.queue.isEmpty()) {
            ServerRequest serverRequest = (ServerRequest)this.queue.elementAt(0);
            this.queue.removeElementAt(0);
            if (this.queueListener != null) {
                this.queueListener.requestRemovedFromQueue(serverRequest, this.queue.size());
            }
            return serverRequest;
        }
        return null;
    }

    protected synchronized ServerRequest removeLast() {
        if (!this.queue.isEmpty()) {
            ServerRequest serverRequest = (ServerRequest)this.queue.lastElement();
            this.queue.removeElementAt(this.queue.size() - 1);
            if (this.queueListener != null) {
                this.queueListener.requestRemovedFromQueue(serverRequest, this.queue.size());
            }
            return serverRequest;
        }
        return null;
    }

    protected synchronized void removeRequestQueueListener(RequestQueueListener requestQueueListener) {
        this.queueListener = EventMulticaster.remove(this.queueListener, requestQueueListener);
    }

    protected int size() {
        return this.queue.size();
    }
}

