/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jacorb.ir.gui.typesystem.AbstractContainer;
import org.jacorb.ir.gui.typesystem.ModelParticipant;
import org.jacorb.ir.gui.typesystem.NodeMapper;
import org.jacorb.ir.gui.typesystem.TypeAssociator;
import org.jacorb.ir.gui.typesystem.TypeSystem;
import org.jacorb.ir.gui.typesystem.TypeSystemNode;
import org.jacorb.ir.gui.typesystem.remote.RemoteTypeSystem;
import org.jacorb.util.Debug;

class IRBrowser
extends JFrame
implements WindowListener,
MouseListener,
ListSelectionListener,
TreeSelectionListener,
ActionListener {
    JTable contentTable;
    JSplitPane splitPane;
    JTree treeView;
    JTextArea textArea;
    TypeSystem typeSystem;
    TreeModel treeModel;
    JMenuItem followTypeMenu;
    private static final String title = "IRBrowser";

    public IRBrowser() {
        this.typeSystem = new RemoteTypeSystem();
        this.initialize();
    }

    public IRBrowser(String string) {
        this.typeSystem = new RemoteTypeSystem(string);
        this.initialize();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        NodeMapper nodeMapper = (NodeMapper)this.contentTable.getModel().getValueAt(this.contentTable.getSelectedRow(), 0);
        TypeSystemNode typeSystemNode = nodeMapper.getNode();
        this.followTypeOf(typeSystemNode);
        System.out.println("following type of " + typeSystemNode);
    }

    private void conn0(WindowEvent windowEvent) {
        try {
            this.dispose();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    public void followTypeOf(TypeSystemNode typeSystemNode) {
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        if (typeSystemNode instanceof TypeAssociator && ((ModelParticipant)(object = ((TypeAssociator)((Object)typeSystemNode)).getAssociatedTypeSystemNode())).getModelRepresentant(this.treeModel) != null) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)((ModelParticipant)object).getModelRepresentant(this.treeModel);
        }
        if (defaultMutableTreeNode != null) {
            System.out.println("expanding Tree: " + defaultMutableTreeNode);
            object = (DefaultTreeModel)this.treeView.getModel();
            TreePath treePath = new TreePath(((DefaultTreeModel)object).getPathToRoot(defaultMutableTreeNode));
            this.treeView.scrollPathToVisible(treePath);
            this.treeView.setSelectionPath(treePath);
            this.treeView.validate();
        }
    }

    private void handleException(Throwable throwable) {
        Debug.output(2, throwable);
    }

    private void initConnections() {
        this.addWindowListener(this);
    }

    public void initialize() {
        this.setTitle(title);
        this.splitPane = new JSplitPane(1);
        DefaultTableModel defaultTableModel = this.typeSystem.getTableModel(null);
        this.contentTable = new JTable(defaultTableModel);
        this.contentTable.setAutoCreateColumnsFromModel(true);
        this.contentTable.setColumnSelectionAllowed(false);
        this.contentTable.setRowSelectionAllowed(true);
        this.contentTable.setCellSelectionEnabled(false);
        this.contentTable.removeEditor();
        this.contentTable.setShowGrid(false);
        this.contentTable.setTableHeader(new JTableHeader(this.contentTable.getColumnModel()));
        this.contentTable.setAutoResizeMode(4);
        this.contentTable.setMinimumSize(new Dimension(100, 100));
        this.contentTable.getSelectionModel().addListSelectionListener(this);
        this.treeModel = this.typeSystem.getTreeModel();
        this.treeView = new JTree(this.treeModel);
        this.treeView.setRootVisible(true);
        this.treeView.setShowsRootHandles(true);
        this.treeView.setMinimumSize(new Dimension(100, 100));
        this.treeView.addTreeSelectionListener(this);
        JScrollPane jScrollPane = JTable.createScrollPaneForTable(this.contentTable);
        JScrollPane jScrollPane2 = new JScrollPane(this.treeView);
        jScrollPane.setMinimumSize(new Dimension(100, 100));
        jScrollPane2.setMinimumSize(new Dimension(100, 100));
        jScrollPane.setPreferredSize(new Dimension(100, 100));
        jScrollPane2.setPreferredSize(new Dimension(100, 100));
        this.textArea = new JTextArea("Hallo, hallo!");
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("sansserif", 0, 10));
        this.textArea.setRows(4);
        this.textArea.setTabSize(15);
        this.textArea.setBorder(BorderFactory.createLoweredBevelBorder());
        this.textArea.setMinimumSize(new Dimension(100, 100));
        this.textArea.setPreferredSize(new Dimension(600, 90));
        this.splitPane.setLeftComponent(new JScrollPane(this.treeView));
        this.splitPane.setRightComponent(jScrollPane);
        this.splitPane.setDividerLocation(300);
        Container container = this.getContentPane();
        this.splitPane.setBounds(0, 0, 600, 400 - this.textArea.getPreferredSize().height);
        this.textArea.setBounds(0, this.splitPane.bounds().height, 600, this.textArea.getPreferredSize().height);
        container.setLayout(new BorderLayout());
        container.add("Center", this.splitPane);
        container.add("South", this.textArea);
        container.setBackground(Color.white);
        this.resize(600, 400);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Navigate");
        jMenuBar.add(jMenu);
        this.followTypeMenu = new JMenuItem("Follow Type");
        this.followTypeMenu.setEnabled(false);
        this.followTypeMenu.addActionListener(this);
        jMenu.add(this.followTypeMenu);
        this.setJMenuBar(jMenuBar);
        this.validate();
        this.treeView.expandPath(new TreePath(((DefaultMutableTreeNode)this.treeModel.getRoot()).getPath()));
        this.treeView.addMouseListener(this);
        this.contentTable.addMouseListener(this);
        this.setName(title);
        this.setName(title);
        this.initConnections();
    }

    private static void usage() {
        System.err.println("usage: IRBrowser [ IOR | -f <ior_file ]");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        Window window = null;
        String string = null;
        if (stringArray.length > 2) {
            IRBrowser.usage();
        } else if (stringArray.length == 2 && stringArray[0].equals("-f")) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[1]));
                string = bufferedReader.readLine();
                while (string.indexOf("IOR:") != 0) {
                    string = bufferedReader.readLine();
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                IRBrowser.usage();
            }
            window = new IRBrowser(string);
        } else {
            window = stringArray.length == 1 ? new IRBrowser(stringArray[0]) : new IRBrowser();
        }
        window.show();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        if (mouseEvent.getComponent() == this.contentTable && mouseEvent.getClickCount() > 1 && this.contentTable.getSelectedRow() != -1) {
            Object object;
            System.out.println("contentTable doubleClick");
            NodeMapper nodeMapper = (NodeMapper)this.contentTable.getModel().getValueAt(this.contentTable.getSelectedRow(), 0);
            TypeSystemNode typeSystemNode = nodeMapper.getNode();
            if (typeSystemNode instanceof AbstractContainer) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)typeSystemNode.getModelRepresentant(this.treeModel);
            }
            if (typeSystemNode instanceof TypeAssociator && ((ModelParticipant)(object = ((TypeAssociator)((Object)typeSystemNode)).getAssociatedTypeSystemNode())).getModelRepresentant(this.treeModel) != null) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)((ModelParticipant)object).getModelRepresentant(this.treeModel);
            }
            if (defaultMutableTreeNode != null) {
                System.out.println("expanding Tree: " + defaultMutableTreeNode);
                object = (DefaultTreeModel)this.treeView.getModel();
                TreePath treePath = new TreePath(((DefaultTreeModel)object).getPathToRoot(defaultMutableTreeNode));
                this.treeView.scrollPathToVisible(treePath);
                this.treeView.setSelectionPath(treePath);
                this.treeView.validate();
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void setSelectedNode(TypeSystemNode typeSystemNode) {
        this.setTitle("IRBrowser - " + typeSystemNode.getAbsoluteName());
        this.textArea.setText(typeSystemNode.description());
        if (typeSystemNode instanceof TypeAssociator) {
            this.followTypeMenu.setEnabled(true);
        } else {
            this.followTypeMenu.setEnabled(false);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        NodeMapper nodeMapper;
        TypeSystemNode typeSystemNode;
        if (this.contentTable.getSelectedRow() != -1 && (typeSystemNode = (nodeMapper = (NodeMapper)this.contentTable.getModel().getValueAt(this.contentTable.getSelectedRow(), 0)).getNode()) != null) {
            this.setSelectedNode(typeSystemNode);
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Debug.output(4, "IRBrowser: valueChanged (Tree...)");
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
        TypeSystemNode typeSystemNode = (TypeSystemNode)defaultMutableTreeNode.getUserObject();
        this.contentTable.setModel(this.typeSystem.getTableModel(defaultMutableTreeNode));
        this.contentTable.clearSelection();
        TableColumnModel tableColumnModel = this.contentTable.getColumnModel();
        int n = 0;
        while (n < this.contentTable.getColumnCount()) {
            TableColumn tableColumn = tableColumnModel.getColumn(n);
            tableColumn.setCellEditor(null);
            ++n;
        }
        this.setSelectedNode(typeSystemNode);
        this.contentTable.validate();
        this.treeView.validate();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        System.exit(0);
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this) {
            this.conn0(windowEvent);
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

