/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.dynany;

import java.util.Vector;
import org.jacorb.orb.Any;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.dynany.DynAny;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.InputStream;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode;
import org.omg.DynamicAny.DynAnyPackage.InvalidValue;
import org.omg.DynamicAny.DynAnyPackage.TypeMismatch;
import org.omg.DynamicAny.DynSequenceOperations;

public final class DynSequence
extends DynAny
implements DynSequenceOperations {
    private Vector members;
    private int length;
    private TypeCode elementType;

    DynSequence(ORB oRB, DynAnyFactory dynAnyFactory, Any any) throws TypeMismatch, InvalidValue {
        super(oRB, dynAnyFactory, any);
    }

    DynSequence(ORB oRB, DynAnyFactory dynAnyFactory, TypeCode typeCode) throws InvalidValue, TypeMismatch {
        if (typeCode.kind() != TCKind.tk_sequence) {
            throw new TypeMismatch();
        }
        try {
            this.type = typeCode;
            this.orb = oRB;
            this.dynFactory = dynAnyFactory;
            this.elementType = typeCode.content_type();
            this.limit = typeCode.length();
            this.length = 0;
            this.members = new Vector();
        }
        catch (BadKind badKind) {
            badKind.printStackTrace();
        }
    }

    public void from_any(org.omg.CORBA.Any any) throws InvalidValue, TypeMismatch {
        if (!this.type().equal(any.type())) {
            System.err.println("expected tc kind " + this.type().kind().value() + ", got " + any.type().kind().value());
            try {
                System.err.println("expected element tc kind " + this.type().content_type().kind().value() + ", got " + any.type().content_type().kind().value());
                System.err.println("expected length " + this.type().length() + ", got " + any.type().length());
            }
            catch (BadKind badKind) {
                badKind.printStackTrace();
            }
            throw new TypeMismatch();
        }
        try {
            this.limit = this.type().length();
            InputStream inputStream = any.create_input_stream();
            this.length = inputStream.read_long();
            if (this.length > 0) {
                this.pos = 0;
            }
            if (this.limit != 0 && this.length > this.limit) {
                throw new InvalidValue();
            }
            this.members = new Vector(this.length);
            this.elementType = this.type().content_type();
            int n = 0;
            while (n < this.length) {
                Any any2 = (Any)this.orb.create_any();
                any2.read_value(inputStream, this.elementType);
                this.members.addElement(any2);
                ++n;
            }
        }
        catch (BadKind badKind) {
            badKind.printStackTrace();
        }
    }

    public org.omg.CORBA.Any to_any() {
        Any any = (Any)this.orb.create_any();
        any.type(this.type());
        CDROutputStream cDROutputStream = new CDROutputStream();
        cDROutputStream.write_long(this.length);
        int n = 0;
        while (n < this.length) {
            cDROutputStream.write_value(this.elementType, (CDRInputStream)((Any)this.members.elementAt(n)).create_input_stream());
            ++n;
        }
        CDRInputStream cDRInputStream = new CDRInputStream(this.orb, cDROutputStream.getBufferCopy());
        any.read_value(cDRInputStream, this.type());
        return any;
    }

    public int get_length() {
        return this.length;
    }

    public void set_length(int n) throws InvalidValue {
        if (this.limit > 0 && n > this.limit) {
            throw new InvalidValue();
        }
        if (n == 0) {
            this.members = new Vector();
            this.pos = -1;
        }
        if (n > this.length) {
            try {
                int n2 = this.length;
                while (n2 < n) {
                    this.members.addElement(this.dynFactory.create_dyn_any_from_type_code(this.elementType).to_any());
                    ++n2;
                }
            }
            catch (InconsistentTypeCode inconsistentTypeCode) {
                inconsistentTypeCode.printStackTrace();
            }
            if (this.pos != -1) {
                this.pos = this.length + 1;
            }
        } else if (n < this.length) {
            this.members.setSize(n);
            if (this.pos > n) {
                this.pos = -1;
            }
        }
        this.length = n;
    }

    public org.omg.CORBA.Any[] get_elements() {
        org.omg.CORBA.Any[] anyArray = new Any[this.members.size()];
        int n = this.members.size();
        while (n-- > 0) {
            anyArray[n] = (Any)this.members.elementAt(n);
        }
        return anyArray;
    }

    public void set_elements(org.omg.CORBA.Any[] anyArray) throws TypeMismatch, InvalidValue {
        if (this.limit > 0 && anyArray.length > this.limit) {
            throw new InvalidValue();
        }
        int n = anyArray.length;
        while (n-- > 0) {
            if (anyArray[n].type().kind() == this.elementType.kind()) continue;
            throw new TypeMismatch();
        }
        this.length = anyArray.length;
        this.members = new Vector();
        int n2 = 0;
        while (n2 < this.length) {
            this.members.addElement(anyArray[n2]);
            ++n2;
        }
        this.pos = this.length > 0 ? 0 : -1;
    }

    public org.omg.DynamicAny.DynAny[] get_elements_as_dyn_any() {
        org.omg.DynamicAny.DynAny[] dynAnyArray = new org.omg.DynamicAny.DynAny[this.members.size()];
        try {
            int n = this.members.size();
            while (n-- > 0) {
                dynAnyArray[n] = this.dynFactory.create_dyn_any((Any)this.members.elementAt(n));
            }
            return dynAnyArray;
        }
        catch (InconsistentTypeCode inconsistentTypeCode) {
            inconsistentTypeCode.printStackTrace();
            return null;
        }
    }

    public void set_elements_as_dyn_any(org.omg.DynamicAny.DynAny[] dynAnyArray) throws TypeMismatch, InvalidValue {
        org.omg.CORBA.Any[] anyArray = new org.omg.CORBA.Any[dynAnyArray.length];
        int n = dynAnyArray.length;
        while (n-- > 0) {
            anyArray[n] = dynAnyArray[n].to_any();
        }
        this.set_elements(anyArray);
    }

    public void destroy() {
        super.destroy();
        this.members.removeAllElements();
        this.members = null;
        this.elementType = null;
    }

    public boolean next() {
        if (this.pos < this.length - 1) {
            ++this.pos;
            return true;
        }
        this.pos = -1;
        return false;
    }

    public boolean seek(int n) {
        if (n < 0) {
            this.pos = -1;
            return false;
        }
        if (n < this.length) {
            this.pos = this.limit;
            return true;
        }
        this.pos = -1;
        return false;
    }

    public org.omg.DynamicAny.DynAny current_component() {
        if (this.pos == -1) {
            return null;
        }
        try {
            return this.dynFactory.create_dyn_any((Any)this.members.elementAt(this.pos));
        }
        catch (InconsistentTypeCode inconsistentTypeCode) {
            inconsistentTypeCode.printStackTrace();
            return null;
        }
    }

    public int component_count() {
        return this.get_length();
    }
}

