/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.domain;

import org.jacorb.orb.domain.Domain;
import org.jacorb.orb.domain.DomainFactoryPOA;
import org.jacorb.orb.domain.DomainHelper;
import org.jacorb.orb.domain.DomainImpl;
import org.jacorb.orb.domain.ORBDomain;
import org.jacorb.util.Debug;
import org.omg.CORBA.BAD_CONTEXT;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.POAPackage.WrongPolicy;

public class DomainFactoryImpl
extends DomainFactoryPOA {
    private ORBDomain theORBDomain = null;

    public Domain createDomain(Object[] objectArray, Policy[] policyArray, String string) {
        DomainImpl domainImpl = new DomainImpl(objectArray, policyArray, string);
        Domain domain = null;
        try {
            domain = DomainHelper.narrow(this._poa().servant_to_reference(domainImpl));
            this.getORBDomain().insertLocalDomain(domain);
        }
        catch (WrongPolicy wrongPolicy) {
            Debug.output(1, "the poa of this domain(" + this + ") has the wrong policies for \"servant_to_reference\".");
        }
        catch (Exception exception) {
            Debug.output(1, exception);
        }
        Debug.output(4, "Domain.createDomain: finished.");
        Debug.assert(2, domain != null, "DomainFactoryImpl.createDomain: result is null");
        Debug.assert(2, domain.isRoot(), "DomainFactoryImpl.createDomain: result isnot a root domain");
        return domain;
    }

    public Domain createEmptyDomain() {
        DomainImpl domainImpl = new DomainImpl();
        Domain domain = null;
        try {
            domain = DomainHelper.narrow(this._poa().servant_to_reference(domainImpl));
            this.getORBDomain().insertLocalDomain(domain);
        }
        catch (WrongPolicy wrongPolicy) {
            Debug.output(1, "DomainFactory.createEmptyDomain:the poa of this domain(" + this + ") has the wrong policies for \"servant_to_reference\".");
        }
        catch (Exception exception) {
            Debug.output(1, exception);
        }
        return domain;
    }

    public void clear(Domain domain) {
        Debug.assert(1, domain.getChildCount() == 0, "DomainFactory.clear: cannot clear a domain with child domains, remove child domains first.");
        Domain[] domainArray = domain.getParents();
        Policy[] policyArray = domain.getPolicies();
        Domain[] domainArray2 = domain.getParents();
        int n = 0;
        while (n < domainArray.length) {
            domain.deleteParent(domainArray[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < domainArray2.length) {
            domain.deleteMember(domainArray2[n2]);
            ++n2;
        }
        int n3 = 0;
        while (n3 < policyArray.length) {
            domain.deletePolicyOfType(policyArray[n3].policy_type());
            ++n3;
        }
    }

    public void destroy(Domain domain) {
        if (domain.getChildCount() > 0 || domain.getParentCount() > 0) {
            throw new BAD_CONTEXT();
        }
        this.clear(domain);
        this.getORBDomain().removeLocalDomain(domain);
    }

    private final ORBDomain getORBDomain() {
        if (this.theORBDomain == null) {
            try {
                return (ORBDomain)this._orb().resolve_initial_references("LocalDomainService");
            }
            catch (InvalidName invalidName) {
                Debug.output(32769, invalidName);
            }
        }
        return this.theORBDomain;
    }
}

