/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.connection.http;

import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jacorb.orb.connection.ConnectionManager;
import org.jacorb.orb.connection.LocateReplyInputStream;
import org.jacorb.orb.connection.LocateRequestOutputStream;
import org.jacorb.orb.connection.ReplyInputStream;
import org.jacorb.orb.connection.ReplyReceptor;
import org.jacorb.orb.connection.RequestOutputStream;
import org.jacorb.orb.factory.SocketFactory;
import org.jacorb.util.Debug;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.InputStream;

public final class ClientConnection
extends org.jacorb.orb.connection.ClientConnection {
    static int counter = 0;
    int mycounter = counter++;
    boolean connected = true;
    java.lang.Object notifier;
    HTTPResponse rsp;
    String host = null;
    int port;

    public ClientConnection(ConnectionManager connectionManager, String string, int n, SocketFactory socketFactory) {
        this.manager = connectionManager;
        this.orb = connectionManager.getORB();
        this.host = string;
        this.port = n;
        this.connection_info = this.host + ":" + this.port;
        this.socket_factory = socketFactory;
    }

    protected void abort() throws EOFException {
        Debug.output(3, "HTTPClient Connection " + this.mycounter + " to " + this.connection_info + " aborting...->Ex");
        Enumeration enumeration = this.replies.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            ReplyInputStream replyInputStream = (ReplyInputStream)this.replies.get(enumeration.nextElement());
            replyInputStream.cancel();
            ++n;
        }
        this.replies.clear();
        this.buffers.clear();
        this.objects.clear();
        if (n > 0) {
            Debug.output(2, "Lost " + n + " outstanding replies");
        }
        throw new EOFException();
    }

    public synchronized void closeConnection() {
        this.manager.removeConnection(this);
        this.connected = false;
    }

    public boolean connected() {
        return true;
    }

    public Hashtable get_buffers() {
        return this.buffers;
    }

    public Hashtable get_objects() {
        return this.objects;
    }

    public Hashtable get_replies() {
        return this.replies;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized byte[] readBuffer() throws IOException {
        while (this.repReceptor == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        java.lang.Object object = this.notifier;
        synchronized (object) {
            while (this.rsp == null) {
                try {
                    this.notifier.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        try {
            this.in_stream = new BufferedInputStream(this.rsp.getInputStream());
            return super.readBuffer();
        }
        catch (Exception exception) {
            Debug.output(1, "This is a Client->Server HTTP Connection. ReadBuffer calls can only be done after some send call+receiveReply()");
        }
        return super.readBuffer();
    }

    public synchronized void reconnect() throws COMM_FAILURE {
        Debug.output(1, "Trying to reconnect to " + this.connection_info);
    }

    public LocateReplyInputStream sendLocateRequest(LocateRequestOutputStream locateRequestOutputStream) throws COMM_FAILURE {
        java.lang.Object object = this.writeLock;
        synchronized (object) {
            java.lang.Object object2;
            LocateReplyInputStream locateReplyInputStream = null;
            try {
                this.rsp = null;
                this.notifier = new java.lang.Object();
                this.repReceptor = new ReplyReceptor(this, true);
                object2 = locateRequestOutputStream.getBufferCopy();
                locateReplyInputStream = new LocateReplyInputStream((ORB)this.orb, locateRequestOutputStream.requestId());
                Integer n = new Integer(locateRequestOutputStream.requestId());
                this.buffers.put(n, locateRequestOutputStream);
                this.replies.put(n, locateReplyInputStream);
                java.lang.Object object3 = this.notifier;
                synchronized (object3) {
                    HTTPConnection hTTPConnection = new HTTPConnection("http://" + this.host + ":" + this.port);
                    this.rsp = hTTPConnection.Post("", (byte[])object2);
                    Thread.yield();
                    this.notifier.notifyAll();
                }
            }
            catch (Exception exception) {
                Debug.output(2, exception);
                throw new COMM_FAILURE();
            }
            object2 = locateReplyInputStream;
            return object2;
        }
    }

    public InputStream sendRequest(Object object, RequestOutputStream requestOutputStream) throws COMM_FAILURE {
        java.lang.Object object2 = this.writeLock;
        synchronized (object2) {
            java.lang.Object object3;
            ReplyInputStream replyInputStream = null;
            try {
                java.lang.Object object4;
                this.rsp = null;
                this.notifier = new java.lang.Object();
                this.repReceptor = new ReplyReceptor(this, true);
                int n = -1;
                object3 = requestOutputStream.getBufferCopy();
                n = ((byte[])object3).length;
                if (requestOutputStream.response_expected()) {
                    replyInputStream = new ReplyInputStream((ORB)this.orb, requestOutputStream.requestId());
                    object4 = new Integer(requestOutputStream.requestId());
                    this.buffers.put(object4, requestOutputStream);
                    this.replies.put(object4, replyInputStream);
                    this.objects.put(object4, object);
                }
                object4 = this.notifier;
                synchronized (object4) {
                    HTTPConnection hTTPConnection = new HTTPConnection(new URL("http://" + this.host + ":" + this.port));
                    this.rsp = hTTPConnection.Post("", (byte[])object3);
                    Thread.yield();
                    this.notifier.notifyAll();
                }
            }
            catch (Exception exception) {
                Debug.output(2, exception);
                throw new COMM_FAILURE();
            }
            object3 = replyInputStream;
            return object3;
        }
    }

    public void setTimeOut(int n) throws SocketException {
    }

    public void writeDirectly(byte[] byArray, int n) throws IOException {
        java.lang.Object object = this.writeLock;
        synchronized (object) {
            Debug.output(2, "Sending request with writeDirectly");
            try {
                this.notifier = new java.lang.Object();
                this.repReceptor = new ReplyReceptor(this, true);
                byte[] byArray2 = new byte[n];
                System.arraycopy(byArray, 0, byArray2, 0, n);
                int n2 = n;
                java.lang.Object object2 = this.notifier;
                synchronized (object2) {
                    HTTPConnection hTTPConnection = new HTTPConnection(new URL("http://" + this.host + ":" + this.port));
                    this.rsp = hTTPConnection.Post("", byArray2);
                    Thread.yield();
                    this.notifier.notifyAll();
                }
            }
            catch (Exception exception) {
                Debug.output(2, exception);
                throw new COMM_FAILURE();
            }
        }
    }
}

