/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.InterfaceBody;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.Scope;
import org.jacorb.idl.ScopeData;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.SymbolList;
import org.jacorb.idl.TypeDeclaration;
import org.jacorb.idl.TypeMap;
import org.jacorb.idl.parser;

class Interface
extends TypeDeclaration
implements Scope {
    public InterfaceBody body = null;
    public SymbolList inheritanceSpec = null;
    private String[] ids = null;
    private boolean locality_constraint = false;
    private boolean is_abstract = false;
    private ScopeData scopeData;
    private Hashtable irInfoTable = new Hashtable();

    public Interface(int n) {
        super(n);
        this.pack_name = "";
    }

    public void setScopeData(ScopeData scopeData) {
        this.scopeData = scopeData;
    }

    public ScopeData getScopeData() {
        return this.scopeData;
    }

    public void setPackage(String string) {
        string = parser.pack_replace(string);
        this.pack_name = this.pack_name.length() > 0 ? new String(string + "." + this.pack_name) : string;
        if (this.body != null) {
            this.body.setPackage(string);
        }
        if (this.inheritanceSpec != null) {
            this.inheritanceSpec.setPackage(string);
        }
    }

    public void set_abstract() {
        this.is_abstract = true;
    }

    public TypeDeclaration declaration() {
        return this;
    }

    public String typeName() {
        return this.full_name();
    }

    public Object clone() {
        throw new RuntimeException("Don't clone me, i am an interface!");
    }

    public void setEnclosingSymbol(IdlSymbol idlSymbol) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != idlSymbol) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = idlSymbol;
    }

    public String signature() {
        return "L" + this.typeName() + ";";
    }

    public void set_locality(boolean bl) {
        this.locality_constraint = bl;
    }

    public String getTypeCodeExpression() {
        return "org.omg.CORBA.ORB.init().create_interface_tc( \"" + this.id() + "\", \"" + this.name + "\")";
    }

    public boolean basic() {
        return true;
    }

    public String holderName() {
        return this.toString() + "Holder";
    }

    public String toString() {
        String string = this.typeName();
        if (!string.startsWith("org.omg")) {
            return this.omgPrefix() + string;
        }
        return string;
    }

    public void set_included(boolean bl) {
        this.included = bl;
    }

    public String printReadExpression(String string) {
        return this.javaName() + "Helper.read(" + string + ")";
    }

    public String printWriteStatement(String string, String string2) {
        return this.javaName() + "Helper.write(" + string2 + "," + string + ");";
    }

    public void parse() {
        boolean bl;
        block13: {
            bl = false;
            this.escapeName();
            ConstrTypeSpec constrTypeSpec = new ConstrTypeSpec(IdlSymbol.new_num());
            try {
                ScopedName.definePseudoScope(this.full_name());
                constrTypeSpec.c_type_spec = this;
                if (this.is_pseudo) {
                    NameTable.define(this.full_name(), "pseudo interface");
                } else {
                    NameTable.define(this.full_name(), "interface");
                }
                TypeMap.typedef(this.full_name(), constrTypeSpec);
            }
            catch (NameAlreadyDefined nameAlreadyDefined) {
                if (this.body != null) {
                    bl = true;
                }
                if (this.full_name().equals("org.omg.CORBA.TypeCode") || this.body == null) break block13;
                TypeMap.replaceForwardDeclaration(this.full_name(), constrTypeSpec);
            }
        }
        if (this.body != null) {
            if (this.inheritanceSpec != null && this.inheritanceSpec.v.size() > 0) {
                Enumeration enumeration = this.inheritanceSpec.v.elements();
                while (enumeration.hasMoreElements()) {
                    try {
                        ScopedName scopedName = (ScopedName)enumeration.nextElement();
                        ConstrTypeSpec constrTypeSpec = (ConstrTypeSpec)scopedName.resolvedTypeSpec();
                        if (constrTypeSpec.declaration() instanceof Interface) {
                            continue;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    parser.fatal_error("Illegal inheritance spec: " + this.inheritanceSpec, this.token);
                }
                this.body.set_ancestors(this.inheritanceSpec);
            }
            this.body.parse();
            NameTable.parsed_interfaces.put(this.full_name(), "");
        } else if (!bl) {
            parser.set_pending(this.full_name());
        }
    }

    InterfaceBody getBody() {
        if (parser.get_pending(this.full_name()) != null) {
            parser.fatal_error(this.full_name() + " is forward declared and still pending!", this.token);
        } else if (this.body == null) {
            if ((Interface)((ConstrTypeSpec)TypeMap.map((String)this.full_name())).c_type_spec != this) {
                this.body = ((Interface)((ConstrTypeSpec)TypeMap.map((String)this.full_name())).c_type_spec).getBody();
            }
            if (this.body == null) {
                parser.fatal_error(this.full_name() + " still has an empty body!", this.token);
            }
        }
        return this.body;
    }

    private void printInterface(String string, PrintWriter printWriter) {
        block11: {
            Enumeration enumeration;
            block10: {
                Serializable serializable;
                if (!this.pack_name.equals("")) {
                    printWriter.println("package " + this.pack_name + ";\n");
                }
                printWriter.println("/**");
                printWriter.println(" * Generated by the JacORB IDL compiler.");
                printWriter.println(" */");
                if (this.inheritanceSpec.v.size() > 0) {
                    enumeration = this.inheritanceSpec.v.elements();
                    while (enumeration.hasMoreElements()) {
                        serializable = (ScopedName)enumeration.nextElement();
                        if (((ScopedName)serializable).resolvedName().indexOf(46) >= 0) continue;
                        printWriter.print("import " + serializable + ";");
                    }
                }
                this.printImport(printWriter);
                if (!this.is_pseudo) break block10;
                printWriter.println("public abstract class " + string);
                if (this.inheritanceSpec.v.size() <= 0) break block11;
                enumeration = new StringBuffer();
                serializable = new StringBuffer();
                String string2 = " ";
                Enumeration enumeration2 = this.inheritanceSpec.v.elements();
                while (enumeration2.hasMoreElements()) {
                    ScopedName scopedName = (ScopedName)enumeration2.nextElement();
                    String string3 = scopedName.resolvedName();
                    if (scopedName.is_pseudo()) {
                        ((StringBuffer)((Object)enumeration)).append(string2 + string3);
                    } else {
                        ((StringBuffer)serializable).append(string2 + string3);
                    }
                    if (this.inheritanceSpec.v.size() <= 1) continue;
                    string2 = ",";
                }
                if (((StringBuffer)((Object)enumeration)).length() > 0) {
                    printWriter.println("\textends " + ((StringBuffer)((Object)enumeration)).toString());
                }
                if (((StringBuffer)serializable).length() <= 0) break block11;
                printWriter.println("\timplements " + ((StringBuffer)serializable).toString());
                break block11;
            }
            printWriter.println("public interface " + string);
            printWriter.print("\textends " + string + "Operations, org.omg.CORBA.Object, org.omg.CORBA.portable.IDLEntity");
            if (this.inheritanceSpec.v.size() > 0) {
                enumeration = this.inheritanceSpec.v.elements();
                while (enumeration.hasMoreElements()) {
                    printWriter.print(", " + (ScopedName)enumeration.nextElement());
                }
            }
        }
        printWriter.println("\n{");
        if (this.body != null) {
            this.body.printConstants(printWriter);
            this.body.printInterfaceMethods(printWriter);
        }
        printWriter.println("}");
    }

    private String indentString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("   ");
            ++n2;
        }
        return stringBuffer.toString();
    }

    private void printOperations(String string, PrintWriter printWriter) {
        Enumeration enumeration;
        if (!this.pack_name.equals("")) {
            printWriter.println("package " + this.pack_name + ";\n");
        }
        printWriter.println("/**");
        printWriter.println(" * Generated by the JacORB IDL compiler.");
        printWriter.println(" */");
        if (this.inheritanceSpec.v.size() > 0) {
            enumeration = this.inheritanceSpec.v.elements();
            while (enumeration.hasMoreElements()) {
                ScopedName scopedName = (ScopedName)enumeration.nextElement();
                if (scopedName.resolvedName().indexOf(46) >= 0) continue;
                printWriter.print("import " + scopedName + ";");
            }
        }
        this.printImport(printWriter);
        printWriter.println("public interface " + string + "Operations");
        if (this.inheritanceSpec.v.size() > 0) {
            printWriter.print("\textends ");
            enumeration = this.inheritanceSpec.v.elements();
            printWriter.print((ScopedName)enumeration.nextElement() + "Operations");
            while (enumeration.hasMoreElements()) {
                printWriter.print(", " + (ScopedName)enumeration.nextElement() + "Operations");
            }
            printWriter.print("\n");
        }
        printWriter.println("{");
        if (this.body != null) {
            this.body.printOperationSignatures(printWriter);
        }
        printWriter.println("}");
    }

    private void printHolder(String string, PrintWriter printWriter) {
        if (!this.pack_name.equals("")) {
            printWriter.println("package " + this.pack_name + ";\n");
        }
        printWriter.println("/**");
        printWriter.println(" * Generated by the JacORB IDL compiler.");
        printWriter.println(" */");
        printWriter.print("public class " + string + "Holder");
        printWriter.print("\timplements org.omg.CORBA.portable.Streamable");
        printWriter.println("{");
        printWriter.println("\t public " + string + " value;");
        printWriter.println("\tpublic " + string + "Holder()");
        printWriter.println("\t{");
        printWriter.println("\t}");
        printWriter.println("\tpublic " + string + "Holder(" + string + " initial)");
        printWriter.println("\t{");
        printWriter.println("\t\tvalue = initial;");
        printWriter.println("\t}");
        printWriter.println("\tpublic org.omg.CORBA.TypeCode _type()");
        printWriter.println("\t{");
        printWriter.println("\t\treturn " + string + "Helper.type();");
        printWriter.println("\t}");
        printWriter.println("\tpublic void _read(org.omg.CORBA.portable.InputStream in)");
        printWriter.println("\t{");
        printWriter.println("\t\tvalue = " + string + "Helper.read(in);");
        printWriter.println("\t}");
        printWriter.println("\tpublic void _write(org.omg.CORBA.portable.OutputStream _out)");
        printWriter.println("\t{");
        printWriter.println("\t\t" + string + "Helper.write(_out,value);");
        printWriter.println("\t}");
        printWriter.println("}");
    }

    private void printHelper(String string, PrintWriter printWriter) {
        if (!this.pack_name.equals("")) {
            printWriter.println("package " + this.pack_name + ";");
        }
        this.printImport(printWriter);
        printWriter.println("/**");
        printWriter.println(" * Generated by the JacORB IDL compiler.");
        printWriter.println(" */");
        printWriter.println("public class " + string + "Helper");
        printWriter.println("{");
        printWriter.println("\tpublic " + string + "Helper()");
        printWriter.println("\t{");
        printWriter.println("\t}");
        printWriter.println("\tpublic static void insert(org.omg.CORBA.Any any, " + this.typeName() + " s)");
        printWriter.println("\t{");
        printWriter.println("\t\tany.insert_Object(s);");
        printWriter.println("\t}");
        printWriter.println("\tpublic static " + this.typeName() + " extract(org.omg.CORBA.Any any)");
        printWriter.println("\t{");
        printWriter.println("\t\treturn narrow(any.extract_Object());");
        printWriter.println("\t}");
        printWriter.println("\tpublic static org.omg.CORBA.TypeCode type()");
        printWriter.println("\t{");
        printWriter.println("\t\treturn " + this.getTypeCodeExpression() + ";");
        printWriter.println("\t}");
        this.printIdMethod(printWriter);
        printWriter.println("\tpublic static " + string + " read(org.omg.CORBA.portable.InputStream in)");
        printWriter.println("\t{");
        printWriter.println("\t\treturn narrow( in.read_Object());");
        printWriter.println("\t}");
        printWriter.println("\tpublic static void write(org.omg.CORBA.portable.OutputStream _out, " + this.typeName() + " s)");
        printWriter.println("\t{");
        printWriter.println("\t\t_out.write_Object(s);");
        printWriter.println("\t}");
        printWriter.println("\tpublic static " + this.typeName() + " narrow(org.omg.CORBA.Object obj)");
        printWriter.println("\t{");
        printWriter.println("\t\tif( obj == null )");
        printWriter.println("\t\t\treturn null;");
        if (parser.generate_stubs) {
            printWriter.println("\t\ttry");
            printWriter.println("\t\t{");
            printWriter.println("\t\t\treturn (" + this.typeName() + ")obj;");
            printWriter.println("\t\t}");
            printWriter.println("\t\tcatch( ClassCastException c )");
            printWriter.println("\t\t{");
            printWriter.println("\t\t\tif( obj._is_a(\"" + this.id() + "\"))");
            printWriter.println("\t\t\t{");
            String string2 = this.typeName();
            string2 = string2.indexOf(46) > -1 ? string2.substring(0, this.typeName().lastIndexOf(46)) + "._" + string2.substring(string2.lastIndexOf(46) + 1) + "Stub" : "_" + string2 + "Stub";
            printWriter.println("\t\t\t\t" + string2 + " stub;");
            printWriter.println("\t\t\t\tstub = new " + string2 + "();");
            printWriter.println("\t\t\t\tstub._set_delegate(((org.omg.CORBA.portable.ObjectImpl)obj)._get_delegate());");
            printWriter.println("\t\t\t\treturn stub;");
            printWriter.println("\t\t\t}");
            printWriter.println("\t\t}");
            printWriter.println("\t\tthrow new org.omg.CORBA.BAD_PARAM(\"Narrow failed\");");
        } else {
            printWriter.println("\t\tif( obj instanceof " + this.typeName() + " )");
            printWriter.println("\t\t\treturn (" + this.typeName() + ")obj;");
            printWriter.println("\t\telse");
            printWriter.println("\t\tthrow new org.omg.CORBA.BAD_PARAM(\"Narrow failed, not a " + this.typeName() + "\");");
        }
        printWriter.println("\t}");
        printWriter.println("\tpublic void write_Object(org.omg.CORBA.portable.OutputStream _out, java.lang.Object obj)");
        printWriter.println("\t{");
        printWriter.println("\t\t throw new RuntimeException(\" not implemented\");");
        printWriter.println("\t}");
        printWriter.println("\tpublic java.lang.Object read_Object(org.omg.CORBA.portable.InputStream in)");
        printWriter.println("\t{");
        printWriter.println("\t\t throw new RuntimeException(\" not implemented\");");
        printWriter.println("\t}");
        printWriter.println("\tpublic String get_id()");
        printWriter.println("\t{");
        printWriter.println("\t\treturn id();");
        printWriter.println("\t}");
        printWriter.println("\tpublic org.omg.CORBA.TypeCode get_type()");
        printWriter.println("\t{");
        printWriter.println("\t\treturn type();");
        printWriter.println("\t}");
        printWriter.println("}");
    }

    private String[] get_ids() {
        if (this.ids == null) {
            Enumeration<Object> enumeration;
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            if (this.inheritanceSpec != null && this.inheritanceSpec.v.size() > 0) {
                enumeration = this.inheritanceSpec.v.elements();
                while (enumeration.hasMoreElements()) {
                    ScopedName scopedName = (ScopedName)enumeration.nextElement();
                    Interface interface_ = null;
                    try {
                        interface_ = (Interface)((ConstrTypeSpec)scopedName.resolvedTypeSpec()).c_type_spec;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        parser.fatal_error("Cannot find base interface " + scopedName, this.token);
                    }
                    String[] stringArray = interface_.get_ids();
                    int n = 0;
                    while (n < stringArray.length) {
                        if (!hashtable.contains(stringArray[n])) {
                            hashtable.put(stringArray[n], "");
                        }
                        ++n;
                    }
                }
            }
            if (hashtable.size() == 0) {
                hashtable.put("IDL:omg.org/CORBA/Object:1.0", "");
            }
            enumeration = hashtable.keys();
            this.ids = new String[hashtable.size() + 1];
            this.ids[0] = this.id();
            int n = 1;
            while (n < this.ids.length) {
                this.ids[n] = (String)enumeration.nextElement();
                ++n;
            }
        }
        return this.ids;
    }

    private void printStub(String string, PrintWriter printWriter) {
        if (!this.pack_name.equals("")) {
            printWriter.println("package " + this.pack_name + ";\n");
        }
        this.printImport(printWriter);
        printWriter.println("/**");
        printWriter.println(" * Generated by the JacORB IDL compiler.");
        printWriter.println(" */");
        printWriter.println("public class _" + string + "Stub");
        printWriter.println("\textends org.omg.CORBA.portable.ObjectImpl");
        printWriter.println("\timplements " + this.javaName());
        printWriter.println("{");
        printWriter.print("\tprivate String[] ids = {");
        String[] stringArray = this.get_ids();
        int n = 0;
        while (n < stringArray.length - 1) {
            printWriter.print("\"" + stringArray[n] + "\",");
            ++n;
        }
        printWriter.println("\"" + stringArray[stringArray.length - 1] + "\"};");
        printWriter.println("\tpublic String[] _ids()");
        printWriter.println("\t{");
        printWriter.println("\t\treturn ids;");
        printWriter.println("\t}\n");
        printWriter.print("\tpublic final static java.lang.Class _opsClass = ");
        if (!this.pack_name.equals("")) {
            printWriter.print(this.pack_name + ".");
        }
        printWriter.println(string + "Operations.class;");
        this.body.printStubMethods(printWriter, string, this.locality_constraint);
        printWriter.println("}");
    }

    private void printImplSkeleton(String string, PrintWriter printWriter) {
        if (!this.pack_name.equals("")) {
            printWriter.println("package " + this.pack_name + ";\n");
        }
        printWriter.println("/**");
        printWriter.println(" * Generated by the JacORB IDL compiler.");
        printWriter.println(" */");
        this.printImport(printWriter);
        printWriter.print("public abstract class " + string + "POA");
        printWriter.println("\n\textends org.omg.PortableServer.Servant");
        printWriter.println("\timplements org.omg.CORBA.portable.InvokeHandler, " + this.javaName() + "Operations");
        printWriter.println("{");
        this.body.printOperationsHash(printWriter);
        printWriter.print("\tprivate String[] ids = {");
        String[] stringArray = this.get_ids();
        int n = 0;
        while (n < stringArray.length - 1) {
            printWriter.print("\"" + stringArray[n] + "\",");
            ++n;
        }
        printWriter.println("\"" + stringArray[stringArray.length - 1] + "\"};");
        printWriter.println("\tpublic " + this.javaName() + " _this()");
        printWriter.println("\t{");
        printWriter.println("\t\treturn " + this.javaName() + "Helper.narrow(_this_object());");
        printWriter.println("\t}");
        printWriter.println("\tpublic " + this.javaName() + " _this(org.omg.CORBA.ORB orb)");
        printWriter.println("\t{");
        printWriter.println("\t\treturn " + this.javaName() + "Helper.narrow(_this_object(orb));");
        printWriter.println("\t}");
        printWriter.println("\tpublic org.omg.CORBA.portable.OutputStream _invoke(String method, org.omg.CORBA.portable.InputStream _input, org.omg.CORBA.portable.ResponseHandler handler)");
        printWriter.println("\t\tthrows org.omg.CORBA.SystemException");
        printWriter.println("\t{");
        printWriter.println("\t\torg.omg.CORBA.portable.OutputStream _out = null;");
        printWriter.println("\t\t// do something");
        this.body.printSkelInvocations(printWriter);
        printWriter.println("\t}\n");
        printWriter.println("\tpublic String[] _all_interfaces(org.omg.PortableServer.POA poa, byte[] obj_id)");
        printWriter.println("\t{");
        printWriter.println("\t\treturn ids;");
        printWriter.println("\t}");
        printWriter.println("}");
    }

    private void printTieSkeleton(String string, PrintWriter printWriter) {
        if (!this.pack_name.equals("")) {
            printWriter.println("package " + this.pack_name + ";\n");
        }
        printWriter.println("import org.omg.PortableServer.POA;");
        this.printImport(printWriter);
        printWriter.println("/**");
        printWriter.println(" * Generated by the JacORB IDL compiler.");
        printWriter.println(" */");
        printWriter.println("public class " + string + "POATie");
        printWriter.println("\textends " + string + "POA");
        printWriter.println("{");
        printWriter.println("\tprivate " + string + "Operations _delegate;\n");
        printWriter.println("\tprivate POA _poa;");
        printWriter.println("\tpublic " + string + "POATie(" + string + "Operations delegate)");
        printWriter.println("\t{");
        printWriter.println("\t\t_delegate = delegate;");
        printWriter.println("\t}");
        printWriter.println("\tpublic " + string + "POATie(" + string + "Operations delegate, POA poa)");
        printWriter.println("\t{");
        printWriter.println("\t\t_delegate = delegate;");
        printWriter.println("\t\t_poa = poa;");
        printWriter.println("\t}");
        printWriter.println("\tpublic " + this.javaName() + " _this()");
        printWriter.println("\t{");
        printWriter.println("\t\treturn " + this.javaName() + "Helper.narrow(_this_object());");
        printWriter.println("\t}");
        printWriter.println("\tpublic " + this.javaName() + " _this(org.omg.CORBA.ORB orb)");
        printWriter.println("\t{");
        printWriter.println("\t\treturn " + this.javaName() + "Helper.narrow(_this_object(orb));");
        printWriter.println("\t}");
        printWriter.println("\tpublic " + string + "Operations _delegate()");
        printWriter.println("\t{");
        printWriter.println("\t\treturn _delegate;");
        printWriter.println("\t}");
        printWriter.println("\tpublic void _delegate(" + string + "Operations delegate)");
        printWriter.println("\t{");
        printWriter.println("\t\t_delegate = delegate;");
        printWriter.println("\t}");
        this.body.printDelegatedMethods(printWriter);
        printWriter.println("}");
    }

    private void printIRHelper(String string, PrintWriter printWriter) {
        if (!this.pack_name.equals("")) {
            printWriter.println("package " + this.pack_name + ";");
        }
        printWriter.println("\n/**");
        printWriter.println(" * DO NOT EDIT. This class contains Interface Repository ");
        printWriter.println(" * information generated by the JacORB IDL compiler.");
        printWriter.println(" */");
        printWriter.println("\npublic class " + string + "IRHelper");
        printWriter.println("{");
        printWriter.println("\tpublic static java.util.Hashtable irInfo = new java.util.Hashtable();");
        printWriter.println("\tstatic");
        printWriter.println("\t{");
        this.body.getIRInfo(this.irInfoTable);
        Enumeration enumeration = this.irInfoTable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            printWriter.println("\t\tirInfo.put(\"" + string2 + "\", \"" + (String)this.irInfoTable.get(string2) + "\");");
        }
        printWriter.println("\t}");
        printWriter.println("}");
    }

    public void print(PrintWriter printWriter) {
        if (this.included && !this.generateIncluded()) {
            return;
        }
        if (this.body != null) {
            try {
                String string = parser.out_dir + IdlSymbol.fileSeparator + this.pack_name.replace('.', IdlSymbol.fileSeparator);
                File file = new File(string);
                if (!file.exists() && !file.mkdirs()) {
                    System.err.println("Unable to create " + string);
                    System.exit(1);
                }
                PrintWriter printWriter2 = new PrintWriter(new FileWriter(new File(file, this.name + ".java")));
                this.printInterface(this.name, printWriter2);
                printWriter2.close();
                if (!this.is_pseudo) {
                    printWriter2 = new PrintWriter(new FileWriter(new File(file, this.name + "Operations.java")));
                    this.printOperations(this.name, printWriter2);
                    printWriter2.close();
                    printWriter2 = new PrintWriter(new FileWriter(new File(file, this.name + "Helper.java")));
                    this.printHelper(this.name, printWriter2);
                    printWriter2.close();
                    printWriter2 = new PrintWriter(new FileWriter(new File(file, this.name + "Holder.java")));
                    this.printHolder(this.name, printWriter2);
                    printWriter2.close();
                    if (parser.generate_stubs) {
                        printWriter2 = new PrintWriter(new FileWriter(new File(file, "_" + this.name + "Stub.java")));
                        this.printStub(this.name, printWriter2);
                        printWriter2.close();
                    }
                    if (parser.generate_skeletons) {
                        printWriter2 = new PrintWriter(new FileWriter(new File(file, this.name + "POA.java")));
                        this.printImplSkeleton(this.name, printWriter2);
                        printWriter2.close();
                        printWriter2 = new PrintWriter(new FileWriter(new File(file, this.name + "POATie.java")));
                        this.printTieSkeleton(this.name, printWriter2);
                        printWriter2.close();
                    }
                    if (parser.generateIR) {
                        printWriter2 = new PrintWriter(new FileWriter(new File(file, this.name + "IRHelper.java")));
                        this.printIRHelper(this.name, printWriter2);
                        printWriter2.close();
                    }
                }
                this.body.print(null);
            }
            catch (IOException iOException) {
                System.err.println("File IO error");
                iOException.printStackTrace();
            }
        }
    }
}

