/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import org.jacorb.idl.BaseType;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.SwitchTypeSpec;
import org.jacorb.idl.TypeSpec;

class CharType
extends BaseType
implements SwitchTypeSpec {
    private boolean wide = false;

    public CharType(int n) {
        super(n);
    }

    public Object clone() {
        CharType charType = new CharType(IdlSymbol.new_num());
        if (this.wide) {
            charType.setWide();
        }
        return charType;
    }

    public boolean isWide() {
        return this.wide;
    }

    public void setWide() {
        this.wide = true;
    }

    public String typeName() {
        return "char";
    }

    public TypeSpec typeSpec() {
        return this;
    }

    public String toString() {
        return this.typeName();
    }

    public boolean basic() {
        return true;
    }

    public int getTCKind() {
        if (this.wide) {
            return 26;
        }
        return 9;
    }

    public String holderName() {
        return "org.omg.CORBA.CharHolder";
    }

    public String signature() {
        return "C";
    }

    public String printReadExpression(String string) {
        if (this.wide) {
            return string + ".read_wchar()";
        }
        return string + ".read_char()";
    }

    public String printWriteStatement(String string, String string2) {
        if (this.wide) {
            return string2 + ".write_wchar(" + string + ");";
        }
        return string2 + ".write_char(" + string + ");";
    }

    public String printInsertExpression() {
        if (this.wide) {
            return "insert_wchar";
        }
        return "insert_char";
    }

    public String printExtractExpression() {
        if (this.wide) {
            return "extract_wchar";
        }
        return "extract_char";
    }
}

