/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.dynany;

import org.jacorb.orb.Any;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.dynany.DynAny;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.InputStream;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode;
import org.omg.DynamicAny.DynAnyPackage.InvalidValue;
import org.omg.DynamicAny.DynAnyPackage.TypeMismatch;
import org.omg.DynamicAny.DynArrayOperations;

public final class DynArray
extends DynAny
implements DynArrayOperations {
    private TypeCode elementType;
    private org.omg.CORBA.Any[] members;

    DynArray(ORB oRB, DynAnyFactory dynAnyFactory, Any any) throws TypeMismatch, InvalidValue {
        super(oRB, dynAnyFactory, any);
    }

    DynArray(ORB oRB, DynAnyFactory dynAnyFactory, TypeCode typeCode) throws InvalidValue, TypeMismatch {
        if (typeCode.kind() != TCKind.tk_array) {
            throw new TypeMismatch();
        }
        try {
            this.type = typeCode;
            this.orb = oRB;
            this.dynFactory = dynAnyFactory;
            this.elementType = typeCode.content_type();
            this.limit = typeCode.length();
            this.members = new Any[this.limit];
            try {
                int n = this.limit;
                while (n-- > 0) {
                    this.members[n] = dynAnyFactory.create_dyn_any_from_type_code(this.elementType).to_any();
                }
            }
            catch (InconsistentTypeCode inconsistentTypeCode) {
                inconsistentTypeCode.printStackTrace();
            }
        }
        catch (BadKind badKind) {
            badKind.printStackTrace();
        }
    }

    public void from_any(org.omg.CORBA.Any any) throws InvalidValue, TypeMismatch {
        if (!this.type.equal(any.type())) {
            throw new TypeMismatch();
        }
        this.type = any.type();
        try {
            this.limit = this.type().length();
            this.elementType = this.type().content_type();
            if (this.limit > 0) {
                this.pos = 0;
            }
            InputStream inputStream = any.create_input_stream();
            this.members = new org.omg.CORBA.Any[this.limit];
            int n = 0;
            while (n < this.limit) {
                this.members[n] = org.omg.CORBA.ORB.init().create_any();
                this.members[n].read_value(inputStream, this.elementType);
                ++n;
            }
        }
        catch (BadKind badKind) {
            badKind.printStackTrace();
        }
    }

    public org.omg.CORBA.Any to_any() {
        Any any = (Any)org.omg.CORBA.ORB.init().create_any();
        any.type(this.type());
        CDROutputStream cDROutputStream = new CDROutputStream();
        int n = 0;
        while (n < this.limit) {
            cDROutputStream.write_value(this.elementType, (CDRInputStream)this.members[n].create_input_stream());
            ++n;
        }
        CDRInputStream cDRInputStream = new CDRInputStream(this.orb, cDROutputStream.getBufferCopy());
        any.read_value(cDRInputStream, this.type());
        return any;
    }

    public org.omg.CORBA.Any[] get_elements() {
        return this.members;
    }

    public void set_elements(org.omg.CORBA.Any[] anyArray) throws TypeMismatch, InvalidValue {
        if (anyArray.length != this.limit) {
            throw new InvalidValue();
        }
        int n = anyArray.length;
        while (n-- > 0) {
            if (anyArray[n].type().kind() == this.elementType.kind()) continue;
            throw new TypeMismatch();
        }
        this.members = anyArray;
    }

    public org.omg.DynamicAny.DynAny[] get_elements_as_dyn_any() {
        org.omg.DynamicAny.DynAny[] dynAnyArray = new org.omg.DynamicAny.DynAny[this.members.length];
        try {
            int n = this.members.length;
            while (n-- > 0) {
                dynAnyArray[n] = this.dynFactory.create_dyn_any(this.members[n]);
            }
            return dynAnyArray;
        }
        catch (InconsistentTypeCode inconsistentTypeCode) {
            inconsistentTypeCode.printStackTrace();
            return null;
        }
    }

    public void set_elements_as_dyn_any(org.omg.DynamicAny.DynAny[] dynAnyArray) throws TypeMismatch, InvalidValue {
        org.omg.CORBA.Any[] anyArray = new org.omg.CORBA.Any[dynAnyArray.length];
        int n = dynAnyArray.length;
        while (n-- > 0) {
            anyArray[n] = dynAnyArray[n].to_any();
        }
        this.set_elements(anyArray);
    }

    public void destroy() {
        super.destroy();
        this.members = null;
        this.elementType = null;
    }

    public org.omg.DynamicAny.DynAny current_component() {
        if (this.pos == -1) {
            return null;
        }
        try {
            return this.dynFactory.create_dyn_any(this.members[this.pos]);
        }
        catch (InconsistentTypeCode inconsistentTypeCode) {
            inconsistentTypeCode.printStackTrace();
            return null;
        }
    }
}

