/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.connection.http.httpserver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jacorb.orb.connection.http.httpserver.ServeInputStream;
import org.jacorb.orb.connection.http.httpserver.ServeOutputStream;

public class ServeConnection {
    private Socket socket;
    private ServeInputStream in;
    private ServeOutputStream out;
    private Vector cookies = new Vector();
    public static final int SC_CONTINUE = 100;
    public static final int SC_SWITCHING_PROTOCOLS = 101;
    public static final int SC_OK = 200;
    public static final int SC_CREATED = 201;
    public static final int SC_ACCEPTED = 202;
    public static final int SC_NON_AUTHORITATIVE_INFORMATION = 203;
    public static final int SC_NO_CONTENT = 204;
    public static final int SC_RESET_CONTENT = 205;
    public static final int SC_PARTIAL_CONTENT = 206;
    public static final int SC_MULTIPLE_CHOICES = 300;
    public static final int SC_MOVED_PERMANENTLY = 301;
    public static final int SC_MOVED_TEMPORARILY = 302;
    public static final int SC_SEE_OTHER = 303;
    public static final int SC_NOT_MODIFIED = 304;
    public static final int SC_USE_PROXY = 305;
    public static final int SC_BAD_REQUEST = 400;
    public static final int SC_UNAUTHORIZED = 401;
    public static final int SC_PAYMENT_REQUIRED = 402;
    public static final int SC_FORBIDDEN = 403;
    public static final int SC_NOT_FOUND = 404;
    public static final int SC_METHOD_NOT_ALLOWED = 405;
    public static final int SC_NOT_ACCEPTABLE = 406;
    public static final int SC_PROXY_AUTHENTICATION_REQUIRED = 407;
    public static final int SC_REQUEST_TIMEOUT = 408;
    public static final int SC_CONFLICT = 409;
    public static final int SC_GONE = 410;
    public static final int SC_LENGTH_REQUIRED = 411;
    public static final int SC_PRECONDITION_FAILED = 412;
    public static final int SC_REQUEST_ENTITY_TOO_LARGE = 413;
    public static final int SC_REQUEST_URI_TOO_LONG = 414;
    public static final int SC_UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int SC_INTERNAL_SERVER_ERROR = 500;
    public static final int SC_NOT_IMPLEMENTED = 501;
    public static final int SC_BAD_GATEWAY = 502;
    public static final int SC_SERVICE_UNAVAILABLE = 503;
    public static final int SC_GATEWAY_TIMEOUT = 504;
    public static final int SC_HTTP_VERSION_NOT_SUPPORTED = 505;
    private String reqMethod = null;
    private String reqUriPath = null;
    private String reqProtocol = null;
    private boolean oneOne;
    private boolean reqMime;
    String reqQuery = null;
    private Vector reqHeaderNames = new Vector();
    private Vector reqHeaderValues = new Vector();
    Vector queryNames = null;
    Vector queryValues = null;
    private int resCode = -1;
    private String resMessage = null;
    private Vector resHeaderNames = new Vector();
    private Vector resHeaderValues = new Vector();
    private static final String[] weekdays = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private boolean headersWritten = false;

    public ServeConnection(Socket socket, InputStream inputStream) {
        this.socket = socket;
        try {
            this.in = new ServeInputStream(inputStream);
            this.out = new ServeOutputStream(socket.getOutputStream(), this);
        }
        catch (IOException iOException) {
            this.problem("Getting streams: " + iOException.getMessage(), 400);
        }
        this.parseRequest();
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void parseRequest() {
        byte[] byArray = new byte[4096];
        try {
            String string;
            int n = this.in.readLine(byArray, 0, byArray.length);
            if (n == -1 || n == 0) {
                this.problem("Empty request", 400);
                return;
            }
            String string2 = new String(byArray, 0, n);
            String[] stringArray = ServeConnection.splitStr(string2);
            switch (stringArray.length) {
                case 2: {
                    this.reqProtocol = "HTTP/0.9";
                    this.oneOne = false;
                    this.reqMime = false;
                    break;
                }
                case 3: {
                    this.reqProtocol = stringArray[2];
                    this.oneOne = !this.reqProtocol.toUpperCase().equals("HTTP/1.0");
                    this.reqMime = true;
                    while ((n = this.in.readLine(byArray, 0, byArray.length)) != -1 && n != 0) {
                        string2 = new String(byArray, 0, n);
                        int n2 = string2.indexOf(": ");
                        if (n2 == -1) continue;
                        String string3 = string2.substring(0, n2);
                        String string4 = string2.substring(n2 + 2);
                        this.reqHeaderNames.addElement(string3.toLowerCase());
                        this.reqHeaderValues.addElement(string4);
                    }
                    break;
                }
                default: {
                    this.problem("Malformed request line", 400);
                    return;
                }
            }
            this.reqMethod = stringArray[0];
            this.reqUriPath = stringArray[1];
            if (this.oneOne && (string = this.getHeader("host")) == null) {
                this.problem("Host header missing on HTTP/1.1 request", 400);
                return;
            }
            int n3 = this.reqUriPath.indexOf(63);
            if (n3 != -1) {
                this.reqQuery = this.reqUriPath.substring(n3 + 1);
                this.reqUriPath = this.reqUriPath.substring(0, n3);
            }
            this.reqUriPath = this.decode(this.reqUriPath);
        }
        catch (Exception exception) {
            this.problem("Reading request: " + exception.getMessage(), 400);
        }
    }

    public void answerRequest(byte[] byArray) {
        this.setStatus(200);
        this.setDateHeader("Date", System.currentTimeMillis());
        this.setHeader("Server", "JacORB builtin HTTPServer");
        this.setHeader("Connection", "close");
        try {
            this.out.write(byArray, 0, byArray.length);
            this.out.flush();
            this.out.close();
        }
        catch (Exception exception) {
            this.problem("unexpected problem running servlet: " + exception.toString(), 500);
        }
    }

    private void problem(String string, int n) {
        try {
            this.sendError(n);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String decode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '%' && n2 + 2 < n) {
                char c2 = string.charAt(n2 + 1);
                char c3 = string.charAt(n2 + 2);
                if (this.isHexit(c2) && this.isHexit(c3)) {
                    stringBuffer.append((char)(this.hexit(c2) * 16 + this.hexit(c3)));
                    n2 += 2;
                } else {
                    stringBuffer.append(c);
                }
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private boolean isHexit(char c) {
        String string = "0123456789abcdefABCDEF";
        return string.indexOf(c) != -1;
    }

    private int hexit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return 0;
    }

    public int getContentLength() {
        return this.getIntHeader("content-length", -1);
    }

    public String getContentType() {
        return this.getHeader("content-type");
    }

    public String getProtocol() {
        return this.reqProtocol;
    }

    public String getScheme() {
        return "http";
    }

    public String getServerName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public int getServerPort() {
        return this.socket.getLocalPort();
    }

    public String getRemoteAddr() {
        return this.socket.getInetAddress().toString();
    }

    public String getRemoteHost() {
        return this.socket.getInetAddress().getHostName();
    }

    public String getRealPath(String string) {
        return "/";
    }

    public ServeInputStream getInputStream() throws IOException {
        return this.in;
    }

    public BufferedReader getReader() {
        return null;
    }

    public Enumeration getParameterNames() {
        if (this.queryNames == null) {
            this.queryNames = new Vector();
            this.queryValues = new Vector();
            String string = this.getQueryString();
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
                while (stringTokenizer.hasMoreElements()) {
                    String string2;
                    String string3;
                    String string4 = (String)stringTokenizer.nextElement();
                    int n = string4.indexOf(61);
                    if (n == -1) {
                        string3 = string4;
                        string2 = "";
                    } else {
                        string3 = string4.substring(0, n);
                        string2 = string4.substring(n + 1);
                    }
                    this.queryNames.addElement(string3);
                    this.queryValues.addElement(string2);
                }
            }
        }
        return this.queryNames.elements();
    }

    public String getParameter(String string) {
        Enumeration enumeration = this.getParameterNames();
        int n = this.queryNames.indexOf(string);
        if (n == -1) {
            return null;
        }
        return (String)this.queryValues.elementAt(n);
    }

    public String[] getParameterValues(String string) {
        Object[] objectArray;
        Vector vector = new Vector();
        Enumeration enumeration = this.getParameterNames();
        int n = 0;
        while (n < this.queryNames.size()) {
            objectArray = (Object[])this.queryNames.elementAt(n);
            if (string.equals(objectArray)) {
                vector.addElement(this.queryValues.elementAt(n));
            }
            ++n;
        }
        if (vector.size() == 0) {
            return null;
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Object getAttribute(String string) {
        return null;
    }

    public String getMethod() {
        return this.reqMethod;
    }

    public String getRequestURI() {
        String string = "";
        int n = this.getServerPort();
        if (n != 80) {
            string = ":" + n;
        }
        String string2 = "";
        String string3 = this.getQueryString();
        if (string3 != null && string3.length() > 0) {
            string2 = "?" + string3;
        }
        return "http://" + this.getServerName() + string + this.reqUriPath + string2;
    }

    public String getServletPath() {
        return this.reqUriPath;
    }

    public String getPathInfo() {
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getQueryString() {
        return this.reqQuery;
    }

    public String getRemoteUser() {
        return null;
    }

    public String getAuthType() {
        return null;
    }

    public String getHeader(String string) {
        int n = this.reqHeaderNames.indexOf(string.toLowerCase());
        if (n == -1) {
            return null;
        }
        return (String)this.reqHeaderValues.elementAt(n);
    }

    public int getIntHeader(String string, int n) {
        String string2 = this.getHeader(string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public long getLongHeader(String string, long l) {
        String string2 = this.getHeader(string);
        if (string2 == null) {
            return l;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (Exception exception) {
            return l;
        }
    }

    public long getDateHeader(String string, long l) {
        String string2 = this.getHeader(string);
        if (string2 == null) {
            return l;
        }
        try {
            return DateFormat.getDateInstance().parse(string2).getTime();
        }
        catch (Exception exception) {
            return l;
        }
    }

    public Enumeration getHeaderNames() {
        return this.reqHeaderNames.elements();
    }

    public String getRequestedSessionId() {
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public void setContentLength(int n) {
        this.setIntHeader("Content-length", n);
    }

    public void setContentType(String string) {
        this.setHeader("Content-type", string);
    }

    public ServeOutputStream getOutputStream() {
        return this.out;
    }

    public PrintWriter getWriter() throws IOException {
        return null;
    }

    public String getCharacterEncoding() {
        return null;
    }

    public boolean containsHeader(String string) {
        return this.resHeaderNames.contains(string);
    }

    public void setStatus(int n, String string) {
        this.resCode = n;
        this.resMessage = string;
    }

    public void setStatus(int n) {
        switch (n) {
            case 100: {
                this.setStatus(n, "Continue");
                break;
            }
            case 101: {
                this.setStatus(n, "Switching protocols");
                break;
            }
            case 200: {
                this.setStatus(n, "Ok");
                break;
            }
            case 201: {
                this.setStatus(n, "Created");
                break;
            }
            case 202: {
                this.setStatus(n, "Accepted");
                break;
            }
            case 203: {
                this.setStatus(n, "Non-authoritative");
                break;
            }
            case 204: {
                this.setStatus(n, "No content");
                break;
            }
            case 205: {
                this.setStatus(n, "Reset content");
                break;
            }
            case 206: {
                this.setStatus(n, "Partial content");
                break;
            }
            case 300: {
                this.setStatus(n, "Multiple choices");
                break;
            }
            case 301: {
                this.setStatus(n, "Moved permanentently");
                break;
            }
            case 302: {
                this.setStatus(n, "Moved temporarily");
                break;
            }
            case 303: {
                this.setStatus(n, "See other");
                break;
            }
            case 304: {
                this.setStatus(n, "Not modified");
                break;
            }
            case 305: {
                this.setStatus(n, "Use proxy");
                break;
            }
            case 400: {
                this.setStatus(n, "Bad request");
                break;
            }
            case 401: {
                this.setStatus(n, "Unauthorized");
                break;
            }
            case 402: {
                this.setStatus(n, "Payment required");
                break;
            }
            case 403: {
                this.setStatus(n, "Forbidden");
                break;
            }
            case 404: {
                this.setStatus(n, "Not found");
                break;
            }
            case 405: {
                this.setStatus(n, "Method not allowed");
                break;
            }
            case 406: {
                this.setStatus(n, "Not acceptable");
                break;
            }
            case 407: {
                this.setStatus(n, "Proxy auth required");
                break;
            }
            case 408: {
                this.setStatus(n, "Request timeout");
                break;
            }
            case 409: {
                this.setStatus(n, "Conflict");
                break;
            }
            case 410: {
                this.setStatus(n, "Gone");
                break;
            }
            case 411: {
                this.setStatus(n, "Length required");
                break;
            }
            case 412: {
                this.setStatus(n, "Precondition failed");
                break;
            }
            case 413: {
                this.setStatus(n, "Request entity too large");
                break;
            }
            case 414: {
                this.setStatus(n, "Request URI too large");
                break;
            }
            case 415: {
                this.setStatus(n, "Unsupported media type");
                break;
            }
            case 500: {
                this.setStatus(n, "Internal server error");
                break;
            }
            case 501: {
                this.setStatus(n, "Not implemented");
                break;
            }
            case 502: {
                this.setStatus(n, "Bad gateway");
                break;
            }
            case 503: {
                this.setStatus(n, "Service unavailable");
                break;
            }
            case 504: {
                this.setStatus(n, "Gateway timeout");
                break;
            }
            case 505: {
                this.setStatus(n, "HTTP version not supported");
                break;
            }
            default: {
                this.setStatus(n, "");
            }
        }
    }

    public void setHeader(String string, String string2) {
        this.resHeaderNames.addElement(string);
        this.resHeaderValues.addElement(string2);
    }

    public void setIntHeader(String string, int n) {
        this.setHeader(string, Integer.toString(n));
    }

    public void setLongHeader(String string, long l) {
        this.setHeader(string, Long.toString(l));
    }

    public void setDateHeader(String string, long l) {
        this.setHeader(string, ServeConnection.to1123String(new Date(l)));
    }

    private static String to1123String(Date date) {
        int n;
        int n2 = date.getDay();
        int n3 = date.getDate();
        String string = date.toGMTString();
        int n4 = Integer.parseInt(string.substring(0, n = string.indexOf(32)));
        int n5 = n4 > n3 || n4 < n3 && n4 == 1 ? (n2 + 1) % 7 : (n3 > n4 || n3 < n4 && n3 == 1 ? (n2 + 6) % 7 : n2);
        return weekdays[n5] + (n4 < 10 ? ", 0" : ", ") + string;
    }

    void writeHeaders() throws IOException {
        if (this.headersWritten) {
            return;
        }
        this.headersWritten = true;
        if (this.reqMime) {
            this.out.println(this.reqProtocol + " " + this.resCode + " " + this.resMessage);
            int n = 0;
            while (n < this.resHeaderNames.size()) {
                String string = (String)this.resHeaderNames.elementAt(n);
                String string2 = (String)this.resHeaderValues.elementAt(n);
                if (string2 != null) {
                    this.out.println(string + ": " + string2);
                }
                ++n;
            }
            this.out.println("");
            this.out.flush();
        }
    }

    public void sendError(int n, String string) throws IOException {
        this.setStatus(n, string);
        this.realSendError();
    }

    public void sendError(int n) throws IOException {
        this.setStatus(n);
        this.realSendError();
    }

    private void realSendError() throws IOException {
        this.setContentType("text/html");
        this.out.println("<HTML><HEAD>");
        this.out.println("<TITLE>" + this.resCode + " " + this.resMessage + "</TITLE>");
        this.out.println("</HEAD><BODY BGCOLOR=\"#99cc99\">");
        this.out.println("<H2>" + this.resCode + " " + this.resMessage + "</H2>");
        this.out.println("<HR>");
        this.out.println("</BODY></HTML>");
        this.out.flush();
    }

    public void sendRedirect(String string) throws IOException {
        this.setHeader("Location", string);
        this.sendError(302);
    }

    public String encodeUrl(String string) {
        return string;
    }

    public String encodeRedirectUrl(String string) {
        return string;
    }

    public static String[] splitStr(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        return stringArray;
    }
}

