/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.connection;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jacorb.orb.BufferManager;
import org.jacorb.orb.ORB;
import org.jacorb.orb.connection.AbstractConnection;
import org.jacorb.orb.connection.CloseConnectionException;
import org.jacorb.orb.connection.ConnectionManager;
import org.jacorb.orb.connection.LocateReplyInputStream;
import org.jacorb.orb.connection.LocateRequestOutputStream;
import org.jacorb.orb.connection.Messages;
import org.jacorb.orb.connection.ReplyInputStream;
import org.jacorb.orb.connection.ReplyReceptor;
import org.jacorb.orb.connection.RequestOutputStream;
import org.jacorb.orb.factory.SocketFactory;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.Object;

public class ClientConnection
extends AbstractConnection {
    private int id_count = 0;
    protected String connection_info = null;
    protected InputStream in_stream;
    BufferedOutputStream out_stream;
    protected ConnectionManager manager;
    public java.lang.Object writeLock = new java.lang.Object();
    protected Hashtable objects = new Hashtable();
    protected Hashtable buffers = new Hashtable();
    protected Hashtable replies = new Hashtable();
    protected boolean littleEndian;
    protected int client_count = 0;
    protected Socket mysock = null;
    protected ReplyReceptor repReceptor;
    private byte[] header = new byte[Messages.MSG_HEADER_SIZE];
    protected SocketFactory socket_factory = null;

    public ClientConnection() {
    }

    public ClientConnection(ConnectionManager connectionManager, Socket socket, SocketFactory socketFactory) throws IOException {
        this(connectionManager, socket, new BufferedInputStream(socket.getInputStream()), socketFactory);
    }

    public ClientConnection(ConnectionManager connectionManager, Socket socket, InputStream inputStream, SocketFactory socketFactory) throws IOException {
        this.socket_factory = socketFactory;
        this.manager = connectionManager;
        this.orb = connectionManager.getORB();
        this.mysock = socket;
        this.in_stream = inputStream;
        this.out_stream = new BufferedOutputStream(this.mysock.getOutputStream(), Environment.outBufSize());
        String string = this.mysock.getInetAddress().getHostAddress();
        if (string.indexOf(47) > 0) {
            string = string.substring(string.indexOf(47) + 1);
        }
        String string2 = string + ":" + this.mysock.getPort();
        String string3 = this.isSSL() ? "SSL " : "";
        this.connection_info = string2;
        this.client_count = 1;
        Debug.output(1, "New " + string3 + "connection to " + string2);
        this.repReceptor = new ReplyReceptor(this);
    }

    ORB getORB() {
        return this.orb;
    }

    public boolean isSSL() {
        return this.socket_factory.isSSL(this.mysock);
    }

    public Socket getSocket() {
        return this.mysock;
    }

    public synchronized void closeConnection() {
        Debug.output(1, "Closing connection to " + this.connection_info);
        try {
            if (this.repReceptor != null) {
                this.repReceptor.stopReceptor();
            }
            Debug.output(4, "Closing connection to " + this.connection_info + " (reply receptor closed)");
            try {
                if (this.mysock != null) {
                    this.mysock.close();
                }
            }
            catch (IOException iOException) {
                Debug.output(4, iOException);
            }
            if (this.in_stream != null) {
                this.in_stream.close();
            }
            Debug.output(4, "Closing connection to " + this.connection_info + " (in streams closed)");
            if (this.out_stream != null) {
                this.out_stream.close();
            }
            Debug.output(4, "Closing connection to " + this.connection_info + " (out streams closed)");
        }
        catch (IOException iOException) {
            Debug.output(4, iOException);
        }
        this.in_stream = null;
        this.out_stream = null;
        this.repReceptor = null;
        this.mysock = null;
        Debug.output(3, "Closing connection to " + this.connection_info + " (sockets closed)");
        this.manager.removeConnection(this);
        if (this.replies.size() > 0) {
            try {
                this.reconnect();
            }
            catch (COMM_FAILURE cOMM_FAILURE) {
                Debug.output(1, "Could not reconnect to " + this.connection_info + " (loss of outstanding replies)");
            }
        }
    }

    public boolean connected() {
        return this.mysock != null;
    }

    public synchronized int getId() {
        return this.id_count++;
    }

    protected synchronized void incUsers() {
        ++this.client_count;
    }

    public void duplicate() {
        this.incUsers();
    }

    private void abort() throws EOFException {
        Debug.output(3, "Connection to " + this.connection_info + " aborting...");
        Enumeration enumeration = this.replies.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            java.lang.Object k = enumeration.nextElement();
            ReplyInputStream replyInputStream = (ReplyInputStream)this.replies.get(k);
            replyInputStream.cancel();
            ++n;
        }
        this.replies.clear();
        this.objects.clear();
        if (n > 0) {
            Debug.output(2, "Lost " + n + " outstanding replies");
        }
        throw new EOFException();
    }

    public byte[] readBuffer() throws IOException {
        int n;
        int n2 = 0;
        while (n2 < Messages.MSG_HEADER_SIZE) {
            n = -1;
            try {
                n = this.in_stream.read();
            }
            catch (InterruptedIOException interruptedIOException) {
                Debug.output(3, "Connection timed out");
            }
            catch (Exception exception) {
                Debug.output(3, exception);
            }
            if (n < 0) {
                this.abort();
            }
            this.header[n2] = (byte)n;
            ++n2;
        }
        if ((char)this.header[0] == 'S' && (char)this.header[1] == 'E' && (char)this.header[2] == 'C' && (char)this.header[3] == 'P') {
            throw new IOException("Cannot handle SECIOP messages yet...");
        }
        if ((char)this.header[0] == 'G' && (char)this.header[1] == 'I' && (char)this.header[2] == 'O' && (char)this.header[3] == 'P') {
            n = 0;
            n = this.header[6] == 0 ? ((0xFF & this.header[8]) << 24) + ((0xFF & this.header[9]) << 16) + ((0xFF & this.header[10]) << 8) + (0xFF & this.header[11]) : ((0xFF & this.header[11]) << 24) + ((0xFF & this.header[10]) << 16) + ((0xFF & this.header[9]) << 8) + (0xFF & this.header[8]);
            if (n < 0) {
                this.abort();
            }
            int n3 = n + Messages.MSG_HEADER_SIZE;
            byte[] byArray = BufferManager.getInstance().getBuffer(n3);
            int n4 = 0;
            while (n4 < Messages.MSG_HEADER_SIZE) {
                byArray[n4] = this.header[n4];
                ++n4;
            }
            int n5 = Messages.MSG_HEADER_SIZE;
            while (n5 < n3) {
                int n6 = -1;
                try {
                    n6 = this.in_stream.read(byArray, n5, n3 - n5);
                }
                catch (IOException iOException) {
                    Debug.output(4, iOException);
                }
                if (n6 < 0) {
                    this.abort();
                }
                n5 += n6;
            }
            return byArray;
        }
        Debug.output(0, "Unknown message header type detected by " + Thread.currentThread().getName() + ", discarding ", this.header);
        return this.readBuffer();
    }

    public void receiveReply() throws IOException, CloseConnectionException {
        if (!this.connected()) {
            throw new EOFException();
        }
        byte[] byArray = this.readBuffer();
        byte by = byArray[5];
        byte by2 = byArray[7];
        Debug.output(4, "received reply, GIOP version 1." + by);
        switch (by2) {
            case 1: {
                Debug.output(8, "receiveReply", byArray);
                Integer n = new Integer(Messages.getRequestId(byArray, by2));
                Object object = (Object)this.objects.remove(n);
                ReplyInputStream replyInputStream = (ReplyInputStream)this.replies.remove(n);
                if (replyInputStream != null) {
                    replyInputStream.init(byArray, object);
                    break;
                }
                System.err.println("Serious Error! No pending request for reply " + n);
                break;
            }
            case 4: {
                Integer n = new Integer(Messages.getRequestId(byArray, by2));
                LocateReplyInputStream locateReplyInputStream = (LocateReplyInputStream)this.replies.remove(n);
                if (locateReplyInputStream != null) {
                    locateReplyInputStream.init(byArray);
                    break;
                }
                System.err.println("Serious Error! No pending request for reply " + n);
                break;
            }
            case 6: {
                Debug.output(1, "Got <MessageError> from server, something went wrong!");
            }
            case 5: {
                Debug.output(3, "got close connection message");
                throw new CloseConnectionException("Received <CloseConnection> from Server");
            }
            default: {
                throw new IOException("Received Message of unrecognizable type " + by2);
            }
        }
    }

    public synchronized void reconnect() throws COMM_FAILURE {
        Debug.output(1, "Trying to reconnect to " + this.connection_info);
        int n = Environment.noOfRetries();
        String string = this.connection_info.substring(0, this.connection_info.indexOf(":"));
        int n2 = new Integer(this.connection_info.substring(this.connection_info.indexOf(":") + 1));
        while (n > 0) {
            try {
                this.mysock = this.socket_factory.createSocket(string, n2);
                this.mysock.setTcpNoDelay(true);
                this.in_stream = new BufferedInputStream(this.mysock.getInputStream());
                this.out_stream = new BufferedOutputStream(this.mysock.getOutputStream(), Environment.outBufSize());
                String string2 = this.mysock.getInetAddress().getHostAddress();
                if (string2.indexOf(47) > 0) {
                    string2 = string2.substring(string2.indexOf(47) + 1);
                }
                String string3 = string2 + ":" + this.mysock.getPort();
                this.manager.addConnection(this);
                this.connection_info = string3;
                Debug.output(1, "Reconnected to " + string3);
                this.repReceptor = new ReplyReceptor(this);
                Enumeration enumeration = this.replies.elements();
                while (enumeration.hasMoreElements()) {
                    Debug.output(1, "WARNING: there were outstanding requests when reconnect succeeded! (Lost now)");
                    ((ReplyInputStream)enumeration.nextElement()).cancel();
                }
                return;
            }
            catch (IOException iOException) {
                Debug.output(1, "Retrying to reconnect to " + this.connection_info);
                try {
                    Thread.sleep(Environment.retryInterval());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                --n;
            }
        }
        if (n == 0) {
            throw new COMM_FAILURE("Retries exceeded, couldn't reconnect to " + this.connection_info);
        }
    }

    public synchronized void releaseConnection() {
        --this.client_count;
        if (this.client_count == 0) {
            this.closeConnection();
        } else {
            Debug.output(2, "Releasing one connection to " + this.connection_info);
        }
    }

    public String getInfo() {
        return this.connection_info;
    }

    public org.omg.CORBA.portable.InputStream sendRequest(Object object, RequestOutputStream requestOutputStream) throws COMM_FAILURE {
        if (!this.connected()) {
            Debug.output(3, "not connected");
            this.reconnect();
        }
        java.lang.Object object2 = this.writeLock;
        synchronized (object2) {
            java.lang.Object object3;
            ReplyInputStream replyInputStream = null;
            try {
                if (requestOutputStream.response_expected()) {
                    replyInputStream = new ReplyInputStream((org.omg.CORBA.ORB)this.orb, requestOutputStream.requestId());
                    replyInputStream.setCodeSet(this.TCS, this.TCSW);
                    object3 = new Integer(requestOutputStream.requestId());
                    this.replies.put(object3, replyInputStream);
                    this.objects.put(object3, object);
                }
                if (Environment.verbosityLevel() > 4) {
                    Debug.output(5, "send request", requestOutputStream.getBufferCopy());
                }
                requestOutputStream.write_to(this.out_stream);
                requestOutputStream.release();
            }
            catch (Exception exception) {
                Debug.output(2, exception);
                throw new COMM_FAILURE();
            }
            object3 = replyInputStream;
            return object3;
        }
    }

    public synchronized LocateReplyInputStream sendLocateRequest(LocateRequestOutputStream locateRequestOutputStream) throws COMM_FAILURE {
        if (!this.connected()) {
            this.reconnect();
        }
        java.lang.Object object = this.writeLock;
        synchronized (object) {
            java.lang.Object object2;
            LocateReplyInputStream locateReplyInputStream = null;
            try {
                locateReplyInputStream = new LocateReplyInputStream((org.omg.CORBA.ORB)this.orb, locateRequestOutputStream.requestId());
                object2 = new Integer(locateRequestOutputStream.requestId());
                this.replies.put(object2, locateReplyInputStream);
                locateRequestOutputStream.write_to(this.out_stream);
                locateRequestOutputStream.release();
            }
            catch (Exception exception) {
                Debug.output(2, exception);
                throw new COMM_FAILURE();
            }
            object2 = locateReplyInputStream;
            return object2;
        }
    }

    public synchronized void sendCloseConnection() throws COMM_FAILURE {
        try {
            this.out_stream.write(Messages.closeConnectionMessage());
            this.out_stream.flush();
            this.closeConnection();
        }
        catch (Exception exception) {
            throw new COMM_FAILURE();
        }
    }

    public void setTimeOut(int n) throws SocketException {
        this.mysock.setSoTimeout(n);
    }

    public BufferedOutputStream get_out_stream() {
        return this.out_stream;
    }

    public Hashtable get_replies() {
        return this.replies;
    }

    public Hashtable get_objects() {
        return this.objects;
    }

    public void writeDirectly(byte[] byArray, int n) throws IOException {
        this.get_out_stream().write(byArray, 0, n);
        this.get_out_stream().flush();
    }
}

