/*
 * Decompiled with CFR 0.152.
 */
package jacorb.trading.db.simple.types;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.IncarnationNumber;

public class Incarnation
implements Serializable {
    private long m_high;
    private long m_low;
    private transient boolean m_dirty;
    private static final long MAX_VALUE = 0xFFFFFFFFL;
    static final long serialVersionUID = -6506601918195268342L;

    public Incarnation() {
        this.m_high = 0L;
        this.m_low = 1L;
        this.m_dirty = true;
    }

    private Incarnation(long l, long l2) {
        this.m_high = l;
        this.m_low = l2;
        this.m_dirty = true;
    }

    public Incarnation(IncarnationNumber incarnationNumber) {
        this.m_high = incarnationNumber.high;
        this.m_low = incarnationNumber.low;
        this.m_dirty = true;
    }

    public int compareTo(Incarnation incarnation) {
        int n = this.m_high < incarnation.m_high || this.m_high == incarnation.m_high && this.m_low < incarnation.m_low ? -1 : (this.m_high == incarnation.m_high && this.m_low == incarnation.m_low ? 0 : 1);
        return n;
    }

    public boolean getDirty() {
        return this.m_dirty;
    }

    public IncarnationNumber getIncarnationNumber() {
        return new IncarnationNumber((int)this.m_high, (int)this.m_low);
    }

    public void increment() {
        if (this.m_low < 0xFFFFFFFFL) {
            ++this.m_low;
        } else {
            this.m_low = 0L;
            ++this.m_high;
        }
        this.m_dirty = true;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.m_dirty = false;
    }

    public String toString() {
        return "{" + this.m_high + "," + this.m_low + "}";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        this.m_dirty = false;
    }
}

