/*
 * Decompiled with CFR 0.152.
 */
package jacorb.poa.util;

import jacorb.orb.Delegate;
import jacorb.poa.POAConstants;
import jacorb.poa.except.POAInternalError;
import jacorb.poa.util.IdUtil;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.PortableServer.IdAssignmentPolicy;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicy;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.ImplicitActivationPolicy;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.LifespanPolicy;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POAManagerPackage.State;
import org.omg.PortableServer.RequestProcessingPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.ServantRetentionPolicy;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import org.omg.PortableServer.ThreadPolicy;
import org.omg.PortableServer.ThreadPolicyValue;

public final class POAUtil {
    public static String convert(Policy policy, int n) {
        switch (n) {
            case 16: {
                if (policy == null || ((ThreadPolicy)policy).value() == ThreadPolicyValue.ORB_CTRL_MODEL) {
                    return "ORB_CTRL_MODEL";
                }
                if (((ThreadPolicy)policy).value() != ThreadPolicyValue.SINGLE_THREAD_MODEL) break;
                return "SINGLE_THREAD_MODEL";
            }
            case 17: {
                if (policy == null || ((LifespanPolicy)policy).value() == LifespanPolicyValue.TRANSIENT) {
                    return "TRANSIENT";
                }
                if (((LifespanPolicy)policy).value() != LifespanPolicyValue.PERSISTENT) break;
                return "PERSISTENT";
            }
            case 18: {
                if (policy == null || ((IdUniquenessPolicy)policy).value() == IdUniquenessPolicyValue.UNIQUE_ID) {
                    return "UNIQUE_ID";
                }
                if (((IdUniquenessPolicy)policy).value() != IdUniquenessPolicyValue.MULTIPLE_ID) break;
                return "MULTIPLE_ID";
            }
            case 19: {
                if (policy == null || ((IdAssignmentPolicy)policy).value() == IdAssignmentPolicyValue.SYSTEM_ID) {
                    return "SYSTEM_ID";
                }
                if (((IdAssignmentPolicy)policy).value() != IdAssignmentPolicyValue.USER_ID) break;
                return "USER_ID";
            }
            case 21: {
                if (policy == null || ((ServantRetentionPolicy)policy).value() == ServantRetentionPolicyValue.RETAIN) {
                    return "RETAIN";
                }
                if (((ServantRetentionPolicy)policy).value() != ServantRetentionPolicyValue.NON_RETAIN) break;
                return "NON_RETAIN";
            }
            case 22: {
                if (policy == null || ((RequestProcessingPolicy)policy).value() == RequestProcessingPolicyValue.USE_ACTIVE_OBJECT_MAP_ONLY) {
                    return "USE_ACTIVE_OBJECT_MAP_ONLY";
                }
                if (((RequestProcessingPolicy)policy).value() == RequestProcessingPolicyValue.USE_SERVANT_MANAGER) {
                    return "USE_SERVANT_MANAGER";
                }
                if (((RequestProcessingPolicy)policy).value() != RequestProcessingPolicyValue.USE_DEFAULT_SERVANT) break;
                return "USE_DEFAULT_SERVANT";
            }
            case 20: {
                if (policy == null || ((ImplicitActivationPolicy)policy).value() == ImplicitActivationPolicyValue.NO_IMPLICIT_ACTIVATION) {
                    return "NO_IMPLICIT_ACTIVATION";
                }
                if (((ImplicitActivationPolicy)policy).value() != ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION) break;
                return "IMPLICIT_ACTIVATION";
            }
        }
        return "unknown";
    }

    public static String convert(State state) {
        if (state.value() == 1) {
            return "active";
        }
        if (state.value() == 0) {
            return "holding";
        }
        if (state.value() == 2) {
            return "discarding";
        }
        if (state.value() == 3) {
            return "inactive";
        }
        return "unknown";
    }

    public static String convert(byte[] byArray, boolean bl) {
        if (bl) {
            String string = "";
            int n = 0;
            while (n < byArray.length) {
                int n2 = (byArray[n] & 0xFF) / 16;
                int n3 = (byArray[n] & 0xFF) % 16;
                char c = (char)(n2 > 9 ? 65 + (n2 - 10) : 48 + n2);
                char c2 = (char)(n3 > 9 ? 65 + (n3 - 10) : 48 + n3);
                string = String.valueOf(string) + c + c2 + " ";
                ++n;
            }
            return string;
        }
        return POAUtil.objectId_to_string(byArray).replace('\n', ' ');
    }

    public static String extractImplName(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] == POAConstants.OBJECT_KEY_SEP_BYTE) {
                byte[] byArray2 = IdUtil.extract(byArray, 0, n);
                return POAUtil.unmaskStr(new String(byArray2));
            }
            ++n;
        }
        throw new POAInternalError("error extracting impl name from object_key: " + POAUtil.convert(byArray, false));
    }

    public static byte[] extractOID(Object object) {
        return ((Delegate)((ObjectImpl)object)._get_delegate()).getObjectId();
    }

    public static byte[] extractOID(byte[] byArray) {
        int n = byArray.length - 1;
        while (n >= 0) {
            if (byArray[n] == POAConstants.OBJECT_KEY_SEP_BYTE) {
                byte[] byArray2 = IdUtil.extract(byArray, ++n, byArray.length - n);
                return POAUtil.unmaskId(byArray2);
            }
            --n;
        }
        throw new POAInternalError("error extracting oid from object_key: " + POAUtil.convert(byArray, false));
    }

    public static String extractPOAName(byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < byArray.length) {
            if (byArray[n3] == POAConstants.OBJECT_KEY_SEP_BYTE) {
                n = n3;
                break;
            }
            ++n3;
        }
        int n4 = byArray.length - 1;
        while (n4 >= 0) {
            if (byArray[n4] == POAConstants.OBJECT_KEY_SEP_BYTE) {
                n2 = n4;
                break;
            }
            --n4;
        }
        if (n > n2) {
            throw new POAInternalError("error extracting poa name from object_key: " + POAUtil.convert(byArray, false));
        }
        if (n == n2) {
            return "";
        }
        return new String(IdUtil.extract(byArray, ++n, n2 - n));
    }

    public static Policy getPolicy(Policy[] policyArray, int n) {
        if (policyArray != null) {
            int n2 = 0;
            while (n2 < policyArray.length) {
                if (policyArray[n2].policy_type() == n) {
                    return policyArray[n2];
                }
                ++n2;
            }
        }
        return null;
    }

    public static boolean isActive(State state) {
        return state.value() == 1;
    }

    public static boolean isDiscarding(State state) {
        return state.value() == 2;
    }

    public static boolean isHolding(State state) {
        return state.value() == 0;
    }

    public static boolean isInactive(State state) {
        return state.value() == 3;
    }

    public static byte[] maskId(byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        while (n2 < byArray.length) {
            if (byArray[n2] == POAConstants.OBJECT_KEY_SEP_BYTE) {
                ++n;
            } else if (byArray[n2] == 38) {
                ++n;
            }
            ++n2;
        }
        if (n == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        n = 0;
        int n3 = 0;
        while (n3 < byArray.length) {
            if (byArray[n3] == POAConstants.OBJECT_KEY_SEP_BYTE) {
                byArray2[n] = 38;
                byArray2[n + 1] = 37;
                n += 2;
            } else if (byArray[n3] == 38) {
                byArray2[n] = 38;
                byArray2[n + 1] = 38;
                n += 2;
            } else {
                byArray2[n] = byArray[n3];
                ++n;
            }
            ++n3;
        }
        return byArray2;
    }

    public static String maskStr(String string) {
        return new String(POAUtil.maskId(string.getBytes()));
    }

    public static String objectId_to_string(byte[] byArray) {
        return new String(byArray);
    }

    public static byte[] string_to_objectId(String string) {
        return string.getBytes();
    }

    public static byte[] unmaskId(byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        while (n2 < byArray.length) {
            if (byArray[n2] == 38) {
                --n;
                ++n2;
            }
            ++n2;
        }
        if (n == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        n = 0;
        int n3 = 0;
        while (n3 < byArray.length) {
            if (byArray[n3] == 38) {
                if (byArray[n3 + 1] == 38) {
                    byArray2[n] = 38;
                } else if (byArray[n3 + 1] == 37) {
                    byArray2[n] = POAConstants.OBJECT_KEY_SEP_BYTE;
                } else {
                    throw new POAInternalError("error: forbidden byte sequence \"38" + byArray[n3 + 1] + "\" (unmaskId)");
                }
                ++n3;
            } else {
                byArray2[n] = byArray[n3];
            }
            ++n;
            ++n3;
        }
        return byArray2;
    }

    public static String unmaskStr(String string) {
        return new String(POAUtil.unmaskId(string.getBytes()));
    }
}

