/*
 * Decompiled with CFR 0.152.
 */
package jacorb.poa;

import jacorb.orb.LocalityConstrainedObject;
import jacorb.orb.ORB;
import jacorb.orb.ServantDelegate;
import jacorb.orb.domain.Domain;
import jacorb.orb.domain.DomainHelper;
import jacorb.orb.domain.InitialMapPolicy;
import jacorb.orb.domain.InitialMapPolicyHelper;
import jacorb.orb.domain.Util;
import jacorb.orb.dsi.ServerRequest;
import jacorb.poa.AOM;
import jacorb.poa.AOMListener;
import jacorb.poa.EventListener;
import jacorb.poa.EventMulticaster;
import jacorb.poa.POAConstants;
import jacorb.poa.POAListener;
import jacorb.poa.POAManager;
import jacorb.poa.POAMonitor;
import jacorb.poa.POAMonitorLightImpl;
import jacorb.poa.RPPoolManagerListener;
import jacorb.poa.RequestController;
import jacorb.poa.RequestQueueListener;
import jacorb.poa.except.ApplicationError;
import jacorb.poa.except.POAInternalError;
import jacorb.poa.except.ParentIsHolding;
import jacorb.poa.except.ResourceLimitReachedException;
import jacorb.poa.policy.IdAssignmentPolicy;
import jacorb.poa.policy.IdUniquenessPolicy;
import jacorb.poa.policy.ImplicitActivationPolicy;
import jacorb.poa.policy.LifespanPolicy;
import jacorb.poa.policy.MapToDefaultDomainsPolicy;
import jacorb.poa.policy.RequestProcessingPolicy;
import jacorb.poa.policy.ServantRetentionPolicy;
import jacorb.poa.policy.ThreadPolicy;
import jacorb.poa.util.IdUtil;
import jacorb.poa.util.LogTrace;
import jacorb.poa.util.LogWriter;
import jacorb.poa.util.POAUtil;
import jacorb.util.Debug;
import jacorb.util.Environment;
import java.util.Enumeration;
import java.util.Hashtable;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.TRANSIENT;
import org.omg.PortableServer.AdapterActivator;
import org.omg.PortableServer.CurrentPackage.NoContext;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POAManagerPackage.State;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.AdapterNonExistent;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.NoServant;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongAdapter;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantActivator;
import org.omg.PortableServer.ServantLocator;
import org.omg.PortableServer.ServantManager;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import org.omg.PortableServer.ThreadPolicyValue;

public class POA
extends LocalityConstrainedObject
implements org.omg.PortableServer.POA {
    private ORB orb;
    private LogTrace logTrace;
    private POAListener poaListener;
    private POAMonitor monitor;
    private POAManager poaManager;
    private POA parent;
    private String name;
    private String qualifiedName;
    private Hashtable childs = new Hashtable();
    Servant defaultServant;
    ServantManager servantManager;
    private AdapterActivator adapterActivator;
    private AOM aom;
    private RequestController requestController;
    private byte[] poaId;
    private byte[] watermark;
    private long objectIdCount;
    protected org.omg.PortableServer.ThreadPolicy threadPolicy;
    protected org.omg.PortableServer.LifespanPolicy lifespanPolicy;
    protected org.omg.PortableServer.IdUniquenessPolicy idUniquenessPolicy;
    protected org.omg.PortableServer.IdAssignmentPolicy idAssignmentPolicy;
    protected org.omg.PortableServer.ServantRetentionPolicy servantRetentionPolicy;
    protected org.omg.PortableServer.RequestProcessingPolicy requestProcessingPolicy;
    protected org.omg.PortableServer.ImplicitActivationPolicy implicitActivationPolicy;
    private static boolean inDomainMapping = false;
    private Hashtable all_policies = null;
    private boolean etherealize;
    private int shutdownState = 0;
    private java.lang.Object poaCreationLog = new java.lang.Object();
    private java.lang.Object poaDestructionLog = new java.lang.Object();
    private java.lang.Object unknownAdapterLog = new java.lang.Object();
    private boolean unknownAdapterCalled;

    private POA() {
    }

    private POA(ORB oRB, String string, POA pOA, POAManager pOAManager, Policy[] policyArray) {
        Policy policy;
        this.orb = oRB;
        this.name = string;
        this.parent = pOA;
        this.poaManager = pOAManager;
        this.all_policies = new Hashtable();
        if (policyArray != null) {
            int n = 0;
            while (n < policyArray.length) {
                this.all_policies.put(new Integer(policyArray[n].policy_type()), policyArray[n]);
                switch (policyArray[n].policy_type()) {
                    case 16: {
                        this.threadPolicy = (org.omg.PortableServer.ThreadPolicy)policyArray[n];
                        break;
                    }
                    case 17: {
                        this.lifespanPolicy = (org.omg.PortableServer.LifespanPolicy)policyArray[n];
                        break;
                    }
                    case 18: {
                        this.idUniquenessPolicy = (org.omg.PortableServer.IdUniquenessPolicy)policyArray[n];
                        break;
                    }
                    case 19: {
                        this.idAssignmentPolicy = (org.omg.PortableServer.IdAssignmentPolicy)policyArray[n];
                        break;
                    }
                    case 21: {
                        this.servantRetentionPolicy = (org.omg.PortableServer.ServantRetentionPolicy)policyArray[n];
                        break;
                    }
                    case 22: {
                        this.requestProcessingPolicy = (org.omg.PortableServer.RequestProcessingPolicy)policyArray[n];
                        break;
                    }
                    case 20: {
                        this.implicitActivationPolicy = (org.omg.PortableServer.ImplicitActivationPolicy)policyArray[n];
                        break;
                    }
                }
                ++n;
            }
        }
        if ((policy = this.getPolicy(115)) == null) {
            Debug.output(1027, "no initial map policy defined. Defining default initial map policy");
            String string2 = Environment.DefaultDomains();
            this.all_policies.put(new Integer(115), new MapToDefaultDomainsPolicy(string2));
        }
        this.watermark = this.generateWatermark();
        this.logTrace = new LogWriter("POA " + this.name, this.isSystemId());
        this.aom = this.isRetain() ? new AOM(this.isUniqueId(), this.isSingleThreadModel(), this.logTrace) : null;
        this.requestController = new RequestController(this, this.orb, this.aom, this.logTrace);
        this.poaManager.registerPOA(this);
        this.monitor = new POAMonitorLightImpl();
        this.monitor.init(this, this.aom, this.requestController.getRequestQueue(), this.requestController.getPoolManager(), "POA " + this.name, this.isSystemId(), this.logTrace);
        this.monitor.openMonitor();
        if (this.poaListener != null) {
            this.poaListener.poaCreated(this);
        }
        this.logTrace.printLog(1, "ready");
    }

    public static POA _POA_init(ORB oRB) {
        POAManager pOAManager = new POAManager(oRB);
        Policy[] policyArray = null;
        if (Environment.DefaultDomains() == null) {
            policyArray = new Policy[1];
        } else {
            policyArray = new Policy[2];
            policyArray[1] = new MapToDefaultDomainsPolicy(Environment.DefaultDomains());
        }
        policyArray[0] = new ImplicitActivationPolicy(ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION);
        POA pOA = new POA(oRB, "RootPOA", null, pOAManager, policyArray);
        return pOA;
    }

    public void _addPOAEventListener(EventListener eventListener) {
        if (eventListener instanceof POAListener) {
            this.addPOAListener((POAListener)eventListener);
        }
        if (eventListener instanceof AOMListener && this.aom != null) {
            this.aom.addAOMListener((AOMListener)eventListener);
        }
        if (eventListener instanceof RequestQueueListener) {
            this.requestController.getRequestQueue().addRequestQueueListener((RequestQueueListener)eventListener);
        }
        if (eventListener instanceof RPPoolManagerListener) {
            this.requestController.getPoolManager().addRPPoolManagerListener((RPPoolManagerListener)eventListener);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public POA _getChildPOA(String var1_1) throws ParentIsHolding {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("adapter destroyed");
        }
        var2_2 = (POA)this.childs.get(var1_1);
        if (var2_2 == null || var2_2.isDestructionApparent()) {
            if (this.adapterActivator == null) {
                throw new OBJECT_NOT_EXIST("no adapter activator exists for " + var1_1);
            }
            if (this.isHolding()) {
                throw new ParentIsHolding();
            }
            if (this.isDiscarding()) {
                throw new TRANSIENT("a parent poa is in discarding state");
            }
            if (this.isInactive()) {
                throw new OBJ_ADAPTER("a parent poa is in inactive state");
            }
            var3_3 = false;
            if (this.isSingleThreadModel()) {
                var4_4 = this.unknownAdapterLog;
                synchronized (var4_4) {
                    block19: {
                        while (true) {
                            if (!this.unknownAdapterCalled) {
                                this.unknownAdapterCalled = true;
                                ** try [egrp 2[TRYBLOCK] [1 : 167->182)] { 
lbl22:
                                // 1 sources

                                break;
                            }
                            try {
                                this.unknownAdapterLog.wait();
                            }
                            catch (InterruptedException v0) {}
                        }
                        {
                            var3_3 = this.the_activator().unknown_adapter(this, POAUtil.unmaskStr(var1_1));
                            break block19;
                        }
lbl30:
                        // 1 sources

                        finally {
                            var7_5 = null;
                            this.unknownAdapterCalled = false;
                            this.unknownAdapterLog.notifyAll();
                        }
                    }
                }
            }
            var3_3 = this.the_activator().unknown_adapter(this, POAUtil.unmaskStr(var1_1));
            if (!var3_3) {
                throw new OBJECT_NOT_EXIST("poa activation is failed");
            }
            var2_2 = (POA)this.childs.get(var1_1);
            if (var2_2 == null) {
                throw new POAInternalError("error: unknown_adapter returns true, but the child poa doesn't extist");
            }
        }
        return var2_2;
    }

    public String _getQualifiedName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = this.parent == null ? "" : (this.parent.the_parent() == null ? this.name : String.valueOf(this.parent._getQualifiedName()) + "/" + this.name);
        }
        return this.qualifiedName;
    }

    public void _invoke(ServerRequest serverRequest) throws WrongAdapter {
        java.lang.Object object = this.poaDestructionLog;
        synchronized (object) {
            if (this.isDestructionApparent()) {
                throw new OBJECT_NOT_EXIST("adapter destroyed");
            }
            if (serverRequest.remainingPOAName() == null) {
                if (!this.previouslyGeneratedObjectKey(serverRequest.objectKey())) {
                    this.logTrace.printLog(0, serverRequest, "_invoke: object key not previous generated!,  operation: " + serverRequest.operation());
                    throw new WrongAdapter();
                }
                if (this.isSystemId() && !this.previouslyGeneratedObjectId(serverRequest.objectId())) {
                    this.logTrace.printLog(0, serverRequest.objectId(), "_invoke: oid not previous generated!, operation: " + serverRequest.operation());
                    throw new WrongAdapter();
                }
            }
            try {
                this.requestController.queueRequest(serverRequest);
            }
            catch (ResourceLimitReachedException resourceLimitReachedException) {
                throw new TRANSIENT("resource limit reached");
            }
        }
    }

    public boolean _localStubsSupported() {
        return this.isRetain() || this.useDefaultServant();
    }

    public void _removePOAEventListener(EventListener eventListener) {
        if (eventListener instanceof POAListener) {
            this.removePOAListener((POAListener)eventListener);
        }
        if (eventListener instanceof AOMListener && this.aom != null) {
            this.aom.removeAOMListener((AOMListener)eventListener);
        }
        if (eventListener instanceof RequestQueueListener) {
            this.requestController.getRequestQueue().removeRequestQueueListener((RequestQueueListener)eventListener);
        }
        if (eventListener instanceof RPPoolManagerListener) {
            this.requestController.getPoolManager().removeRPPoolManagerListener((RPPoolManagerListener)eventListener);
        }
    }

    public byte[] activate_object(Servant servant) throws ServantAlreadyActive, WrongPolicy {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("adapter destroyed");
        }
        if (!this.isRetain() || !this.isSystemId()) {
            throw new WrongPolicy();
        }
        byte[] byArray = this.generateObjectId();
        try {
            this.aom.add(byArray, servant);
            this.orb.set_delegate(servant);
            ((ServantDelegate)servant._get_delegate()).setPOA(this);
        }
        catch (ObjectAlreadyActive objectAlreadyActive) {
            throw new POAInternalError("error: object already active (activate_object)");
        }
        return byArray;
    }

    public void activate_object_with_id(byte[] byArray, Servant servant) throws ServantAlreadyActive, ObjectAlreadyActive, WrongPolicy {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("adapter destroyed");
        }
        if (!this.isRetain()) {
            throw new WrongPolicy();
        }
        if (this.isSystemId() && !this.previouslyGeneratedObjectId(byArray)) {
            this.logTrace.printLog(0, byArray, "activate_object_with_id: oid not previous generated!");
            throw new BAD_PARAM();
        }
        this.aom.add(byArray, servant);
        this.orb.set_delegate(servant);
        ((ServantDelegate)servant._get_delegate()).setPOA(this);
    }

    protected synchronized void addPOAListener(POAListener pOAListener) {
        this.poaListener = EventMulticaster.add(this.poaListener, pOAListener);
    }

    protected void changeToActive() {
        if (this.poaListener != null) {
            this.poaListener.poaStateChanged(this, POAConstants.ACTIVE);
        }
        this.monitor.changeState("changed to active...");
        this.requestController.resetPreviousCompletionCall();
        this.requestController.continueToWork();
        this.monitor.changeState("active");
    }

    protected void changeToDiscarding() {
        if (this.poaListener != null) {
            this.poaListener.poaStateChanged(this, POAConstants.DISCARDING);
        }
        this.monitor.changeState("changed to discarding ...");
        this.requestController.resetPreviousCompletionCall();
        this.requestController.continueToWork();
        this.requestController.waitForCompletion();
        this.monitor.changeState("discarding");
    }

    protected void changeToHolding() {
        if (this.poaListener != null) {
            this.poaListener.poaStateChanged(this, POAConstants.HOLDING);
        }
        this.monitor.changeState("changed to holding ...");
        this.requestController.resetPreviousCompletionCall();
        this.requestController.waitForCompletion();
        this.monitor.changeState("holding");
    }

    protected void changeToInactive(boolean bl) {
        if (this.poaListener != null) {
            this.poaListener.poaStateChanged(this, POAConstants.INACTIVE);
        }
        this.monitor.changeState("changed to inactive ...");
        this.requestController.resetPreviousCompletionCall();
        this.requestController.continueToWork();
        this.requestController.waitForCompletion();
        if (this.etherealize && this.isRetain() && this.useServantManager()) {
            this.logTrace.printLog(3, "etherialize all servants ...");
            this.aom.removeAll((ServantActivator)this.servantManager, this, true);
            this.logTrace.printLog(3, "... done");
            if (this.monitor != null) {
                this.monitor.changeState("inactive (etherialization completed)");
            }
        } else if (this.monitor != null) {
            this.monitor.changeState("inactive (no etherialization)");
        }
    }

    public org.omg.PortableServer.POA create_POA(String string, org.omg.PortableServer.POAManager pOAManager, Policy[] policyArray) throws AdapterAlreadyExists, InvalidPolicy {
        POA pOA;
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("adapter destroyed");
        }
        String string2 = POAUtil.maskStr(string);
        if (pOAManager != null && !(pOAManager instanceof POAManager)) {
            throw new ApplicationError("error: the POAManager is incompatible with type \"jacorb.poa.POAManager\"!");
        }
        Policy[] policyArray2 = null;
        if (policyArray != null) {
            short s = this.verifyPolicyList(policyArray);
            if (s != -1) {
                throw new InvalidPolicy(s);
            }
            policyArray2 = new Policy[policyArray.length];
            int n = 0;
            while (n < policyArray.length) {
                policyArray2[n] = policyArray[n].copy();
                ++n;
            }
        }
        java.lang.Object object = this.poaCreationLog;
        synchronized (object) {
            LocalityConstrainedObject localityConstrainedObject;
            pOA = (POA)this.childs.get(string2);
            if (pOA != null && !pOA.isDestructionApparent()) {
                throw new AdapterAlreadyExists();
            }
            if (pOA != null) {
                while ((localityConstrainedObject = (POA)this.childs.get(string2)) != null) {
                    try {
                        this.poaCreationLog.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    if (pOA == localityConstrainedObject) continue;
                    throw new AdapterAlreadyExists();
                }
            }
            if (this.isShutdownInProgress()) {
                throw new BAD_INV_ORDER();
            }
            localityConstrainedObject = pOAManager == null ? new POAManager(this.orb) : (POAManager)pOAManager;
            pOA = new POA(this.orb, string2, this, (POAManager)localityConstrainedObject, policyArray2);
            if (this.poaListener != null) {
                this.poaListener.poaCreated(pOA);
            }
            this.childs.put(string2, pOA);
        }
        return pOA;
    }

    public org.omg.PortableServer.IdAssignmentPolicy create_id_assignment_policy(IdAssignmentPolicyValue idAssignmentPolicyValue) {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("adapter destroyed");
        }
        return new IdAssignmentPolicy(idAssignmentPolicyValue);
    }

    public org.omg.PortableServer.IdUniquenessPolicy create_id_uniqueness_policy(IdUniquenessPolicyValue idUniquenessPolicyValue) {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("adapter destroyed");
        }
        return new IdUniquenessPolicy(idUniquenessPolicyValue);
    }

    public org.omg.PortableServer.ImplicitActivationPolicy create_implicit_activation_policy(ImplicitActivationPolicyValue implicitActivationPolicyValue) {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("adapter destroyed");
        }
        return new ImplicitActivationPolicy(implicitActivationPolicyValue);
    }

    public org.omg.PortableServer.LifespanPolicy create_lifespan_policy(LifespanPolicyValue lifespanPolicyValue) {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("adapter destroyed");
        }
        return new LifespanPolicy(lifespanPolicyValue);
    }

    public Object create_reference(String string) throws WrongPolicy {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("adapter destroyed");
        }
        if (!this.isSystemId()) {
            throw new WrongPolicy();
        }
        return this.getReference(this.generateObjectId(), string);
    }

    public Object create_reference_with_id(byte[] byArray, String string) throws WrongPolicy {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("adapter destroyed");
        }
        if (this.isSystemId() && !this.previouslyGeneratedObjectId(byArray)) {
            this.logTrace.printLog(0, byArray, "create_reference_with_id: oid not previous generated!");
            throw new BAD_PARAM();
        }
        return this.getReference(byArray, string);
    }

    public org.omg.PortableServer.RequestProcessingPolicy create_request_processing_policy(RequestProcessingPolicyValue requestProcessingPolicyValue) {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("adapter destroyed");
        }
        return new RequestProcessingPolicy(requestProcessingPolicyValue);
    }

    public org.omg.PortableServer.ServantRetentionPolicy create_servant_retention_policy(ServantRetentionPolicyValue servantRetentionPolicyValue) {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("adapter destroyed");
        }
        return new ServantRetentionPolicy(servantRetentionPolicyValue);
    }

    public org.omg.PortableServer.ThreadPolicy create_thread_policy(ThreadPolicyValue threadPolicyValue) {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("adapter destroyed");
        }
        return new ThreadPolicy(threadPolicyValue);
    }

    public void deactivate_object(byte[] byArray) throws ObjectNotActive, WrongPolicy {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("adapter destroyed");
        }
        if (!this.isRetain()) {
            throw new WrongPolicy();
        }
        if (!this.aom.contains(byArray)) {
            throw new ObjectNotActive();
        }
        final byte[] byArray2 = byArray;
        final ServantActivator servantActivator = this.useServantManager() ? (ServantActivator)this.servantManager : null;
        final POA pOA = this;
        Thread thread = new Thread(){

            public void run() {
                aom.remove(byArray2, requestController, servantActivator, pOA, false);
            }
        };
        thread.start();
    }

    public void destroy(boolean bl, boolean bl2) {
        block4: {
            java.lang.Object object;
            if (bl2 && this.isInInvocationContext()) {
                throw new BAD_INV_ORDER();
            }
            this.makeShutdownInProgress(bl);
            Enumeration enumeration = this.childs.elements();
            while (enumeration.hasMoreElements()) {
                object = (POA)enumeration.nextElement();
                ((POA)object).destroy(this.etherealize, bl2);
            }
            object = new Thread(){

                public void run() {
                    POA.this.requestController.waitForShutdown();
                    POA.this.makeDestructionApparent();
                    POA.this.makeDestructionComplete();
                }
            };
            ((Thread)object).start();
            if (!bl2) break block4;
            try {
                ((Thread)object).join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void doInitialDomainMapping(Object object) {
        Domain domain;
        InitialMapPolicy initialMapPolicy = null;
        if (inDomainMapping) {
            Debug.output(1029, "POA.doInitialMapping: avoiding mapping of a " + Util.toID(object.toString()));
            return;
        }
        inDomainMapping = true;
        try {
            domain = DomainHelper.narrow(this.orb.resolve_initial_references("LocalDomainService"));
        }
        catch (InvalidName invalidName) {
            Debug.output(1026, "POA.doInitialDomainMapping: cannot obtain (local) domain service , skipping object domain mapping. (may be recursion end)");
            inDomainMapping = false;
            return;
        }
        try {
            initialMapPolicy = InitialMapPolicyHelper.narrow(this.getPolicy(115));
        }
        catch (BAD_PARAM bAD_PARAM) {
            Debug.output(1026, "POA.doInitialDomainMapping: no initial map policy available, mapping a " + Util.toID(object.toString()) + " to local orb domain.");
            domain.insertMember(object);
            inDomainMapping = false;
            return;
        }
        Domain[] domainArray = initialMapPolicy.OnReferenceCreation(object, domain);
        int n = 0;
        while (n < domainArray.length) {
            Debug.output(1027, " POA.doInitialMapping: putting obj into " + domainArray[n].name());
            domainArray[n].insertMember(object);
            ++n;
        }
        inDomainMapping = false;
    }

    private byte[] extractWatermark(byte[] byArray) {
        if (byArray.length < this.watermark.length) {
            return new byte[0];
        }
        return IdUtil.extract(byArray, byArray.length - this.watermark.length, this.watermark.length);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public org.omg.PortableServer.POA find_POA(String var1_1, boolean var2_2) throws AdapterNonExistent {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("adapter destroyed");
        }
        var3_3 = POAUtil.maskStr(var1_1);
        var4_4 = (POA)this.childs.get(var3_3);
        if (var4_4 == null || var4_4.isDestructionApparent()) {
            var5_5 = false;
            if (var2_2 && this.the_activator() != null) {
                if (this.isSingleThreadModel()) {
                    var6_6 = this.unknownAdapterLog;
                    synchronized (var6_6) {
                        block16: {
                            while (true) {
                                if (!this.unknownAdapterCalled) {
                                    this.unknownAdapterCalled = true;
                                    ** try [egrp 2[TRYBLOCK] [1 : 107->120)] { 
lbl16:
                                    // 1 sources

                                    break;
                                }
                                try {
                                    this.unknownAdapterLog.wait();
                                }
                                catch (InterruptedException v0) {}
                            }
                            {
                                var5_5 = this.the_activator().unknown_adapter(this, var1_1);
                                break block16;
                            }
lbl24:
                            // 1 sources

                            finally {
                                var9_7 = null;
                                this.unknownAdapterCalled = false;
                                this.unknownAdapterLog.notifyAll();
                            }
                        }
                    }
                }
                var5_5 = this.the_activator().unknown_adapter(this, var1_1);
            }
            if (!var5_5) {
                throw new AdapterNonExistent();
            }
            var4_4 = (POA)this.childs.get(var3_3);
            if (var4_4 == null) {
                throw new POAInternalError("error: unknown_adapter returns true, but the child poa does'n extist");
            }
        }
        return var4_4;
    }

    private byte[] generateObjectId() {
        if (this.isPersistent()) {
            return IdUtil.concat(IdUtil.createId(4), this.watermark);
        }
        return IdUtil.concat(IdUtil.toId(this.objectIdCount++), this.watermark);
    }

    private byte[] generateWatermark() {
        if (this.watermark == null) {
            this.watermark = this.isPersistent() ? IdUtil.toId(new String(this.getPOAId()).hashCode()) : IdUtil.createId(4);
        }
        return this.watermark;
    }

    protected POAMonitor getMonitor() {
        return this.monitor;
    }

    protected ORB getORB() {
        return this.orb;
    }

    public byte[] getPOAId() {
        if (this.poaId == null) {
            byte[] byArray = POAUtil.maskId(Environment.implName() != null ? Environment.implName() : Environment.serverId());
            int n = byArray.length;
            byte[] byArray2 = this._getQualifiedName().getBytes();
            int n2 = byArray2.length;
            if (n2 == 0) {
                this.poaId = byArray;
            } else {
                this.poaId = new byte[n + n2 + 1];
                int n3 = 0;
                System.arraycopy(byArray, 0, this.poaId, n3, n);
                this.poaId[n3 += n] = POAConstants.OBJECT_KEY_SEP_BYTE;
                System.arraycopy(byArray2, 0, this.poaId, ++n3, n2);
            }
        }
        return this.poaId;
    }

    public Policy getPolicy(int n) {
        return (Policy)this.all_policies.get(new Integer(n));
    }

    protected Object getReference(byte[] byArray, String string) {
        byte[] byArray2 = POAUtil.maskId(byArray);
        int n = this.getPOAId().length;
        int n2 = byArray2.length;
        byte[] byArray3 = new byte[n + n2 + 1];
        int n3 = 0;
        System.arraycopy(this.getPOAId(), 0, byArray3, n3, n);
        byArray3[n3 += n] = POAConstants.OBJECT_KEY_SEP_BYTE;
        System.arraycopy(byArray2, 0, byArray3, ++n3, n2);
        BooleanHolder booleanHolder = new BooleanHolder();
        Object object = this.orb.getReference(this, byArray3, string, this.isPersistent() ^ true, booleanHolder);
        if (!booleanHolder.value) {
            Debug.output(1027, "Poa.getReference: a new " + Util.toID(object.toString()));
            if (Environment.useDomain()) {
                this.doInitialDomainMapping(object);
            }
            if (this.poaListener != null) {
                this.poaListener.referenceCreated(object);
            }
        }
        return object;
    }

    protected RequestController getRequestController() {
        return this.requestController;
    }

    protected State getState() {
        return this.poaManager.get_state();
    }

    public Servant get_servant() throws NoServant, WrongPolicy {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("adapter destroyed");
        }
        if (!this.isUseDefaultServant()) {
            throw new WrongPolicy();
        }
        if (this.defaultServant == null) {
            throw new NoServant();
        }
        return this.defaultServant;
    }

    public ServantManager get_servant_manager() throws WrongPolicy {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("adapter destroyed");
        }
        if (!this.isUseServantManager()) {
            throw new WrongPolicy();
        }
        return this.servantManager;
    }

    public Object id_to_reference(byte[] byArray) throws ObjectNotActive, WrongPolicy {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("adapter destroyed");
        }
        if (!this.isRetain()) {
            throw new WrongPolicy();
        }
        Servant servant = null;
        servant = this.aom.getServant(byArray);
        if (servant == null) {
            throw new ObjectNotActive();
        }
        return this.getReference(byArray, servant._all_interfaces(this, byArray)[0]);
    }

    public Servant id_to_servant(byte[] byArray) throws ObjectNotActive, WrongPolicy {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("adapter destroyed");
        }
        if (!this.isRetain() && !this.isUseDefaultServant()) {
            throw new WrongPolicy();
        }
        Servant servant = null;
        if (this.isRetain() && (servant = this.aom.getServant(byArray)) != null) {
            return servant;
        }
        if (this.useDefaultServant()) {
            return this.defaultServant;
        }
        throw new ObjectNotActive();
    }

    protected boolean isActive() {
        return this.poaManager.get_state().value() == 1;
    }

    protected boolean isDestructionApparent() {
        return this.shutdownState >= 2;
    }

    protected boolean isDestructionComplete() {
        return this.shutdownState >= 3;
    }

    protected boolean isDiscarding() {
        return this.poaManager.get_state().value() == 2;
    }

    protected boolean isHolding() {
        return this.poaManager.get_state().value() == 0;
    }

    protected boolean isImplicitActivation() {
        return this.implicitActivationPolicy != null && this.implicitActivationPolicy.value() == ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION;
    }

    private boolean isInInvocationContext() {
        try {
            if (this.orb.getPOACurrent().getORB() == this.orb) {
                return true;
            }
        }
        catch (NoContext noContext) {}
        return false;
    }

    private boolean isInInvocationContext(Servant servant) {
        try {
            if (this.orb.getPOACurrent().get_POA() == this && (servant == null || this.orb.getPOACurrent().getServant() == servant)) {
                return true;
            }
        }
        catch (NoContext noContext) {}
        return false;
    }

    protected boolean isInactive() {
        return this.poaManager.get_state().value() == 3;
    }

    protected boolean isMultipleId() {
        return this.idUniquenessPolicy != null && this.idUniquenessPolicy.value() == IdUniquenessPolicyValue.MULTIPLE_ID;
    }

    public boolean isPersistent() {
        return this.lifespanPolicy != null && this.lifespanPolicy.value() == LifespanPolicyValue.PERSISTENT;
    }

    protected boolean isRetain() {
        return this.servantRetentionPolicy == null || this.servantRetentionPolicy.value() == ServantRetentionPolicyValue.RETAIN;
    }

    protected boolean isShutdownInProgress() {
        return this.shutdownState >= 1;
    }

    protected boolean isSingleThreadModel() {
        return this.threadPolicy != null && this.threadPolicy.value() == ThreadPolicyValue.SINGLE_THREAD_MODEL;
    }

    protected boolean isSystemId() {
        return this.idAssignmentPolicy == null || this.idAssignmentPolicy.value() == IdAssignmentPolicyValue.SYSTEM_ID;
    }

    protected boolean isUniqueId() {
        return this.idUniquenessPolicy == null || this.idUniquenessPolicy.value() == IdUniquenessPolicyValue.UNIQUE_ID;
    }

    protected boolean isUseDefaultServant() {
        return this.requestProcessingPolicy != null && this.requestProcessingPolicy.value() == RequestProcessingPolicyValue.USE_DEFAULT_SERVANT;
    }

    protected boolean isUseServantManager() {
        return this.requestProcessingPolicy != null && this.requestProcessingPolicy.value() == RequestProcessingPolicyValue.USE_SERVANT_MANAGER;
    }

    private void makeDestructionApparent() {
        java.lang.Object object = this.poaDestructionLog;
        synchronized (object) {
            if (this.shutdownState < 2) {
                this.poaManager.unregisterPOA(this);
                this.shutdownState = 2;
                if (this.poaListener != null) {
                    this.poaListener.poaStateChanged(this, POAConstants.DESTROYED);
                }
                this.logTrace.printLog(3, "destruction is apparent");
                this.monitor.changeState("destruction is apparent ...");
            }
        }
    }

    private void makeDestructionComplete() {
        if (this.shutdownState < 3) {
            this.logTrace.printLog(3, "clear up the queue ...");
            this.requestController.clearUpQueue(new OBJECT_NOT_EXIST("adapter destroyed"));
            this.logTrace.printLog(3, "... done");
            if (this.etherealize && this.isRetain() && this.useServantManager()) {
                this.logTrace.printLog(3, "etherialize all servants ...");
                this.aom.removeAll((ServantActivator)this.servantManager, this, true);
                this.logTrace.printLog(3, "... done");
            }
            if (!this.isSingleThreadModel()) {
                this.logTrace.printLog(3, "remove all processors from the pool ...");
                this.requestController.clearUpPool();
                this.logTrace.printLog(3, "... done");
            }
            this.logTrace.printLog(3, "stop the request controller ...");
            this.requestController.end();
            this.logTrace.printLog(3, "... done");
            this.shutdownState = 3;
            if (this.parent != null) {
                this.parent.unregisterChild(this.name);
            }
            this.logTrace.printLog(1, "destroyed");
            this.monitor.changeState("destroyed");
        }
    }

    private void makeShutdownInProgress(boolean bl) {
        java.lang.Object object = this.poaCreationLog;
        synchronized (object) {
            if (this.shutdownState < 1) {
                this.etherealize = bl;
                this.shutdownState = 1;
                this.logTrace.printLog(3, "shutdown is in progress");
                this.monitor.changeState("shutdown is in progress ...");
            }
        }
    }

    private boolean previouslyGeneratedObjectId(byte[] byArray) {
        return IdUtil.equals(this.watermark, this.extractWatermark(byArray));
    }

    private boolean previouslyGeneratedObjectKey(byte[] byArray) {
        return IdUtil.equals(byArray, this.getPOAId(), this.getPOAId().length);
    }

    public byte[] reference_to_id(Object object) throws WrongAdapter, WrongPolicy {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("adapter destroyed");
        }
        byte[] byArray = POAUtil.extractOID(object);
        if (this.isSystemId() && !this.previouslyGeneratedObjectId(byArray)) {
            this.logTrace.printLog(0, byArray, "reference_to_id: oid not previous generated!");
            throw new WrongAdapter();
        }
        return byArray;
    }

    public Servant reference_to_servant(Object object) throws ObjectNotActive, WrongAdapter, WrongPolicy {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("adapter destroyed");
        }
        if (!this.isRetain() && !this.isUseDefaultServant()) {
            throw new WrongPolicy();
        }
        byte[] byArray = POAUtil.extractOID(object);
        if (this.isSystemId() && !this.previouslyGeneratedObjectId(byArray)) {
            this.logTrace.printLog(0, byArray, "reference_to_servant: oid not previous generated!");
            throw new WrongAdapter();
        }
        Servant servant = null;
        if (this.isRetain() && (servant = this.aom.getServant(byArray)) != null) {
            return servant;
        }
        if (this.useDefaultServant()) {
            return this.defaultServant;
        }
        throw new ObjectNotActive();
    }

    protected synchronized void removePOAListener(POAListener pOAListener) {
        this.poaListener = EventMulticaster.remove(this.poaListener, pOAListener);
    }

    public byte[] servant_to_id(Servant servant) throws ServantNotActive, WrongPolicy {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("adapter destroyed");
        }
        if (!(this.isUseDefaultServant() || this.isRetain() && this.isUniqueId() || this.isRetain() && this.isImplicitActivation())) {
            throw new WrongPolicy();
        }
        byte[] byArray = null;
        if (this.isRetain()) {
            if (this.isUniqueId() && (byArray = this.aom.getObjectId(servant)) != null) {
                return byArray;
            }
            if (this.isImplicitActivation() && (this.isMultipleId() || !this.aom.contains(servant))) {
                byArray = this.generateObjectId();
                try {
                    this.aom.add(byArray, servant);
                }
                catch (ObjectAlreadyActive objectAlreadyActive) {
                    throw new POAInternalError("error: object already active (servant_to_id)");
                }
                catch (ServantAlreadyActive servantAlreadyActive) {
                    byArray = this.aom.getObjectId(servant);
                }
                return byArray;
            }
        }
        if (this.isUseDefaultServant() && servant == this.defaultServant && this.isInInvocationContext(servant)) {
            try {
                byArray = this.orb.getPOACurrent().get_object_id();
            }
            catch (NoContext noContext) {
                throw new POAInternalError("error: not in invocation context (servant_to_id)");
            }
            return byArray;
        }
        throw new ServantNotActive();
    }

    public Object servant_to_reference(Servant servant) throws ServantNotActive, WrongPolicy {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("adapter destroyed");
        }
        boolean bl = this.isInInvocationContext(servant);
        if (!(this.isRetain() && this.isUniqueId() || this.isRetain() && this.isImplicitActivation() || bl)) {
            throw new WrongPolicy();
        }
        byte[] byArray = null;
        if (bl) {
            try {
                byArray = this.orb.getPOACurrent().get_object_id();
            }
            catch (NoContext noContext) {
                throw new POAInternalError("error: not in invocation context (servant_to_reference)");
            }
            return this.getReference(byArray, servant._all_interfaces(this, byArray)[0]);
        }
        if (this.isRetain()) {
            if (this.isUniqueId() && (byArray = this.aom.getObjectId(servant)) != null) {
                return this.getReference(byArray, servant._all_interfaces(this, byArray)[0]);
            }
            if (this.isImplicitActivation() && (this.isMultipleId() || !this.aom.contains(servant))) {
                byArray = this.generateObjectId();
                try {
                    this.aom.add(byArray, servant);
                }
                catch (ObjectAlreadyActive objectAlreadyActive) {
                    throw new POAInternalError("error: object already active (servant_to_reference)");
                }
                catch (ServantAlreadyActive servantAlreadyActive) {
                    byArray = this.aom.getObjectId(servant);
                }
                this.orb.set_delegate(servant);
                return this.getReference(byArray, servant._all_interfaces(this, byArray)[0]);
            }
        }
        throw new ServantNotActive();
    }

    protected void setMonitor(POAMonitor pOAMonitor) {
        this.monitor = pOAMonitor;
    }

    public void set_servant(Servant servant) throws WrongPolicy {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("adapter destroyed");
        }
        if (!this.isUseDefaultServant()) {
            throw new WrongPolicy();
        }
        this.defaultServant = servant;
        if (this.defaultServant != null) {
            this.orb.set_delegate(this.defaultServant);
        }
    }

    public void set_servant_manager(ServantManager servantManager) throws WrongPolicy {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("adapter destroyed");
        }
        if (!this.isUseServantManager()) {
            throw new WrongPolicy();
        }
        if (this.servantManager != null) {
            throw new BAD_INV_ORDER();
        }
        if (this.isRetain() && !(servantManager instanceof ServantActivator)) {
            throw new WrongPolicy();
        }
        if (!this.isRetain() && !(servantManager instanceof ServantLocator)) {
            throw new WrongPolicy();
        }
        this.servantManager = servantManager;
    }

    public org.omg.PortableServer.POAManager the_POAManager() {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("adapter destroyed");
        }
        return this.poaManager;
    }

    public AdapterActivator the_activator() {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("adapter destroyed");
        }
        return this.adapterActivator;
    }

    public void the_activator(AdapterActivator adapterActivator) {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("adapter destroyed");
        }
        this.adapterActivator = adapterActivator;
    }

    public String the_name() {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("adapter destroyed");
        }
        return POAUtil.unmaskStr(this.name);
    }

    public org.omg.PortableServer.POA the_parent() {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("adapter destroyed");
        }
        return this.parent;
    }

    protected void unregisterChild(String string) {
        java.lang.Object object = this.poaCreationLog;
        synchronized (object) {
            this.childs.remove(string);
            this.poaCreationLog.notifyAll();
        }
    }

    protected boolean useDefaultServant() {
        return this.isUseDefaultServant() && this.defaultServant != null;
    }

    protected boolean useServantManager() {
        return this.isUseServantManager() && this.servantManager != null;
    }

    private short verifyPolicyList(Policy[] policyArray) {
        short s = 0;
        while (s < policyArray.length) {
            switch (policyArray[s].policy_type()) {
                case 17: {
                    if (((org.omg.PortableServer.LifespanPolicy)policyArray[s]).value() != LifespanPolicyValue.PERSISTENT || Environment.implName() != null) break;
                    Debug.output(0, "error: cannot create a persistent poa! (implname property is not used)");
                    return s;
                }
                case 21: {
                    if (((org.omg.PortableServer.ServantRetentionPolicy)policyArray[s]).value() != ServantRetentionPolicyValue.NON_RETAIN) break;
                    Policy policy = POAUtil.getPolicy(policyArray, 22);
                    if (policy != null) {
                        if (((org.omg.PortableServer.RequestProcessingPolicy)policy).value() == RequestProcessingPolicyValue.USE_DEFAULT_SERVANT || ((org.omg.PortableServer.RequestProcessingPolicy)policy).value() == RequestProcessingPolicyValue.USE_SERVANT_MANAGER) break;
                        return s;
                    }
                    return s;
                }
                case 22: {
                    Policy policy;
                    if (((org.omg.PortableServer.RequestProcessingPolicy)policyArray[s]).value() == RequestProcessingPolicyValue.USE_ACTIVE_OBJECT_MAP_ONLY) {
                        policy = POAUtil.getPolicy(policyArray, 21);
                        if (policy == null || ((org.omg.PortableServer.ServantRetentionPolicy)policy).value() == ServantRetentionPolicyValue.RETAIN) break;
                        return s;
                    }
                    if (((org.omg.PortableServer.RequestProcessingPolicy)policyArray[s]).value() != RequestProcessingPolicyValue.USE_DEFAULT_SERVANT) break;
                    policy = POAUtil.getPolicy(policyArray, 18);
                    Policy policy2 = POAUtil.getPolicy(policyArray, 21);
                    if (policy == null && policy2 == null) {
                        return s;
                    }
                    if (!(policy != null && policy2 == null ? ((org.omg.PortableServer.IdUniquenessPolicy)policy).value() != IdUniquenessPolicyValue.MULTIPLE_ID : (policy == null && policy2 != null ? ((org.omg.PortableServer.ServantRetentionPolicy)policy2).value() != ServantRetentionPolicyValue.NON_RETAIN : policy != null && policy2 != null && ((org.omg.PortableServer.IdUniquenessPolicy)policy).value() != IdUniquenessPolicyValue.MULTIPLE_ID && ((org.omg.PortableServer.ServantRetentionPolicy)policy2).value() != ServantRetentionPolicyValue.NON_RETAIN))) break;
                    return s;
                }
                case 20: {
                    if (((org.omg.PortableServer.ImplicitActivationPolicy)policyArray[s]).value() != ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION) break;
                    Policy policy = POAUtil.getPolicy(policyArray, 21);
                    if (policy != null && ((org.omg.PortableServer.ServantRetentionPolicy)policy).value() != ServantRetentionPolicyValue.RETAIN) {
                        return s;
                    }
                    policy = POAUtil.getPolicy(policyArray, 19);
                    if (policy == null || ((org.omg.PortableServer.IdAssignmentPolicy)policy).value() == IdAssignmentPolicyValue.SYSTEM_ID) break;
                    return s;
                }
            }
            s = (short)(s + 1);
        }
        return -1;
    }
}

