/*
 * Decompiled with CFR 0.152.
 */
package jacorb.orb.domain;

import jacorb.orb.domain.ConflictResolutionPolicy;
import jacorb.orb.domain.ConflictResolutionPolicyHelper;
import jacorb.orb.domain.Domain;
import jacorb.orb.domain.DomainFactory;
import jacorb.orb.domain.DomainFactoryHelper;
import jacorb.orb.domain.DomainFactoryImpl;
import jacorb.orb.domain.DomainHelper;
import jacorb.orb.domain.DomainListHolder;
import jacorb.orb.domain.DomainPOA;
import jacorb.orb.domain.DomainQueueImpl;
import jacorb.orb.domain.GraphNodePackage.ClosesCycle;
import jacorb.orb.domain.InitialMapPolicy;
import jacorb.orb.domain.InvalidName;
import jacorb.orb.domain.MemberListInserter;
import jacorb.orb.domain.MetaPolicy;
import jacorb.orb.domain.MetaPolicyHelper;
import jacorb.orb.domain.MetaPropertyPolicy;
import jacorb.orb.domain.NameAlreadyDefined;
import jacorb.orb.domain.ODMImpl;
import jacorb.orb.domain.ORBDomain;
import jacorb.orb.domain.ORBDomainHelper;
import jacorb.orb.domain.PolicyFactory;
import jacorb.orb.domain.PolicyFactoryHelper;
import jacorb.orb.domain.PolicyFactoryImpl;
import jacorb.orb.domain.PolicyTypeAlreadyDefined;
import jacorb.orb.domain.PropertyPolicy;
import jacorb.orb.domain.Util;
import jacorb.poa.POAListener;
import jacorb.util.AssertionViolation;
import jacorb.util.Debug;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.WrongPolicy;

public class DomainImpl
extends DomainPOA
implements POAListener {
    private DomainFactory _factory;
    private ORBDomain theORBDomain = null;
    private PolicyFactory _policyFactory;
    private ODMImpl _odm;
    String _name;
    String _autonamingPrefix;
    long _NameCount;
    String _sep = "/";
    private Hashtable _members = new Hashtable();
    private Hashtable _memberNames = new Hashtable();
    protected java.lang.Object _memberLock = new java.lang.Object();
    private Hashtable _policies = new Hashtable();
    private Hashtable _metaPolicies = new Hashtable();
    private Hashtable _child_domains = new Hashtable();
    private Hashtable _child_domain_names = new Hashtable();
    protected Hashtable _parents = new Hashtable();
    public static final int UNDEF = -1;

    public DomainImpl() {
        this(null, null, "");
    }

    public DomainImpl(Object[] objectArray) {
        this(objectArray, null, "");
    }

    public DomainImpl(Object[] objectArray, int n) {
        this(objectArray, null, "");
    }

    public DomainImpl(Object[] objectArray, Policy[] policyArray) {
        this(objectArray, policyArray, "");
    }

    public DomainImpl(Object[] objectArray, Policy[] policyArray, String string) {
        this._name = string;
        this._autonamingPrefix = "member #";
        if (objectArray != null) {
            MemberListInserter memberListInserter = new MemberListInserter(this, objectArray);
            memberListInserter.start();
        } else {
            Debug.output(3, "DMImpl.init: list of initial members is empty");
        }
        if (policyArray != null) {
            int n = 0;
            while (n < policyArray.length) {
                this._policies.put(new Integer(policyArray[n].policy_type()), policyArray[n]);
                ++n;
            }
        } else {
            Debug.output(3, "DMImpl.init: list of initial policies is empty");
        }
    }

    public String NameAutoPrefix() {
        return this._autonamingPrefix;
    }

    public void NameAutoPrefix(String string) {
        this._autonamingPrefix = string;
    }

    public ORB _getORB() {
        return this._orb();
    }

    public POA _getPOA() {
        return this._poa();
    }

    public final void addToMapping(Object object, Domain domain) {
        this.getODM().addToMapping(object, domain);
        this.getORBDomain().addToODMCache(object, domain);
    }

    public final boolean areMapped(Object object, Domain domain) {
        return this.getODM().areMapped(object, domain);
    }

    static Hashtable calculateDistances(Domain domain) {
        Hashtable<Domain, Integer> hashtable = new Hashtable<Domain, Integer>();
        hashtable.put(domain, new Integer(0));
        DomainQueueImpl domainQueueImpl = new DomainQueueImpl();
        domainQueueImpl.enqueue(domain);
        while (!domainQueueImpl.isEmpty()) {
            Domain domain2 = domainQueueImpl.dequeue();
            Domain[] domainArray = domain2.getChilds();
            int n = 0;
            while (n < domainArray.length) {
                if (!hashtable.containsKey(domainArray[n])) {
                    int n2 = (Integer)hashtable.get(domain2);
                    hashtable.put(domainArray[n], new Integer(n2 + 1));
                    domainQueueImpl.enqueue(domainArray[n]);
                }
                ++n;
            }
        }
        return hashtable;
    }

    private static final Hashtable calculateIntersection(Hashtable hashtable, Hashtable hashtable2) {
        if (hashtable == null || hashtable2 == null) {
            return null;
        }
        if (hashtable.size() < hashtable2.size()) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                java.lang.Object k = enumeration.nextElement();
                if (hashtable2.contains(k)) continue;
                hashtable.remove(k);
            }
            return hashtable;
        }
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            java.lang.Object k = enumeration.nextElement();
            if (hashtable.contains(k)) continue;
            hashtable2.remove(k);
        }
        return hashtable2;
    }

    public void clear(Domain domain) {
        Debug.assert(1, domain.getChildCount() == 0, "DomainFactory.clear: cannot clear a domain with child domains, remove child domains first.");
        Domain domain2 = this._this();
        if (domain._is_equivalent(domain2)) {
            Domain[] domainArray = this.getParents();
            int n = 0;
            while (n < domainArray.length) {
                this.deleteParent(domainArray[n]);
                ++n;
            }
            this._members.clear();
            this._memberNames.clear();
            this._policies.clear();
            this._metaPolicies.clear();
            this._child_domain_names.clear();
            this._child_domains.clear();
            this._parents.clear();
            this._NameCount = 0L;
        }
    }

    public ConflictResolutionPolicy createConflictResolutionPolicy(short s) {
        return this.policyFactory().createConflictResolutionPolicy(s);
    }

    public Domain createDomain(Object[] objectArray, Policy[] policyArray, String string) {
        return this.domainFactory().createDomain(objectArray, policyArray, string);
    }

    public Domain createEmptyDomain() {
        return this.domainFactory().createEmptyDomain();
    }

    public InitialMapPolicy createInitialMapPolicy(short s) {
        return this.policyFactory().createInitialMapPolicy(s);
    }

    public MetaPropertyPolicy createMetaPropertyPolicy() {
        return this.policyFactory().createMetaPropertyPolicy();
    }

    public PropertyPolicy createPropertyPolicy() {
        return this.policyFactory().createPropertyPolicy();
    }

    public Policy create_policy(int n, Any any) throws PolicyError {
        return this.policyFactory().create_policy(n, any);
    }

    public void deleteChild(Domain domain) {
        Domain domain2 = this._this();
        this._child_domains.remove(domain);
        try {
            this._child_domain_names.remove(domain.name());
            if (domain.hasParent(domain2)) {
                domain.deleteParent(domain2);
            }
            Debug.assert(2, !domain.hasParent(domain2) && !domain2.hasChild(domain), "DSImpl.deleteChild: post condition violated");
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            Debug.output(32770, " DomainImpl.deleteChild: child domain doesn't answer, OK");
        }
    }

    public final void deleteMapping(Object object) {
        this.getODM().deleteMapping(object);
        this.getORBDomain().invalidateODMCache(object);
    }

    public void deleteMember(Object object) {
        java.lang.Object object2 = this._memberLock;
        synchronized (object2) {
            if (!this.hasMember(object)) {
                java.lang.Object var3_3 = null;
                return;
            }
            Domain[] domainArray = this.getDomains(object);
            String string = this.getNameOf(object);
            this._members.remove(object);
            if (string != null && !string.equals("")) {
                this._memberNames.remove(string);
            }
            Domain domain = this._this();
            this.deleteMapping(object);
            int n = 0;
            while (n < domainArray.length) {
                try {
                    domainArray[n].removeFromMapping(object, domain);
                }
                catch (COMM_FAILURE cOMM_FAILURE) {}
                ++n;
            }
            DomainImpl.invalidateORBDomainCaches(object, this.getRootDomain(), new Hashtable());
        }
    }

    public void deleteMetaPolicy(MetaPolicy metaPolicy) {
        this._metaPolicies.remove(new Integer(metaPolicy.policy_type()));
    }

    public void deleteParent(Domain domain) {
        this._parents.remove(domain);
        Domain domain2 = this._this();
        if (domain.hasChild(domain2)) {
            domain.deleteChild(domain2);
        }
        Debug.assert(2, !domain.hasChild(domain2) && !domain2.hasParent(domain), "DMImpl.insertParent: child <-> parent postcondition violated");
    }

    public void deletePolicyOfType(int n) {
        this._policies.remove(new Integer(n));
    }

    private String deleteSeparatorAtFront(String string) {
        String string2 = string.substring(this._sep.length(), string.length());
        return string2;
    }

    public void destroy(Domain domain) {
        this.domainFactory().destroy(domain);
    }

    private Policy doConflictResolution(Vector vector, int n, PolicyFactory policyFactory) {
        ConflictResolutionPolicy conflictResolutionPolicy;
        try {
            conflictResolutionPolicy = ConflictResolutionPolicyHelper.narrow(this.get_domain_policy(114));
            Debug.output(2, "DSImpl.doConflictResolution: using policy " + conflictResolutionPolicy.short_description() + " which states: \"" + conflictResolutionPolicy.long_description() + "\"");
        }
        catch (INV_POLICY iNV_POLICY) {
            conflictResolutionPolicy = policyFactory.createConflictResolutionPolicy((short)1);
            Debug.output(2, "DSImpl.doConflictResolution: no conflict policy found. Creating a FIRST conflict resolution policy and inserting it into this domain.");
            this.overwrite_domain_policy(conflictResolutionPolicy);
        }
        java.lang.Object[] objectArray = new Domain[vector.size()];
        vector.copyInto(objectArray);
        return conflictResolutionPolicy.resolveConflict((Domain[])objectArray, n);
    }

    private DomainFactory domainFactory() {
        block3: {
            if (this._factory != null) break block3;
            DomainFactoryImpl domainFactoryImpl = new DomainFactoryImpl();
            try {
                this._factory = DomainFactoryHelper.narrow(this._getPOA().servant_to_reference(domainFactoryImpl));
            }
            catch (WrongPolicy wrongPolicy) {
                Debug.output(1, "the poa of this domain(" + this + ") has the wrong policies for \"servant_to_reference\".");
            }
            catch (Exception exception) {
                Debug.output(1, exception);
            }
        }
        return this._factory;
    }

    private static final void exchangeODMInformation(Domain domain, Domain domain2, Domain domain3, Domain domain4) {
        Domain domain5;
        if (DomainImpl.isEmptyDomain(domain) || DomainImpl.isEmptyDomain(domain2)) {
            return;
        }
        Hashtable hashtable = new Hashtable();
        Domain domain6 = domain3 == null ? DomainImpl.getRootDomain(domain, hashtable) : domain3;
        if (domain6._is_equivalent(domain5 = domain4 == null ? DomainImpl.getRootDomain(domain2, hashtable) : domain4)) {
            return;
        }
        Hashtable hashtable2 = new Hashtable();
        Hashtable hashtable3 = new Hashtable();
        hashtable.clear();
        DomainImpl.getAllMembers(domain6, hashtable, hashtable2);
        hashtable.clear();
        DomainImpl.getAllMembers(domain5, hashtable, hashtable3);
        Hashtable hashtable4 = DomainImpl.calculateIntersection(hashtable2, hashtable3);
        Debug.output(32771, "DomainImpl.exchangeODMInformation: " + hashtable4.size() + " members in intersection.");
        Enumeration enumeration = hashtable4.keys();
        while (enumeration.hasMoreElements()) {
            Object object = (Object)enumeration.nextElement();
            Domain[] domainArray = domain6.getDomains(object);
            Domain[] domainArray2 = domain5.getDomains(object);
            Domain[] domainArray3 = DomainImpl.union(domainArray, domainArray2);
            int n = 0;
            while (n < domainArray.length) {
                domainArray[n].insertMapping(object, domainArray3);
                ++n;
            }
            n = 0;
            while (n < domainArray2.length) {
                domainArray2[n].insertMapping(object, domainArray3);
                ++n;
            }
        }
    }

    public Domain findChild(String string) {
        java.lang.Object v = this._child_domain_names.get(string);
        return DomainHelper.narrow((Object)v);
    }

    private static final void getAllMembers(Domain domain, Hashtable hashtable, Hashtable hashtable2) {
        Object[] objectArray = domain.getMembers();
        int n = 0;
        while (n < objectArray.length) {
            hashtable2.put(objectArray[n], objectArray[n]);
            ++n;
        }
        Domain[] domainArray = domain.getChilds();
        int n2 = 0;
        while (n2 < domainArray.length) {
            if (!hashtable.containsKey(domainArray[n2])) {
                hashtable.put(domainArray[n2], domainArray[n2]);
                Object[] objectArray2 = domainArray[n2].getMembers();
                int n3 = 0;
                while (n3 < objectArray2.length) {
                    hashtable2.put(objectArray2[n3], objectArray2[n3]);
                    ++n3;
                }
                DomainImpl.getIndirectMembers(domainArray[n2], hashtable, hashtable2);
            }
            ++n2;
        }
    }

    public int getChildCount() {
        return this._child_domains.size();
    }

    public Domain[] getChilds() {
        Domain[] domainArray = new Domain[this._child_domains.size()];
        Enumeration enumeration = this._child_domains.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            domainArray[n] = (Domain)enumeration.nextElement();
            ++n;
        }
        return domainArray;
    }

    public Domain[] getDomains(Object object) {
        return this.getORBDomain().getDomains(object);
    }

    public Policy getEffectiveDomainPolicy(int n) {
        Policy policy = null;
        java.lang.Object v = this._policies.get(new Integer(n));
        if (v != null) {
            policy = (Policy)v;
        } else if (!this.isRoot()) {
            policy = this.getParentPolicy(n);
        } else {
            throw new INV_POLICY("DM.getNonInheritedPolicy: this domain " + this + "doesn't have a policy of type " + n);
        }
        return policy;
    }

    public Object[] getIndirectMembers() {
        Hashtable hashtable = new Hashtable();
        DomainImpl.getIndirectMembers(this._this(), new Hashtable(), hashtable);
        Enumeration enumeration = hashtable.keys();
        int n = hashtable.size();
        Object[] objectArray = new Object[n];
        Debug.output(4, "found " + n + " indirect members");
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            objectArray[n2] = (Object)enumeration.nextElement();
            ++n2;
        }
        return objectArray;
    }

    private static final void getIndirectMembers(Domain domain, Hashtable hashtable, Hashtable hashtable2) {
        Domain[] domainArray = domain.getChilds();
        int n = 0;
        while (n < domainArray.length) {
            if (!hashtable.containsKey(domainArray[n])) {
                hashtable.put(domainArray[n], domainArray[n]);
                Object[] objectArray = domainArray[n].getMembers();
                int n2 = 0;
                while (n2 < objectArray.length) {
                    hashtable2.put(objectArray[n2], objectArray[n2]);
                    ++n2;
                }
                DomainImpl.getIndirectMembers(domainArray[n], hashtable, hashtable2);
            }
            ++n;
        }
    }

    public final Domain[] getMapping(Object object) {
        return this.getODM().getMapping(object);
    }

    public int getMemberCount() {
        return this._members.size();
    }

    public Object[] getMembers() {
        java.lang.Object object = this._memberLock;
        synchronized (object) {
            Enumeration enumeration = this._members.keys();
            int n = this._members.size();
            Object[] objectArray = new Object[n];
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                Object object2 = (Object)enumeration.nextElement();
                if (object2._non_existent()) {
                    Debug.output(32770, "DomainImpl.getMembers: removing a invalid object reference from domain members");
                    this.deleteMember(object2);
                    continue;
                }
                objectArray[n2] = object2;
                ++n2;
            }
            if (n2 == n) {
                Object[] objectArray2 = objectArray;
                java.lang.Object var3_9 = null;
                return objectArray2;
            }
            Debug.output(32771, "oldSize: " + n + "counter: " + n2);
            Object[] objectArray3 = new Object[n2];
            int n3 = 0;
            while (n3 < n2) {
                objectArray3[n3] = objectArray[n3];
                ++n3;
            }
            Object[] objectArray4 = objectArray3;
            java.lang.Object var3_10 = null;
            return objectArray4;
        }
    }

    public MetaPolicy getMetaPolicy(int n) {
        java.lang.Object v = this._metaPolicies.get(new Integer(n));
        if (v != null) {
            return MetaPolicyHelper.narrow((Object)v);
        }
        throw new INV_POLICY("no meta policy of type " + n + " available");
    }

    public String getNameOf(Object object) {
        java.lang.Object v = this._members.get(object);
        if (v != null) {
            return (String)v;
        }
        return "";
    }

    private final ODMImpl getODM() {
        if (this._odm == null) {
            this._odm = new ODMImpl();
        }
        return this._odm;
    }

    private final ORBDomain getORBDomain() {
        if (this.theORBDomain == null) {
            try {
                return (ORBDomain)this._getORB().resolve_initial_references("LocalDomainService");
            }
            catch (org.omg.CORBA.ORBPackage.InvalidName invalidName) {
                Debug.output(32769, invalidName);
            }
        }
        return this.theORBDomain;
    }

    public int getParentCount() {
        return this._parents.size();
    }

    protected Policy getParentPolicy(int n) {
        ConflictResolutionPolicy conflictResolutionPolicy;
        Debug.assert(2, this.isRoot() ^ true, "DMImpl.getParentPolicy: precondition violated");
        Enumeration enumeration = this._parents.keys();
        if (this._parents.size() == 1) {
            Domain domain = DomainHelper.narrow((Object)enumeration.nextElement());
            return domain.get_domain_policy(n);
        }
        Vector<Domain> vector = new Vector<Domain>();
        while (enumeration.hasMoreElements()) {
            Domain domain = DomainHelper.narrow((Object)enumeration.nextElement());
            try {
                domain.get_domain_policy(n);
            }
            catch (INV_POLICY iNV_POLICY) {
                continue;
            }
            vector.addElement(domain);
        }
        int n2 = vector.size();
        if (n2 < 1) {
            throw new INV_POLICY("DM.get_domain_policy: this domain " + this + "doesn't have a policy of type " + n);
        }
        if (n2 == 1) {
            return ((Domain)vector.firstElement()).get_domain_policy(n);
        }
        if (n == 114) {
            Debug.output(1, "DomainImpl.getParentPolicy: conflict resolution  policy itself conflicts, using (hardcoded) ParentRulesPolicy to resolve this conflict.");
            ConflictResolutionPolicy conflictResolutionPolicy2 = this.policyFactory().createConflictResolutionPolicy((short)2);
            java.lang.Object[] objectArray = new Domain[vector.size()];
            vector.copyInto(objectArray);
            return conflictResolutionPolicy2.resolveConflict((Domain[])objectArray, n);
        }
        try {
            conflictResolutionPolicy = ConflictResolutionPolicyHelper.narrow(this.get_domain_policy(114));
        }
        catch (INV_POLICY iNV_POLICY) {
            conflictResolutionPolicy = this.policyFactory().createConflictResolutionPolicy((short)2);
            this.overwrite_domain_policy(conflictResolutionPolicy);
        }
        java.lang.Object[] objectArray = new Domain[vector.size()];
        vector.copyInto(objectArray);
        return conflictResolutionPolicy.resolveConflict((Domain[])objectArray, n);
    }

    public Domain[] getParents() {
        Enumeration enumeration = this._parents.keys();
        Domain[] domainArray = new Domain[this._parents.size()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            domainArray[n] = DomainHelper.narrow((Object)enumeration.nextElement());
            ++n;
        }
        return domainArray;
    }

    public String[] getPathNames() {
        return null;
    }

    public Policy[] getPolicies() {
        Enumeration enumeration = this._policies.elements();
        Policy[] policyArray = new Policy[this._policies.size()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            policyArray[n] = (Policy)enumeration.nextElement();
            ++n;
        }
        return policyArray;
    }

    public Policy getPolicy(Object object, int n) {
        Policy policy = null;
        Vector<Domain> vector = new Vector<Domain>();
        Domain[] domainArray = this.getDomains(object);
        Debug.assert(2, domainArray != null, " Domain.getPolicy: result of getDomains is null");
        int n2 = 0;
        while (n2 < domainArray.length) {
            try {
                Debug.assert(2, domainArray[n2] != null, "Domain.getPolicy: array entry is null");
                policy = domainArray[n2].getEffectiveDomainPolicy(n);
                vector.addElement(domainArray[n2]);
            }
            catch (INV_POLICY iNV_POLICY) {}
            ++n2;
        }
        int n3 = vector.size();
        if (n3 == 1) {
            Debug.assert(1, policy != null, "DomainImpl.getPolicy: pol is null");
            return policy;
        }
        if (n3 > 1) {
            Debug.output(2, "Domain.getPolicy: there is more than one domain (n= " + n3 + ") with the wanted policy, using conflict resolution for overlapping domains...");
            policy = this.doConflictResolution(vector, n, this.policyFactory());
            Debug.assert(1, policy != null, "DomainImpl.getPolicy: pol is null (conflict case)");
            return policy;
        }
        throw new INV_POLICY("obj " + object + " does not have a policy of type " + n);
    }

    public int getPolicyCount() {
        return this._policies.size();
    }

    public Domain getRootDomain() {
        return DomainImpl.getRootDomain(this._this(), new Hashtable());
    }

    private static final Domain getRootDomain(Domain domain) {
        Debug.assert(2, domain != null, "Domain.getRootDomain: Parameter aDomain is null");
        if (domain.isRoot()) {
            return domain;
        }
        Domain[] domainArray = domain.getParents();
        Domain domain2 = null;
        int n = 0;
        while (n < domainArray.length) {
            Domain domain3 = domainArray[n];
            Debug.output(32771, "Domain.getRootDomain: calling getRootDomain on " + domain.name() + ", parent is " + domain3.name());
            Domain domain4 = DomainImpl.getRootDomain(domain3);
            Debug.assert(1, domain4 != null, "DMImpl.getRootDomain: found root is null");
            if (domain2 == null) {
                domain2 = domain4;
            } else if (!domain2._is_equivalent(domain4)) {
                throw new AssertionViolation("DMImpl.getRootDomain: invariant of  unique root violated");
            }
            ++n;
        }
        return domain2;
    }

    static final Domain getRootDomain(Domain domain, Hashtable hashtable) {
        Debug.assert(2, domain != null, "Domain.getRootDomain: Parameter aDomain is null");
        if (domain.isRoot()) {
            hashtable.put(domain, domain);
            return domain;
        }
        Domain[] domainArray = domain.getParents();
        Domain domain2 = null;
        int n = 0;
        while (n < domainArray.length) {
            Domain domain3 = domainArray[n];
            Domain domain4 = (Domain)hashtable.get(domain3);
            if (domain4 != null) {
                return domain4;
            }
            Debug.output(3, "Domain.getRootDomain(Dynamic): calling getRootDomain on " + domain.name() + ", parent is " + domain3.name());
            Domain domain5 = DomainImpl.getRootDomain(domain3, hashtable);
            Debug.assert(1, domain5 != null, "DMImpl.getRootDomain: found root is null");
            if (domain2 == null) {
                domain2 = domain5;
            } else if (!domain2._is_equivalent(domain5)) {
                throw new AssertionViolation("DMImpl.getRootDomain: invariant of  unique root violated");
            }
            ++n;
        }
        hashtable.put(domain, domain2);
        return domain2;
    }

    public Policy get_domain_policy(int n) {
        Policy policy = null;
        java.lang.Object v = this._policies.get(new Integer(n));
        if (v == null) {
            throw new INV_POLICY("DM.get_domain_policy: this domain " + this + "doesn't have a policy of type " + n);
        }
        policy = (Policy)v;
        return policy;
    }

    public boolean hasChild(Domain domain) {
        return this._child_domains.containsKey(domain);
    }

    private static boolean hasIndirectMember(Domain domain, Object object, Hashtable hashtable) {
        if (domain.hasMember(object)) {
            return true;
        }
        Domain[] domainArray = domain.getChilds();
        int n = 0;
        while (n < domainArray.length) {
            if (!hashtable.containsKey(domainArray[n])) {
                hashtable.put(domainArray[n], domainArray[n]);
                if (DomainImpl.hasIndirectMember(domainArray[n], object, hashtable)) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    public boolean hasIndirectMember(Object object) {
        return DomainImpl.hasIndirectMember(this._this(), object, new Hashtable());
    }

    public final boolean hasMapping(Object object) {
        return this.getODM().hasMapping(object);
    }

    public boolean hasMember(Object object) {
        return this._members.containsKey(object);
    }

    public boolean hasParent(Domain domain) {
        return this._parents.containsKey(domain);
    }

    public boolean hasPolicyOfType(int n) {
        return this._policies.containsKey(new Integer(n));
    }

    public void insertChild(Domain domain) throws ClosesCycle, NameAlreadyDefined {
        Domain domain2 = this._this();
        Debug.assert(2, domain != null, "child is null");
        Debug.assert(2, domain2 != null, "self is null");
        if (domain.isReachable(domain2)) {
            throw new ClosesCycle();
        }
        Debug.assert(2, domain != null, "child is null");
        String string = domain.name();
        if (this._child_domain_names.containsKey(string)) {
            throw new NameAlreadyDefined(string);
        }
        this._child_domains.put(domain, domain);
        this._child_domain_names.put(string, domain);
        if (!domain.hasParent(domain2)) {
            domain.insertParent(domain2);
        }
        Debug.assert(2, domain2.hasChild(domain) && domain.hasParent(domain2), "post condition of Domain.insertChild violated");
    }

    public final void insertMapping(Object object, Domain[] domainArray) {
        this.getODM().insertMapping(object, domainArray);
        this.getORBDomain().updateODMCache(object, domainArray);
    }

    public void insertMember(Object object) {
        java.lang.Object object2 = this._memberLock;
        synchronized (object2) {
            if (this.hasMember(object)) {
                java.lang.Object var3_3 = null;
                return;
            }
            Domain[] domainArray = this.getDomains(object);
            ++this._NameCount;
            String string = String.valueOf(this._autonamingPrefix) + Long.toString(this._NameCount);
            this._members.put(object, string);
            this._memberNames.put(string, object);
            Domain domain = this._this();
            this.insertMapping(object, domainArray);
            this.addToMapping(object, domain);
            int n = 0;
            while (n < domainArray.length) {
                try {
                    domainArray[n].addToMapping(object, domain);
                }
                catch (COMM_FAILURE cOMM_FAILURE) {}
                ++n;
            }
            DomainImpl.invalidateORBDomainCaches(object, this.getRootDomain(), new Hashtable());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insertMemberWithName(String string, Object object) throws NameAlreadyDefined {
        java.lang.Object object2 = this._memberLock;
        synchronized (object2) {
            if (this._memberNames.containsKey(string)) {
                throw new NameAlreadyDefined(string);
            }
            if (this.hasMember(object)) {
                String string2 = this.getNameOf(object);
                try {
                    if (string2.equals(string)) {
                        return;
                    }
                    this.renameMember(string2, string);
                    return;
                }
                catch (InvalidName invalidName) {
                }
                return;
            }
            Domain[] domainArray = this.getDomains(object);
            this._memberNames.put(string, object);
            this._members.put(object, string);
            Domain domain = this._this();
            this.insertMapping(object, domainArray);
            this.addToMapping(object, domain);
            int n = 0;
            while (true) {
                if (n >= domainArray.length) {
                    DomainImpl.invalidateORBDomainCaches(object, this.getRootDomain(), new Hashtable());
                    return;
                }
                try {
                    domainArray[n].addToMapping(object, domain);
                }
                catch (COMM_FAILURE cOMM_FAILURE) {}
                ++n;
            }
        }
    }

    public void insertParent(Domain domain) throws ClosesCycle, NameAlreadyDefined {
        Hashtable hashtable = new Hashtable();
        Domain domain2 = this._this();
        Domain domain3 = DomainImpl.getRootDomain(domain2, hashtable);
        Domain domain4 = DomainImpl.getRootDomain(domain, hashtable);
        Debug.assert(32769, domain2.isRoot() || !domain2.isRoot() && domain4._is_equivalent(domain3), "DMImpl.insertParent: precondition violated");
        Debug.output(32771, "Domain(" + this._name + ").insertParent: " + " adding " + domain.name() + " as parent domain.");
        if (domain2.isReachable(domain)) {
            throw new ClosesCycle();
        }
        DomainImpl.exchangeODMInformation(domain, domain2, domain4, domain3);
        this._parents.put(domain, domain);
        if (!domain.hasChild(domain2)) {
            try {
                domain.insertChild(domain2);
            }
            catch (NameAlreadyDefined nameAlreadyDefined) {
                this._parents.remove(domain);
                throw nameAlreadyDefined;
            }
        }
        hashtable.clear();
        domain3 = DomainImpl.getRootDomain(domain2, hashtable);
        domain4 = DomainImpl.getRootDomain(domain, hashtable);
        Debug.assert(1, domain2.hasParent(domain) && domain.hasChild(domain2), "DMImpl.insertParent: child <-> parent postcond. violated");
        Debug.assert(1, domain2.isRoot() ^ true, "DMImpl.insertParent: root postcondition violated");
        if (!domain3._is_equivalent(domain4)) {
            Debug.output(1, String.valueOf(domain2.name()) + ": parent " + domain.name() + "has root " + domain4.name() + "I have " + domain3.name() + " as root.");
        }
        Debug.assert(1, domain4._is_equivalent(domain3), "DMImpl.insertParent: unique root postcondition violated");
    }

    protected static final void invalidateORBDomainCaches(Object object, Domain domain, Hashtable hashtable) {
        Domain[] domainArray;
        if (hashtable.containsKey(domain)) {
            return;
        }
        hashtable.put(domain, domain);
        try {
            domainArray = ORBDomainHelper.narrow(domain);
            Debug.output(32771, "DomainImpl.invalidateORBDomainCaches: invalidating odm cache of orb domain \"" + domainArray.name() + "\" on a  \"" + Util.toID(object.toString()));
            domainArray.invalidateODMCache(object);
        }
        catch (BAD_PARAM bAD_PARAM) {}
        try {
            domainArray = domain.getChilds();
            int n = 0;
            while (n < domainArray.length) {
                DomainImpl.invalidateORBDomainCaches(object, domainArray[n], hashtable);
                ++n;
            }
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            Debug.output(32770, "DomainImpl.invalidateORBDomainCaches: comm failer occured, continue.");
        }
    }

    private static final boolean isEmptyDomain(Domain domain) {
        return domain.getMemberCount() == 0 && domain.getChildCount() == 0 && domain.getParentCount() == 0;
    }

    public boolean isReachable(Domain domain) {
        if (this._this()._is_equivalent(domain)) {
            return true;
        }
        if (this.hasChild(domain)) {
            return true;
        }
        Enumeration enumeration = this._child_domains.keys();
        while (enumeration.hasMoreElements()) {
            Domain domain2 = (Domain)enumeration.nextElement();
            if (!domain2.isReachable(domain)) continue;
            return true;
        }
        return false;
    }

    public boolean isRoot() {
        return this._parents.size() == 0;
    }

    public String name() {
        return this._name;
    }

    public void name(String string) {
        this._name = string;
    }

    public void overwrite_domain_policy(Policy policy) {
        this._policies.put(new Integer(policy.policy_type()), policy);
    }

    public void poaCreated(jacorb.poa.POA pOA) {
    }

    public void poaStateChanged(jacorb.poa.POA pOA, int n) {
    }

    private PolicyFactory policyFactory() {
        block3: {
            if (this._policyFactory != null) break block3;
            PolicyFactoryImpl policyFactoryImpl = new PolicyFactoryImpl();
            try {
                this._policyFactory = PolicyFactoryHelper.narrow(this._getPOA().servant_to_reference(policyFactoryImpl));
            }
            catch (WrongPolicy wrongPolicy) {
                Debug.output(1, "the poa of this domain(" + this + ") has the wrong policies for \"servant_to_reference\".");
            }
            catch (Exception exception) {
                Debug.output(1, exception);
            }
        }
        return this._policyFactory;
    }

    public void referenceCreated(Object object) {
        Debug.output(2, " DomainImpl.referenceCreated: POA created new object reference" + object);
    }

    public final void removeFromMapping(Object object, Domain domain) {
        this.getODM().removeFromMapping(object, domain);
        this.getORBDomain().addToODMCache(object, domain);
    }

    public void renameChildDomain(String string, String string2) throws InvalidName, NameAlreadyDefined {
        if (this._child_domain_names.containsKey(string2)) {
            throw new NameAlreadyDefined(string2);
        }
        Domain domain = this.findChild(string);
        if (domain == null) {
            throw new InvalidName(string);
        }
        domain.name(string2);
        this._child_domain_names.remove(string);
        this._child_domain_names.put(string2, domain);
    }

    public void renameMember(String string, String string2) throws InvalidName, NameAlreadyDefined {
        Object object = this.resolveName(string);
        if (object == null) {
            throw new InvalidName(string);
        }
        if (this._memberNames.containsKey(string2)) {
            throw new NameAlreadyDefined(string2);
        }
        this._memberNames.remove(string);
        this._members.remove(object);
        this._memberNames.put(string2, object);
        this._members.put(object, string2);
    }

    public Domain resolveDomainPathName(String string) throws InvalidName {
        if (string == null) {
            throw new InvalidName("***pathname is null***");
        }
        if (string.startsWith(this._sep)) {
            if (string.equals(this._sep)) {
                return this.getRootDomain();
            }
            if (this.isRoot()) {
                return this.resolveDomainPathName(this.deleteSeparatorAtFront(string));
            }
            return this.getRootDomain().resolveDomainPathName(this.deleteSeparatorAtFront(string));
        }
        Domain domain = this._this();
        while (true) {
            String string2;
            String string3;
            int n;
            if ((n = string.indexOf(this._sep)) < 0) {
                string3 = string;
                string2 = "";
            } else {
                string3 = string.substring(0, n);
                string2 = string.substring(n + this._sep.length(), string.length());
            }
            Domain domain2 = domain.findChild(string3);
            if (domain2 == null) {
                throw new InvalidName(string3);
            }
            if (string2.length() < 1) {
                return domain2;
            }
            string = string2;
            domain = domain2;
        }
    }

    public Object resolveName(String string) {
        return (Object)this._memberNames.get(string);
    }

    public String separator() {
        return this._sep;
    }

    public void separator(String string) {
        this._sep = string;
    }

    public void setMetaPolicy(MetaPolicy metaPolicy) throws PolicyTypeAlreadyDefined {
        this._metaPolicies.put(new Integer(metaPolicy.policy_type()), metaPolicy);
    }

    public void set_domain_policy(Policy policy) throws PolicyTypeAlreadyDefined {
        int n = policy.policy_type();
        if (this._policies.containsKey(new Integer(n))) {
            throw new PolicyTypeAlreadyDefined(n);
        }
        this._policies.put(new Integer(n), policy);
        Debug.output(3, "Domain.set_domain_policy:setting policy of type " + n);
    }

    protected static final boolean traverseDownwards(Object object, Domain domain, DomainListHolder domainListHolder, Hashtable hashtable) {
        if (hashtable.containsKey(domain)) {
            return false;
        }
        hashtable.put(domain, domain);
        if (domain.hasMember(object)) {
            domainListHolder.value = domain.getMapping(object);
            Debug.assert(1, domainListHolder.value != null, "D<" + domain.name() + ">: has member, but" + " mapping is null");
            Debug.output(32770, "DomainImpl.traverseDownwards found domain: " + domain.name());
            return true;
        }
        Domain[] domainArray = domain.getChilds();
        int n = 0;
        while (n < domainArray.length) {
            if (DomainImpl.traverseDownwards(object, domainArray[n], domainListHolder, hashtable)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static final void traverseDownwards(Object object, Domain domain, Hashtable hashtable, Hashtable hashtable2) {
        Debug.output(4, "D.traverseDownwards: visiting domain " + domain.name());
        if (hashtable2.containsKey(domain)) {
            Debug.output(4, "D.traverseDownwards: domain " + domain.name() + " already (down)traversed, skipping it");
            return;
        }
        hashtable2.put(domain, domain);
        if (domain.hasMember(object)) {
            hashtable.put(domain, domain);
        }
        Domain[] domainArray = domain.getChilds();
        int n = 0;
        while (n < domainArray.length) {
            DomainImpl.traverseDownwards(object, domainArray[n], hashtable, hashtable2);
            ++n;
        }
    }

    private static final void traverseUpwards(Domain domain, Hashtable hashtable) {
        Debug.output(4, "D.traverseUpwards: visiting domain " + domain.name());
        if (hashtable.containsKey(domain)) {
            Debug.output(4, "D.traverseUpwards: domain " + domain.name() + " already (up)traversed, skipping it");
            return;
        }
        hashtable.put(domain, domain);
        Domain[] domainArray = domain.getParents();
        int n = 0;
        while (n < domainArray.length) {
            DomainImpl.traverseUpwards(domainArray[n], hashtable);
            ++n;
        }
    }

    private static final Domain[] union(Domain[] domainArray, Domain[] domainArray2) {
        Hashtable<Domain, Domain> hashtable = new Hashtable<Domain, Domain>(domainArray.length + domainArray2.length);
        int n = 0;
        while (n < domainArray.length) {
            hashtable.put(domainArray[n], domainArray[n]);
            ++n;
        }
        n = 0;
        while (n < domainArray2.length) {
            hashtable.put(domainArray2[n], domainArray2[n]);
            ++n;
        }
        Domain[] domainArray3 = new Domain[hashtable.size()];
        Enumeration enumeration = hashtable.elements();
        n = 0;
        while (enumeration.hasMoreElements()) {
            domainArray3[n] = (Domain)enumeration.nextElement();
            ++n;
        }
        return domainArray3;
    }
}

