/*
 * Decompiled with CFR 0.152.
 */
package jacorb.orb;

import jacorb.orb.Connection;
import jacorb.orb.Delegate;
import jacorb.orb.ORB;
import jacorb.orb.ParsedIOR;
import jacorb.orb.factory.SocketFactory;
import jacorb.orb.http.ClientConnection;
import jacorb.proxy.Forwarder;
import jacorb.proxy.ForwarderHelper;
import jacorb.util.Debug;
import jacorb.util.Environment;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;
import org.omg.IOP.IOR;

public class ConnectionManager {
    private ORB orb;
    private Hashtable connections = new Hashtable();
    private SocketFactory socket_factory = null;
    private SocketFactory ssl_socket_factory = null;
    private Forwarder proxyObj = null;
    private boolean proxyConnectDirectly = false;
    private Hashtable unproxyTable = null;
    private boolean applet_properties_read = false;
    private Vector proxyEntries = new Vector();
    static /* synthetic */ Class class$jacorb$orb$ORB;

    public ConnectionManager(ORB oRB) {
        this.orb = oRB;
        this.socket_factory = new SocketFactory(){

            public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
                return new Socket(string, n);
            }

            public boolean isSSL(Socket socket) {
                return false;
            }
        };
        if (Environment.supportSSL()) {
            String string = Environment.getProperty("jacorb.ssl.socket_factory");
            if (string == null || string.length() == 0) {
                throw new RuntimeException("SSL support is on, but the property \"jacorb.ssl.socket_factory\" is not set!");
            }
            try {
                Class<?> clazz = Class.forName(string);
                Constructor<?> constructor = clazz.getConstructor(class$jacorb$orb$ORB != null ? class$jacorb$orb$ORB : (class$jacorb$orb$ORB = ConnectionManager.class$("jacorb.orb.ORB")));
                this.ssl_socket_factory = (SocketFactory)constructor.newInstance(oRB);
            }
            catch (Exception exception) {
                Debug.output(257, exception);
                throw new RuntimeException("SSL support is on, but the ssl socket factory can't be instanciated (see trace)!");
            }
        }
    }

    public final Connection _getConnection(Delegate delegate) {
        return this._getConnection(delegate.get_adport(), delegate.port_is_ssl());
    }

    /*
     * Unable to fully structure code
     */
    public final Connection _getConnection(String var1_1, boolean var2_2) {
        var3_3 = Environment.noOfRetries();
        if (var1_1.indexOf(47) > 0) {
            var1_1 = var1_1.substring(var1_1.indexOf(47) + 1);
        }
        var4_4 = var1_1.substring(0, var1_1.indexOf(":"));
        var5_5 = var1_1.substring(var1_1.indexOf(":") + 1);
        try {
            var6_6 = InetAddress.getByName(var4_4);
            var1_1 = String.valueOf(var6_6.getHostAddress()) + ":" + var5_5;
        }
        catch (UnknownHostException v0) {
            throw new COMM_FAILURE("Unknown host " + var4_4);
        }
        var6_6 = (Connection)this.connections.get(var1_1);
        if (var6_6 == null) ** GOTO lbl60
        if (!var6_6.isSSL()) {
            if (var2_2) {
                throw new NO_PERMISSION(0, CompletionStatus.COMPLETED_NO);
            }
            if (Environment.enforceSSL()) {
                throw new NO_PERMISSION("Illegal connection setup, SSL required", 0, CompletionStatus.COMPLETED_NO);
            }
        }
        var6_6.incUsers();
        return var6_6;
lbl-1000:
        // 1 sources

        {
            try {
                var7_8 = new Integer(var5_5);
                if (var7_8 < 0) {
                    var7_8 += 65536;
                }
                if (Environment.useHTTPTunneling(var4_4)) {
                    var8_9 = new ClientConnection(this, var4_4, var7_8, this.socket_factory);
                    this.connections.put(var8_9.getInfo(), var8_9);
                    return var8_9;
                }
                var9_11 = null;
                try {
                    if (var2_2) {
                        var9_11 = this.ssl_socket_factory.createSocket(var4_4, var7_8);
                    } else {
                        if (Environment.enforceSSL()) {
                            throw new NO_PERMISSION("Illegal connection request to non-SSL target, SSL required", 0, CompletionStatus.COMPLETED_NO);
                        }
                        var9_11 = this.socket_factory.createSocket(var4_4, var7_8);
                    }
                }
                catch (SecurityException v1) {
                    var9_11 = this.socket_factory.createSocket(this.orb.getApplet().getCodeBase().getHost(), var7_8);
                }
                var9_11.setTcpNoDelay(true);
                var10_12 = Environment.getProperty("jacorb.connection.client_timeout");
                if (var10_12 != null) {
                    try {
                        var9_11.setSoTimeout(Integer.parseInt(var10_12));
                    }
                    catch (NumberFormatException v2) {}
                }
                var8_10 = new jacorb.orb.giop.ClientConnection(this, var9_11, var2_2 != false ? this.ssl_socket_factory : this.socket_factory);
                this.connections.put(var8_10.getInfo(), var8_10);
                return var8_10;
            }
            catch (IOException var7_7) {
                Debug.output(258, var7_7);
                Debug.output(1, "Retrying connection to " + var1_1);
                try {
                    Thread.sleep(Environment.retryInterval());
                }
                catch (InterruptedException v3) {}
                --var3_3;
            }
lbl60:
            // 2 sources

            ** while (var3_3 + 1 > 0)
        }
lbl61:
        // 1 sources

        if (var3_3 < 0) {
            throw new COMM_FAILURE("Retries exceeded, couldn't connect to " + var1_1);
        }
        return var6_6;
    }

    public void addConnection(Connection connection) {
        this.connections.put(connection.getInfo(), connection);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String effective_host_and_port(Delegate delegate) {
        java.lang.Object object;
        String string;
        java.lang.Object object2;
        String string2 = null;
        if (this.proxyConnectDirectly || !Environment.useAppligator(this.orb.getApplet() != null)) {
            string2 = delegate.get_adport();
        } else {
            this.proxyConnectDirectly = true;
            if (this.proxyObj == null) {
                this.initProxy();
            }
            Debug.output(2, "ORB:Applet-Proxy diverting");
            object2 = new StringHolder();
            string = this.proxyObj.forward(delegate.getParsedIOR().getIORString(), (StringHolder)object2);
            this.proxyEntries.addElement(((StringHolder)object2).value);
            object = new ParsedIOR(string);
            this.unproxyTable.put(((ParsedIOR)object).getIORString(), delegate.getParsedIOR().getIORString());
            delegate.setIOR(((ParsedIOR)object).getIOR());
            delegate.set_adport_and_key(String.valueOf(((ParsedIOR)object).getProfileBody().host) + ":" + ((ParsedIOR)object).getProfileBody().port, ((ParsedIOR)object).getProfileBody().object_key);
            this.proxyConnectDirectly = false;
            Debug.output(2, "ORB:Applet-Proxy new address set");
            string2 = delegate.get_adport();
        }
        if (string2.indexOf(47) > 0) {
            string2 = string2.substring(string2.indexOf(47) + 1);
        }
        object2 = string2.substring(0, string2.indexOf(":"));
        string = string2.substring(string2.indexOf(":") + 1);
        try {
            object = InetAddress.getByName((String)object2);
            string2 = String.valueOf(((InetAddress)object).getHostAddress()) + ":" + string;
        }
        catch (UnknownHostException unknownHostException) {
            throw new COMM_FAILURE("Unknown host " + (String)object2);
        }
        return string2;
    }

    public Connection getConnection(Delegate delegate) {
        if (this.proxyConnectDirectly || !Environment.useAppligator(this.orb.getApplet() != null)) {
            return this._getConnection(delegate);
        }
        this.proxyConnectDirectly = true;
        if (this.proxyObj == null) {
            this.initProxy();
        }
        Debug.output(2, "ORB:Applet-Proxy diverting");
        StringHolder stringHolder = new StringHolder();
        String string = this.proxyObj.forward(delegate.getParsedIOR().getIORString(), stringHolder);
        this.proxyEntries.addElement(stringHolder.value);
        ParsedIOR parsedIOR = new ParsedIOR(string);
        this.unproxyTable.put(parsedIOR.getIORString(), delegate.getParsedIOR().getIORString());
        delegate.setIOR(parsedIOR.getIOR());
        delegate.set_adport_and_key(String.valueOf(parsedIOR.getProfileBody().host) + ":" + parsedIOR.getProfileBody().port, parsedIOR.getProfileBody().object_key);
        this.proxyConnectDirectly = false;
        Debug.output(2, "ORB:Applet-Proxy new address set");
        return this._getConnection(delegate);
    }

    public ORB getORB() {
        return this.orb;
    }

    public void initProxy() {
        if (!Environment.useAppligator(this.orb.getApplet() != null)) {
            return;
        }
        Debug.output(2, "using appligator");
        if (this.proxyObj == null) {
            String string;
            Debug.output(2, "ORB:Applet-Proxy Init");
            URL uRL = null;
            this.unproxyTable = new Hashtable();
            if (this.orb.getApplet() != null) {
                try {
                    if (!this.applet_properties_read) {
                        Environment.readFromURL(new URL(String.valueOf(this.orb.getApplet().getCodeBase().toString()) + "jacorb.properties"));
                        this.applet_properties_read = true;
                        Debug.initialize();
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    Debug.output(2, "Bad URL: " + this.orb.getApplet().getCodeBase().toString() + "jacorb.properties");
                    throw new RuntimeException("Bad URL for default context.");
                }
                try {
                    uRL = new URL(this.orb.getApplet().getParameter("JacorbProxyServerURL"));
                    Debug.output(2, "Trying address (applet param):" + uRL.toString());
                    this.readProxyIOR(uRL);
                    return;
                }
                catch (MalformedURLException malformedURLException) {
                    Debug.output(2, "Malformed proxyaddress in parametertags");
                }
                catch (Exception exception) {
                    Debug.output(2, "No proxy ior found in" + uRL.toString());
                }
            } else {
                this.applet_properties_read = true;
            }
            if (this.proxyObj == null) {
                try {
                    uRL = new URL(Environment.proxyURL());
                    Debug.output(2, "ORB:Trying address (Environment):" + uRL.toString());
                    this.readProxyIOR(uRL);
                    return;
                }
                catch (MalformedURLException malformedURLException) {
                    Debug.output(2, "ORB:No proxyaddress in local properties set");
                }
                catch (Exception exception) {
                    Debug.output(2, "ORB:No proxy ior found in (Environment) " + uRL.toString());
                }
            }
            if (this.proxyObj == null) {
                string = this.orb.getApplet().getCodeBase().toString();
                try {
                    uRL = new URL(String.valueOf(string.substring(string.lastIndexOf("/"))) + "proxy.ior");
                    Debug.output(2, "ORB:Trying address (Magic):" + uRL.toString());
                    this.readProxyIOR(uRL);
                    return;
                }
                catch (MalformedURLException malformedURLException) {
                    Debug.output(2, "ORB:Malformed Applet-Codebase URL");
                }
                catch (Exception exception) {
                    Debug.output(2, "ORB:No proxy ior found in" + uRL.toString());
                }
            }
            if (this.proxyObj == null) {
                string = this.orb.getApplet().getCodeBase().getHost();
                try {
                    uRL = new URL("http://" + string + "/proxy.ior");
                    Debug.output(2, "ORB:Trying address (MagicHome):" + uRL.toString());
                    this.readProxyIOR(uRL);
                    return;
                }
                catch (MalformedURLException malformedURLException) {
                    Debug.output(2, "ORB:Malformed Host URL");
                }
                catch (Exception exception) {
                    Debug.output(2, "ORB:No proxy ior found in " + uRL.toString());
                }
            }
            if (this.proxyObj == null) {
                string = this.orb.getApplet().getCodeBase().getHost();
                try {
                    uRL = new URL("http://" + string + "/" + Environment.proxyURL());
                    Debug.output(2, "ORB:Trying address (WebHome):" + uRL.toString());
                    this.readProxyIOR(uRL);
                    return;
                }
                catch (MalformedURLException malformedURLException) {
                    Debug.output(2, "ORB:Malformed Host/Env URL");
                }
                catch (Exception exception) {
                    Debug.output(2, "ORB:No proxy ior found in " + uRL.toString());
                }
            }
            if (this.proxyObj == null) {
                Debug.output(1, "ORB:Proxy server NOT found");
                if (this.orb.getApplet() != null) {
                    throw new RuntimeException("Appligator not reachable! Check configuration");
                }
            }
        } else {
            Debug.output(2, "ORB:Tried to initialize proxy a second time -- ignored");
        }
    }

    IOR proxyfy(String string) {
        Debug.output(4, "ORB.proxyfy(), proxifying original ior " + string);
        StringHolder stringHolder = new StringHolder();
        IOR iOR = new ParsedIOR(this.proxyObj.forward(string, stringHolder)).getIOR();
        String string2 = new ParsedIOR(this.proxyObj.forward(string, stringHolder)).getIORString();
        this.proxyEntries.addElement(stringHolder.value);
        this.unproxyTable.put(string2, string);
        Debug.output(4, "ORB.createIOR, returning proxifyed ior " + iOR.hashCode());
        return iOR;
    }

    private void readProxyIOR(URL uRL) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            String string = bufferedReader.readLine();
            while (string.indexOf("IOR:") != 0) {
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
            ParsedIOR parsedIOR = new ParsedIOR(string);
            Object object = this.orb.string_to_object(string);
            this.proxyObj = ForwarderHelper.narrow(object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void removeConnection(Connection connection) {
        this.connections.remove(connection.getInfo());
    }

    public void shutdown() {
        int n = 0;
        while (n < this.proxyEntries.size()) {
            this.proxyObj.release((String)this.proxyEntries.elementAt(n));
            ++n;
        }
        Enumeration enumeration = this.connections.elements();
        while (enumeration.hasMoreElements()) {
            ((Connection)enumeration.nextElement()).closeConnection();
        }
        Debug.output(3, "ConnectionManager shut down (all connections released)");
        this.connections.clear();
    }

    IOR unproxyfy(IOR iOR) {
        Debug.output(3, "ORB.unproxyfy ior with oid: " + new String(new ParsedIOR(iOR).get_object_key()));
        String string = (String)this.unproxyTable.get(new ParsedIOR(iOR).getIORString());
        if (string == null) {
            Debug.output(3, "ORB.unproxyfy, no original ior found for " + new ParsedIOR(iOR).getIORString());
            return iOR;
        }
        String string2 = null;
        while (string != null) {
            Debug.output(4, "ORB.unproxyfy, looping (IOR now:" + string + ")");
            string2 = string;
            string = (String)this.unproxyTable.get(string);
        }
        Debug.output(3, "ORB.unproxyfy, original ior: " + string2);
        return new ParsedIOR(string2).getIOR();
    }
}

