/*
 * Decompiled with CFR 0.152.
 */
package jacorb.orb;

import jacorb.orb.Connection;
import jacorb.orb.ORB;
import jacorb.orb.dsi.ServerRequest;
import jacorb.orb.factory.SSLServerSocketFactory;
import jacorb.orb.factory.ServerSocketFactory;
import jacorb.orb.factory.SocketFactory;
import jacorb.orb.giop.LocateRequest;
import jacorb.orb.http.ServerConnection;
import jacorb.poa.except.ParentIsHolding;
import jacorb.poa.util.POAUtil;
import jacorb.util.Debug;
import jacorb.util.Environment;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.WrongAdapter;

public class BasicAdapter {
    private static SSLServerSocketFactory ssl_socket_factory = null;
    private static ServerSocketFactory socket_factory = null;
    private static SocketFactory client_socket_factory = null;
    private int pendingReplies = 0;
    private ORB orb;
    private POA rootPOA;
    private Listener listener;
    private Listener sslListener;
    static /* synthetic */ Class class$jacorb$orb$ORB;

    static {
        socket_factory = new ServerSocketFactory(){

            public ServerSocket createServerSocket(int n) throws IOException {
                return new ServerSocket(n);
            }

            public ServerSocket createServerSocket(int n, int n2) throws IOException {
                return new ServerSocket(n, n2);
            }

            public ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
                return new ServerSocket(n, n2, inetAddress);
            }
        };
    }

    public BasicAdapter(ORB oRB, POA pOA) {
        String string;
        this.orb = oRB;
        this.rootPOA = pOA;
        if (Environment.supportSSL()) {
            Constructor<?> constructor;
            Class<?> clazz;
            if (ssl_socket_factory == null) {
                string = Environment.getProperty("jacorb.ssl.server_socket_factory");
                if (string == null || string.length() == 0) {
                    throw new RuntimeException("SSL support is on, but the property \"jacorb.ssl.server_socket_factory\" is not set!");
                }
                try {
                    clazz = Class.forName(string);
                    constructor = clazz.getConstructor(class$jacorb$orb$ORB != null ? class$jacorb$orb$ORB : (class$jacorb$orb$ORB = BasicAdapter.class$("jacorb.orb.ORB")));
                    ssl_socket_factory = (SSLServerSocketFactory)constructor.newInstance(oRB);
                }
                catch (Exception exception) {
                    Debug.output(257, exception);
                    throw new RuntimeException("SSL support is on, but the ssl server socket factory can't be instanciated (see trace)!");
                }
            }
            if (client_socket_factory == null) {
                string = Environment.getProperty("jacorb.ssl.socket_factory");
                if (string == null || string.length() == 0) {
                    throw new RuntimeException("SSL support is on, but the property \"jacorb.ssl.socket_factory\" is not set!");
                }
                try {
                    clazz = Class.forName(string);
                    constructor = clazz.getConstructor(class$jacorb$orb$ORB != null ? class$jacorb$orb$ORB : (class$jacorb$orb$ORB = BasicAdapter.class$("jacorb.orb.ORB")));
                    client_socket_factory = (SocketFactory)constructor.newInstance(oRB);
                }
                catch (Exception exception) {
                    Debug.output(257, exception);
                    throw new RuntimeException("SSL support is on, but the ssl socket factory can't be instanciated (see trace)!");
                }
            }
        } else if (client_socket_factory == null) {
            client_socket_factory = new SocketFactory(){

                public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
                    return new Socket(string, n);
                }

                public boolean isSSL(Socket socket) {
                    return false;
                }
            };
        }
        if (Environment.supportSSL()) {
            this.sslListener = new Listener(oRB, pOA, Environment.getProperty("OASSLPort"), ssl_socket_factory);
            this.sslListener.is_ssl = true;
            Debug.output(1, "SSL Listener on port = " + this.sslListener.port);
        }
        if (Environment.enforceSSL() && !Environment.supportSSL()) {
            throw new Error("SSL required but not supported, cannot continue!");
        }
        this.listener = new Listener(oRB, pOA, Environment.getProperty("OAPort"), socket_factory);
        string = Environment.getProperty("jacorb.connection.server_timeout");
        if (string != null) {
            this.setTimeout(Integer.parseInt(string));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void deliverRequest(ServerRequest var1_1, POA var2_2) {
        var3_3 = (jacorb.poa.POA)var2_2;
        var4_4 = var1_1.remainingPOAName();
        try {
            var5_5 = 0;
            while (var5_5 < var4_4.length - 1) {
                block10: {
                    if (var4_4[var5_5].equals("")) {
                        var1_1.setRemainingPOAName(null);
                        break;
                    }
                    try {
                        var3_3 = var3_3._getChildPOA(var4_4[var5_5]);
                        break block10;
                    }
                    catch (ParentIsHolding v0) {
                        var6_8 = new String[var4_4.length - var5_5];
                        var7_9 = 0;
                        ** while (var7_9 < var5_5)
                    }
lbl-1000:
                    // 1 sources

                    {
                        var6_8[var7_9] = var4_4[var7_9 + var5_5];
                        ++var7_9;
                        continue;
                    }
lbl19:
                    // 1 sources

                    var1_1.setRemainingPOAName(var6_8);
                    break;
                }
                ++var5_5;
            }
            if (var3_3 == null) {
                throw new Error("request POA null!");
            }
            var3_3._invoke(var1_1);
        }
        catch (WrongAdapter v1) {
            var1_1.setSystemException(new OBJECT_NOT_EXIST("unknown oid"));
            var1_1.reply();
        }
        catch (SystemException var5_6) {
            var1_1.setSystemException(var5_6);
            var1_1.reply();
        }
        catch (Throwable var5_7) {
            var1_1.setSystemException(new UNKNOWN(var5_7.toString()));
            var1_1.reply();
            var5_7.printStackTrace();
        }
    }

    public String getAddress() {
        return this.listener.getAddress();
    }

    public int getPort() {
        return this.listener.getPort();
    }

    public int getSSLPort() {
        return this.sslListener.getPort();
    }

    public void replyPending() {
        ++this.pendingReplies;
    }

    public synchronized void return_result(ServerRequest serverRequest) {
        --this.pendingReplies;
        serverRequest.reply();
    }

    public void setTimeout(int n) {
        this.listener.setTimeout(n);
    }

    public void stopListeners() {
        this.listener.doStop();
        if (this.sslListener != null) {
            this.sslListener.doStop();
        }
    }

    static class Listener
    extends Thread {
        ServerSocket serverSocket;
        int port = 0;
        String address;
        int timeout = 0;
        ORB orb;
        POA rootPOA;
        private boolean is_ssl = false;
        private ServerSocketFactory factory = null;
        private boolean do_run = true;

        public Listener(ORB oRB, POA pOA, String string, ServerSocketFactory serverSocketFactory) {
            this.orb = oRB;
            this.rootPOA = pOA;
            this.factory = serverSocketFactory;
            if (serverSocketFactory == null) {
                throw new Error("No socket factory available!");
            }
            try {
                String string2 = Environment.getProperty("OAIAddr");
                if (string2 == null) {
                    this.serverSocket = string != null ? serverSocketFactory.createServerSocket(Integer.parseInt(string)) : serverSocketFactory.createServerSocket(0);
                    this.address = InetAddress.getLocalHost().toString();
                    if (this.address.indexOf("/") > 0) {
                        this.address = this.address.substring(this.address.indexOf("/") + 1);
                    }
                } else {
                    InetAddress inetAddress = InetAddress.getByName(string2);
                    if (inetAddress == null) {
                        inetAddress = InetAddress.getLocalHost();
                    }
                    if (inetAddress == null) {
                        System.err.println("[ Listener: Couldn't initialize, illegal ip addr " + string2 + " ]");
                        System.exit(1);
                    }
                    this.serverSocket = string != null ? serverSocketFactory.createServerSocket(Integer.parseInt(string), 20, inetAddress) : serverSocketFactory.createServerSocket(0, 20, inetAddress);
                    this.address = string2;
                }
                this.port = this.serverSocket.getLocalPort();
            }
            catch (Exception exception) {
                Debug.output(2, exception);
                System.err.println("[ Listener: Couldn't initialize. Illegal address configuration? ]");
                System.exit(1);
            }
            this.setName("JacORB Listener Thread on port " + this.port);
            this.setDaemon(true);
            this.start();
        }

        static /* synthetic */ boolean access$0(Listener listener) {
            return listener.is_ssl;
        }

        public void doStop() {
            this.do_run = false;
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                Debug.output(258, iOException);
            }
        }

        public String getAddress() {
            return this.address;
        }

        public int getPort() {
            return this.port;
        }

        public void run() {
            while (this.do_run) {
                try {
                    new RequestReceptor(this.orb, this.rootPOA, this.serverSocket.accept(), this.timeout, ssl_socket_factory == null ? false : ssl_socket_factory.isSSL(this.serverSocket));
                }
                catch (Exception exception) {
                    Debug.output(257, exception);
                }
            }
            Debug.output(258, "Listener exited");
        }

        public void setTimeout(int n) {
            this.timeout = n;
        }
    }

    static class RequestReceptor
    extends Thread {
        private Socket clientSocket;
        private Connection connection;
        private int timeout;
        private ORB orb;
        private POA rootPOA;
        private boolean done = false;
        private static final byte[] HTTPPostHeader = new byte[]{80, 79, 83, 84};
        private static final int HEADER_SIZE = 4;
        private boolean is_ssl;

        public RequestReceptor(ORB oRB, POA pOA, Socket socket, int n, boolean bl) {
            this.orb = oRB;
            this.rootPOA = pOA;
            this.clientSocket = socket;
            this.is_ssl = bl;
            if (bl) {
                Debug.output(1, "SSL Listener completed session request...");
                ssl_socket_factory.switchToClientMode(socket);
            }
            this.timeout = n;
            InetAddress inetAddress = socket.getInetAddress();
            InetAddress inetAddress2 = null;
            try {
                inetAddress2 = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                unknownHostException.printStackTrace();
            }
            this.setName("JacORB Request Receptor Thread on " + inetAddress2);
            this.start();
        }

        public void close() {
            try {
                if (this.clientSocket != null) {
                    if (this.connection != null) {
                        this.connection.closeConnection();
                    }
                    this.clientSocket.close();
                }
            }
            catch (Exception exception) {
                Debug.output(2, exception);
            }
            this.done = true;
        }

        /*
         * Unable to fully structure code
         */
        private void deliverRequest(ServerRequest var1_1) {
            var2_2 = (jacorb.poa.POA)this.rootPOA;
            try {
                var3_3 = POAUtil.extractPOAName(var1_1.objectKey());
                var4_6 = new StringTokenizer(var3_3, "/");
                var5_7 = new String[var4_6.countTokens()];
                var6_8 = 0;
                while (var4_6.hasMoreTokens()) {
                    var5_7[var6_8++] = var4_6.nextToken();
                }
                var7_9 = 0;
                while (var7_9 < var5_7.length) {
                    block10: {
                        if (var5_7[var7_9].equals("")) break;
                        try {
                            var2_2 = var2_2._getChildPOA(var5_7[var7_9]);
                            break block10;
                        }
                        catch (ParentIsHolding v0) {
                            var8_10 = new String[var5_7.length - var7_9];
                            var9_11 = 0;
                            ** while (var9_11 < var7_9)
                        }
lbl-1000:
                        // 1 sources

                        {
                            var8_10[var9_11] = var5_7[var9_11 + var7_9];
                            ++var9_11;
                            continue;
                        }
lbl23:
                        // 1 sources

                        var1_1.setRemainingPOAName(var8_10);
                        break;
                    }
                    ++var7_9;
                }
                if (var2_2 == null) {
                    throw new Error("request POA null!");
                }
                var2_2._invoke(var1_1);
            }
            catch (WrongAdapter v1) {
                var1_1.setSystemException(new OBJECT_NOT_EXIST("unknown oid"));
                var1_1.reply();
            }
            catch (SystemException var3_4) {
                var1_1.setSystemException(var3_4);
                var1_1.reply();
            }
            catch (Throwable var3_5) {
                var1_1.setSystemException(new UNKNOWN(var3_5.toString()));
                var1_1.reply();
                var3_5.printStackTrace();
            }
        }

        /*
         * Handled impossible loop by adding 'first' condition
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Object object;
            try {
                object = null;
                object = new BufferedInputStream(this.clientSocket.getInputStream());
                byte[] byArray = new byte[4];
                boolean bl = true;
                try {
                    ((InputStream)object).mark(4);
                    boolean bl2 = false;
                    int n = 0;
                    while (n < 4) {
                        int n2 = ((InputStream)object).read();
                        if (n2 < 0) {
                            this.close();
                            Object var5_14 = null;
                            ((InputStream)object).reset();
                            return;
                        }
                        byArray[n] = (byte)n2;
                        ++n;
                    }
                }
                catch (IOException iOException) {
                    Debug.output(1, "Can not read from socket");
                    iOException.printStackTrace();
                }
                Object var5_15 = null;
                {
                    catch (Throwable throwable) {
                        Object var5_16 = null;
                        ((InputStream)object).reset();
                        throw throwable;
                    }
                }
                ((InputStream)object).reset();
                int n = 0;
                boolean bl3 = true;
                do {
                    if (bl3 && !(bl3 = false)) {
                        if (true) continue;
                    }
                    bl = bl && byArray[n] == HTTPPostHeader[n];
                    ++n;
                } while (n < 4);
                if (bl) {
                    Debug.output(2, "Incoming HTTP Request");
                    this.connection = new ServerConnection(this.orb.getConnectionManager(), this.clientSocket, (InputStream)object, client_socket_factory);
                } else {
                    Debug.output(2, "Incoming GIOP Request");
                    this.connection = new jacorb.orb.giop.ServerConnection(this.orb.getConnectionManager(), this.clientSocket, (InputStream)object, client_socket_factory);
                }
                if (this.timeout != 0) {
                    try {
                        this.connection.setTimeOut(this.timeout);
                    }
                    catch (SocketException socketException) {
                        socketException.printStackTrace();
                    }
                }
            }
            catch (IOException iOException) {
                Debug.output(2, iOException);
                Debug.output(0, "Error in " + (this.is_ssl ? "SSL " : "") + "session setup.");
                return;
            }
            try {
                while (!this.done) {
                    object = this.connection.readBuffer();
                    Object object2 = object[7];
                    switch (object2) {
                        case 0: {
                            ServerRequest serverRequest;
                            if (Environment.enforceSSL() && !this.connection.isSSL()) {
                                serverRequest = new ServerRequest(this.orb, (byte[])object, this.connection);
                                serverRequest.setSystemException(new NO_PERMISSION("Connection should be SSL, but isn't", 3, CompletionStatus.COMPLETED_NO));
                                serverRequest.reply();
                                break;
                            }
                            serverRequest = new ServerRequest(this.orb, (byte[])object, this.connection);
                            this.orb.getBasicAdapter().replyPending();
                            if (!this.connection.isTCSNegotiated()) {
                                this.connection.setServerCodeSet(serverRequest.getServiceContext());
                            }
                            this.deliverRequest(serverRequest);
                            break;
                        }
                        case 3: {
                            ServerRequest serverRequest = new LocateRequest(this.orb, (byte[])object, this.connection);
                            this.deliverRequest(serverRequest);
                            break;
                        }
                        default: {
                            Debug.output(0, "SessionServer, message_type " + (int)object2 + " not understood.");
                            break;
                        }
                        case 2: 
                    }
                }
                return;
            }
            catch (EOFException eOFException) {
                Debug.output(4, eOFException);
                this.close();
                return;
            }
            catch (COMM_FAILURE cOMM_FAILURE) {
                Debug.output(1, cOMM_FAILURE);
                this.close();
                return;
            }
            catch (IOException iOException) {
                Debug.output(4, iOException);
                this.close();
            }
        }
    }
}

