/*
 * Decompiled with CFR 0.152.
 */
package jacorb.imr;

import jacorb.imr.AdminPackage.DuplicateServerName;
import jacorb.imr.AdminPackage.FileOpFailed;
import jacorb.imr.AdminPackage.IllegalServerName;
import jacorb.imr.AdminPackage.UnknownHostName;
import jacorb.imr.HostInfo;
import jacorb.imr.ImRHostInfo;
import jacorb.imr.ImRInfo;
import jacorb.imr.ImRPOAInfo;
import jacorb.imr.ImRServerInfo;
import jacorb.imr.ImplementationRepository;
import jacorb.imr.ImplementationRepositoryHelper;
import jacorb.imr.ImplementationRepositoryPOA;
import jacorb.imr.RegistrationPackage.DuplicatePOAName;
import jacorb.imr.RegistrationPackage.IllegalHostName;
import jacorb.imr.RegistrationPackage.IllegalPOAName;
import jacorb.imr.RegistrationPackage.InvalidSSDRef;
import jacorb.imr.ServerInfo;
import jacorb.imr.ServerStartupFailed;
import jacorb.imr.ServerTable;
import jacorb.imr.UnknownServerName;
import jacorb.orb.Connection;
import jacorb.orb.ORB;
import jacorb.orb.ParsedIOR;
import jacorb.orb.SystemExceptionHelper;
import jacorb.orb.factory.SocketFactory;
import jacorb.orb.giop.ReplyOutputStream;
import jacorb.orb.giop.RequestInputStream;
import jacorb.poa.util.POAUtil;
import jacorb.util.Debug;
import jacorb.util.Environment;
import jacorb.util.threadpool.Consumer;
import jacorb.util.threadpool.ConsumerFactory;
import jacorb.util.threadpool.ThreadPool;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UNKNOWN;
import org.omg.GIOP.ReplyStatusType;
import org.omg.IIOP.ProfileBody_1_0;
import org.omg.IIOP.Version;
import org.omg.IOP.IOR;
import org.omg.IOP.ServiceContext;
import org.omg.PortableServer.POAHelper;

public class ImplementationRepositoryImpl
extends ImplementationRepositoryPOA {
    private static int default_port = 0;
    private static ORB orb;
    private File table_file;
    private ServerTable server_table;
    private File table_file_backup;
    private SocketListener listener;
    private int object_activation_retries = 5;
    private int object_activation_sleep = 50;

    public ImplementationRepositoryImpl(File file, File file2, boolean bl) {
        java.lang.Object object;
        this.table_file = file;
        this.table_file_backup = file2;
        if (bl) {
            this.server_table = new ServerTable();
        } else {
            try {
                object = new ObjectInputStream(new FileInputStream(file));
                this.server_table = (ServerTable)((ObjectInputStream)object).readObject();
                ((ObjectInputStream)object).close();
            }
            catch (Exception exception) {
                Debug.output(2050, exception);
                this.server_table = new ServerTable();
            }
        }
        try {
            object = Environment.getProperty("jacorb.imr.object_activation_retries");
            this.object_activation_retries = Integer.parseInt((String)object);
        }
        catch (Exception exception) {}
        try {
            object = Environment.getProperty("jacorb.imr.object_activation_sleep");
            this.object_activation_sleep = Integer.parseInt((String)object);
        }
        catch (Exception exception) {}
        this.listener = new SocketListener();
    }

    public void edit_server(String string, String string2, String string3) throws UnknownServerName {
        ImRServerInfo imRServerInfo = this.server_table.getServer(string);
        imRServerInfo.command = string2;
        imRServerInfo.host = string3;
        Debug.output(2050, "ImR: server " + string + " edited");
    }

    public static ImplementationRepository getImR(org.omg.CORBA.ORB oRB) {
        String string = Environment.getProperty("jacorb.ImplementationRepositoryURL");
        if (string == null) {
            string = "http://localhost/ImR_Ref";
        }
        return ImplementationRepositoryImpl.getImR(oRB, string);
    }

    public static ImplementationRepository getImR(org.omg.CORBA.ORB oRB, String string) {
        try {
            URL uRL = new URL(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            String string2 = bufferedReader.readLine();
            while (string2.indexOf("IOR:") != 0) {
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
            ImplementationRepository implementationRepository = ImplementationRepositoryHelper.narrow(oRB.string_to_object(string2));
            return implementationRepository;
        }
        catch (Exception exception) {
            Debug.output(2051, exception);
            return null;
        }
    }

    public ImRInfo get_imr_info() {
        return new ImRInfo(this.listener.getAddress(), this.listener.getPort());
    }

    public ServerInfo get_server_info(String string) throws UnknownServerName {
        return this.server_table.getServer(string).toServerInfo();
    }

    public void hold_server(String string) throws UnknownServerName {
        ImRServerInfo imRServerInfo = this.server_table.getServer(string);
        imRServerInfo.holding = true;
    }

    public HostInfo[] list_hosts() {
        return this.server_table.getHosts();
    }

    public ServerInfo[] list_servers() {
        return this.server_table.getServers();
    }

    public static void main(String[] stringArray) {
        java.lang.Object object;
        java.lang.Object object2;
        if (stringArray.length > 8) {
            ImplementationRepositoryImpl.usage();
        }
        String string = null;
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        try {
            int n = 0;
            while (n < stringArray.length) {
                switch (stringArray[n].charAt(1)) {
                    case 'h': {
                        ImplementationRepositoryImpl.usage();
                    }
                    case 'p': {
                        default_port = Integer.parseInt(stringArray[++n]);
                        break;
                    }
                    case 'f': {
                        if (bl) {
                            ImplementationRepositoryImpl.usage();
                        }
                        string = stringArray[++n];
                        break;
                    }
                    case 'n': {
                        if (string != null) {
                            ImplementationRepositoryImpl.usage();
                        }
                        bl = true;
                        break;
                    }
                    case 'i': {
                        string2 = stringArray[++n];
                        break;
                    }
                    case 'b': {
                        string3 = stringArray[++n];
                        break;
                    }
                    default: {
                        ImplementationRepositoryImpl.usage();
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ImplementationRepositoryImpl.usage();
        }
        if (string == null && (string = Environment.getProperty("jacorb.imr.table_file")) == null) {
            System.out.println("WARNING: No file for the server table specified!");
            System.out.println("Property jacorb.imr.table_file or use the -f switch");
            System.out.println("Will create \"table.dat\" in current directory, if necessary");
            string = "table.dat";
        }
        File file = new File(string);
        if (!bl) {
            if (!file.exists()) {
                System.out.println("ERROR: The table file does not exist!");
                System.out.println("Please check " + file.getAbsolutePath());
                System.out.println("Property jacorb.imr.table_file or use the -n or -f switch");
                System.exit(-1);
            }
            if (file.isDirectory()) {
                System.out.println("ERROR: The table file is a directory!");
                System.out.println("Please check " + file.getAbsolutePath());
                System.out.println("Property jacorb.imr.table_file or use the -n or -f switch");
                System.exit(-1);
            }
            if (!file.canRead()) {
                System.out.println("ERROR: The table file is not readable!");
                System.out.println("Please check " + file.getAbsolutePath());
                System.exit(-1);
            }
            if (!file.canWrite()) {
                System.out.println("WARNING: The table file is not writable!");
                System.out.println("Please check " + file.getAbsolutePath());
            }
        } else {
            try {
                object2 = new FileOutputStream(file);
                ((FileOutputStream)object2).close();
                file.delete();
            }
            catch (Exception exception) {
                System.out.println("WARNING: Unable to create table file!");
                System.out.println("Please check " + file.getAbsolutePath());
            }
        }
        if (string2 == null && (string2 = Environment.getProperty("jacorb.imr.ior_file")) == null) {
            System.out.println("ERROR: Please specify a file for the IOR string!");
            System.out.println("Property jacorb.imr.ior_file or use the -i switch");
            System.exit(-1);
        }
        if (string3 == null && (string3 = Environment.getProperty("jacorb.imr.backup_file")) == null) {
            System.out.println("WARNING: No backup file specified!\nWill create \"backup.dat\" in current directory, if necessary");
            string3 = "backup.dat";
        }
        object2 = new File(string3);
        try {
            if (((File)object2).exists()) {
                if (!((File)object2).canWrite()) {
                    System.out.println("WARNING: The backup file exists, but is not writable!");
                    System.out.println("Please check " + ((File)object2).getAbsolutePath());
                } else {
                    System.out.println("WARNING: The backup file already exists and might get overwritten!");
                    System.out.println("Please check " + ((File)object2).getAbsolutePath());
                }
            } else {
                object = new FileOutputStream((File)object2);
                ((FileOutputStream)object).close();
                ((File)object2).delete();
            }
        }
        catch (Exception exception) {
            System.out.println("WARNING: The backup file is not accessible!");
            System.out.println("Please check " + ((File)object2).getAbsolutePath());
        }
        orb = (ORB)org.omg.CORBA.ORB.init(stringArray, null);
        try {
            object = POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
            object.the_POAManager().activate();
            ImplementationRepositoryImpl implementationRepositoryImpl = new ImplementationRepositoryImpl(file, (File)object2, bl);
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(new File(string2)));
            printWriter.println(orb.object_to_string(object.servant_to_reference(implementationRepositoryImpl)));
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            Debug.output(2050, exception);
            System.out.println("ERROR: Failed to write IOR to file.\nPlease check the path.");
            System.out.println("Property jacorb.imr.ior_file or -i <file> switch");
            System.exit(-1);
        }
        orb.run();
    }

    public void register_host(HostInfo hostInfo) throws IllegalHostName, InvalidSSDRef {
        if (hostInfo.name == null || hostInfo.name.length() == 0) {
            throw new IllegalHostName(hostInfo.name);
        }
        try {
            hostInfo.ssd_ref.get_system_load();
        }
        catch (Exception exception) {
            Debug.output(2050, exception);
            throw new InvalidSSDRef();
        }
        this.server_table.putHost(hostInfo.name, new ImRHostInfo(hostInfo));
    }

    public void register_poa(String string, String string2, String string3, int n) throws IllegalPOAName, DuplicatePOAName, UnknownServerName {
        Debug.output(2050, "ImR: registering poa " + string + " for server: " + string2 + " on " + string3);
        ImRServerInfo imRServerInfo = this.server_table.getServer(string2);
        ImRPOAInfo imRPOAInfo = this.server_table.getPOA(string);
        if (imRPOAInfo == null) {
            imRPOAInfo = new ImRPOAInfo(string, string3, n, imRServerInfo);
            imRServerInfo.addPOA(imRPOAInfo);
            this.server_table.putPOA(string, imRPOAInfo);
            Debug.output(2050, "ImR: new poa registered");
        } else {
            if (imRPOAInfo.active || !string2.equals(imRPOAInfo.server.name)) {
                throw new DuplicatePOAName("POA " + string + " has already been registered " + "for server " + imRPOAInfo.server.name);
            }
            imRPOAInfo.reactivate(string3, n);
            Debug.output(2050, "ImR: register_poa, reactivated");
        }
    }

    public void register_server(String string, String string2, String string3) throws IllegalServerName, DuplicateServerName {
        ImRServerInfo imRServerInfo = new ImRServerInfo(string, string3, string2);
        this.server_table.putServer(string, imRServerInfo);
        Debug.output(2050, "ImR: server " + string + " on " + string3 + " registered");
    }

    public void release_server(String string) throws UnknownServerName {
        ImRServerInfo imRServerInfo = this.server_table.getServer(string);
        imRServerInfo.release();
    }

    private void restartServer(ImRServerInfo imRServerInfo) throws ServerStartupFailed {
        imRServerInfo.awaitRelease();
        if (!imRServerInfo.active) {
            Debug.output(2050, "ImR: server " + imRServerInfo.name + " is down");
            if (imRServerInfo.command.length() == 0) {
                throw new ServerStartupFailed("Server " + imRServerInfo.name + " can't be restarted because" + " of missing startup command");
            }
            if (imRServerInfo.shouldBeRestarted()) {
                try {
                    ImRHostInfo imRHostInfo = this.server_table.getHost(imRServerInfo.host);
                    Debug.output(2050, "ImR: will restart " + imRServerInfo.name);
                    imRHostInfo.startServer(imRServerInfo.command, orb);
                }
                catch (ServerStartupFailed serverStartupFailed) {
                    throw serverStartupFailed;
                }
                catch (Exception exception) {
                    Debug.output(2050, exception);
                    this.server_table.removeHost(imRServerInfo.host);
                    throw new ServerStartupFailed("Failed to connect to host!");
                }
            } else {
                Debug.output(2050, "ImR: somebody else is restarting " + imRServerInfo.name);
            }
        } else {
            Debug.output(2050, "ImR: server " + imRServerInfo.name + " is active");
        }
    }

    public void save_server_table() throws FileOpFailed {
        this.save_server_table(this.table_file_backup);
    }

    private void save_server_table(File file) throws FileOpFailed {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            this.server_table.table_lock.gainExclusiveLock();
            objectOutputStream.writeObject(this.server_table);
            this.server_table.table_lock.releaseExclusiveLock();
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            Debug.output(2050, exception);
            throw new FileOpFailed();
        }
    }

    public void set_server_down(String string) throws UnknownServerName {
        Debug.output(2050, "ImR: server " + string + " is going down... ");
        ImRServerInfo imRServerInfo = this.server_table.getServer(string);
        imRServerInfo.setDown();
    }

    public void shutdown(boolean bl) {
        try {
            this.save_server_table(this.table_file);
        }
        catch (Exception exception) {
            Debug.output(2050, exception);
        }
        this.listener.stopListening(bl);
    }

    public void start_server(String string) throws UnknownServerName, ServerStartupFailed {
        this.restartServer(this.server_table.getServer(string));
    }

    public void unregister_host(String string) throws UnknownHostName {
        if (this.server_table.removeHost(string) == null) {
            throw new UnknownHostName(string);
        }
    }

    public void unregister_server(String string) throws UnknownServerName {
        ImRServerInfo imRServerInfo = this.server_table.getServer(string);
        String[] stringArray = imRServerInfo.getPOANames();
        int n = 0;
        while (n < stringArray.length) {
            this.server_table.removePOA(stringArray[n]);
            ++n;
        }
        this.server_table.removeServer(string);
        Debug.output(2050, "ImR: server " + string + " unregistered");
    }

    public static void usage() {
        System.out.println("Usage: ImplementationRepositoryImpl [Parameter]");
        System.out.println("Parameter:");
        System.out.println("\t -p <port> Port to listen on for requests");
        System.out.println("\t -f <file> Read in server table from this file");
        System.out.println("\t -n Start with empty server table");
        System.out.println("\t -i <iorfile> Place IOR in this file");
        System.out.println("\t -b <backupfile> Put server table in this file");
        System.out.println("\t -h Print this help");
        System.exit(0);
    }

    private class SocketListener
    extends Thread {
        private ServerSocket server_socket;
        private int port = 0;
        private String address;
        private int timeout = 0;
        private boolean run = true;
        private boolean wait = false;
        private ThreadPool pool = null;

        public SocketListener() {
            try {
                this.server_socket = new ServerSocket(default_port);
                this.address = InetAddress.getLocalHost().toString();
                if (this.address.indexOf("/") > 0) {
                    this.address = this.address.substring(this.address.indexOf("/") + 1);
                }
                this.port = this.server_socket.getLocalPort();
                if (this.port < 0) {
                    this.port += 65536;
                }
                Debug.output(2050, "ImR Listener at " + this.port + ", " + this.address);
            }
            catch (Exception exception) {
                Debug.output(2049, exception);
                Debug.output(2049, "Listener: Couldn't init");
                System.exit(1);
            }
            this.setDaemon(true);
            this.pool = new ThreadPool(new ConsumerFactory(this){
                private final /* synthetic */ SocketListener this$1;
                {
                    this.this$1 = socketListener;
                }

                public Consumer create() {
                    ImplementationRepositoryImpl implementationRepositoryImpl = SocketListener.access$0(this.this$1);
                    implementationRepositoryImpl.getClass();
                    return implementationRepositoryImpl.new RequestReceptor(SocketListener.access$1(this.this$1));
                }
            });
            this.start();
        }

        static /* synthetic */ ImplementationRepositoryImpl access$0(SocketListener socketListener) {
            return socketListener.ImplementationRepositoryImpl.this;
        }

        static /* synthetic */ int access$1(SocketListener socketListener) {
            return socketListener.timeout;
        }

        public String getAddress() {
            return this.address;
        }

        public int getPort() {
            Debug.output(2050, "ImR Listener at " + this.port + ", " + this.address);
            return this.port;
        }

        public void run() {
            Thread.currentThread().setPriority(10);
            while (this.run) {
                try {
                    this.pool.putJob(this.server_socket.accept());
                }
                catch (Exception exception) {
                    if (!this.run) continue;
                    Debug.output(2050, exception);
                }
            }
            orb.shutdown(this.wait);
            System.exit(0);
        }

        public void setTimeout(int n) {
            this.timeout = n;
        }

        public void stopListening(boolean bl) {
            this.run = false;
            this.wait = bl;
            try {
                this.server_socket.close();
            }
            catch (Exception exception) {
                Debug.output(2050, exception);
            }
        }
    }

    private class RequestReceptor
    implements Consumer {
        private Socket client_socket;
        private Connection connection;
        private int timeout;
        private ReplyOutputStream out;
        private RequestInputStream in;
        private SocketFactory socket_factory = null;

        public RequestReceptor(int n) {
            this.timeout = n;
            this.socket_factory = new SocketFactory(){

                public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
                    return new Socket(string, n);
                }

                public boolean isSSL(Socket socket) {
                    return false;
                }
            };
        }

        public void close() {
            try {
                if (this.client_socket != null) {
                    this.connection.releaseConnection();
                    this.client_socket.close();
                }
            }
            catch (Exception exception) {
                Debug.output(2050, exception);
            }
        }

        public void doWork(java.lang.Object object) {
            this.client_socket = (Socket)object;
            try {
                this.connection = new Connection(orb.getConnectionManager(), this.client_socket, true, this.socket_factory);
                if (this.timeout != 0) {
                    try {
                        this.connection.setTimeOut(this.timeout);
                    }
                    catch (SocketException socketException) {
                        Debug.output(2050, socketException);
                    }
                }
            }
            catch (Exception exception) {
                Debug.output(2049, exception);
                Debug.output(2049, "Fatal error in session setup.");
                System.exit(1);
            }
            try {
                block13: while (true) {
                    byte[] byArray = this.connection.readBuffer();
                    byte by = byArray[7];
                    switch (by) {
                        case 2: {
                            continue block13;
                        }
                        case 0: {
                            this.replyNewLocation(byArray);
                            continue block13;
                        }
                        case 3: {
                            this.replyNewLocation(byArray);
                            continue block13;
                        }
                    }
                    Debug.output(2049, "SessionServer, message_type " + by + " not understood.");
                }
            }
            catch (EOFException eOFException) {
                Debug.output(2051, eOFException);
                this.close();
            }
            catch (COMM_FAILURE cOMM_FAILURE) {
                Debug.output(2049, cOMM_FAILURE);
                this.close();
            }
            catch (IOException iOException) {
                Debug.output(2051, iOException);
                this.close();
            }
        }

        private void replyNewLocation(byte[] byArray) {
            this.in = new RequestInputStream(this.connection, byArray);
            String string = String.valueOf(POAUtil.extractImplName(this.in.req_hdr.object_key)) + "/" + POAUtil.extractPOAName(this.in.req_hdr.object_key);
            ImRPOAInfo imRPOAInfo = ImplementationRepositoryImpl.this.server_table.getPOA(string);
            if (imRPOAInfo == null) {
                this.sendSysException(new OBJECT_NOT_EXIST("POA " + string + " unknown"));
                return;
            }
            ImRServerInfo imRServerInfo = imRPOAInfo.server;
            Debug.output(2050, "ImR: Looking up: " + imRServerInfo.name);
            try {
                ImplementationRepositoryImpl.this.restartServer(imRServerInfo);
            }
            catch (ServerStartupFailed serverStartupFailed) {
                this.sendSysException(new TRANSIENT(serverStartupFailed.reason));
                return;
            }
            boolean bl = imRPOAInfo.active;
            if (!imRPOAInfo.awaitActivation()) {
                this.sendSysException(new TRANSIENT("Timeout exceeded"));
                return;
            }
            ProfileBody_1_0 profileBody_1_0 = new ProfileBody_1_0(new Version(1, 0), imRPOAInfo.host, (short)imRPOAInfo.port, this.in.req_hdr.object_key);
            this.out = new ReplyOutputStream(this.connection, new ServiceContext[0], this.in.req_hdr.request_id, ReplyStatusType.LOCATION_FORWARD);
            IOR iOR = ParsedIOR.createIOR("org.omg/CORBA/Object", profileBody_1_0);
            if (!bl) {
                Object object = orb.string_to_object(new ParsedIOR(iOR).getIORString());
                int n = 0;
                while (n < ImplementationRepositoryImpl.this.object_activation_retries) {
                    try {
                        Thread.sleep(ImplementationRepositoryImpl.this.object_activation_sleep);
                        if (!object._non_existent()) {
                            break;
                        }
                    }
                    catch (Exception exception) {
                        Debug.output(2051, exception);
                    }
                    ++n;
                }
            }
            try {
                this.out.write_IOR(iOR);
                this.out.close();
                Debug.output(2050, "ImR: Sending location forward for " + imRServerInfo.name);
                this.connection.sendReply(this.out);
            }
            catch (Exception exception) {
                Debug.output(2050, exception);
                this.sendSysException(new UNKNOWN(exception.toString()));
            }
        }

        private void sendSysException(SystemException systemException) {
            this.out = new ReplyOutputStream(this.connection, new ServiceContext[0], this.in.req_hdr.request_id, ReplyStatusType.SYSTEM_EXCEPTION);
            SystemExceptionHelper.write(this.out, systemException);
            this.out.close();
            try {
                this.connection.sendReply(this.out);
            }
            catch (Exception exception) {
                Debug.output(2050, exception);
            }
        }
    }
}

