/*
 * Decompiled with CFR 0.152.
 */
package jacorb.idl;

import jacorb.idl.Environment;
import jacorb.idl.IdlSymbol;
import jacorb.idl.NameAlreadyDefined;
import jacorb.idl.ObjectTypeSpec;
import jacorb.idl.ScopedName;
import jacorb.idl.TypeCodeTypeSpec;
import jacorb.idl.TypeSpec;
import java.util.Hashtable;

class TypeMap {
    static Hashtable typemap = new Hashtable(5000);

    static {
        typemap.put("org.omg.CORBA.Object", new ObjectTypeSpec(IdlSymbol.new_num()));
        typemap.put("org.omg.CORBA.TypeCode", new TypeCodeTypeSpec(IdlSymbol.new_num()));
        typemap.put("CORBA.Object", new ObjectTypeSpec(IdlSymbol.new_num()));
        typemap.put("CORBA.TypeCode", new TypeCodeTypeSpec(IdlSymbol.new_num()));
    }

    TypeMap() {
    }

    public static TypeSpec map(String string) {
        return (TypeSpec)typemap.get(string);
    }

    public static void replaceForwardDeclaration(String string, TypeSpec typeSpec) {
        if (typemap.containsKey(string)) {
            typemap.remove(string);
            try {
                TypeMap.typedef(string, typeSpec);
            }
            catch (NameAlreadyDefined nameAlreadyDefined) {
                System.err.println("TypeMap.replaceForwardDeclaration, serious error!");
                nameAlreadyDefined.printStackTrace();
                System.exit(1);
            }
        } else {
            throw new RuntimeException("Could not find forward declaration!");
        }
    }

    public static void typedef(String string, TypeSpec typeSpec) throws NameAlreadyDefined {
        Environment.output(3, "Typedef'ing " + string + " for " + typeSpec.typeName() + " , hash: " + typeSpec.hashCode());
        if (!typemap.containsKey(string)) {
            if (typeSpec.typeSpec() instanceof ScopedName) {
                if (((ScopedName)typeSpec.typeSpec()).resolvedTypeSpec() != null) {
                    typemap.put(string, ((ScopedName)typeSpec.typeSpec()).resolvedTypeSpec());
                } else {
                    typemap.put(string, typeSpec.typeSpec());
                }
                Environment.output(3, " resolved " + ((ScopedName)typeSpec.typeSpec()).resolvedTypeSpec());
            } else {
                typemap.put(string, typeSpec.typeSpec());
                Environment.output(3, String.valueOf(String.valueOf(typeSpec.typeSpec())));
            }
        }
    }
}

