package jacorb.orb.standardInterceptors;

import org.omg.PortableInterceptor.*;
import org.omg.IOP.*;
import jacorb.orb.*;
import jacorb.util.*;

/**
 * This interceptor creates an ssl TaggedComponent
 *
 * @author Nicolas Noffke
 * @version $Id: SSLComponentInterceptor.java,v 1.6 2000/09/08 13:36:52 noffke Exp $
 */

public class SSLComponentInterceptor 
    extends LocalityConstrainedObject
    implements IORInterceptor
{
    private ORB orb = null;

    public SSLComponentInterceptor(ORB orb) {
        this.orb = orb;
    }
  
     public String name(){
        return "SSLComponentCreator";
    }

    // implementation of org.omg.PortableInterceptor.IORInterceptorOperations interface

    /**
     * Builds an ssl TaggedComponent.
     * Was formerly: ORB.makeSSLComponent()
     */

    public void establish_components(IORInfo info) 
    {
        try
        {
            org.omg.IIOP.Version v = new org.omg.IIOP.Version((byte) 1, (byte) 1); // bnv
            org.omg.SSLIOP.SSL ssl = new org.omg.SSLIOP.SSL ( Environment.supportedBySSL(),
                                                              Environment.requiredBySSL(),
                                                              (short) orb.getBasicAdapter().getSSLPort());

            if( !jacorb.util.Environment.enforceSSL() ) 
            {
                // target supports unprotected messages
                ssl.target_supports |= 0x1;
            }

            CDROutputStream sslDataStream = new jacorb.orb.CDROutputStream(orb);
  
            sslDataStream.beginEncapsulation();

            org.omg.SSLIOP.SSLHelper.write( sslDataStream, ssl );

            sslDataStream.endEncapsulation();

            TaggedComponent tc = new TaggedComponent(org.omg.SSLIOP.TAG_SSL_SEC_TRANS.value,
                                                     sslDataStream.getBufferCopy());
            sslDataStream.close();
            
            info.add_ior_component_to_profile (tc, TAG_INTERNET_IOP.value);
        }
        catch (Exception e)
        {
            Debug.output( Debug.SECURITY | Debug.IMPORTANT, e);
        }
    }
} // SSLComponentInterceptor
