package jacorb.orb.giop;
/*
 *        JacORB - a free Java ORB
 *
 *   Copyright (C) 1997-98  Gerald Brose.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import java.io.*;
import org.omg.GIOP.*;
import jacorb.orb.*;

/**
 * @author Gerald Brose, FU Berlin 1999
 * @version $Id: LocateRequestOutputStream.java,v 1.3 1999/11/25 16:07:25 brose Exp $
 *
 */

public class LocateRequestOutputStream
    extends jacorb.orb.CDROutputStream
{
    private org.omg.GIOP.LocateRequestHeader req_hdr;

    public LocateRequestOutputStream(Connection c,byte[] object_key)
    {
		super(c);
		int request_id = connection.getId();

		req_hdr = new org.omg.GIOP.LocateRequestHeader( request_id, object_key);
		writeHeader();
    }


    private void writeHeader()
    {
		writeGIOPMsgHeader( (byte)org.omg.GIOP.MsgType_1_0._LocateRequest );
		org.omg.GIOP.LocateRequestHeaderHelper.write(this, req_hdr);
        insertMsgSize();
    }

    public int requestId()
    {
	return req_hdr.request_id;
    }


}


