package jacorb.ir.gui.typesystem;

import java.util.*;
import javax.swing.tree.*;
import javax.swing.table.*;

/**
 * This class was generated by a SmartGuide.
 * 
 */
public abstract class TypeSystem 
{
    // Abbildung von Benutzer-lesbaren nodeTypeNames auf Klassennamen
    // Unterklassen von TypeSystemNode tragen sich hier entsprechend selbst ein.
    // (da sich konkret nur Klassen entsprechend den CORBA-IR Klassen eintragen,
    // kann es nicht zu Namenskonflikten kommen, da IDL-Bezeichner eindeutig sind)
    private static Hashtable nodeTypes = new Hashtable();
	
    protected DefaultTreeModel treeModel = null;



    /**
     * Erzeugt node entsprechend dem bergebenen nodeTypeName 
     * (z.B. "module" erzeugt ein IRModule-Objekt)
     * @return jacorb.ir.gui.typesystem.TypeSystemNode
     * @param nodeTypeName java.lang.String
     */
    public static TypeSystemNode createNode (String nodeTypeName) 
        throws ClassNotFoundException 
    {
	TypeSystemNode node = null;
	Class c = Class.forName( (String)nodeTypes.get(nodeTypeName) );
	try {
            node = (TypeSystemNode)c.newInstance();
	}
	catch (Exception e) {
            e.printStackTrace();
	}	
	return node;
    
}
    /**
     * Erzeugt TreeModel, das nur root enthlt. Um Nodes zu expandieren, mu der von getTreeExpansionListener(treeModel)
     * zurckgegebene TreeExpansionListener bei JTree angemeldet werden.
     * @return javax.swing.tree.DefaultTreeModel
     * @param root jacorb.ir.gui.typesystem.ModelParticipant
     */

    public abstract DefaultTreeModel createTreeModelRoot();

    /**
     * This method was created by a SmartGuide.
     * @return TableModel
     * @param node jacorb.ir.gui.typesystem.TypeSystemNode
     */

    public abstract DefaultTableModel getTableModel(DefaultMutableTreeNode treeNode);
    /**
     * This method was created by a SmartGuide.
     * @return javax.swing.event.TreeExpansionListener
     * @param treeModel javax.swing.tree.DefaultTreeModel
     */
    public abstract javax.swing.event.TreeExpansionListener getTreeExpansionListener(TreeModel treeModel);
    /**
     * This method was created by a SmartGuide.
     * @return javax.swing.tree.TreeModel
     */
    public abstract TreeModel getTreeModel ( );
    /**
     * Wird von static initializern von Unterklassen von TypeSystemNode aufgerufen, um sich fr 
     * createNode() zu registrieren.
     * @param nodeTypeName java.lang.String
     * @param className java.lang.String
     */
    protected static void registerNodeType(String nodeTypeName, String className) {
	nodeTypes.put(nodeTypeName,className);
    }
}


