/*
 * Decompiled with CFR 0.152.
 */
package jacorb.util;

import jacorb.util.Debug;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class Environment {
    private static String propertiesFile1 = ".jacorb_properties";
    private static String propertiesFile2 = "jacorb.properties";
    private static Vector propertiesFiles = new Vector();
    private static String jacorbPrefix = "jacorb.";
    private static String poaPrefix = String.valueOf(jacorbPrefix) + "poa.";
    private static Properties _props;
    private static int _retries;
    private static long _retry_interval;
    private static int _outbuf_size;
    private static int _charset_flags;
    private static String _default_context;
    private static String _ir_server;
    private static String _trading_service;
    private static String _domain_service;
    private static int _verbosity;
    private static boolean _locate_on_bind;
    private static boolean _use_imr;
    private static boolean _cache_references;
    private static PrintWriter _log_file_out;
    private static boolean _use_domain;
    private static boolean _mount_orb_domain;
    private static String _orb_domain_filename;
    private static long _cache_entry_lifetime;
    private static String _default_domains;
    private static boolean _monitoring_on;
    private static int _thread_pool_max;
    private static int _thread_pool_min;
    private static int _queue_max;
    private static String _proxy_server;
    private static boolean _use_appligator_for_applets;
    private static boolean _use_appligator_for_applications;
    private static Hashtable _use_httptunneling_for;
    public static URL URL;
    private static byte[] _impl_name;
    private static byte[] _server_id;
    private static String _keyStore;
    private static boolean _enforce_ssl;
    private static short _supported_options;
    private static short _required_options;
    private static boolean _support_ssl;
    private static String _default_user;
    private static String _default_password;

    static {
        _retries = 10;
        _retry_interval = 700L;
        _outbuf_size = 4096;
        _charset_flags = 13;
        _default_context = "<undefined>";
        _ir_server = "<undefined>";
        _trading_service = "<undefined>";
        _domain_service = "<undefined>";
        _verbosity = 0;
        _locate_on_bind = false;
        _use_imr = false;
        _cache_references = false;
        _log_file_out = null;
        _use_domain = false;
        _mount_orb_domain = true;
        _orb_domain_filename = null;
        _cache_entry_lifetime = 300000L;
        _default_domains = null;
        _monitoring_on = false;
        _thread_pool_max = 20;
        _thread_pool_min = 10;
        _queue_max = 100;
        _proxy_server = null;
        _use_appligator_for_applets = true;
        _use_appligator_for_applications = false;
        _use_httptunneling_for = new Hashtable();
        URL = null;
        _impl_name = null;
        _server_id = null;
        _keyStore = ".keystore";
        _enforce_ssl = false;
        _supported_options = (short)103;
        _required_options = (short)102;
        _support_ssl = false;
        _default_user = null;
        _default_password = null;
        Environment._init();
    }

    public static final String DefaultDomains() {
        return _default_domains;
    }

    public static final String DomainServiceURL() {
        return _domain_service;
    }

    public static final long LifetimeOfCacheEntry() {
        return _cache_entry_lifetime;
    }

    public static final String ORBDomainFilename() {
        return _orb_domain_filename;
    }

    private static void _init() {
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            _props = new Properties(System.getProperties());
            string = _props.getProperty("user.home");
            string2 = _props.getProperty("file.separator");
            string3 = _props.getProperty("java.home");
            propertiesFiles.addElement(String.valueOf(string) + string2 + propertiesFile1);
            propertiesFiles.addElement(String.valueOf(string) + string2 + propertiesFile2);
            propertiesFiles.addElement(propertiesFile1);
            propertiesFiles.addElement(propertiesFile2);
            propertiesFiles.addElement(String.valueOf(string3) + string2 + "lib" + string2 + propertiesFile1);
            propertiesFiles.addElement(String.valueOf(string3) + string2 + "lib" + string2 + propertiesFile2);
            boolean bl = false;
            int n = 0;
            while (!bl && n < propertiesFiles.size()) {
                try {
                    _props.load(new BufferedInputStream(new FileInputStream((String)propertiesFiles.elementAt(n))));
                    bl = true;
                }
                catch (Exception exception) {}
                ++n;
            }
            Environment.merge(_props, System.getProperties());
            if (!bl) {
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = 0;
                while (n2 < propertiesFiles.size()) {
                    if (n2 > 0) {
                        stringBuffer.append(" or ");
                    }
                    stringBuffer.append((String)propertiesFiles.elementAt(n2));
                    ++n2;
                }
                if (_verbosity > 3) {
                    System.err.println("Setup Warning: no properties file found! This warning can be ignored\n for applets. (A properties file should be in the current directory or in \n" + stringBuffer.toString() + "t)");
                }
            }
            Environment.readValues();
            if (_enforce_ssl) {
                if (!_support_ssl) {
                    System.err.println("Security Policy violation: SSL is not supported.Check your environment please.");
                    System.exit(0);
                } else {
                    Debug.output(1, "Security policy will enforce SSL connections");
                }
            }
        }
        catch (SecurityException securityException) {
            System.out.println("Could not read local jacorb properties.");
        }
    }

    public static void addProperties(Properties properties) {
        if (_props == null) {
            _props = new Properties();
        }
        if (properties != null) {
            try {
                Environment.merge(_props, System.getProperties());
            }
            catch (SecurityException securityException) {}
            Environment.merge(_props, properties);
            Environment.readValues();
        }
    }

    public static final boolean cacheReferences() {
        return _cache_references;
    }

    public static final boolean charsetScanCtx() {
        return (_charset_flags & 8) != 0;
    }

    public static final boolean charsetSendCtx() {
        return (_charset_flags & 4) != 0;
    }

    public static final boolean charsetUpdateIOP() {
        return (_charset_flags & 2) != 0;
    }

    public static final boolean charsetUpdateMulti() {
        return (_charset_flags & 1) != 0;
    }

    public static final String defaultPassword() {
        return _default_password;
    }

    public static final String defaultUser() {
        return _default_user;
    }

    public static final boolean enforceSSL() {
        return _enforce_ssl;
    }

    public static Vector getORBInitializers() {
        Enumeration<?> enumeration = _props.propertyNames();
        Vector vector = new Vector();
        String string = "org.omg.PortableInterceptor.ORBInitializerClass.";
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith("org.omg.PortableInterceptor.ORBInitializerClass.")) continue;
            String string3 = _props.getProperty(string2);
            try {
                vector.addElement(Class.forName(string3).newInstance());
                Debug.output(16387, "Build: " + string3);
            }
            catch (Exception exception) {
                Debug.output(1, exception);
            }
        }
        return vector;
    }

    public static Properties getProperties() {
        return (Properties)((Hashtable)_props).clone();
    }

    public static Hashtable getProperties(String string) {
        Enumeration<?> enumeration = _props.propertyNames();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            hashtable.put(string2, _props.getProperty(string2));
        }
        return hashtable;
    }

    public static String getProperty(String string) {
        return _props.getProperty(string);
    }

    public static String[] getPropertyValueList(String string) {
        String string2 = _props.getProperty(string);
        if (string2 == null) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public static final byte[] implName() {
        return _impl_name;
    }

    public static final String interfaceRepositoryURL() {
        return _ir_server;
    }

    public static final boolean isMonitoringOn() {
        return _monitoring_on;
    }

    public static final Properties jacorbProperties() {
        return _props;
    }

    public static final String keyStore() {
        return _keyStore;
    }

    public static final boolean locateOnBind() {
        return _locate_on_bind;
    }

    public static final PrintWriter logFileOut() {
        return _log_file_out;
    }

    private static void merge(Properties properties, Properties properties2) {
        Enumeration<?> enumeration = properties2.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ((Hashtable)properties).put(string, properties2.getProperty(string));
        }
    }

    public static final boolean mountORBDomain() {
        return _mount_orb_domain;
    }

    public static final int noOfRetries() {
        return _retries;
    }

    public static final int outBufSize() {
        return _outbuf_size;
    }

    public static final String proxyURL() {
        return _proxy_server;
    }

    public static final int queueMax() {
        return _queue_max;
    }

    public static final void readFromURL(URL uRL) {
        URL = uRL;
        System.out.println("Reading properties from url:" + URL.toString());
        try {
            _props = new Properties();
            _props.load(new BufferedInputStream(URL.openStream()));
        }
        catch (Exception exception) {
            System.out.println("Could not read properties from URL, reason: " + exception.toString());
        }
        Environment.readValues();
    }

    private static String readValue(String string, String string2) {
        if (_props.getProperty(string) != null) {
            return _props.getProperty(string);
        }
        if (string2 != null && _props.getProperty(string2) != null) {
            return _props.getProperty(string2);
        }
        return null;
    }

    private static void readValue(String string, String string2, String string3) {
        String string4 = Environment.readValue(string2, string3);
        if (string4 == null) {
            return;
        }
        if (string.equals("_retries")) {
            _retries = Integer.parseInt(string4);
        } else if (string.equals("_retry_interval")) {
            _retry_interval = Integer.parseInt(string4);
        } else if (string.equals("_cache_entry_lifetime")) {
            _cache_entry_lifetime = Long.parseLong(string4);
        } else if (string.equals("_outbuf_size")) {
            _outbuf_size = Integer.parseInt(string4);
        } else if (string.equals("_default_context")) {
            _default_context = string4;
        } else if (string.equals("_ir_server")) {
            _ir_server = string4;
        } else if (string.equals("_trading_service")) {
            _trading_service = string4;
        } else if (string.equals("_domain_service")) {
            _domain_service = string4;
        } else if (string.equals("_orb_domain_filename")) {
            _orb_domain_filename = string4;
        } else if (string.equals("_default_domains")) {
            _default_domains = string4;
        } else if (string.equals("_verbosity")) {
            _verbosity = Integer.parseInt(string4);
        } else if (string.equals("_locate_on_bind")) {
            _locate_on_bind = string4.equalsIgnoreCase("on");
        } else if (string.equals("_cache_references")) {
            _cache_references = string4.equalsIgnoreCase("on");
        } else if (string.equals("_monitoring_on")) {
            _monitoring_on = string4.equalsIgnoreCase("on");
        } else if (string.equals("_use_imr")) {
            _use_imr = string4.equalsIgnoreCase("on");
        } else if (string.equals("_use_domain")) {
            _use_domain = string4.equalsIgnoreCase("on");
        } else if (string.equals("_mount_orb_domain")) {
            _mount_orb_domain = !string4.equalsIgnoreCase("off");
        } else if (string.equals("_thread_pool_max")) {
            _thread_pool_max = Integer.parseInt(string4);
        } else if (string.equals("_thread_pool_min")) {
            _thread_pool_min = Integer.parseInt(string4);
        } else if (string.equals("_queue_max")) {
            _queue_max = Integer.parseInt(string4);
        } else if (string.equals("_proxy_server")) {
            _proxy_server = string4;
        } else if (string.equals("_use_appligator_for_applets")) {
            _use_appligator_for_applets = !string4.equalsIgnoreCase("off");
        } else if (string.equals("_use_appligator_for_applications")) {
            _use_appligator_for_applications = !string4.equalsIgnoreCase("off");
        } else if (string.equals("_use_httptunneling_for")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                System.out.println("HTTP Tunneling set for:" + string5);
                _use_httptunneling_for.put(string5, new Object());
            }
        } else if (string.equals("_charset_flags")) {
            _charset_flags = Integer.parseInt(string4);
        } else if (string.equals("_keyStore")) {
            String string6 = _props.getProperty("user.home");
            String string7 = _props.getProperty("file.separator");
            _keyStore = String.valueOf(string6) + string7 + string4;
        } else if (string.equals("_impl_name")) {
            _impl_name = string4.getBytes();
        } else if (string.equals("_support_ssl")) {
            _support_ssl = string4.equalsIgnoreCase("on");
        } else if (string.equals("_supported_options")) {
            _supported_options = Integer.valueOf(string4, 16).shortValue();
        } else if (string.equals("_required_options")) {
            _required_options = Integer.valueOf(string4, 16).shortValue();
        } else if (string.equals("_enforce_ssl")) {
            _enforce_ssl = string4.equalsIgnoreCase("on");
        } else if (string.equals("_default_user")) {
            _default_user = string4;
        } else if (string.equals("_default_password")) {
            _default_password = string4;
        }
    }

    private static void readValues() {
        String string = null;
        if (_props.getProperty("logfile") != null) {
            string = _props.getProperty("logfile");
        } else if (_props.getProperty(String.valueOf(jacorbPrefix) + "logfile") != null) {
            string = _props.getProperty(String.valueOf(jacorbPrefix) + "logfile");
        }
        if (string != null && !string.equals("")) {
            try {
                _log_file_out = new PrintWriter(new FileOutputStream(string));
                System.out.println("Write output to log file \"" + string + "\"");
            }
            catch (IOException iOException) {
                System.out.println("Cannot access log file \"" + string + "\"");
            }
        }
        Environment.readValue("_retries", "retries", String.valueOf(jacorbPrefix) + "retries");
        Environment.readValue("_retry_interval", "retry_interval", String.valueOf(jacorbPrefix) + "retry_interval");
        Environment.readValue("_cache_entry_lifetime", "_cache_entry_lifetime", String.valueOf(jacorbPrefix) + "domain.cache_entry.lifetime");
        Environment.readValue("_outbuf_size", "outbuf_size", String.valueOf(jacorbPrefix) + "outbuf_size");
        Environment.readValue("_default_context", "ns", String.valueOf(jacorbPrefix) + "NameServerURL");
        Environment.readValue("_attributeProvider", String.valueOf(jacorbPrefix) + "AttributeProviderURL", null);
        Environment.readValue("_attributeProvider", String.valueOf(jacorbPrefix) + "AttributeProviderURL", null);
        Environment.readValue("_attributeProvider", String.valueOf(jacorbPrefix) + "AttributeProviderURL", null);
        Environment.readValue("_ir_server", "ir", String.valueOf(jacorbPrefix) + "InterfaceRepositoryURL");
        Environment.readValue("_trading_service", "tc", String.valueOf(jacorbPrefix) + "TradingServiceURL");
        Environment.readValue("_domain_service", "ds", String.valueOf(jacorbPrefix) + "DomainServiceURL");
        Environment.readValue("_orb_domain_filename", "ds", String.valueOf(jacorbPrefix) + "orb_domain.filename");
        Environment.readValue("_default_domains", "ds", String.valueOf(jacorbPrefix) + "poa.default_domains");
        Environment.readValue("_verbosity", "verbosity", String.valueOf(jacorbPrefix) + "verbosity");
        Environment.readValue("_locate_on_bind", "locate_on_bind", String.valueOf(jacorbPrefix) + "locate_on_bind");
        Environment.readValue("_cache_references", "reference_caching", String.valueOf(jacorbPrefix) + "reference_caching");
        Environment.readValue("_interceptServerRequests", "interceptor.server.Requests", String.valueOf(jacorbPrefix) + "interceptor.server.Requests");
        Environment.readValue("_interceptClientRequests", "interceptor.client.Requests", String.valueOf(jacorbPrefix) + "interceptor.client.Requests");
        Environment.readValue("_interceptClientMessages", "interceptor.client.Messages", String.valueOf(jacorbPrefix) + "interceptor.client.Messages");
        Environment.readValue("_interceptServerMessages", "interceptor.server.Messages", String.valueOf(jacorbPrefix) + "interceptor.server.Messages");
        Environment.readValue("_perObjectInterceptors", "interceptor.perObject", String.valueOf(jacorbPrefix) + "interceptor.perObject");
        Environment.readValue("_monitoring_on", "monitoring", String.valueOf(poaPrefix) + "monitoring");
        Environment.readValue("_use_imr", "use_imr", String.valueOf(jacorbPrefix) + "use_imr");
        Environment.readValue("_use_domain", "use_domain", String.valueOf(jacorbPrefix) + "use_domain");
        Environment.readValue("_mount_orb_domain", "_mount_orb_domain", String.valueOf(jacorbPrefix) + "orb_domain.mount");
        Environment.readValue("_thread_pool_max", "thread_pool_max", String.valueOf(poaPrefix) + "thread_pool_max");
        Environment.readValue("_thread_pool_min", "thread_pool_min", String.valueOf(poaPrefix) + "thread_pool_min");
        Environment.readValue("_queue_max", "queue_max", String.valueOf(poaPrefix) + "queue_max");
        Environment.readValue("_proxy_server", "proxy", String.valueOf(jacorbPrefix) + "ProxyServerURL");
        Environment.readValue("_use_appligator_for_applets", String.valueOf(jacorbPrefix) + "use_appligator_for_applets", null);
        Environment.readValue("_use_appligator_for_applications", String.valueOf(jacorbPrefix) + "use_appligator_for_applications", null);
        Environment.readValue("_use_httptunneling_for", String.valueOf(jacorbPrefix) + "use_httptunneling_for", null);
        Environment.readValue("_charset_flags", "charset_flags", String.valueOf(jacorbPrefix) + "charset_flags");
        Environment.readValue("_impl_name", "implname", String.valueOf(jacorbPrefix) + "implname");
        Environment.readValue("_enforce_ssl", String.valueOf(jacorbPrefix) + "security.enforce_ssl", null);
        Environment.readValue("_supported_options", String.valueOf(jacorbPrefix) + "security.ssl.supported_options", null);
        Environment.readValue("_required_options", String.valueOf(jacorbPrefix) + "security.ssl.required_options", null);
        Environment.readValue("_support_ssl", String.valueOf(jacorbPrefix) + "security.support_ssl", null);
        Environment.readValue("_default_user", String.valueOf(jacorbPrefix) + "security.default_user", null);
        Environment.readValue("_default_password", String.valueOf(jacorbPrefix) + "security.default_password", null);
        Environment.readValue("_keyStore", String.valueOf(jacorbPrefix) + "security.keystore", null);
    }

    public static final short requiredBySSL() {
        return _required_options;
    }

    public static final long retryInterval() {
        return _retry_interval;
    }

    public static final String rootNsURL() {
        return _default_context;
    }

    public static final byte[] serverId() {
        if (_server_id == null) {
            _server_id = String.valueOf((long)(Math.random() * 9.999999999E9)).getBytes();
        }
        return _server_id;
    }

    public static void setProxyURL(String string) {
        _proxy_server = string;
    }

    public static void setRootNsURL(String string) {
        _default_context = string;
    }

    public static final boolean supportSSL() {
        return _support_ssl;
    }

    public static final short supportedBySSL() {
        return _supported_options;
    }

    public static final int threadPoolMax() {
        return _thread_pool_max;
    }

    public static final int threadPoolMin() {
        return _thread_pool_min;
    }

    public static final String time() {
        Calendar calendar = Calendar.getInstance();
        return String.valueOf(calendar.get(11)) + ":" + (calendar.get(12) < 10 ? "0" + calendar.get(12) : String.valueOf(calendar.get(12))) + ":" + (calendar.get(13) < 10 ? "0" + calendar.get(13) : String.valueOf(calendar.get(13)));
    }

    public static final String tradingServiceURL() {
        return _trading_service;
    }

    public static final boolean useAppligator(boolean bl) {
        if (bl) {
            return _use_appligator_for_applets;
        }
        return _use_appligator_for_applications;
    }

    public static final boolean useDomain() {
        return _use_domain;
    }

    public static final boolean useHTTPTunneling(String string) {
        Object v = _use_httptunneling_for.get(string);
        return v != null;
    }

    public static final boolean useImR() {
        return _use_imr;
    }

    public static final int verbosityLevel() {
        return _verbosity;
    }
}

