/*
 * Decompiled with CFR 0.152.
 */
package jacorb.util;

import jacorb.util.CADTableModel;
import jacorb.util.Debug;
import jacorb.util.Environment;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CAD
extends JFrame {
    private JTable bit_table;
    private JPanel jPanel1;
    private JLabel jLabel1;
    private JLabel int_lbl;
    private JLabel categories_lbl;
    private JLabel level_lbl;
    private JSplitPane jSplitPane1;
    private JScrollPane jScrollPane1;
    private JList categories_list;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JList levels_list;
    private JButton print_btn;
    private JButton exit_btn;
    private CADTableModel model = null;
    private int debug_int = 0;

    public CAD() {
        this.initComponents();
        this.pack();
    }

    private void doExit(ActionEvent actionEvent) {
        System.exit(0);
    }

    private void exitForm(WindowEvent windowEvent) {
        System.exit(0);
    }

    private void initComponents() {
        String[] stringArray = new String[]{"Quiet", "Important", "Information", "Debug1"};
        String[] stringArray2 = new String[]{"ORB - Connect", "ORB - Misc", "POA", "ImR", "DSI", "DII", "Interceptor", "Domain", "Proxy", "Tools", "Naming", "Trading", "Events", "Transaction", "Security"};
        final int[] nArray = new int[]{256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 262144, 0x1000000, 0x2000000, 0x4000000, 0x8000000, 0x10000000};
        final int[] nArray2 = new int[]{8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 24, 25, 26, 27, 28};
        this.model = new CADTableModel();
        this.bit_table = new JTable(this.model);
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.int_lbl = new JLabel();
        this.categories_lbl = new JLabel();
        this.level_lbl = new JLabel();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.categories_list = new JList<String>(stringArray2);
        this.jScrollPane2 = new JScrollPane();
        this.levels_list = new JList<String>(stringArray);
        this.print_btn = new JButton();
        this.exit_btn = new JButton();
        this.setTitle("Click-a-Debug-Level");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CAD.this.exitForm(windowEvent);
            }
        });
        this.debug_int = Environment.verbosityLevel();
        int n = 0;
        while (n < 32) {
            this.model.setBit(n, this.debug_int >> n & 1);
            ++n;
        }
        int n2 = 0;
        while (n2 < 8) {
            this.bit_table.getColumnModel().getColumn(n2).setPreferredWidth(30);
            ++n2;
        }
        Vector<Integer> vector = new Vector<Integer>();
        int n3 = 0;
        while (n3 < nArray2.length) {
            if ((this.debug_int >> nArray2[n3] & 1) == 1) {
                vector.addElement(new Integer(n3));
            }
            ++n3;
        }
        int[] nArray3 = new int[vector.size()];
        int n4 = 0;
        while (n4 < vector.size()) {
            nArray3[n4] = (Integer)vector.elementAt(n4);
            ++n4;
        }
        this.categories_list.setSelectedIndices(nArray3);
        this.levels_list.setSelectedIndex(this.debug_int & 0xFF);
        this.getContentPane().add((Component)this.bit_table.getTableHeader(), "North");
        this.getContentPane().add((Component)this.bit_table, "Center");
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText("As int:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.int_lbl.setText(String.valueOf(this.debug_int));
        this.int_lbl.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.jPanel1.add((Component)this.int_lbl, gridBagConstraints);
        this.categories_lbl.setText("Categories:");
        this.categories_lbl.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.categories_lbl, gridBagConstraints);
        this.level_lbl.setText("Debug Level:");
        this.level_lbl.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.jPanel1.add((Component)this.level_lbl, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.categories_list);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.jScrollPane2.setViewportView(this.levels_list);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        this.categories_list.setSelectionMode(2);
        this.categories_list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = listSelectionEvent.getFirstIndex();
                while (n <= listSelectionEvent.getLastIndex()) {
                    if (categories_list.isSelectedIndex(n)) {
                        model.setBit(nArray2[n], 1);
                        CAD cAD = this;
                        cAD.debug_int = cAD.debug_int | nArray[n];
                    } else {
                        model.setBit(nArray2[n], 0);
                        CAD cAD = this;
                        cAD.debug_int = cAD.debug_int & nArray[n] * -1 - 1;
                    }
                    ++n;
                }
                int_lbl.setText(String.valueOf(debug_int));
            }
        });
        this.levels_list.setSelectionMode(0);
        this.levels_list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = listSelectionEvent.getFirstIndex();
                while (n <= listSelectionEvent.getLastIndex()) {
                    if (CAD.this.levels_list.isSelectedIndex(n)) {
                        int n2 = 0;
                        while (n2 < 4) {
                            CAD.this.model.setBit(n2, n >> n2 & 1);
                            ++n2;
                        }
                        CAD cAD = CAD.this;
                        cAD.debug_int = cAD.debug_int & 0xFFFFFF00;
                        CAD cAD2 = CAD.this;
                        cAD2.debug_int = cAD2.debug_int | n;
                    }
                    ++n;
                }
                CAD.this.int_lbl.setText(String.valueOf(CAD.this.debug_int));
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.jPanel1.add((Component)this.jSplitPane1, gridBagConstraints);
        this.print_btn.setText("Write");
        this.print_btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                block7: {
                    JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.home"));
                    jFileChooser.setDialogTitle("Select the properties file...");
                    String string = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator");
                    File file = new File(String.valueOf(string) + "jacorb.properties");
                    if (!file.exists()) {
                        file = new File(String.valueOf(string) + ".jacorb_properties");
                    }
                    if (file.exists()) {
                        jFileChooser.setSelectedFile(file);
                    }
                    if (jFileChooser.showDialog(CAD.this, "Write") != 0) break block7;
                    try {
                        file = jFileChooser.getSelectedFile();
                        File file2 = new File(String.valueOf(file.getAbsolutePath()) + ".tmp");
                        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                        PrintWriter printWriter = new PrintWriter(new FileWriter(file2));
                        String string2 = null;
                        boolean bl = false;
                        while ((string2 = bufferedReader.readLine()) != null) {
                            if (!bl && string2.startsWith("jacorb.verbosity=")) {
                                printWriter.println("jacorb.verbosity=" + CAD.this.debug_int);
                                bl = true;
                                continue;
                            }
                            printWriter.println(string2);
                        }
                        if (!bl) {
                            printWriter.println("jacorb.verbosity=" + CAD.this.debug_int);
                        }
                        bufferedReader.close();
                        printWriter.flush();
                        printWriter.close();
                        file2.renameTo(file);
                    }
                    catch (Exception exception) {
                        Debug.output(262145, exception);
                    }
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.jPanel1.add((Component)this.print_btn, gridBagConstraints);
        this.exit_btn.setText("Exit");
        this.exit_btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CAD.this.doExit(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        this.jPanel1.add((Component)this.exit_btn, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "South");
    }

    public static void main(String[] stringArray) {
        new CAD().show();
    }
}

