/*
 * Decompiled with CFR 0.152.
 */
package jacorb.orb;

import jacorb.orb.BufferManager;
import jacorb.orb.CDRInputStream;
import jacorb.orb.CDROutputStream;
import jacorb.orb.CloseConnectionException;
import jacorb.orb.CodeSet;
import jacorb.orb.ConnectionManager;
import jacorb.orb.ORB;
import jacorb.orb.ParsedIOR;
import jacorb.orb.ReplyReceptor;
import jacorb.orb.factory.SocketFactory;
import jacorb.orb.giop.LocateReplyInputStream;
import jacorb.orb.giop.LocateRequestOutputStream;
import jacorb.orb.giop.Messages;
import jacorb.orb.giop.ReplyInputStream;
import jacorb.orb.giop.ReplyOutputStream;
import jacorb.orb.giop.RequestOutputStream;
import jacorb.util.Debug;
import jacorb.util.Environment;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.omg.CONV_FRAME.CodeSetComponent;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import org.omg.CONV_FRAME.CodeSetContext;
import org.omg.CONV_FRAME.CodeSetContextHelper;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.Object;
import org.omg.IIOP.Version;
import org.omg.IOP.ServiceContext;

public class Connection {
    private int id_count = 0;
    protected String connection_info = null;
    protected InputStream in_stream;
    BufferedOutputStream out_stream;
    protected ORB orb;
    protected ConnectionManager manager;
    public java.lang.Object writeLock = new java.lang.Object();
    protected Hashtable objects = new Hashtable();
    protected Hashtable buffers = new Hashtable();
    protected Hashtable replies = new Hashtable();
    protected boolean littleEndian;
    protected boolean is_server;
    protected int TCS = 0;
    protected int TCSW = 0;
    private boolean tcsNegotiated = false;
    protected Version IIOPVersion = new Version(1, 0);
    protected int client_count = 0;
    protected Socket mysock = null;
    protected ReplyReceptor repReceptor;
    private byte[] header = new byte[Messages.MSG_HEADER_SIZE];
    protected SocketFactory socket_factory = null;

    public Connection() {
    }

    public Connection(ConnectionManager connectionManager, Socket socket, boolean bl, SocketFactory socketFactory) throws IOException {
        this(connectionManager, socket, bl, new BufferedInputStream(socket.getInputStream()), socketFactory);
    }

    public Connection(ConnectionManager connectionManager, Socket socket, boolean bl, InputStream inputStream, SocketFactory socketFactory) throws IOException {
        this.socket_factory = socketFactory;
        this.manager = connectionManager;
        this.orb = connectionManager.getORB();
        this.mysock = socket;
        this.is_server = bl;
        this.in_stream = inputStream;
        this.out_stream = new BufferedOutputStream(this.mysock.getOutputStream(), Environment.outBufSize());
        String string = this.mysock.getInetAddress().getHostAddress();
        if (string.indexOf(47) > 0) {
            string = string.substring(string.indexOf(47) + 1);
        }
        String string2 = String.valueOf(string) + ":" + this.mysock.getPort();
        String string3 = this.isSSL() ? "SSL " : "";
        this.connection_info = string2;
        this.client_count = 1;
        if (!bl) {
            Debug.output(1, "New " + string3 + "connection to " + string2);
            this.repReceptor = new ReplyReceptor(this);
        } else {
            Debug.output(1, "Accepted " + string3 + "connection from " + string2);
        }
    }

    private void abort() throws EOFException {
        Debug.output(3, "Connection to " + this.connection_info + " aborting...");
        Enumeration enumeration = this.replies.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            java.lang.Object k = enumeration.nextElement();
            ReplyInputStream replyInputStream = (ReplyInputStream)this.replies.get(k);
            replyInputStream.cancel();
            ++n;
        }
        this.replies.clear();
        this.objects.clear();
        if (n > 0) {
            Debug.output(2, "Lost " + n + " outstanding replies");
        }
        throw new EOFException();
    }

    public ServiceContext[] addCodeSetContext(ServiceContext[] serviceContextArray, ParsedIOR parsedIOR) {
        if (this.tcsNegotiated || !Environment.charsetSendCtx()) {
            return serviceContextArray;
        }
        if (this.TCS == 0 && !this.selectCodeSet(parsedIOR)) {
            return serviceContextArray;
        }
        CDROutputStream cDROutputStream = new CDROutputStream(this.orb);
        cDROutputStream.write_boolean(false);
        CodeSetContextHelper.write(cDROutputStream, new CodeSetContext(this.TCS, this.TCSW));
        ServiceContext[] serviceContextArray2 = new ServiceContext[serviceContextArray.length + 1];
        System.arraycopy(serviceContextArray, 0, serviceContextArray2, 0, serviceContextArray.length);
        serviceContextArray2[serviceContextArray.length] = new ServiceContext(1, cDROutputStream.getBufferCopy());
        return serviceContextArray2;
    }

    public synchronized void closeConnection() {
        block10: {
            Debug.output(1, "Closing connection to " + this.connection_info);
            try {
                if (this.repReceptor != null) {
                    this.repReceptor.stopReceptor();
                }
                Debug.output(4, "Closing connection to " + this.connection_info + " (reply receptor closed)");
                try {
                    if (this.mysock != null) {
                        this.mysock.close();
                    }
                }
                catch (IOException iOException) {
                    Debug.output(4, iOException);
                }
                if (this.in_stream != null) {
                    this.in_stream.close();
                }
                Debug.output(4, "Closing connection to " + this.connection_info + " (in streams closed)");
                if (this.out_stream != null) {
                    this.out_stream.close();
                }
                Debug.output(4, "Closing connection to " + this.connection_info + " (out streams closed)");
            }
            catch (IOException iOException) {
                Debug.output(4, iOException);
            }
            this.in_stream = null;
            this.out_stream = null;
            this.repReceptor = null;
            this.mysock = null;
            Debug.output(3, "Closing connection to " + this.connection_info + " (sockets closed)");
            this.manager.removeConnection(this);
            if (this.replies.size() <= 0) break block10;
            try {
                this.reconnect();
            }
            catch (COMM_FAILURE cOMM_FAILURE) {
                Debug.output(1, "Could not reconnect to " + this.connection_info + " (loss of outstanding replies)");
            }
        }
    }

    public boolean connected() {
        return this.mysock != null;
    }

    public static void dumpBA(byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (n2 % 20 == 0) {
                System.out.println();
            }
            Connection.dumpHex(byArray[n2]);
            ++n2;
        }
        System.out.println();
    }

    public static void dumpHex(byte by) {
        int n = (by & 0xFF) / 16;
        int n2 = (by & 0xFF) % 16;
        char c = (char)(n > 9 ? 65 + (n - 10) : 48 + n);
        char c2 = (char)(n2 > 9 ? 65 + (n2 - 10) : 48 + n2);
        char c3 = by > 31 && by < 127 ? (char)((char)by) : (char)' ';
        System.out.print(String.valueOf(c) + c2 + " " + c3 + "  ");
    }

    public void duplicate() {
        this.incUsers();
    }

    public BufferManager getBufferManager() {
        return this.orb.getBufferManager();
    }

    public synchronized int getId() {
        return this.id_count++;
    }

    public String getInfo() {
        return this.connection_info;
    }

    ORB getORB() {
        return this.orb;
    }

    public Socket getSocket() {
        return this.mysock;
    }

    public Hashtable get_objects() {
        return this.objects;
    }

    public BufferedOutputStream get_out_stream() {
        return this.out_stream;
    }

    public Hashtable get_replies() {
        return this.replies;
    }

    protected synchronized void incUsers() {
        ++this.client_count;
    }

    public boolean isSSL() {
        return this.socket_factory.isSSL(this.mysock);
    }

    public boolean isTCSNegotiated() {
        return this.tcsNegotiated;
    }

    public void markTcsNegotiated() {
        if (this.tcsNegotiated) {
            return;
        }
        this.tcsNegotiated = true;
        Debug.output(4, "TCS marked as negotiated");
    }

    public byte[] readBuffer() throws IOException {
        int n;
        int n2 = 0;
        while (n2 < Messages.MSG_HEADER_SIZE) {
            n = -1;
            try {
                n = this.in_stream.read();
            }
            catch (InterruptedIOException interruptedIOException) {
                Debug.output(3, "Connection timed out");
            }
            catch (Exception exception) {
                Debug.output(3, exception);
            }
            if (n < 0) {
                this.abort();
            }
            this.header[n2] = (byte)n;
            ++n2;
        }
        if ((char)this.header[0] == 'S' && (char)this.header[1] == 'E' && (char)this.header[2] == 'C' && (char)this.header[3] == 'P') {
            throw new IOException("Cannot handle SECIOP messages yet...");
        }
        if ((char)this.header[0] == 'G' && (char)this.header[1] == 'I' && (char)this.header[2] == 'O' && (char)this.header[3] == 'P') {
            n = 0;
            n = this.header[6] == 0 ? ((0xFF & this.header[8]) << 24) + ((0xFF & this.header[9]) << 16) + ((0xFF & this.header[10]) << 8) + (0xFF & this.header[11]) : ((0xFF & this.header[11]) << 24) + ((0xFF & this.header[10]) << 16) + ((0xFF & this.header[9]) << 8) + (0xFF & this.header[8]);
            if (n < 0) {
                this.abort();
            }
            int n3 = n + Messages.MSG_HEADER_SIZE;
            byte[] byArray = this.orb.getBufferManager().getBuffer(n3);
            int n4 = 0;
            while (n4 < Messages.MSG_HEADER_SIZE) {
                byArray[n4] = this.header[n4];
                ++n4;
            }
            int n5 = Messages.MSG_HEADER_SIZE;
            while (n5 < n3) {
                int n6 = -1;
                try {
                    n6 = this.in_stream.read(byArray, n5, n3 - n5);
                }
                catch (IOException iOException) {
                    Debug.output(4, iOException);
                }
                if (n6 < 0) {
                    this.abort();
                }
                n5 += n6;
            }
            return byArray;
        }
        Debug.output(0, "Unknown message header type detected by " + Thread.currentThread().getName() + ", discarding ", this.header);
        return this.readBuffer();
    }

    public void receiveReply() throws IOException, CloseConnectionException {
        if (!this.connected()) {
            throw new EOFException();
        }
        byte[] byArray = this.readBuffer();
        byte by = byArray[5];
        byte by2 = byArray[7];
        Debug.output(4, "received reply, GIOP version 1." + by);
        switch (by2) {
            case 1: {
                Debug.output(8, "receiveReply", byArray);
                Integer n = new Integer(Messages.getRequestId(byArray, by2));
                Object object = (Object)this.objects.remove(n);
                ReplyInputStream replyInputStream = (ReplyInputStream)this.replies.remove(n);
                if (replyInputStream != null) {
                    replyInputStream.init(byArray, object);
                    break;
                }
                System.err.println("Serious Error! No pending request for reply " + n);
                break;
            }
            case 4: {
                Integer n = new Integer(Messages.getRequestId(byArray, by2));
                LocateReplyInputStream locateReplyInputStream = (LocateReplyInputStream)this.replies.remove(n);
                if (locateReplyInputStream != null) {
                    locateReplyInputStream.init(byArray);
                    break;
                }
                System.err.println("Serious Error! No pending request for reply " + n);
                break;
            }
            case 6: {
                Debug.output(1, "Got <MessageError> from server, something went wrong!");
            }
            case 5: {
                Debug.output(3, "got close connection message");
                throw new CloseConnectionException("Received <CloseConnection> from Server");
            }
            default: {
                throw new IOException("Received Message of unrecognizable type " + by2);
            }
        }
    }

    public synchronized void reconnect() throws COMM_FAILURE {
        Debug.output(1, "Trying to reconnect to " + this.connection_info);
        int n = Environment.noOfRetries();
        String string = this.connection_info.substring(0, this.connection_info.indexOf(":"));
        int n2 = new Integer(this.connection_info.substring(this.connection_info.indexOf(":") + 1));
        while (n > 0) {
            try {
                this.mysock = this.socket_factory.createSocket(string, n2);
                this.mysock.setTcpNoDelay(true);
                this.in_stream = new BufferedInputStream(this.mysock.getInputStream());
                this.out_stream = new BufferedOutputStream(this.mysock.getOutputStream(), Environment.outBufSize());
                String string2 = this.mysock.getInetAddress().getHostAddress();
                if (string2.indexOf(47) > 0) {
                    string2 = string2.substring(string2.indexOf(47) + 1);
                }
                String string3 = String.valueOf(string2) + ":" + this.mysock.getPort();
                this.manager.addConnection(this);
                this.connection_info = string3;
                Debug.output(1, "Reconnected to " + string3);
                this.repReceptor = new ReplyReceptor(this);
                Enumeration enumeration = this.replies.elements();
                while (enumeration.hasMoreElements()) {
                    Debug.output(1, "WARNING: there were outstanding requests when reconnect succeeded! (Lost now)");
                    ((ReplyInputStream)enumeration.nextElement()).cancel();
                }
                return;
            }
            catch (IOException iOException) {
                Debug.output(1, "Retrying to reconnect to " + this.connection_info);
                try {
                    Thread.sleep(Environment.retryInterval());
                }
                catch (InterruptedException interruptedException) {}
                --n;
            }
        }
        if (n == 0) {
            throw new COMM_FAILURE("Retries exceeded, couldn't reconnect to " + this.connection_info);
        }
    }

    public synchronized void releaseConnection() {
        --this.client_count;
        if (this.client_count == 0) {
            this.closeConnection();
        } else {
            Debug.output(2, "Releasing one connection to " + this.connection_info);
        }
    }

    protected boolean selectCodeSet(ParsedIOR parsedIOR) {
        int n = 0;
        while (n < parsedIOR.taggedComponents.length) {
            if (parsedIOR.taggedComponents[n].tag == 1) {
                Debug.output(4, "TAG_CODE_SETS found");
                CDRInputStream cDRInputStream = new CDRInputStream(this.orb, parsedIOR.taggedComponents[n].component_data);
                cDRInputStream.setLittleEndian(cDRInputStream.read_boolean());
                CodeSetComponentInfo codeSetComponentInfo = CodeSetComponentInfoHelper.read(cDRInputStream);
                this.TCS = this.selectCodeSet(codeSetComponentInfo.ForCharData, 0x5010001);
                if (this.TCS == 0) {
                    this.TCS = 65537;
                }
                this.TCSW = this.selectCodeSet(codeSetComponentInfo.ForWcharData, 0x5010001);
                if (this.TCSW == 0) {
                    this.TCSW = this.selectCodeSet(codeSetComponentInfo.ForWcharData, 65801);
                }
                Debug.output(4, "TCS selected: " + CodeSet.csName(this.TCS) + "," + CodeSet.csName(this.TCSW));
                return true;
            }
            ++n;
        }
        this.TCS = 65537;
        this.TCSW = 65801;
        this.markTcsNegotiated();
        Debug.output(4, "default TCS selected: " + CodeSet.csName(this.TCS) + "," + CodeSet.csName(this.TCSW));
        return false;
    }

    protected int selectCodeSet(CodeSetComponent codeSetComponent, int n) {
        if (codeSetComponent.native_code_set == n) {
            return n;
        }
        int n2 = 0;
        while (n2 < codeSetComponent.conversion_code_sets.length) {
            if (codeSetComponent.conversion_code_sets[n2] == n) {
                return n;
            }
            ++n2;
        }
        return 0;
    }

    public synchronized void sendCloseConnection() throws COMM_FAILURE {
        try {
            this.out_stream.write(Messages.closeConnectionMessage());
            this.out_stream.flush();
            this.closeConnection();
        }
        catch (Exception exception) {
            throw new COMM_FAILURE();
        }
    }

    public void sendLocateReply(int n, int n2, Object object) throws COMM_FAILURE {
        java.lang.Object object2 = this.writeLock;
        synchronized (object2) {
            try {
                this.out_stream.write(Messages.locateReplyMessage(n, n2, object, this));
                this.out_stream.flush();
            }
            catch (Exception exception) {
                Debug.output(2, exception);
                throw new COMM_FAILURE();
            }
        }
    }

    public synchronized LocateReplyInputStream sendLocateRequest(LocateRequestOutputStream locateRequestOutputStream) throws COMM_FAILURE {
        if (!this.connected()) {
            this.reconnect();
        }
        java.lang.Object object = this.writeLock;
        synchronized (object) {
            LocateReplyInputStream locateReplyInputStream = null;
            try {
                locateReplyInputStream = new LocateReplyInputStream(this, locateRequestOutputStream.requestId());
                Integer n = new Integer(locateRequestOutputStream.requestId());
                this.replies.put(n, locateReplyInputStream);
                locateRequestOutputStream.write_to(this.out_stream);
                locateRequestOutputStream.release();
            }
            catch (Exception exception) {
                Debug.output(2, exception);
                throw new COMM_FAILURE();
            }
            LocateReplyInputStream locateReplyInputStream2 = locateReplyInputStream;
            java.lang.Object var4_7 = null;
            return locateReplyInputStream2;
        }
    }

    public void sendReply(ReplyOutputStream replyOutputStream) throws IOException {
        java.lang.Object object = this.writeLock;
        synchronized (object) {
            try {
                if (Environment.verbosityLevel() > 4) {
                    Debug.output(5, "send reply", replyOutputStream.getBufferCopy());
                }
                replyOutputStream.write_to(this.out_stream);
                replyOutputStream.release();
            }
            catch (Exception exception) {
                Debug.output(2, exception);
                throw new COMM_FAILURE();
            }
        }
    }

    public org.omg.CORBA.portable.InputStream sendRequest(Object object, RequestOutputStream requestOutputStream) throws COMM_FAILURE {
        if (!this.connected()) {
            Debug.output(3, "not connected");
            this.reconnect();
        }
        java.lang.Object object2 = this.writeLock;
        synchronized (object2) {
            ReplyInputStream replyInputStream = null;
            try {
                if (requestOutputStream.response_expected()) {
                    replyInputStream = new ReplyInputStream(this, requestOutputStream.requestId());
                    Integer n = new Integer(requestOutputStream.requestId());
                    this.replies.put(n, replyInputStream);
                    this.objects.put(n, object);
                }
                if (Environment.verbosityLevel() > 4) {
                    Debug.output(5, "send request", requestOutputStream.getBufferCopy());
                }
                requestOutputStream.write_to(this.out_stream);
                requestOutputStream.release();
            }
            catch (Exception exception) {
                Debug.output(2, exception);
                throw new COMM_FAILURE();
            }
            ReplyInputStream replyInputStream2 = replyInputStream;
            java.lang.Object var5_8 = null;
            return replyInputStream2;
        }
    }

    public boolean setServerCodeSet(ServiceContext[] serviceContextArray) {
        if (!Environment.charsetScanCtx()) {
            return false;
        }
        int n = 0;
        while (n < serviceContextArray.length) {
            if (serviceContextArray[n].context_id == 1) {
                CDRInputStream cDRInputStream = new CDRInputStream(this.orb, serviceContextArray[n].context_data);
                cDRInputStream.setLittleEndian(cDRInputStream.read_boolean());
                CodeSetContext codeSetContext = CodeSetContextHelper.read(cDRInputStream);
                this.TCSW = codeSetContext.wchar_data;
                this.TCS = codeSetContext.char_data;
                this.markTcsNegotiated();
                Debug.output(4, "TCS set: " + CodeSet.csName(this.TCS) + "," + CodeSet.csName(this.TCSW));
                return true;
            }
            ++n;
        }
        return false;
    }

    public void setTimeOut(int n) throws SocketException {
        this.mysock.setSoTimeout(n);
    }

    public void writeDirectly(byte[] byArray, int n) throws IOException {
        this.get_out_stream().write(byArray, 0, n);
        this.get_out_stream().flush();
    }
}

