/*
 * Decompiled with CFR 0.152.
 */
package jacorb.ir.gui.typesystem.remote;

import jacorb.ir.gui.typesystem.AbstractContainer;
import jacorb.ir.gui.typesystem.ModelParticipant;
import jacorb.ir.gui.typesystem.TypeSystemNode;
import jacorb.ir.gui.typesystem.remote.IRException;
import jacorb.ir.gui.typesystem.remote.IRNodeWithType;
import jacorb.ir.gui.typesystem.remote.IRParameter;
import jacorb.ir.gui.typesystem.remote.RemoteTypeSystem;
import org.omg.CORBA.ExceptionDef;
import org.omg.CORBA.IRObject;
import org.omg.CORBA.OperationDef;
import org.omg.CORBA.OperationDefHelper;
import org.omg.CORBA.ParameterDescription;

public class IROperation
extends IRNodeWithType
implements AbstractContainer {
    protected IRParameter[] parameters;
    protected IRException[] exceptions;
    private String instanceNodeTypeName;
    private OperationDef operationDef;

    public IROperation() {
    }

    public IROperation(IRObject iRObject) {
        super(iRObject);
        this.operationDef = OperationDefHelper.narrow(iRObject);
        this.setAssociatedTypeSystemNode(RemoteTypeSystem.createTypeSystemNode(this.operationDef.result_def()));
        String string = super.getInstanceNodeTypeName();
        if (this.operationDef.mode().value() == 1) {
            string = "oneway " + string;
        }
        this.instanceNodeTypeName = string;
    }

    public ModelParticipant[] contents() {
        OperationDef operationDef = OperationDefHelper.narrow(this.irObject);
        ParameterDescription[] parameterDescriptionArray = operationDef.params();
        ModelParticipant[] modelParticipantArray = new TypeSystemNode[parameterDescriptionArray.length];
        int n = 0;
        while (n < parameterDescriptionArray.length) {
            modelParticipantArray[n] = RemoteTypeSystem.createTypeSystemNode(parameterDescriptionArray[n]);
            ++n;
        }
        return modelParticipantArray;
    }

    public String description() {
        String string = super.description();
        if (this.exceptions == null) {
            ExceptionDef[] exceptionDefArray = this.operationDef.exceptions();
            this.exceptions = new IRException[exceptionDefArray.length];
            int n = 0;
            while (n < exceptionDefArray.length) {
                this.exceptions[n] = (IRException)RemoteTypeSystem.createTypeSystemNode(exceptionDefArray[n]);
                ++n;
            }
        }
        if (this.exceptions.length > 0) {
            string = String.valueOf(string) + "\nExceptions:\t ";
            int n = 0;
            while (n < this.exceptions.length) {
                string = String.valueOf(string) + ((TypeSystemNode)this.exceptions[n]).getAbsoluteName();
                if (n != this.exceptions.length - 1) {
                    string = String.valueOf(string) + ", ";
                }
                ++n;
            }
        } else {
            string = String.valueOf(string) + "\nExceptions:\t:none";
        }
        return string;
    }

    public String getInstanceNodeTypeName() {
        return this.instanceNodeTypeName;
    }

    public static String nodeTypeName() {
        return "operation";
    }
}

