/*
 * Decompiled with CFR 0.152.
 */
package jacorb.ir;

import jacorb.ir.Container;
import jacorb.ir.IRObject;
import jacorb.ir.PrimitiveDef;
import jacorb.util.Debug;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.omg.CORBA.AliasDef;
import org.omg.CORBA.Any;
import org.omg.CORBA.ArrayDef;
import org.omg.CORBA.ConstantDef;
import org.omg.CORBA.Contained;
import org.omg.CORBA.ContainerPackage.Description;
import org.omg.CORBA.DefinitionKind;
import org.omg.CORBA.EnumDef;
import org.omg.CORBA.ExceptionDef;
import org.omg.CORBA.FixedDef;
import org.omg.CORBA.IDLType;
import org.omg.CORBA.Initializer;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.ModuleDef;
import org.omg.CORBA.NativeDef;
import org.omg.CORBA.ORB;
import org.omg.CORBA.PrimitiveDefHelper;
import org.omg.CORBA.PrimitiveDefPOATie;
import org.omg.CORBA.PrimitiveKind;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.omg.CORBA.RepositoryOperations;
import org.omg.CORBA.RepositoryPOATie;
import org.omg.CORBA.SequenceDef;
import org.omg.CORBA.StringDef;
import org.omg.CORBA.StructDef;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UnionDef;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.ValueBoxDef;
import org.omg.CORBA.ValueDef;
import org.omg.CORBA.WstringDef;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;

public class RepositoryImpl
extends IRObject
implements RepositoryOperations {
    private String classpath;
    private Hashtable contained = new Hashtable();
    private Container delegate;
    public static POA poa;
    public static ClassLoader loader;
    public static char fileSeparator;
    public static String pathSeparator;

    static {
        fileSeparator = System.getProperty("file.separator").charAt(0);
        pathSeparator = System.getProperty("path.separator");
    }

    public RepositoryImpl(String string, String string2, URLClassLoader uRLClassLoader) {
        this.classpath = string;
        loader = uRLClassLoader;
        this.def_kind = DefinitionKind.dk_Repository;
        this.delegate = new Container(this, this.classpath, null);
        try {
            URL[] uRLArray = uRLClassLoader.getURLs();
            StringBuffer stringBuffer = new StringBuffer("IR configured for class path: ");
            int n = 0;
            while (n < uRLArray.length) {
                stringBuffer.append(String.valueOf(uRLArray[n].toString()) + "\n");
                ++n;
            }
            ORB oRB = ORB.init(new String[0], null);
            poa = POAHelper.narrow(oRB.resolve_initial_references("RootPOA"));
            Repository repository = RepositoryHelper.narrow(poa.servant_to_reference(new RepositoryPOATie(this)));
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(string2), true);
            printWriter.println(oRB.object_to_string(repository));
            this.setReference(repository);
            printWriter.close();
            poa.the_POAManager().activate();
            Debug.output(1, stringBuffer.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Contained[] contents(DefinitionKind definitionKind, boolean bl) {
        return this.delegate.contents(definitionKind, bl);
    }

    public AliasDef create_alias(String string, String string2, String string3, IDLType iDLType) {
        return this.delegate.create_alias(string, string2, string3, iDLType);
    }

    public ArrayDef create_array(int n, IDLType iDLType) {
        return null;
    }

    public ConstantDef create_constant(String string, String string2, String string3, IDLType iDLType, Any any) {
        return this.delegate.create_constant(string, string2, string3, iDLType, any);
    }

    public EnumDef create_enum(String string, String string2, String string3, String[] stringArray) {
        return this.delegate.create_enum(string, string2, string3, stringArray);
    }

    public ExceptionDef create_exception(String string, String string2, String string3, StructMember[] structMemberArray) {
        return this.delegate.create_exception(string, string2, string3, structMemberArray);
    }

    public FixedDef create_fixed(short s, short s2) {
        return null;
    }

    public InterfaceDef create_interface(String string, String string2, String string3, InterfaceDef[] interfaceDefArray, boolean bl) {
        return this.delegate.create_interface(string, string2, string3, interfaceDefArray, bl);
    }

    public ModuleDef create_module(String string, String string2, String string3) {
        return this.delegate.create_module(string, string2, string3);
    }

    public NativeDef create_native(String string, String string2, String string3) {
        return this.delegate.create_native(string, string2, string3);
    }

    public SequenceDef create_sequence(int n, IDLType iDLType) {
        return null;
    }

    public StringDef create_string(int n) {
        return null;
    }

    public StructDef create_struct(String string, String string2, String string3, StructMember[] structMemberArray) {
        return this.delegate.create_struct(string, string2, string3, structMemberArray);
    }

    public UnionDef create_union(String string, String string2, String string3, IDLType iDLType, UnionMember[] unionMemberArray) {
        return this.delegate.create_union(string, string2, string3, iDLType, unionMemberArray);
    }

    public ValueDef create_value(String string, String string2, String string3, boolean bl, boolean bl2, ValueDef valueDef, boolean bl3, ValueDef[] valueDefArray, InterfaceDef[] interfaceDefArray, Initializer[] initializerArray) {
        return this.delegate.create_value(string, string2, string3, bl, bl2, valueDef, bl3, valueDefArray, interfaceDefArray, initializerArray);
    }

    public ValueBoxDef create_value_box(String string, String string2, String string3, IDLType iDLType) {
        return this.delegate.create_value_box(string, string2, string3, iDLType);
    }

    public WstringDef create_wstring(int n) {
        return null;
    }

    void define() {
    }

    public Description[] describe_contents(DefinitionKind definitionKind, boolean bl, int n) {
        Contained[] containedArray = this.contents(definitionKind, bl);
        int n2 = n > containedArray.length ? n : containedArray.length;
        Description[] descriptionArray = new Description[n2];
        int n3 = 0;
        while (n3 < n2) {
            descriptionArray[n3] = new Description();
            org.omg.CORBA.ContainedPackage.Description description = containedArray[n3].describe();
            descriptionArray[n3].contained_object = containedArray[n3];
            descriptionArray[n3].kind = description.kind;
            descriptionArray[n3].value = description.value;
            ++n3;
        }
        return descriptionArray;
    }

    public void destroy() {
        this.delegate.destroy();
    }

    public TypeCode get_canonical_typecode(TypeCode typeCode) {
        return null;
    }

    public org.omg.CORBA.PrimitiveDef get_primitive(PrimitiveKind primitiveKind) {
        try {
            return PrimitiveDefHelper.narrow(poa.servant_to_reference(new PrimitiveDefPOATie(new PrimitiveDef(primitiveKind.value()))));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private String idToScopedName(String string) {
        String string2 = "";
        if (!string.startsWith("IDL:") || !string.endsWith(":1.0")) {
            return null;
        }
        String string3 = string.substring(string.indexOf(58) + 1, string.lastIndexOf(58)).replace(fileSeparator, '/');
        if (string3.startsWith("omg.org")) {
            string3 = "org/omg" + string3.substring(7);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "/");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = String.valueOf(string2) + "::" + stringTokenizer.nextToken();
            ++n;
        }
        return string2;
    }

    public void loadContents() {
        Debug.output(1, "Repository loads contents...");
        this.delegate.loadContents();
        this.delegate.define();
        Debug.output(1, "Repository contents loaded");
    }

    public Contained lookup(String string) {
        Debug.output(2, "IR lookup : " + string);
        return this.delegate.lookup(string);
    }

    public Contained lookup_id(String string) {
        Debug.output(2, "IR lookup_id: " + string);
        String string2 = this.idToScopedName(string);
        if (string2 == null) {
            return null;
        }
        return this.lookup(string2);
    }

    public Contained[] lookup_name(String string, int n, DefinitionKind definitionKind, boolean bl) {
        Debug.output(2, "IR lookup_name: " + string);
        return this.delegate.lookup_name(string, n, definitionKind, bl);
    }
}

