/*
 * Decompiled with CFR 0.152.
 */
package jacorb.ir;

import jacorb.ir.Contained;
import jacorb.ir.ExceptionDef;
import jacorb.ir.IDLType;
import jacorb.ir.RepositoryID;
import jacorb.ir.RepositoryImpl;
import jacorb.ir.TypeCodeUtil;
import jacorb.orb.TypeCode;
import jacorb.util.Debug;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.ContainedHelper;
import org.omg.CORBA.ContainedPackage.Description;
import org.omg.CORBA.DefinitionKind;
import org.omg.CORBA.ExceptionDefHelper;
import org.omg.CORBA.ExceptionDefPOATie;
import org.omg.CORBA.ExceptionDescription;
import org.omg.CORBA.ExceptionDescriptionHelper;
import org.omg.CORBA.INTF_REPOS;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.OperationDefOperations;
import org.omg.CORBA.OperationDescription;
import org.omg.CORBA.OperationDescriptionHelper;
import org.omg.CORBA.OperationMode;
import org.omg.CORBA.ParameterDescription;
import org.omg.CORBA.ParameterMode;

public class OperationDef
extends Contained
implements OperationDefOperations {
    private org.omg.CORBA.TypeCode result = null;
    private org.omg.CORBA.IDLType result_def = null;
    private org.omg.CORBA.ExceptionDef[] exceptions = null;
    private ParameterDescription[] params = null;
    private String[] contexts = new String[0];
    private OperationMode mode;
    private Method method;
    private String opInfo;
    private String returnTypeName;
    private String[] paramTypeNames = new String[0];
    private boolean defined = false;

    public OperationDef(Method method, Class clazz, Class clazz2, InterfaceDef interfaceDef) {
        this.def_kind = DefinitionKind.dk_Operation;
        this.name(method.getName());
        Debug.assert(clazz != null, "Class argument null");
        Debug.assert(interfaceDef != null, "Idef argument null");
        this.id(RepositoryID.toRepositoryID(String.valueOf(RepositoryID.className(interfaceDef.id())) + "/" + this.name()));
        this.version(this.id().substring(this.id().lastIndexOf(58)));
        this.defined_in = interfaceDef;
        this.containing_repository = interfaceDef.containing_repository();
        String string = clazz.getName();
        this.absolute_name = String.valueOf(interfaceDef.absolute_name()) + "::" + this.name;
        this.method = method;
        Debug.output(2, "New OperationDef, name: " + this.name + " " + this.absolute_name);
        Hashtable hashtable = null;
        this.opInfo = null;
        try {
            hashtable = (Hashtable)clazz2.getDeclaredField("irInfo").get(null);
            this.opInfo = (String)hashtable.get(this.name());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.opInfo != null) {
            if (this.opInfo.endsWith("-oneway")) {
                this.mode = OperationMode.OP_ONEWAY;
            }
            if (this.opInfo.indexOf("(") > 0) {
                this.returnTypeName = this.opInfo.substring(0, this.opInfo.indexOf("("));
            }
            StringTokenizer stringTokenizer = new StringTokenizer(this.opInfo.substring(this.opInfo.indexOf("(") + 1, this.opInfo.lastIndexOf(")")), ",");
            this.paramTypeNames = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (n < this.paramTypeNames.length) {
                String string2 = stringTokenizer.nextToken();
                this.paramTypeNames[n] = !string2.equals(",") ? string2 : null;
                ++n;
            }
        }
        if (this.mode == null) {
            this.mode = OperationMode.OP_NORMAL;
        }
        this.contexts = new String[0];
    }

    public String[] contexts() {
        Debug.assert(this.defined, "OperationDeg undefined");
        if (!this.defined) {
            this.define();
        }
        return this.contexts;
    }

    public void contexts(String[] stringArray) {
        this.contexts = stringArray;
    }

    void define() {
        try {
            this.result = TypeCodeUtil.getTypeCode(this.method.getReturnType(), RepositoryImpl.loader, null, this.returnTypeName);
            this.result_def = IDLType.create(this.result, this.containing_repository);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.params = this.getParameterDescriptions();
        Class<?>[] classArray = this.method.getExceptionTypes();
        Class<?> clazz = null;
        try {
            clazz = RepositoryImpl.loader.loadClass("org.omg.CORBA.UserException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new INTF_REPOS(2620, CompletionStatus.COMPLETED_NO);
        }
        Vector<org.omg.CORBA.ExceptionDef> vector = new Vector<org.omg.CORBA.ExceptionDef>();
        int n = 0;
        while (n < classArray.length) {
            if (clazz.isAssignableFrom(classArray[n])) {
                try {
                    ExceptionDef exceptionDef = new ExceptionDef(classArray[n], this.defined_in, this.containing_repository);
                    org.omg.CORBA.ExceptionDef exceptionDef2 = ExceptionDefHelper.narrow(RepositoryImpl.poa.servant_to_reference(new ExceptionDefPOATie(exceptionDef)));
                    vector.addElement(exceptionDef2);
                    exceptionDef.setReference(exceptionDef2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            ++n;
        }
        this.exceptions = new org.omg.CORBA.ExceptionDef[vector.size()];
        vector.copyInto(this.exceptions);
        this.defined = true;
    }

    public Description describe() {
        Debug.assert(this.defined, "OperationDef undefined");
        Any any = this.orb.create_any();
        OperationDescriptionHelper.insert(any, this.describe_operation());
        return new Description(DefinitionKind.dk_Operation, any);
    }

    public OperationDescription describe_operation() {
        if (!this.defined) {
            this.define();
        }
        ExceptionDescription[] exceptionDescriptionArray = new ExceptionDescription[this.exceptions.length];
        int n = 0;
        while (n < this.exceptions.length) {
            Description description = this.exceptions[n].describe();
            if (description.kind != DefinitionKind.dk_Exception) {
                throw new INTF_REPOS(2610, CompletionStatus.COMPLETED_NO);
            }
            exceptionDescriptionArray[n] = ExceptionDescriptionHelper.extract(description.value);
            ++n;
        }
        return new OperationDescription(this.name, this.id, ContainedHelper.narrow(this.defined_in).id(), this.version, this.result, this.mode, this.contexts, this.params, exceptionDescriptionArray);
    }

    public void destroy() {
        throw new INTF_REPOS(2600, CompletionStatus.COMPLETED_NO);
    }

    public org.omg.CORBA.ExceptionDef[] exceptions() {
        Debug.assert(this.defined, "OperationDeg undefined");
        if (!this.defined) {
            this.define();
        }
        return this.exceptions;
    }

    public void exceptions(org.omg.CORBA.ExceptionDef[] exceptionDefArray) {
        this.exceptions = exceptionDefArray;
    }

    ParameterDescription[] getParameterDescriptions() {
        TypeCode typeCode = null;
        Class<?>[] classArray = this.method.getParameterTypes();
        ParameterDescription[] parameterDescriptionArray = new ParameterDescription[classArray.length];
        if (this.paramTypeNames.length > 0) {
            Debug.assert(this.paramTypeNames.length == classArray.length, "Different parameter type numbers! " + this.paramTypeNames.length + " vs. " + classArray.length + " inforString: " + this.opInfo);
        }
        int n = 0;
        while (n < parameterDescriptionArray.length) {
            Object object;
            String string = "arg_" + n;
            String string2 = null;
            ParameterMode parameterMode = null;
            try {
                object = classArray[n].getName();
                if (this.paramTypeNames.length != 0) {
                    string2 = this.paramTypeNames[n];
                }
                if (!((String)object).endsWith("Holder")) {
                    parameterMode = ParameterMode.PARAM_IN;
                    if (string2 != null && string2.indexOf(32) > 0) {
                        object = string2.substring(string2.indexOf(32) + 1);
                    }
                } else {
                    Debug.assert(string2 != null && string2.indexOf(32) > 0, "No param info for " + (String)object);
                    parameterMode = string2.substring(0, string2.indexOf(32) - 1).equals("inout") ? ParameterMode.PARAM_INOUT : ParameterMode.PARAM_OUT;
                    object = ((String)object).substring(0, ((String)object).indexOf("Holder"));
                }
                Debug.output(2, "Operation " + this.name() + ", param #" + n + ", paramTypeName " + (String)object + string2);
                typeCode = TypeCodeUtil.getTypeCode(classArray[n], RepositoryImpl.loader, null, (String)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new INTF_REPOS(2620, CompletionStatus.COMPLETED_NO);
            }
            object = IDLType.create(typeCode, this.containing_repository);
            parameterDescriptionArray[n] = new ParameterDescription(string, typeCode, (org.omg.CORBA.IDLType)object, parameterMode);
            ++n;
        }
        return parameterDescriptionArray;
    }

    public OperationMode mode() {
        return this.mode;
    }

    public void mode(OperationMode operationMode) {
        this.mode = operationMode;
    }

    public ParameterDescription[] params() {
        Debug.assert(this.defined, "OperationDeg undefined");
        if (!this.defined) {
            this.define();
        }
        return this.params;
    }

    public void params(ParameterDescription[] parameterDescriptionArray) {
        this.params = parameterDescriptionArray;
    }

    public org.omg.CORBA.TypeCode result() {
        Debug.assert(this.defined, "OperationDeg undefined");
        return this.result;
    }

    public org.omg.CORBA.IDLType result_def() {
        Debug.assert(this.defined, "OperationDef undefined");
        Debug.assert(this.result_def != null, "Result def for op " + this.name() + " null");
        return this.result_def;
    }

    public void result_def(org.omg.CORBA.IDLType iDLType) {
        this.result_def = iDLType;
    }
}

