/*
 * Decompiled with CFR 0.152.
 */
package jacorb.idl;

import jacorb.idl.Declaration;
import jacorb.idl.Definitions;
import jacorb.idl.Environment;
import jacorb.idl.IdlSymbol;
import jacorb.idl.Scope;
import jacorb.idl.ScopeData;
import jacorb.idl.lexer;
import jacorb.idl.parser;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

class Module
extends Declaration
implements Scope {
    public Definitions spec;
    private ScopeData scopeData;
    private String unreplacedName = null;

    public Module(int n) {
        super(n);
        this.pack_name = "";
    }

    String full_name() {
        return this.pack_name;
    }

    public ScopeData getScopeData() {
        return this.scopeData;
    }

    public String originalModuleName() {
        return this.unreplacedName;
    }

    public void parse() {
        this.spec.parse();
    }

    public void print(PrintWriter printWriter) {
        if (parser.generateIR) {
            try {
                String string = String.valueOf(parser.out_dir) + IdlSymbol.fileSeparator + this.pack_name.replace('.', IdlSymbol.fileSeparator);
                File file = new File(string);
                if (!file.exists() && !file.mkdirs()) {
                    System.err.println("Unable to create " + string);
                    System.exit(1);
                }
                PrintWriter printWriter2 = new PrintWriter(new FileWriter(new File(file, "_" + this.name + "Module.java")));
                printWriter2.println("package " + this.pack_name + ";\n");
                printWriter2.println("/** \n * IR module information, generated by the JacORB IDL compiler \n */");
                printWriter2.println("public class _" + this.name + "Module {}");
                printWriter2.close();
            }
            catch (IOException iOException) {
                Environment.output(2, iOException);
            }
        }
        this.spec.print(printWriter);
    }

    public void setEnclosingSymbol(IdlSymbol idlSymbol) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != idlSymbol) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = idlSymbol;
        this.spec.setEnclosingSymbol(this);
    }

    public void setPackage(String string) {
        if (this.unreplacedName == null) {
            this.unreplacedName = string;
        }
        string = parser.pack_replace(string);
        if (this.pack_name.length() > 0) {
            this.pack_name = String.valueOf(string) + "." + this.pack_name;
            this.spec.setPackage(string);
        } else {
            this.pack_name = string;
            if (lexer.needsJavaEscape(this)) {
                this.pack_name = "_" + string;
            }
            this.name = this.pack_name;
            this.spec.setPackage(this.pack_name);
        }
    }

    public void setScopeData(ScopeData scopeData) {
        this.scopeData = scopeData;
    }

    public void set_included(boolean bl) {
        this.included = bl;
        this.spec.set_included(bl);
    }
}

