/*
 * Decompiled with CFR 0.152.
 */
package jacorb.idl;

import jacorb.idl.AliasTypeSpec;
import jacorb.idl.BaseType;
import jacorb.idl.BooleanType;
import jacorb.idl.CharType;
import jacorb.idl.ConstExpr;
import jacorb.idl.ConstrTypeSpec;
import jacorb.idl.ElementSpec;
import jacorb.idl.IdlSymbol;
import jacorb.idl.IntType;
import jacorb.idl.Literal;
import jacorb.idl.ScopedName;
import jacorb.idl.SymbolList;
import jacorb.idl.TypeSpec;
import jacorb.idl.parser;
import java.io.PrintWriter;
import java.util.Enumeration;

class Case
extends IdlSymbol {
    public SymbolList case_label_list = null;
    public ElementSpec element_spec = null;
    String enum_type_name = null;
    TypeSpec type_spec = null;

    public Case(int n) {
        super(n);
    }

    public void parse() {
        this.element_spec.parse();
        Enumeration enumeration = this.case_label_list.v.elements();
        while (enumeration.hasMoreElements()) {
            TypeSpec typeSpec;
            IdlSymbol idlSymbol = (IdlSymbol)enumeration.nextElement();
            if (idlSymbol != null && ((ConstExpr)idlSymbol).or_expr.xor_expr.and_expr.shift_expr.add_expr.mult_expr.unary_expr.primary_expr.symbol instanceof Literal && this.type_spec.typeSpec() instanceof ScopedName) {
                typeSpec = this.type_spec.typeSpec();
                while (typeSpec instanceof ScopedName) {
                    typeSpec = ((ScopedName)this.type_spec.typeSpec()).resolvedTypeSpec();
                    if (!(typeSpec instanceof AliasTypeSpec)) continue;
                    typeSpec = ((AliasTypeSpec)typeSpec).originalType();
                }
                if (!(typeSpec instanceof BooleanType || typeSpec instanceof IntType || typeSpec instanceof CharType || typeSpec instanceof BaseType && ((BaseType)typeSpec).isSwitchType())) {
                    parser.error("Illegal case label for switch type " + this.type_spec.typeName(), this.token);
                    return;
                }
            }
            if (this.enum_type_name == null) {
                if (idlSymbol == null) continue;
                idlSymbol.parse();
                continue;
            }
            if (idlSymbol == null) continue;
            typeSpec = (ScopedName)((ConstExpr)idlSymbol).or_expr.xor_expr.and_expr.shift_expr.add_expr.mult_expr.unary_expr.primary_expr.symbol;
            int n = this.case_label_list.v.indexOf(idlSymbol);
            idlSymbol = new ScopedName(IdlSymbol.new_num());
            ((ScopedName)idlSymbol).setId(typeSpec.typeName);
            idlSymbol.setPackage(this.enum_type_name);
            idlSymbol.parse();
            this.case_label_list.v.setElementAt(idlSymbol, n);
        }
    }

    public void print(PrintWriter printWriter) {
        this.element_spec.print(printWriter);
    }

    public void setEnclosingSymbol(IdlSymbol idlSymbol) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != idlSymbol) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = idlSymbol;
        this.element_spec.setEnclosingSymbol(idlSymbol);
    }

    public void setPackage(String string) {
        string = parser.pack_replace(string);
        this.pack_name = this.pack_name.length() > 0 ? new String(String.valueOf(string) + "." + this.pack_name) : string;
        this.element_spec.setPackage(string);
        Enumeration enumeration = this.case_label_list.v.elements();
        while (enumeration.hasMoreElements()) {
            IdlSymbol idlSymbol = (IdlSymbol)enumeration.nextElement();
            if (idlSymbol == null) continue;
            idlSymbol.setPackage(string);
        }
        if (this.type_spec != null) {
            this.type_spec.setPackage(string);
        }
    }

    public void setTypeSpec(TypeSpec typeSpec) {
        if (typeSpec.type_spec instanceof ConstrTypeSpec) {
            this.enum_type_name = ((ConstrTypeSpec)typeSpec.type_spec).typeName();
        } else if (typeSpec.type_spec instanceof ScopedName) {
            TypeSpec typeSpec2 = ((ScopedName)typeSpec.type_spec).resolvedTypeSpec();
            while (typeSpec2 instanceof ScopedName || typeSpec2 instanceof AliasTypeSpec) {
                if (typeSpec2 instanceof ScopedName) {
                    typeSpec2 = ((ScopedName)typeSpec2).resolvedTypeSpec();
                }
                if (!(typeSpec2 instanceof AliasTypeSpec)) continue;
                typeSpec2 = ((AliasTypeSpec)typeSpec2).originalType();
            }
            if (typeSpec2 instanceof ConstrTypeSpec) {
                this.enum_type_name = ((ConstrTypeSpec)typeSpec2).c_type_spec.full_name();
            }
        }
        this.type_spec = typeSpec;
        this.type_spec.setPackage(this.pack_name);
    }
}

