/*
 * Decompiled with CFR 0.152.
 */
package jacorb.trading.db.simple.types;

import jacorb.trading.db.simple.types.Incarnation;
import jacorb.trading.db.simple.types.TypeProperty;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.IncarnationNumber;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropStruct;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.TypeStruct;

public class Type
implements Serializable {
    private String m_name;
    private String m_interfaceName;
    private Vector m_properties;
    private String[] m_superTypes;
    private Incarnation m_incarnation;
    private boolean m_masked;
    private transient TypeStruct m_description;
    static final long serialVersionUID = -4144073280876434847L;

    public Type() {
    }

    public Type(String string, String string2, PropStruct[] propStructArray, String[] stringArray, IncarnationNumber incarnationNumber) {
        this.m_name = string;
        this.m_interfaceName = string2;
        this.m_incarnation = new Incarnation(incarnationNumber);
        this.m_masked = false;
        this.m_superTypes = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            this.m_superTypes[n] = stringArray[n];
            ++n;
        }
        this.m_properties = new Vector();
        int n2 = 0;
        while (n2 < propStructArray.length) {
            TypeProperty typeProperty = new TypeProperty(propStructArray[n2]);
            this.m_properties.addElement(typeProperty);
            ++n2;
        }
        this.createDescription();
    }

    private void createDescription() {
        this.m_description = new TypeStruct();
        this.m_description.if_name = this.m_interfaceName;
        this.m_description.masked = this.m_masked;
        this.m_description.incarnation = this.m_incarnation.getIncarnationNumber();
        this.m_description.props = new PropStruct[this.m_properties.size()];
        int n = 0;
        Enumeration enumeration = this.m_properties.elements();
        while (enumeration.hasMoreElements()) {
            TypeProperty typeProperty = (TypeProperty)enumeration.nextElement();
            this.m_description.props[n] = typeProperty.describe();
            ++n;
        }
        this.m_description.super_types = new String[this.m_superTypes.length];
        int n2 = 0;
        while (n2 < this.m_superTypes.length) {
            this.m_description.super_types[n2] = this.m_superTypes[n2];
            ++n2;
        }
    }

    public TypeStruct describe() {
        return this.m_description;
    }

    public boolean equals(Object object) {
        Type type = (Type)object;
        return this.m_name.equals(type.getName());
    }

    public Incarnation getIncarnation() {
        return this.m_incarnation;
    }

    public String getInterfaceName() {
        return this.m_interfaceName;
    }

    public boolean getMasked() {
        return this.m_masked;
    }

    public String getName() {
        return this.m_name;
    }

    public PropStruct getPropertyInfo(String string) {
        PropStruct propStruct = null;
        int n = 0;
        while (n < this.m_description.props.length && propStruct == null) {
            if (string.equals(this.m_description.props[n].name)) {
                propStruct = this.m_description.props[n];
            }
            ++n;
        }
        return propStruct;
    }

    public String[] getSuperTypes() {
        return this.m_description.super_types;
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    public void mask() {
        this.m_masked = true;
        this.m_description.masked = true;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.createDescription();
    }

    public void unmask() {
        this.m_masked = false;
        this.m_description.masked = false;
    }
}

