/*
 * Decompiled with CFR 0.152.
 */
package jacorb.orb;

import jacorb.orb.BufferManager;
import jacorb.orb.CDRInputStream;
import jacorb.orb.Connection;
import jacorb.orb.Delegate;
import jacorb.orb.EncapsInfo;
import jacorb.orb.LocalityConstrainedObject;
import jacorb.orb.ORB;
import jacorb.orb.TypeCode;
import jacorb.util.Debug;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Stack;
import org.omg.CORBA.Any;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.TaggedProfile;

public class CDROutputStream
extends org.omg.CORBA.portable.OutputStream {
    private static final byte[] giopMessageHeader;
    private int index = 0;
    private int pos = 0;
    public byte[] buffer;
    private int BUF_SIZE;
    private int NET_BUF_SIZE = 1024;
    private static final int MEM_BUF_SIZE = 64;
    private boolean closed = false;
    private boolean released = false;
    private BufferManager bufMgr;
    private int resize_factor = 1;
    private int encaps_start = -1;
    private Stack encaps_stack = new Stack();
    private Stack recursiveTCStack = new Stack();
    private static final String null_ior_str = "IOR:00000000000000010000000000000000";
    private static final IOR null_ior;
    private ORB orb;
    protected Connection connection;
    protected CDROutputStream header_stream = null;

    static {
        byte[] byArray = new byte[7];
        byArray[0] = 71;
        byArray[1] = 73;
        byArray[2] = 79;
        byArray[3] = 80;
        byArray[4] = 1;
        giopMessageHeader = byArray;
        null_ior = new IOR("", new TaggedProfile[0]);
    }

    public CDROutputStream() {
        this.bufMgr = null;
        this.connection = null;
        this.buffer = new byte[64];
    }

    public CDROutputStream(Connection connection) {
        this.connection = connection;
        this.orb = connection.getORB();
        this.bufMgr = connection.getBufferManager();
        this.buffer = this.bufMgr.getBuffer(this.NET_BUF_SIZE);
    }

    public CDROutputStream(Connection connection, byte[] byArray) {
        this.connection = connection;
        this.orb = connection.getORB();
        this.bufMgr = connection.getBufferManager();
        this.buffer = byArray;
    }

    public CDROutputStream(org.omg.CORBA.ORB oRB) {
        this.orb = (ORB)oRB;
        this.bufMgr = ((ORB)oRB).getBufferManager();
        this.connection = null;
        this.buffer = this.bufMgr.getBuffer(64);
    }

    private static final void _write4int(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n + 1] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n + 2] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n + 3] = (byte)(n2 & 0xFF);
    }

    public final void beginEncapsulation() {
        this.check(8, 4);
        this.pos += 4;
        this.index += 4;
        this.encaps_stack.push(new EncapsInfo(this.index, this.encaps_start));
        this.encaps_start = this.pos;
        this.resetIndex();
        this.buffer[this.pos++] = 0;
        ++this.index;
    }

    private final void check(int n) {
        if (this.pos + n + 2 > this.buffer.length) {
            byte[] byArray;
            if (this.bufMgr == null) {
                int n2 = this.buffer.length;
                while (this.pos + n + 2 > n2) {
                    n2 <<= 1;
                }
                byArray = new byte[n2];
                System.arraycopy(this.buffer, 0, byArray, 0, this.pos);
            } else {
                byArray = this.bufMgr.getBuffer(this.pos + n + 2);
                System.arraycopy(this.buffer, 0, byArray, 0, this.pos);
                this.bufMgr.returnBuffer(this.buffer);
            }
            this.buffer = byArray;
        }
    }

    private final void check(int n, int n2) {
        this.check(n);
        int n3 = n2 - this.index % n2;
        if (n3 != n2) {
            this.index += n3;
            this.pos += n3;
        }
    }

    public void close() {
        if (this.closed) {
            throw new Error("Stream already closed!");
        }
        if (this.header_stream != null) {
            this.header_stream.close();
        } else {
            this.insertMsgSize();
        }
        this.closed = true;
    }

    protected int codeSet(boolean bl) {
        if (this.connection == null) {
            if (bl) {
                throw new RuntimeException("Wide codeset can't be used without associated connection");
            }
            return 65537;
        }
        return bl ? this.connection.TCSW : this.connection.TCS;
    }

    public InputStream create_input_stream() {
        byte[] byArray = (byte[])this.buffer.clone();
        return new CDRInputStream(this.orb, byArray);
    }

    public final void endEncapsulation() throws IOException {
        if (this.encaps_start == -1) {
            throw new IOException("too many end-of-encapsulations");
        }
        int n = this.pos - this.encaps_start;
        this.buffer[this.encaps_start - 4] = (byte)(n >>> 24 & 0xFF);
        this.buffer[this.encaps_start - 3] = (byte)(n >>> 16 & 0xFF);
        this.buffer[this.encaps_start - 2] = (byte)(n >>> 8 & 0xFF);
        this.buffer[this.encaps_start - 1] = (byte)(n & 0xFF);
        EncapsInfo encapsInfo = (EncapsInfo)this.encaps_stack.pop();
        this.encaps_start = encapsInfo.start;
        this.index = encapsInfo.index + n;
    }

    public byte[] getBufferCopy() {
        byte[] byArray = null;
        if (this.header_stream != null) {
            byArray = new byte[this.pos + this.header_stream.pos];
            System.arraycopy(this.header_stream.buffer, 0, byArray, 0, this.header_stream.pos);
            System.arraycopy(this.buffer, 0, byArray, this.header_stream.pos, this.pos);
        } else {
            byArray = new byte[this.pos];
            System.arraycopy(this.buffer, 0, byArray, 0, byArray.length);
        }
        Debug.output(10, "getBufferCopy", byArray, byArray.length);
        return byArray;
    }

    public CDROutputStream getHeaderStream() {
        return this.header_stream;
    }

    public byte[] getInternalBuffer() {
        return this.buffer;
    }

    public void insertMsgSize() {
        this.insertMsgSize(this.pos - 12);
    }

    public void insertMsgSize(int n) {
        this.buffer[8] = (byte)(n >>> 24 & 0xFF);
        this.buffer[9] = (byte)(n >>> 16 & 0xFF);
        this.buffer[10] = (byte)(n >>> 8 & 0xFF);
        this.buffer[11] = (byte)(n & 0xFF);
    }

    public void release() {
        if (this.released) {
            throw new Error("Stream already released!");
        }
        if (this.bufMgr != null) {
            this.bufMgr.returnBuffer(this.buffer);
            if (this.header_stream != null) {
                this.header_stream.release();
            }
        }
        this.released = true;
    }

    public void reset() {
        this.pos = 0;
        this.index = 0;
    }

    public void resetIndex() {
        this.index = 0;
    }

    public boolean separateHeader() {
        return this.header_stream != null;
    }

    public void setBuffer(byte[] byArray) {
        if (this.bufMgr != null) {
            this.bufMgr.returnBuffer(this.buffer);
        }
        if (this.header_stream != null && !this.header_stream.released) {
            this.header_stream.release();
            this.header_stream = null;
        }
        this.buffer = byArray;
        this.pos = this.buffer.length;
    }

    public void setGIOPRequestId(int n) {
        if ((this.buffer[6] & 1) == 0) {
            this.buffer[16] = (byte)(n >> 24 & 0xFF);
            this.buffer[17] = (byte)(n >> 16 & 0xFF);
            this.buffer[18] = (byte)(n >> 8 & 0xFF);
            this.buffer[19] = (byte)(n & 0xFF);
        } else {
            this.buffer[16] = (byte)(n & 0xFF);
            this.buffer[17] = (byte)(n >> 8 & 0xFF);
            this.buffer[18] = (byte)(n >> 16 & 0xFF);
            this.buffer[19] = (byte)(n >> 24 & 0xFF);
        }
    }

    public void setSize(int n) {
        this.pos = n;
    }

    public int size() {
        return this.pos;
    }

    public void writeGIOPMsgHeader(byte by) {
        System.arraycopy(giopMessageHeader, 0, this.buffer, 0, giopMessageHeader.length);
        this.buffer[7] = by;
        this.index = 12;
        this.pos = 12;
    }

    public void write_IOR(IOR iOR) {
        if (iOR == null) {
            IORHelper.write(this, null_ior);
        } else {
            IORHelper.write(this, iOR);
        }
    }

    public void write_Object(Object object) {
        if (object == null) {
            IORHelper.write(this, null_ior);
        } else {
            if (object instanceof LocalityConstrainedObject) {
                throw new MARSHAL("Attempt to serialize a locality-constrained object.");
            }
            ObjectImpl objectImpl = (ObjectImpl)object;
            IORHelper.write(this, ((Delegate)objectImpl._get_delegate()).getIOR());
        }
    }

    public final void write_Principal(Principal principal) {
        this.write_octet_array(principal.name(), 0, principal.name().length);
    }

    public final void write_TypeCode(org.omg.CORBA.TypeCode typeCode) {
        Hashtable hashtable = new Hashtable();
        this.write_TypeCode(typeCode, hashtable);
        hashtable.clear();
    }

    private final void write_TypeCode(org.omg.CORBA.TypeCode typeCode, Hashtable hashtable) {
        int n = this.pos;
        int n2 = ((TypeCode)typeCode)._kind();
        Debug.output(4, "Write Type code of kind " + n2);
        try {
            if (((TypeCode)typeCode).is_recursive() && hashtable.containsKey(typeCode.id())) {
                Debug.output(4, "Write recursive Type code for id " + typeCode.id() + " pos " + ((Integer)hashtable.get(typeCode.id()) - this.pos));
                this.write_long(-1);
                this.write_long((Integer)hashtable.get(typeCode.id()) - this.pos);
                return;
            }
            this.write_long(n2);
            switch (n2) {
                case 14: {
                    this.beginEncapsulation();
                    this.write_string(typeCode.id());
                    this.write_string(typeCode.name());
                    this.endEncapsulation();
                    break;
                }
                case 15: 
                case 22: {
                    hashtable.put(typeCode.id(), new Integer(n));
                    this.beginEncapsulation();
                    this.write_string(typeCode.id());
                    this.write_string(typeCode.name());
                    int n3 = typeCode.member_count();
                    this.write_long(n3);
                    int n4 = 0;
                    while (n4 < n3) {
                        Debug.output(3, "struct member name " + typeCode.member_name(n4));
                        this.write_string(typeCode.member_name(n4));
                        this.write_TypeCode(typeCode.member_type(n4), hashtable);
                        ++n4;
                    }
                    this.endEncapsulation();
                    break;
                }
                case 17: {
                    this.beginEncapsulation();
                    this.write_string(typeCode.id());
                    this.write_string(typeCode.name());
                    int n5 = typeCode.member_count();
                    this.write_long(n5);
                    int n6 = 0;
                    while (n6 < n5) {
                        this.write_string(typeCode.member_name(n6));
                        ++n6;
                    }
                    this.endEncapsulation();
                    break;
                }
                case 16: {
                    hashtable.put(typeCode.id(), new Integer(n));
                    this.beginEncapsulation();
                    this.write_string(typeCode.id());
                    this.write_string(typeCode.name());
                    this.write_TypeCode(typeCode.discriminator_type());
                    this.write_long(typeCode.default_index());
                    int n7 = typeCode.member_count();
                    this.write_long(n7);
                    int n8 = 0;
                    while (n8 < n7) {
                        if (n8 == typeCode.default_index()) {
                            this.write_octet((byte)0);
                        } else {
                            typeCode.member_label(n8).write_value(this);
                        }
                        this.write_string(typeCode.member_name(n8));
                        this.write_TypeCode(typeCode.member_type(n8), hashtable);
                        ++n8;
                    }
                    this.endEncapsulation();
                    break;
                }
                case 18: {
                    this.write_long(typeCode.length());
                    break;
                }
                case 28: {
                    this.write_ushort(typeCode.fixed_digits());
                    this.write_short(typeCode.fixed_scale());
                    break;
                }
                case 19: 
                case 20: {
                    this.beginEncapsulation();
                    this.write_TypeCode(typeCode.content_type(), hashtable);
                    this.write_long(typeCode.length());
                    this.endEncapsulation();
                    break;
                }
                case 21: {
                    this.beginEncapsulation();
                    this.write_string(typeCode.id());
                    this.write_string(typeCode.name());
                    this.write_TypeCode(typeCode.content_type(), hashtable);
                    this.endEncapsulation();
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (BadKind badKind) {
            throw new RuntimeException("org.omg.CORBA.TypeCodePackage.BadKind");
        }
        catch (Bounds bounds) {
            throw new RuntimeException("org.omg.CORBA.TypeCodePackage.Bounds");
        }
        catch (IOException iOException) {}
    }

    public final void write_any(Any any) {
        this.write_TypeCode(any.type());
        any.write_value(this);
    }

    public final void write_boolean(boolean bl) {
        this.check(1);
        this.buffer[this.pos++] = bl ? (byte)1 : 0;
        ++this.index;
    }

    public final void write_boolean_array(boolean[] blArray, int n, int n2) {
        if (blArray != null) {
            this.check(n2);
            int n3 = n;
            while (n3 < n + n2) {
                this.buffer[this.pos++] = blArray[n3] ? (byte)1 : 0;
                ++n3;
            }
            this.index += n2;
        }
    }

    public final void write_char(char c) {
        this.check(3);
        this.write_char(c, this.codeSet(false));
    }

    private final void write_char(char c, int n) {
        switch (n) {
            case 0: 
            case 65537: {
                short s = (short)c;
                if (s > 255 || s < 0) {
                    throw new MARSHAL("char (" + s + ") out of range for ISO8859_1");
                }
                ++this.index;
                this.buffer[this.pos++] = (byte)c;
                break;
            }
            case 0x5010001: {
                if (c <= '\u007f') {
                    this.buffer[this.pos++] = (byte)c;
                    ++this.index;
                    break;
                }
                if (c > '\u07ff') {
                    this.buffer[this.pos++] = (byte)(0xE0 | c >> 12 & 0xF);
                    this.buffer[this.pos++] = (byte)(0x80 | c >> 6 & 0x3F);
                    this.buffer[this.pos++] = (byte)(0x80 | c & 0x3F);
                    this.index += 3;
                    break;
                }
                this.buffer[this.pos++] = (byte)(0xC0 | c >> 6 & 0x1F);
                this.buffer[this.pos++] = (byte)(0x80 | c & 0x3F);
                this.index += 2;
                break;
            }
            case 65801: {
                this.buffer[this.pos++] = (byte)(c >>> 8 & 0xFF);
                this.buffer[this.pos++] = (byte)(c & 0xFF);
                this.index += 2;
                break;
            }
            default: {
                throw new Error("Bad codeset");
            }
        }
    }

    public final void write_char_array(char[] cArray, int n, int n2) {
        if (cArray == null) {
            throw new MARSHAL("Null References");
        }
        this.check(n2 * 3);
        int n3 = n;
        while (n3 < n + n2) {
            this.write_char(cArray[n3], this.codeSet(false));
            ++n3;
        }
    }

    public final void write_double(double d) {
        this.write_longlong(Double.doubleToLongBits(d));
    }

    public final void write_double_array(double[] dArray, int n, int n2) {
        this.check(7 + n2 * 8, 8);
        if (dArray != null) {
            int n3 = n;
            while (n3 < n + n2) {
                long l = Double.doubleToLongBits(dArray[n3]);
                this.buffer[this.pos] = (byte)(l >>> 56 & 0xFFL);
                this.buffer[this.pos + 1] = (byte)(l >>> 48 & 0xFFL);
                this.buffer[this.pos + 2] = (byte)(l >>> 40 & 0xFFL);
                this.buffer[this.pos + 3] = (byte)(l >>> 32 & 0xFFL);
                this.buffer[this.pos + 4] = (byte)(l >>> 24 & 0xFFL);
                this.buffer[this.pos + 5] = (byte)(l >>> 16 & 0xFFL);
                this.buffer[this.pos + 6] = (byte)(l >>> 8 & 0xFFL);
                this.buffer[this.pos + 7] = (byte)(l & 0xFFL);
                this.pos += 8;
                ++n3;
            }
            this.index += 8 * n2;
        }
    }

    public final void write_fixed(BigDecimal bigDecimal) {
        int n;
        byte[] byArray;
        String string = bigDecimal.movePointRight(bigDecimal.scale()).toString();
        if (string.length() % 2 == 0) {
            byArray = new byte[string.length() / 2 + 1];
            byArray[0] = 0;
            int n2 = 0;
            while (n2 < string.length()) {
                int n3 = Character.digit(string.charAt(n2), 10);
                n = byArray[(1 + n2) / 2] << 4;
                byArray[(1 + n2) / 2] = (byte)(n |= n3);
                ++n2;
            }
        } else {
            byArray = new byte[(string.length() + 1) / 2];
            int n4 = 0;
            while (n4 < string.length()) {
                int n5 = Character.digit(string.charAt(n4), 10);
                n = byArray[n4 / 2] << 4;
                byArray[n4 / 2] = (byte)(n |= n5);
                ++n4;
            }
        }
        n = byArray[byArray.length - 1] << 4;
        byArray[byArray.length - 1] = (byte)(bigDecimal.signum() < 0 ? n | 0xD : n | 0xC);
        this.check(byArray.length);
        System.arraycopy(byArray, 0, this.buffer, this.pos, byArray.length);
        this.index += byArray.length;
        this.pos += byArray.length;
    }

    public final void write_float(float f) {
        this.write_long(Float.floatToIntBits(f));
    }

    public final void write_float_array(float[] fArray, int n, int n2) {
        this.check(3 + n2 * 4, 4);
        if (fArray != null) {
            int n3 = n;
            while (n3 < n + n2) {
                CDROutputStream._write4int(this.buffer, this.pos, Float.floatToIntBits(fArray[n3]));
                this.pos += 4;
                ++n3;
            }
            this.index += 4 * n2;
        }
    }

    public final void write_long(int n) {
        this.check(7, 4);
        CDROutputStream._write4int(this.buffer, this.pos, n);
        this.pos += 4;
        this.index += 4;
    }

    public final void write_long_array(int[] nArray, int n, int n2) {
        this.check(3 + n2 * 4, 4);
        int n3 = 4 - this.index % 4;
        if (n3 != 4) {
            this.index += n3;
            this.pos += n3;
        }
        if (nArray != null) {
            int n4 = n;
            while (n4 < n + n2) {
                CDROutputStream._write4int(this.buffer, this.pos, nArray[n4]);
                this.pos += 4;
                ++n4;
            }
            this.index += 4 * n2;
        }
    }

    public final void write_longlong(long l) {
        this.check(15, 8);
        this.buffer[this.pos] = (byte)(l >>> 56 & 0xFFL);
        this.buffer[this.pos + 1] = (byte)(l >>> 48 & 0xFFL);
        this.buffer[this.pos + 2] = (byte)(l >>> 40 & 0xFFL);
        this.buffer[this.pos + 3] = (byte)(l >>> 32 & 0xFFL);
        this.buffer[this.pos + 4] = (byte)(l >>> 24 & 0xFFL);
        this.buffer[this.pos + 5] = (byte)(l >>> 16 & 0xFFL);
        this.buffer[this.pos + 6] = (byte)(l >>> 8 & 0xFFL);
        this.buffer[this.pos + 7] = (byte)(l & 0xFFL);
        this.index += 8;
        this.pos += 8;
    }

    public final void write_longlong_array(long[] lArray, int n, int n2) {
        this.check(7 + n2 * 8, 8);
        if (lArray != null) {
            int n3 = n;
            while (n3 < n + n2) {
                this.buffer[this.pos] = (byte)(lArray[n3] >>> 56 & 0xFFL);
                this.buffer[this.pos + 1] = (byte)(lArray[n3] >>> 48 & 0xFFL);
                this.buffer[this.pos + 2] = (byte)(lArray[n3] >>> 40 & 0xFFL);
                this.buffer[this.pos + 3] = (byte)(lArray[n3] >>> 32 & 0xFFL);
                this.buffer[this.pos + 4] = (byte)(lArray[n3] >>> 24 & 0xFFL);
                this.buffer[this.pos + 5] = (byte)(lArray[n3] >>> 16 & 0xFFL);
                this.buffer[this.pos + 6] = (byte)(lArray[n3] >>> 8 & 0xFFL);
                this.buffer[this.pos + 7] = (byte)(lArray[n3] & 0xFFL);
                this.pos += 8;
                ++n3;
            }
            this.index += 8 * n2;
        }
    }

    public final void write_octet(byte by) {
        this.check(1);
        ++this.index;
        this.buffer[this.pos++] = by;
    }

    public final void write_octet_array(byte[] byArray, int n, int n2) {
        if (byArray != null) {
            this.check(n2);
            System.arraycopy(byArray, n, this.buffer, this.pos, n2);
            this.index += n2;
            this.pos += n2;
        }
    }

    public final void write_short(short s) {
        this.check(3, 2);
        this.buffer[this.pos] = (byte)(s >>> 8 & 0xFF);
        this.buffer[this.pos + 1] = (byte)(s & 0xFF);
        this.index += 2;
        this.pos += 2;
    }

    public final void write_short_array(short[] sArray, int n, int n2) {
        this.check(2 * n2 + 3);
        int n3 = 2 - this.index % 2;
        if (n3 != 2) {
            this.index += n3;
            this.pos += n3;
        }
        if (sArray != null) {
            int n4 = n;
            while (n4 < n + n2) {
                this.buffer[this.pos] = (byte)(sArray[n4] >>> 8 & 0xFF);
                this.buffer[this.pos + 1] = (byte)(sArray[n4] & 0xFF);
                this.pos += 2;
                ++n4;
            }
            this.index += 2 * n2;
        }
    }

    public final void write_string(String string) {
        if (string == null) {
            throw new MARSHAL("Null References");
        }
        this.check(7 + string.length() * 3, 4);
        int n = string.length();
        int n2 = this.pos;
        this.pos += 4;
        this.index += 4;
        int n3 = this.codeSet(false);
        int n4 = 0;
        while (n4 < n) {
            this.write_char(string.charAt(n4), n3);
            ++n4;
        }
        this.write_char('\u0000', n3);
        CDROutputStream._write4int(this.buffer, n2, this.pos - n2 - 4);
    }

    public void write_to(OutputStream outputStream) throws IOException {
        if (this.header_stream != null) {
            this.header_stream.insertMsgSize(this.header_stream.size() + this.size() - 12);
            outputStream.write(this.header_stream.buffer, 0, this.header_stream.pos);
        }
        outputStream.write(this.buffer, 0, this.pos);
        outputStream.flush();
    }

    public final void write_ulong(int n) {
        this.write_long(n);
    }

    public final void write_ulong_array(int[] nArray, int n, int n2) {
        this.write_long_array(nArray, n, n2);
    }

    public final void write_ulonglong(long l) {
        this.write_longlong(l);
    }

    public final void write_ulonglong_array(long[] lArray, int n, int n2) {
        this.write_longlong_array(lArray, n, n2);
    }

    public final void write_ushort(short s) {
        this.write_short(s);
    }

    public final void write_ushort_array(short[] sArray, int n, int n2) {
        this.write_short_array(sArray, n, n2);
    }

    public final void write_value(org.omg.CORBA.TypeCode typeCode, CDRInputStream cDRInputStream) {
        int n = ((TypeCode)typeCode)._kind();
        Debug.output(3, "CDROutput.write_value kind " + n);
        switch (n) {
            case 8: {
                this.write_boolean(cDRInputStream.read_boolean());
                break;
            }
            case 9: {
                this.write_char(cDRInputStream.read_char());
                break;
            }
            case 10: {
                this.write_octet(cDRInputStream.read_octet());
                break;
            }
            case 2: {
                this.write_ushort(cDRInputStream.read_ushort());
                break;
            }
            case 4: {
                this.write_short(cDRInputStream.read_short());
                break;
            }
            case 3: {
                this.write_long(cDRInputStream.read_long());
                break;
            }
            case 5: {
                this.write_ulong(cDRInputStream.read_ulong());
                break;
            }
            case 6: {
                this.write_float(cDRInputStream.read_float());
                break;
            }
            case 7: {
                this.write_double(cDRInputStream.read_double());
                break;
            }
            case 23: {
                this.write_longlong(cDRInputStream.read_longlong());
                break;
            }
            case 24: {
                this.write_ulonglong(cDRInputStream.read_ulonglong());
                break;
            }
            case 11: {
                this.write_any(cDRInputStream.read_any());
                break;
            }
            case 12: {
                this.write_TypeCode(cDRInputStream.read_TypeCode());
                break;
            }
            case 13: {
                this.write_Principal(cDRInputStream.read_Principal());
                break;
            }
            case 14: {
                this.write_Object(cDRInputStream.read_Object());
                break;
            }
            case 18: {
                this.write_string(cDRInputStream.read_string());
                break;
            }
            case 20: {
                try {
                    int n2 = typeCode.length();
                    int n3 = 0;
                    while (n3 < n2) {
                        this.write_value(typeCode.content_type(), cDRInputStream);
                        ++n3;
                    }
                }
                catch (BadKind badKind) {}
                break;
            }
            case 19: {
                try {
                    int n4 = cDRInputStream.read_long();
                    this.write_long(n4);
                    int n5 = 0;
                    while (n5 < n4) {
                        this.write_value(typeCode.content_type(), cDRInputStream);
                        ++n5;
                    }
                }
                catch (BadKind badKind) {}
                break;
            }
            case 22: {
                this.write_string(cDRInputStream.read_string());
            }
            case 15: {
                try {
                    int n6 = 0;
                    while (n6 < typeCode.member_count()) {
                        this.write_value(typeCode.member_type(n6), cDRInputStream);
                        ++n6;
                    }
                }
                catch (BadKind badKind) {
                }
                catch (Bounds bounds) {}
                break;
            }
            case 17: {
                this.write_long(cDRInputStream.read_long());
                break;
            }
            case 16: {
                try {
                    TypeCode typeCode2 = (TypeCode)typeCode.discriminator_type();
                    int n7 = typeCode.default_index();
                    int n8 = -1;
                    block32 : switch (typeCode2._kind()) {
                        case 2: {
                            short s = cDRInputStream.read_short();
                            this.write_short(s);
                            int n9 = 0;
                            while (n9 < typeCode.member_count()) {
                                if (n9 != n7 && s == typeCode.member_label(n9).extract_short()) {
                                    n8 = n9;
                                    break block32;
                                }
                                ++n9;
                            }
                            break;
                        }
                        case 4: {
                            short s = cDRInputStream.read_ushort();
                            this.write_ushort(s);
                            int n10 = 0;
                            while (n10 < typeCode.member_count()) {
                                if (n10 != n7 && s == typeCode.member_label(n10).extract_ushort()) {
                                    n8 = n10;
                                    break block32;
                                }
                                ++n10;
                            }
                            break;
                        }
                        case 3: {
                            int n11 = cDRInputStream.read_long();
                            this.write_long(n11);
                            int n12 = 0;
                            while (n12 < typeCode.member_count()) {
                                if (n12 != n7 && n11 == typeCode.member_label(n12).extract_long()) {
                                    n8 = n12;
                                    break block32;
                                }
                                ++n12;
                            }
                            break;
                        }
                        case 5: {
                            int n13 = cDRInputStream.read_ulong();
                            this.write_ulong(n13);
                            int n14 = 0;
                            while (n14 < typeCode.member_count()) {
                                if (n14 != n7 && n13 == typeCode.member_label(n14).extract_ulong()) {
                                    n8 = n14;
                                    break block32;
                                }
                                ++n14;
                            }
                            break;
                        }
                        case 23: {
                            long l = cDRInputStream.read_longlong();
                            this.write_longlong(l);
                            int n15 = 0;
                            while (n15 < typeCode.member_count()) {
                                if (n15 != n7 && l == typeCode.member_label(n15).extract_longlong()) {
                                    n8 = n15;
                                    break block32;
                                }
                                ++n15;
                            }
                            break;
                        }
                        case 24: {
                            long l = cDRInputStream.read_ulonglong();
                            this.write_ulonglong(l);
                            int n16 = 0;
                            while (n16 < typeCode.member_count()) {
                                if (n16 != n7 && l == typeCode.member_label(n16).extract_ulonglong()) {
                                    n8 = n16;
                                    break block32;
                                }
                                ++n16;
                            }
                            break;
                        }
                        case 8: {
                            boolean bl = cDRInputStream.read_boolean();
                            this.write_boolean(bl);
                            int n17 = 0;
                            while (n17 < typeCode.member_count()) {
                                if (n17 != n7 && bl == typeCode.member_label(n17).extract_boolean()) {
                                    n8 = n17;
                                    break block32;
                                }
                                ++n17;
                            }
                            break;
                        }
                        case 17: {
                            int n18 = cDRInputStream.read_long();
                            this.write_long(n18);
                            int n19 = 0;
                            while (n19 < typeCode.member_count()) {
                                if (n19 != n7) {
                                    int n20 = typeCode.member_label(n19).create_input_stream().read_long();
                                    Debug.output(10, "label: " + n20 + " switch: " + n18);
                                    if (n18 == typeCode.member_label(n19).create_input_stream().read_long()) {
                                        n8 = n19;
                                        break block32;
                                    }
                                }
                                ++n19;
                            }
                            break;
                        }
                        case 9: {
                            char c = cDRInputStream.read_char();
                            this.write_char(c);
                            int n21 = 0;
                            while (n21 < typeCode.member_count()) {
                                if (n21 != n7 && c == typeCode.member_label(n21).extract_char()) {
                                    n8 = n21;
                                    break block32;
                                }
                                ++n21;
                            }
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unfinished implementation for unions in anys, sorry.");
                        }
                    }
                    if (n8 != -1) {
                        this.write_value(typeCode.member_type(n8), cDRInputStream);
                        break;
                    }
                    this.write_value(typeCode.member_type(n7), cDRInputStream);
                }
                catch (BadKind badKind) {
                }
                catch (Bounds bounds) {}
                break;
            }
            case 21: {
                try {
                    this.write_value(typeCode.content_type(), cDRInputStream);
                }
                catch (BadKind badKind) {}
                break;
            }
            case -1: {
                throw new RuntimeException("Cannot handle recursive TypeCode here!");
            }
            default: {
                throw new RuntimeException("Cannot handle TypeCode with kind " + n);
            }
            case 0: 
            case 1: 
        }
    }

    public final void write_wchar(char c) {
        this.check(3);
        this.write_char(c, this.codeSet(true));
    }

    public final void write_wchar_array(char[] cArray, int n, int n2) {
        if (cArray == null) {
            throw new MARSHAL("Null References");
        }
        this.check(n2 * 3);
        int n3 = n;
        while (n3 < n + n2) {
            this.write_char(cArray[n3], this.codeSet(true));
            ++n3;
        }
    }

    public final void write_wstring(String string) {
        if (string == null) {
            throw new MARSHAL("Null References");
        }
        this.check(7 + string.length() * 3, 4);
        int n = string.length();
        int n2 = this.pos;
        this.pos += 4;
        this.index += 4;
        int n3 = this.codeSet(true);
        int n4 = 0;
        while (n4 < n) {
            this.write_char(string.charAt(n4), n3);
            ++n4;
        }
        this.write_char('\u0000', n3);
        boolean bl = this.connection != null && this.connection.IIOPVersion.minor < 2 && n3 == 65801;
        CDROutputStream._write4int(this.buffer, n2, this.pos - n2 - 4 >> (bl ? 1 : 0));
    }
}

