/*
 * Decompiled with CFR 0.152.
 */
package jacorb.orb;

import jacorb.orb.CDRInputStream;
import jacorb.orb.CDROutputStream;
import jacorb.orb.ORB;
import jacorb.orb.TypeCode;
import jacorb.util.Debug;
import java.io.Serializable;
import java.math.BigDecimal;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.FixedHolder;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.Streamable;

public final class Any
extends org.omg.CORBA.Any {
    private org.omg.CORBA.TypeCode typeCode;
    private java.lang.Object value;
    private org.omg.CORBA.ORB orb;

    Any(org.omg.CORBA.ORB oRB) {
        this.orb = oRB;
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_null);
    }

    public int _get_TCKind() {
        return 11;
    }

    public InputStream create_input_stream() {
        if (this.value instanceof CDROutputStream) {
            return new CDRInputStream(this.orb, ((CDROutputStream)this.value).getBufferCopy());
        }
        CDROutputStream cDROutputStream = !(this.orb instanceof ORB) ? new CDROutputStream() : new CDROutputStream(this.orb);
        this.write_value(cDROutputStream);
        return new CDRInputStream(this.orb, cDROutputStream.getBufferCopy());
    }

    public OutputStream create_output_stream() {
        this.value = !(this.orb instanceof ORB) ? new CDROutputStream() : new CDROutputStream(this.orb);
        return (CDROutputStream)this.value;
    }

    public boolean equal(org.omg.CORBA.Any any) {
        if (!this.typeCode.equal(any.type())) {
            return false;
        }
        return ((Any)any).value().equals(this.value());
    }

    public boolean equals(java.lang.Object object) {
        if (object instanceof org.omg.CORBA.Any) {
            return this.equal((org.omg.CORBA.Any)object);
        }
        return false;
    }

    public Object extract_Object() {
        if (this.typeCode.kind().value() != 14) {
            this.tc_error("Cannot extract object!");
        }
        return (Object)this.value;
    }

    public Principal extract_Principal() {
        if (!this.typeCode.kind().equals(TCKind.tk_Principal)) {
            this.tc_error();
        }
        return (Principal)this.value;
    }

    public Streamable extract_Streamable() throws BAD_INV_ORDER {
        try {
            return (Streamable)this.value;
        }
        catch (ClassCastException classCastException) {
            throw new BAD_INV_ORDER();
        }
    }

    public org.omg.CORBA.TypeCode extract_TypeCode() {
        if (this.typeCode.kind().value() != 12) {
            this.tc_error("Cannot extract TypeCode!");
        }
        return (TypeCode)this.value;
    }

    public Serializable extract_Value() throws BAD_OPERATION {
        return null;
    }

    public org.omg.CORBA.Any extract_any() {
        if (this.typeCode.kind().value() != 11) {
            this.tc_error("Cannot extract any!");
        }
        return (org.omg.CORBA.Any)this.value;
    }

    public boolean extract_boolean() {
        if (this.typeCode.kind().value() != 8) {
            this.tc_error("Cannot extract boolean!");
        }
        return (Boolean)this.value;
    }

    public char extract_char() {
        if (this.typeCode.kind().value() != 9) {
            this.tc_error("Cannot extract char!");
        }
        return ((Character)this.value).charValue();
    }

    public double extract_double() {
        if (this.typeCode.kind().value() != 7) {
            this.tc_error("Cannot extract double!");
        }
        return (Double)this.value;
    }

    public BigDecimal extract_fixed() {
        if (this.typeCode.kind().value() != 28) {
            this.tc_error("Cannot extract fixed!");
        }
        return (BigDecimal)this.value;
    }

    public float extract_float() {
        if (this.typeCode.kind().value() != 6) {
            this.tc_error("Cannot extract float!");
        }
        return ((Float)this.value).floatValue();
    }

    public int extract_long() {
        if (this.typeCode.kind().value() != 3) {
            this.tc_error("Cannot extract long!");
        }
        return (Integer)this.value;
    }

    public long extract_longlong() {
        if (this.typeCode.kind().value() != 23) {
            this.tc_error("Cannot extract longlong! (TC is " + this.typeCode.kind().value() + ")");
        }
        return (Long)this.value;
    }

    public java.lang.Object extract_objref() {
        if (!this.typeCode.kind().equals(TCKind.tk_objref)) {
            this.tc_error();
        }
        return this.value;
    }

    public byte extract_octet() {
        if (this.typeCode.kind().value() != 10) {
            this.tc_error("Cannot extract octet!");
        }
        return (Byte)this.value;
    }

    public short extract_short() throws BAD_OPERATION {
        if (this.typeCode.kind().value() != 2) {
            this.tc_error("Cannot extract short!");
        }
        return (Short)this.value;
    }

    public String extract_string() {
        if (this.typeCode.kind().value() != 18) {
            this.tc_error("Cannot extract string!");
        }
        return this.value.toString();
    }

    public int extract_ulong() {
        if (this.typeCode.kind().value() != 5) {
            this.tc_error("Cannot extract ulong!");
        }
        return (Integer)this.value;
    }

    public long extract_ulonglong() {
        if (this.typeCode.kind().value() != 24) {
            this.tc_error("Cannot extract ulonglong!");
        }
        return (Long)this.value;
    }

    public short extract_ushort() {
        if (this.typeCode.kind().value() != 4) {
            this.tc_error("Cannot extract ushort!");
        }
        return (Short)this.value;
    }

    public char extract_wchar() {
        if (this.typeCode.kind().value() != 26) {
            this.tc_error("Cannot extract char!");
        }
        return ((Character)this.value).charValue();
    }

    public String extract_wstring() {
        if (this.typeCode.kind().value() != 27) {
            this.tc_error("Cannot extract string!");
        }
        return this.value.toString();
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public void insert_Object(Object object) {
        this.orb = ((ObjectImpl)object)._orb();
        this.value = object;
        this.typeCode = this.orb.create_interface_tc(((ObjectImpl)object)._ids()[0], "*** don't know yet ***");
    }

    public void insert_Object(Object object, org.omg.CORBA.TypeCode typeCode) {
        this.orb = ((ObjectImpl)object)._orb();
        this.value = object;
        this.typeCode = typeCode;
    }

    public void insert_Principal(Principal principal) {
        this.value = principal;
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_Principal);
    }

    public void insert_Streamable(Streamable streamable) {
        this.value = streamable;
        this.typeCode = streamable._type();
    }

    public void insert_TypeCode(org.omg.CORBA.TypeCode typeCode) {
        this.value = typeCode;
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_TypeCode);
    }

    public void insert_Value(Serializable serializable) {
        throw new NO_IMPLEMENT();
    }

    public void insert_Value(Serializable serializable, org.omg.CORBA.TypeCode typeCode) throws MARSHAL {
        throw new NO_IMPLEMENT();
    }

    public void insert_any(org.omg.CORBA.Any any) {
        this.value = any;
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_any);
    }

    public void insert_boolean(boolean bl) {
        this.value = new Boolean(bl);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_boolean);
    }

    public void insert_char(char c) {
        this.value = new Character(c);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_char);
    }

    public void insert_double(double d) {
        this.value = new Double(d);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_double);
    }

    public void insert_fixed(BigDecimal bigDecimal) {
        this.value = bigDecimal;
        this.typeCode = new FixedHolder(bigDecimal)._type();
    }

    public void insert_fixed(BigDecimal bigDecimal, org.omg.CORBA.TypeCode typeCode) {
        this.value = bigDecimal;
        this.typeCode = typeCode;
    }

    public void insert_float(float f) {
        this.value = new Float(f);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_float);
    }

    public void insert_long(int n) {
        this.value = new Integer(n);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_long);
    }

    public void insert_longlong(long l) {
        this.value = new Long(l);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_longlong);
    }

    public void insert_object(org.omg.CORBA.TypeCode typeCode, java.lang.Object object) {
        this.insert_object(typeCode, null, object);
    }

    public void insert_object(org.omg.CORBA.TypeCode typeCode, org.omg.CORBA.ORB oRB, java.lang.Object object) {
        this.typeCode = typeCode;
        if (oRB != null) {
            this.orb = oRB;
        }
        this.value = object;
    }

    public void insert_octet(byte by) {
        this.value = new Byte(by);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_octet);
    }

    public void insert_short(short s) {
        this.value = new Short(s);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_short);
    }

    public void insert_string(String string) {
        this.value = string;
        if (this.typeCode.kind().value() == 0) {
            this.typeCode = this.orb.create_string_tc(string.length());
        }
    }

    public void insert_ulong(int n) {
        this.value = new Integer(n);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_ulong);
    }

    public void insert_ulonglong(long l) {
        this.value = new Long(l);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_ulonglong);
    }

    public void insert_ushort(short s) {
        this.value = new Short(s);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_ushort);
    }

    public void insert_void() {
        this.value = null;
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_void);
    }

    public void insert_wchar(char c) {
        this.value = new Character(c);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_wchar);
    }

    public void insert_wstring(String string) {
        this.value = string;
        if (this.typeCode.kind().value() == 0) {
            this.typeCode = this.orb.create_wstring_tc(string.length());
        }
    }

    public TCKind kind() {
        return this.typeCode.kind();
    }

    public void read_value(InputStream inputStream, org.omg.CORBA.TypeCode typeCode) throws MARSHAL {
        this.typeCode = typeCode;
        int n = typeCode.kind().value();
        switch (n) {
            case 2: {
                this.insert_short(inputStream.read_short());
                break;
            }
            case 3: {
                this.insert_long(inputStream.read_long());
                break;
            }
            case 23: {
                this.insert_longlong(inputStream.read_longlong());
                break;
            }
            case 4: {
                this.insert_ushort(inputStream.read_ushort());
                break;
            }
            case 5: {
                this.insert_ulong(inputStream.read_ulong());
                break;
            }
            case 24: {
                this.insert_ulonglong(inputStream.read_ulonglong());
                break;
            }
            case 6: {
                this.insert_float(inputStream.read_float());
                break;
            }
            case 7: {
                this.insert_double(inputStream.read_double());
                break;
            }
            case 28: {
                this.insert_fixed(inputStream.read_fixed());
                break;
            }
            case 8: {
                this.insert_boolean(inputStream.read_boolean());
                break;
            }
            case 9: {
                this.insert_char(inputStream.read_char());
                break;
            }
            case 10: {
                this.insert_octet(inputStream.read_octet());
                break;
            }
            case 11: {
                this.insert_any(inputStream.read_any());
                break;
            }
            case 12: {
                this.insert_TypeCode(inputStream.read_TypeCode());
                break;
            }
            case 13: {
                this.insert_Principal(inputStream.read_Principal());
                break;
            }
            case 14: {
                this.insert_Object(inputStream.read_Object());
                break;
            }
            case 18: {
                this.insert_string(inputStream.read_string());
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: {
                this.value = !(this.orb instanceof ORB) ? new CDROutputStream() : new CDROutputStream(this.orb);
                ((CDRInputStream)inputStream).read_value(typeCode, (CDROutputStream)this.value);
                break;
            }
            case 21: {
                try {
                    this.read_value(inputStream, typeCode.content_type());
                    break;
                }
                catch (BadKind badKind) {
                    throw new UNKNOWN("Bad TypeCode kind");
                }
            }
            default: {
                throw new RuntimeException("Cannot handle TypeCode with kind " + n);
            }
            case 0: 
            case 1: 
        }
    }

    private void tc_error() {
        throw new BAD_OPERATION();
    }

    private void tc_error(String string) {
        throw new BAD_OPERATION(string);
    }

    public String toString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return "null";
    }

    public org.omg.CORBA.TypeCode type() {
        return this.typeCode;
    }

    public void type(org.omg.CORBA.TypeCode typeCode) {
        this.typeCode = typeCode;
        this.value = null;
    }

    public java.lang.Object value() {
        return this.value;
    }

    public void write_value(OutputStream outputStream) {
        int n = this.typeCode.kind().value();
        Debug.output(3, "Any.writeValue kind " + n);
        switch (n) {
            case 2: {
                outputStream.write_short(this.extract_short());
                break;
            }
            case 3: {
                outputStream.write_long(this.extract_long());
                break;
            }
            case 23: {
                outputStream.write_longlong(this.extract_longlong());
                break;
            }
            case 4: {
                outputStream.write_ushort(this.extract_ushort());
                break;
            }
            case 5: {
                outputStream.write_ulong(this.extract_ulong());
                break;
            }
            case 24: {
                outputStream.write_ulonglong(this.extract_ulonglong());
                break;
            }
            case 6: {
                outputStream.write_float(this.extract_float());
                break;
            }
            case 7: {
                outputStream.write_double(this.extract_double());
                break;
            }
            case 28: {
                outputStream.write_fixed(this.extract_fixed());
                break;
            }
            case 8: {
                outputStream.write_boolean(this.extract_boolean());
                break;
            }
            case 9: {
                outputStream.write_char(this.extract_char());
                break;
            }
            case 10: {
                outputStream.write_octet(this.extract_octet());
                break;
            }
            case 11: {
                outputStream.write_any(this.extract_any());
                break;
            }
            case 12: {
                outputStream.write_TypeCode(this.extract_TypeCode());
                break;
            }
            case 13: {
                outputStream.write_Principal(this.extract_Principal());
                break;
            }
            case 14: {
                outputStream.write_Object(this.extract_Object());
                break;
            }
            case 18: {
                outputStream.write_string(this.extract_string());
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: {
                try {
                    if (this.value instanceof Streamable) {
                        Streamable streamable = (Streamable)this.value;
                        streamable._write(outputStream);
                        break;
                    }
                    if (!(this.value instanceof OutputStream)) break;
                    CDRInputStream cDRInputStream = new CDRInputStream(this.orb, ((CDROutputStream)this.value).getInternalBuffer());
                    ((CDROutputStream)outputStream).write_value(this.typeCode, cDRInputStream);
                    break;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new RuntimeException(exception.getMessage());
                }
            }
            case 21: {
                try {
                    org.omg.CORBA.TypeCode typeCode = this.typeCode;
                    this.typeCode = this.typeCode.content_type();
                    this.write_value(outputStream);
                    this.typeCode = typeCode;
                    break;
                }
                catch (BadKind badKind) {
                    throw new UNKNOWN("Bad TypeCode kind");
                }
            }
            default: {
                throw new RuntimeException("Cannot handle TypeCode with kind " + n);
            }
            case 0: 
            case 1: 
        }
    }
}

