/*
 * Decompiled with CFR 0.152.
 */
package jacorb.ir.gui.typesystem.remote;

import jacorb.ir.gui.typesystem.AbstractContainer;
import jacorb.ir.gui.typesystem.ModelBuilder;
import jacorb.ir.gui.typesystem.NodeMapper;
import jacorb.ir.gui.typesystem.TypeAssociator;
import jacorb.ir.gui.typesystem.TypeSystem;
import jacorb.ir.gui.typesystem.TypeSystemNode;
import jacorb.ir.gui.typesystem.remote.IRAlias;
import jacorb.ir.gui.typesystem.remote.IRArray;
import jacorb.ir.gui.typesystem.remote.IRAttribute;
import jacorb.ir.gui.typesystem.remote.IRConstant;
import jacorb.ir.gui.typesystem.remote.IREnum;
import jacorb.ir.gui.typesystem.remote.IREnumMember;
import jacorb.ir.gui.typesystem.remote.IRException;
import jacorb.ir.gui.typesystem.remote.IRFixed;
import jacorb.ir.gui.typesystem.remote.IRInterface;
import jacorb.ir.gui.typesystem.remote.IRModule;
import jacorb.ir.gui.typesystem.remote.IRNode;
import jacorb.ir.gui.typesystem.remote.IROperation;
import jacorb.ir.gui.typesystem.remote.IRParameter;
import jacorb.ir.gui.typesystem.remote.IRPrimitive;
import jacorb.ir.gui.typesystem.remote.IRRepository;
import jacorb.ir.gui.typesystem.remote.IRSequence;
import jacorb.ir.gui.typesystem.remote.IRString;
import jacorb.ir.gui.typesystem.remote.IRStruct;
import jacorb.ir.gui.typesystem.remote.IRStructMember;
import jacorb.ir.gui.typesystem.remote.IRUnion;
import jacorb.ir.gui.typesystem.remote.IRUnionMember;
import jacorb.util.Debug;
import java.util.Hashtable;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Contained;
import org.omg.CORBA.ContainedHelper;
import org.omg.CORBA.IRObject;
import org.omg.CORBA.IRObjectHelper;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.ParameterDescription;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.UnionMember;

public class RemoteTypeSystem
extends TypeSystem {
    Repository rep;
    ORB orb = ORB.init(new String[0], null);
    private static Hashtable knownIRObjects = new Hashtable();
    private static String test = "";
    private static int test2;

    public RemoteTypeSystem() {
        try {
            this.rep = RepositoryHelper.narrow(this.orb.resolve_initial_references("InterfaceRepository"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public RemoteTypeSystem(String string) {
        Object object = this.orb.string_to_object(string);
        try {
            this.rep = RepositoryHelper.narrow(object);
        }
        catch (BAD_PARAM bAD_PARAM) {
            System.out.println("IOR is not a Repository, sorry.");
            System.exit(0);
        }
    }

    public DefaultTreeModel createTreeModelRoot() {
        if (this.treeModel != null) {
            return this.treeModel;
        }
        IRRepository iRRepository = new IRRepository(this.rep);
        this.treeModel = ModelBuilder.getSingleton().createTreeModelRoot(iRRepository);
        return this.treeModel;
    }

    public static TypeSystemNode createTypeSystemNode(java.lang.Object object) {
        Debug.assert(object != null, "A reference from the Repository is null... (but it should not)");
        IRObject iRObject = null;
        TypeSystemNode typeSystemNode = null;
        System.out.flush();
        if (object instanceof IRObject) {
            try {
                iRObject = IRObjectHelper.narrow((Object)object);
            }
            catch (BAD_PARAM bAD_PARAM) {}
        }
        if (iRObject != null) {
            typeSystemNode = (TypeSystemNode)knownIRObjects.get(iRObject);
            if (typeSystemNode != null) {
                Debug.output(2, String.valueOf(typeSystemNode.getInstanceNodeTypeName()) + " " + typeSystemNode.getAbsoluteName() + " (cached)");
                return typeSystemNode;
            }
            try {
                Contained contained = ContainedHelper.narrow(iRObject);
                typeSystemNode = (TypeSystemNode)knownIRObjects.get(contained.id());
                if (typeSystemNode != null) {
                    Debug.output(2, String.valueOf(typeSystemNode.getInstanceNodeTypeName()) + " " + typeSystemNode.getAbsoluteName() + " (cached by id)");
                    return typeSystemNode;
                }
            }
            catch (BAD_PARAM bAD_PARAM) {}
            switch (iRObject.def_kind().value()) {
                case 6: {
                    typeSystemNode = new IRModule(iRObject);
                    break;
                }
                case 5: {
                    typeSystemNode = new IRInterface(iRObject);
                    break;
                }
                case 3: {
                    typeSystemNode = new IRConstant(iRObject);
                    break;
                }
                case 2: {
                    typeSystemNode = new IRAttribute(iRObject);
                    break;
                }
                case 7: {
                    typeSystemNode = new IROperation(iRObject);
                    break;
                }
                case 4: {
                    typeSystemNode = new IRException(iRObject);
                    break;
                }
                case 10: {
                    typeSystemNode = new IRStruct(iRObject);
                    break;
                }
                case 11: {
                    typeSystemNode = new IRUnion(iRObject);
                    break;
                }
                case 13: {
                    typeSystemNode = new IRPrimitive(iRObject);
                    break;
                }
                case 19: {
                    typeSystemNode = new IRFixed(iRObject);
                    break;
                }
                case 14: {
                    typeSystemNode = new IRString(iRObject);
                    break;
                }
                case 9: {
                    typeSystemNode = new IRAlias(iRObject);
                    break;
                }
                case 15: {
                    typeSystemNode = new IRSequence(iRObject);
                    break;
                }
                case 12: {
                    typeSystemNode = new IREnum(iRObject);
                    break;
                }
                case 16: {
                    typeSystemNode = new IRArray(iRObject);
                    break;
                }
                default: {
                    System.out.println("Unknown/senseless DefinitionKind returned from Repository: " + iRObject.def_kind().value());
                }
            }
            if (typeSystemNode instanceof IRInterface && ((IRInterface)typeSystemNode).getName().equals("Container")) {
                int n = ((IRNode)typeSystemNode).irObject.hashCode();
                int n2 = iRObject.hashCode();
                if (test.equals(((IRInterface)typeSystemNode).getAbsoluteName())) {
                    System.out.println("bug!");
                }
                test = ((IRInterface)typeSystemNode).getAbsoluteName();
                test2 = ((IRNode)typeSystemNode).irObject.hashCode();
            }
            if (typeSystemNode != null) {
                knownIRObjects.put(iRObject, typeSystemNode);
                if (knownIRObjects.get(iRObject) == null) {
                    System.out.println("wasislos?");
                }
                if (typeSystemNode instanceof IRNode && !((IRNode)typeSystemNode).repositoryID.equals("")) {
                    knownIRObjects.put(((IRNode)typeSystemNode).repositoryID, typeSystemNode);
                }
            }
        } else {
            if (knownIRObjects.get(object) != null) {
                return (TypeSystemNode)knownIRObjects.get(object);
            }
            if (object instanceof StructMember) {
                StructMember structMember = (StructMember)object;
                if (knownIRObjects.get("structmember" + structMember.name + structMember.type.kind().toString()) != null) {
                    return (TypeSystemNode)knownIRObjects.get("structmember" + structMember.name + structMember.type.kind().toString());
                }
                typeSystemNode = new IRStructMember((StructMember)object);
                knownIRObjects.put("structmember" + structMember.name + structMember.type.kind().toString(), typeSystemNode);
            } else if (object instanceof UnionMember) {
                UnionMember unionMember = (UnionMember)object;
                if (knownIRObjects.get("unionmember" + unionMember.name + unionMember.type.kind().toString()) != null) {
                    return (TypeSystemNode)knownIRObjects.get("unionmember" + unionMember.name + unionMember.type.kind().toString());
                }
                typeSystemNode = new IRUnionMember((UnionMember)object);
                knownIRObjects.put("unionmember" + unionMember.name + unionMember.type.kind().toString(), typeSystemNode);
            } else if (object instanceof ParameterDescription) {
                ParameterDescription parameterDescription = (ParameterDescription)object;
                if (knownIRObjects.get("parameter" + parameterDescription.name + parameterDescription.type.kind().toString()) != null) {
                    return (TypeSystemNode)knownIRObjects.get("parameter" + parameterDescription.name + parameterDescription.type.kind().toString());
                }
                typeSystemNode = new IRParameter(parameterDescription);
                knownIRObjects.put("parameter" + parameterDescription.name + parameterDescription.type.kind().toString(), typeSystemNode);
            } else if (object instanceof String) {
                if (knownIRObjects.get((String)object) != null) {
                    return (IREnumMember)knownIRObjects.get((String)object);
                }
                typeSystemNode = new IREnumMember((String)object);
                knownIRObjects.put(object, typeSystemNode);
            }
        }
        Debug.output(2, String.valueOf(typeSystemNode.getInstanceNodeTypeName()) + " " + typeSystemNode.getAbsoluteName());
        return typeSystemNode;
    }

    public DefaultTableModel getTableModel(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        java.lang.Object[] objectArray = new java.lang.Object[]{"Item", "Type", "Name"};
        defaultTableModel.setColumnIdentifiers(objectArray);
        if (defaultMutableTreeNode != null && defaultMutableTreeNode.getUserObject() instanceof AbstractContainer) {
            int n = 0;
            while (n < this.treeModel.getChildCount(defaultMutableTreeNode)) {
                TypeSystemNode typeSystemNode = (TypeSystemNode)((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n)).getUserObject();
                String string = "";
                if (typeSystemNode instanceof TypeAssociator) {
                    string = ((TypeAssociator)((java.lang.Object)typeSystemNode)).getAssociatedType();
                }
                java.lang.Object[] objectArray2 = new java.lang.Object[]{new NodeMapper(typeSystemNode, typeSystemNode.getInstanceNodeTypeName()), new NodeMapper(typeSystemNode, string), new NodeMapper(typeSystemNode, typeSystemNode.getName())};
                defaultTableModel.addRow(objectArray2);
                ++n;
            }
        }
        return defaultTableModel;
    }

    public TreeExpansionListener getTreeExpansionListener(TreeModel treeModel) {
        return ModelBuilder.getSingleton().getTreeExpansionListener(treeModel);
    }

    public TreeModel getTreeModel() {
        if (this.treeModel != null) {
            return this.treeModel;
        }
        try {
            IRRepository iRRepository = new IRRepository(this.rep);
            this.treeModel = ModelBuilder.getSingleton().buildTreeModelAsync(iRRepository);
            return this.treeModel;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void main(String[] stringArray) {
        TreeModel treeModel = new RemoteTypeSystem().getTreeModel();
    }
}

