/*
 * Decompiled with CFR 0.152.
 */
package jacorb.ir.gui.typesystem.remote;

import jacorb.ir.gui.typesystem.Interface;
import jacorb.ir.gui.typesystem.ModelParticipant;
import jacorb.ir.gui.typesystem.TypeSystemNode;
import jacorb.ir.gui.typesystem.remote.IRAttribute;
import jacorb.ir.gui.typesystem.remote.IRConstant;
import jacorb.ir.gui.typesystem.remote.IRContainer;
import jacorb.ir.gui.typesystem.remote.IRException;
import jacorb.ir.gui.typesystem.remote.IROperation;
import jacorb.ir.gui.typesystem.remote.IRTypedef;
import jacorb.ir.gui.typesystem.remote.RemoteTypeSystem;
import java.util.Enumeration;
import java.util.Vector;
import org.omg.CORBA.IRObject;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;

public class IRInterface
extends IRContainer
implements Interface {
    private IRInterface[] superInterfaces = null;
    private IRAttribute[] allFields = null;
    private IROperation[] allOperations = null;

    public IRInterface() {
    }

    public IRInterface(IRObject iRObject) {
        super(iRObject);
    }

    public String[] allowedToAdd() {
        String[] stringArray = new String[]{IRAttribute.nodeTypeName(), IROperation.nodeTypeName(), IRConstant.nodeTypeName(), IRTypedef.nodeTypeName(), IRException.nodeTypeName()};
        return stringArray;
    }

    public String description() {
        String string = super.description();
        Interface[] interfaceArray = this.getSuperInterfaces();
        if (interfaceArray.length > 0) {
            string = String.valueOf(string) + "\nSuper-Interfaces:\t ";
            int n = 0;
            while (n < interfaceArray.length) {
                string = String.valueOf(string) + ((TypeSystemNode)((Object)interfaceArray[n])).getAbsoluteName();
                if (n != interfaceArray.length - 1) {
                    string = String.valueOf(string) + ", ";
                }
                ++n;
            }
        } else {
            string = String.valueOf(string) + "\nSuper-Interfaces:\t:none";
        }
        return string;
    }

    public TypeSystemNode[] getAllFields() {
        if (this.allFields == null) {
            int n;
            ModelParticipant[] modelParticipantArray;
            Vector<ModelParticipant> vector = new Vector<ModelParticipant>();
            Interface[] interfaceArray = this.getSuperInterfaces();
            int n2 = 0;
            while (n2 < interfaceArray.length) {
                modelParticipantArray = interfaceArray[n2].getAllFields();
                n = 0;
                while (n < modelParticipantArray.length) {
                    vector.addElement(modelParticipantArray[n]);
                    ++n;
                }
                ++n2;
            }
            modelParticipantArray = this.contents();
            n = 0;
            while (n < modelParticipantArray.length) {
                if (modelParticipantArray[n] instanceof IRAttribute) {
                    vector.addElement(modelParticipantArray[n]);
                }
                ++n;
            }
            this.allFields = new IRAttribute[vector.size()];
            int n3 = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.allFields[n3] = (IRAttribute)enumeration.nextElement();
                ++n3;
            }
        }
        return this.allFields;
    }

    public TypeSystemNode[] getAllOperations() {
        if (this.allOperations == null) {
            int n;
            ModelParticipant[] modelParticipantArray;
            Vector<ModelParticipant> vector = new Vector<ModelParticipant>();
            Interface[] interfaceArray = this.getSuperInterfaces();
            int n2 = 0;
            while (n2 < interfaceArray.length) {
                modelParticipantArray = interfaceArray[n2].getAllOperations();
                n = 0;
                while (n < modelParticipantArray.length) {
                    vector.addElement(modelParticipantArray[n]);
                    ++n;
                }
                ++n2;
            }
            modelParticipantArray = this.contents();
            n = 0;
            while (n < modelParticipantArray.length) {
                if (modelParticipantArray[n] instanceof IROperation) {
                    vector.addElement(modelParticipantArray[n]);
                }
                ++n;
            }
            this.allOperations = new IROperation[vector.size()];
            int n3 = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.allOperations[n3] = (IROperation)enumeration.nextElement();
                ++n3;
            }
        }
        return this.allOperations;
    }

    public Interface[] getSuperInterfaces() {
        if (this.superInterfaces == null) {
            InterfaceDef interfaceDef = InterfaceDefHelper.narrow(this.irObject);
            InterfaceDef[] interfaceDefArray = interfaceDef.base_interfaces();
            this.superInterfaces = new IRInterface[interfaceDefArray.length];
            int n = 0;
            while (n < interfaceDefArray.length) {
                IRInterface iRInterface;
                this.superInterfaces[n] = iRInterface = (IRInterface)RemoteTypeSystem.createTypeSystemNode(interfaceDefArray[n]);
                ++n;
            }
        }
        return this.superInterfaces;
    }

    public static String nodeTypeName() {
        return "interface";
    }

    protected void setIRObject(IRObject iRObject) {
        super.setIRObject(iRObject);
    }
}

