/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.NVPair;
import HTTPClient.Util;

public class HttpHeaderElement {
    private String name;
    private String value;
    private NVPair[] parameters;

    public HttpHeaderElement(String string) {
        this.name = string;
        this.value = null;
        this.parameters = new NVPair[0];
    }

    public HttpHeaderElement(String string, String string2, NVPair[] nVPairArray) {
        this.name = string;
        this.value = string2;
        if (nVPairArray != null) {
            this.parameters = new NVPair[nVPairArray.length];
            System.arraycopy(nVPairArray, 0, this.parameters, 0, nVPairArray.length);
        } else {
            this.parameters = new NVPair[0];
        }
    }

    public void appendTo(StringBuffer stringBuffer) {
        stringBuffer.append(this.name);
        if (this.value != null) {
            if (Util.needsQuoting(this.value)) {
                stringBuffer.append("=\"");
                stringBuffer.append(Util.quoteString(this.value, "\\\""));
                stringBuffer.append('\"');
            } else {
                stringBuffer.append('=');
                stringBuffer.append(this.value);
            }
        }
        int n = 0;
        while (n < this.parameters.length) {
            stringBuffer.append(";");
            stringBuffer.append(this.parameters[n].getName());
            String string = this.parameters[n].getValue();
            if (string != null) {
                if (Util.needsQuoting(string)) {
                    stringBuffer.append("=\"");
                    stringBuffer.append(Util.quoteString(string, "\\\""));
                    stringBuffer.append('\"');
                } else {
                    stringBuffer.append('=');
                    stringBuffer.append(string);
                }
            }
            ++n;
        }
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof HttpHeaderElement) {
            String string = ((HttpHeaderElement)object).name;
            return this.name.equalsIgnoreCase(string);
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public NVPair[] getParams() {
        return this.parameters;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendTo(stringBuffer);
        return stringBuffer.toString();
    }
}

