package jacorb.orb.portableInterceptor;

import org.omg.IOP_N.CodecPackage.*;
import org.omg.IOP_N.Codec;
import org.omg.CORBA.*;

import jacorb.orb.CDRInputStream;
import jacorb.orb.CDROutputStream;
import jacorb.util.Debug;
/**
 * This class represents a codec for encoding ENCODING_CDR_ENCAPS 1.0.
 *
 * See PI SPec p.10-77ff
 *
 * @author Nicolas Noffke
 * @version $Id: Codec_CDR_1_0_Impl.java,v 1.4 2000/08/18 13:40:45 noffke Exp $
 */

public class Codec_CDR_1_0_Impl 
    extends jacorb.orb.LocalityConstrainedObject 
    implements Codec 
{

    private ORB orb = null;

    public Codec_CDR_1_0_Impl(ORB orb) {
        this.orb = orb;
    }

    // implementation of org.omg.IOP_N.CodecOperations interface

    public Any decode(byte[] data) throws FormatMismatch 
    {
        CDRInputStream in = new CDRInputStream(orb, data);

        in.openEncapsulation();
        Any result = in.read_any();
    
        //not necessary, since stream is never used again
        //in.closeEncapsulation();

        return result;
    }


    public Any decode_value(byte[] data, TypeCode tc) 
        throws FormatMismatch, TypeMismatch 
    {
        CDRInputStream in = new CDRInputStream(orb, data);

        in.openEncapsulation();
        Any result = orb.create_any();
        result.read_value(in, tc);
   
        //not necessary, since stream is never used again
        //in.closeEncasupaltion(); 

        return result;
    }

    public byte[] encode(Any data) 
        throws InvalidTypeForEncoding 
    {
        CDROutputStream out = new CDROutputStream(orb);
    
        out.beginEncapsulation();
        out.write_any(data);

        try
        {
            out.endEncapsulation();
        }
        catch (java.io.IOException e)
        {
            Debug.output(Debug.INFORMATION | Debug.INTERCEPTOR, e);
        }

        /*
         * We have to copy anyway since we need an exact-sized array.
         * Closing afterwards, to return buffer to BufferManager.
         */
        byte[] result = out.getBufferCopy();
        out.release();

        return result;
    }

    public byte[] encode_value(Any data) 
        throws InvalidTypeForEncoding 
    {
  
        CDROutputStream out = new CDROutputStream(orb);
    
        out.beginEncapsulation();
        data.write_value(out);
    
        try
        {
            out.endEncapsulation();
        }
        catch (java.io.IOException e)
        {
            Debug.output(Debug.INFORMATION | Debug.INTERCEPTOR, e);
        }

        /*
         * We have to copy anyway since we need an exact-sized array.
         * Closing afterwards, to return buffer to BufferManager.
         */
        byte[] result = out.getBufferCopy();
        out.release();

        return result;
    }

} // Codec_CDR_1_0_Impl
