package jacorb.orb;

/*
 *        JacORB - a free Java ORB
 *
 *   Copyright (C) 1997-98  Gerald Brose.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/**
 * Interface for connectiosn on the server-side
 *
 * @author Gerald Brose, FU Berlin
 * @version $Id: ServerSideConnection.java,v 1.1 2000/03/23 23:51:42 semu Exp $
 *
 */


import java.io.*;
import java.net.*;
import java.util.*;
import jacorb.orb.giop.*;
import jacorb.util.*;

public interface ServerSideConnection 
{
		
	/**
	 * send a "close connection" message to the other side.
	 */

	public void sendCloseConnection() throws org.omg.CORBA.COMM_FAILURE ;
	/**
	 *
	 */

	public void sendLocateReply( int request_id, int status, org.omg.CORBA.Object arg ) throws org.omg.CORBA.COMM_FAILURE;
	/**
	 * called from dsi/ServerRequest
	 */


	public void sendReply( jacorb.orb.giop.ReplyOutputStream os ) throws IOException;
}