package jacorb.security.ssl;

/*
 *        JacORB - a free Java ORB
 *
 *   Copyright (C) 2000  Benvenuti Andr.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import java.io.*;
import org.omg.SecurityReplaceable.*;
import org.omg.Security.*;

import org.omg.PortableInterceptor.*;
import org.omg.CORBA.ORBPackage.*;
import org.omg.CORBA.Any;

import jacorb.util.Environment;
import jacorb.util.Debug;
import jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import jacorb.security.level2.*;

/**
 * This interceptor is a prototype secure access interceptors 
 * $Id: ServerInvocationInterceptor.java,v 1.6 2000/09/06 12:41:54 brose Exp $
 * @author Benvenuti Andr
 */

public class ServerInvocationInterceptor
    extends jacorb.orb.LocalityConstrainedObject 
    implements ServerRequestInterceptor
{
    /** context management. */
    private java.util.Hashtable contexts = 
        new java.util.Hashtable(); // key is session id

    private java.util.Hashtable connections = 
        new java.util.Hashtable(); // key is session id

    private Object contextsLock = new Object();

    private boolean enforceSSL;
    private SSLSetup sslSetup = null;
    private jacorb.security.level2.CurrentImpl current = null;
    private SecAttributeManager attrib_mgr;
    private AttributeType type; 

    ServerInvocationInterceptor(org.omg.SecurityLevel2.Current current)
    {
        enforceSSL = Environment.enforceSSL();
        this.current = (jacorb.security.level2.CurrentImpl)current;
        attrib_mgr = SecAttributeManager.getInstance();
        type = new AttributeType
            ( new ExtensibleFamily( (short) 0,
                                    (short) 1 ),
              AccessId.value );   
    }

    public String name()
    {
        return "ServerInvocationInterceptor";
    }

    public void receive_request(org.omg.PortableInterceptor.ServerRequestInfo ri)
        throws org.omg.PortableInterceptor.ForwardRequest
    {
        jacorb.util.Debug.output( 3, "receive_request_service_contexts!");
    }


    /**
     * @throws CORBA::NO_PERMISSION, if security policy violated
     */

    public void receive_request_service_contexts(org.omg.PortableInterceptor.ServerRequestInfo ri)
        throws org.omg.PortableInterceptor.ForwardRequest
    {
        jacorb.util.Debug.output( 3, "receive_request!");

        jacorb.orb.dsi.ServerRequest request =
            ((jacorb.orb.portableInterceptor.ServerRequestInfoImpl)ri).request;

        jacorb.orb.Connection connection = request.getConnection();

        // lookup for context
        if (connection == null)
        {
            jacorb.util.Debug.output( 3, "target has no connection!");
            return;
        }

        //        iaik.security.ssl.SSLSocket sslSocket = (iaik.security.ssl.SSLSocket)target.connection.getSocket();

        if( !connection.isSSL() )
        {
            return;
        }

        iaik.security.ssl.SSLSocket sslSocket = 
            (iaik.security.ssl.SSLSocket)connection.getSocket();
            


        KeyAndCert kac = new KeyAndCert( null, sslSocket.getPeerCertificateChain() );

        SecAttribute [] atts = new SecAttribute[] {
            attrib_mgr.createCertAttribute( kac,
                                            type ) } ;

        current.set_received_credentials( new jacorb.security.level2.ReceivedCredentialsImpl( atts ) );
 
    }

    public void send_reply(org.omg.PortableInterceptor.ServerRequestInfo ri)
    {
        jacorb.util.Debug.output( 3, "send_reply!");
    }

    public void send_exception(org.omg.PortableInterceptor.ServerRequestInfo ri)
        throws org.omg.PortableInterceptor.ForwardRequest
    {
        jacorb.util.Debug.output( 3, "send_exception!");
    }

    public void send_other(org.omg.PortableInterceptor.ServerRequestInfo ri)
        throws org.omg.PortableInterceptor.ForwardRequest
    {
        jacorb.util.Debug.output( 3, "send_other!");
    }

    public void receive_other(ClientRequestInfo ri) 
        throws ForwardRequest
    {
        jacorb.util.Debug.output( 3, "receive_other!");
    }
}
