/*
 *        JacORB - a free Java ORB
 *
 *   Copyright (C) 1997-98  Gerald Brose.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jacorb.idl;

/**
 * @author Gerald Brose
 * @version $Id: RaisesExpr.java,v 1.6 1999/11/25 16:04:08 brose Exp $
 */

import java.util.*;
import java.io.PrintWriter;

class RaisesExpr 
    extends IdlSymbol
{
    public Vector nameList;

    public RaisesExpr(int num)
    {
	super(num);
	nameList = new Vector();
    }

    public void setPackage( String s, boolean propagate_into_included )
    {
        s = parser.pack_replace(s);
	for( Enumeration e = nameList.elements(); 	
	     e.hasMoreElements();
	     ((ScopedName)e.nextElement()).setPackage(s, propagate_into_included))
	    ;
    }

    public boolean empty()
    {
	return ( nameList.size() == 0 );
    }

    public String[] getExceptionNames()
    {
	String[] result = new String[nameList.size()];
	Enumeration e = nameList.elements();
	for( int i = 0; i < result.length; i++)
	{
	    result[i] = ((ScopedName)e.nextElement()).toString();
	}
	return result;
    }

    public String[] getExceptionIds()
    {
	String[] result = new String[nameList.size()];
	Enumeration e = nameList.elements();
	for( int i = 0; i < result.length; i++)
	{
	    result[i] = ((ScopedName)e.nextElement()).id();
	}
	return result;    
    }

    public String[] getExceptionClassNames()
    {
	String[] result = new String[nameList.size()];
	Enumeration e = nameList.elements();
	for( int i = 0; i < result.length; i++)
	{
	    result[i] = ((ScopedName)e.nextElement()).toString();
	}
	return result;
    }

    public void print(PrintWriter ps)
    {
	Enumeration e = nameList.elements();
	if(e.hasMoreElements())
	{
	    ps.print(" throws " +  ((ScopedName)e.nextElement()));
	}
	for(; e.hasMoreElements();)
	{
	    ps.print("," + ((ScopedName)e.nextElement()));
	}
    }
}







