package jacorb.orb.ir;

/*
 *        JacORB - a free Java ORB
 *
 *   Copyright (C) 1997-98  Gerald Brose.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/**
 * @author Gerald Brose
 */

public class Util 
{

    /**
     * maps a Java class name to a scoped IDL name
     *
     * @returns String - the scoped IDL name
     */

    public static String mapName2IDL( String s )
    {
	if( s.indexOf(".") < 0)
	    return s;

	java.util.StringTokenizer strtok = new java.util.StringTokenizer( s, "." );

	String scopes[] = new String[strtok.countTokens()];
	for( int i = 0; strtok.hasMoreTokens(); i++ )
	{
	    String sc = strtok.nextToken();
	    if( sc.endsWith("Package"))
		scopes[i] = sc.substring(0,sc.indexOf("Package"));
	    else
		scopes[i] = sc;
	}

	StringBuffer sb = new StringBuffer();
	if( scopes.length > 1 )
	{
	    for( int i = 0; i < scopes.length-1; i++)
		sb.append( scopes[i] + "::" );
	}

	sb.append( scopes[scopes.length-1] );
	return sb.toString();
    }



    

}


