/*
 * Decompiled with CFR 0.152.
 */
package jacorb.idl;

import jacorb.idl.Declarator;
import jacorb.idl.IdlSymbol;
import jacorb.idl.NameAlreadyDefined;
import jacorb.idl.NameTable;
import jacorb.idl.lexer;
import jacorb.idl.parser;

class SimpleDeclarator
extends Declarator {
    public SimpleDeclarator(int n) {
        super(n);
    }

    public void escapeName() {
        if (!this.name.startsWith("_") && lexer.strictJavaEscapeCheck(this.name)) {
            this.name = "_" + this.name;
        }
    }

    String full_name() {
        if (this.name.length() == 0) {
            return null;
        }
        if (this.pack_name.length() > 0) {
            return String.valueOf(this.pack_name) + "." + this.name;
        }
        return this.name;
    }

    public IdlSymbol getEnclosingSymbol() {
        return this.enclosing_symbol;
    }

    public String name() {
        return this.name;
    }

    public void parse() {
        try {
            NameTable.define(this.full_name(), "attr/param name");
        }
        catch (NameAlreadyDefined nameAlreadyDefined) {
            parser.error("Declarator name " + this.full_name() + " already declared", this.token);
        }
    }

    public void setEnclosingSymbol(IdlSymbol idlSymbol) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != idlSymbol) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = idlSymbol;
    }

    public void setPackage(String string, boolean bl) {
        string = parser.pack_replace(string);
        this.pack_name = this.pack_name.length() > 0 ? new String(String.valueOf(string) + "." + this.pack_name) : string;
    }

    public String toString() {
        return this.name;
    }
}

