/*
 * Decompiled with CFR 0.152.
 */
package jacorb.trading.impl;

import jacorb.trading.db.TypeDatabase;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.omg.CORBA.Contained;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.Repository;
import org.omg.CORBA.SystemException;
import org.omg.CosTrading.DuplicatePropertyName;
import org.omg.CosTrading.IllegalPropertyName;
import org.omg.CosTrading.IllegalServiceType;
import org.omg.CosTrading.UnknownServiceType;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPOA;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.AlreadyMasked;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.DuplicateServiceTypeName;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.HasSubTypes;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.IncarnationNumber;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.InterfaceTypeMismatch;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.ListOption;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.NotMasked;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropStruct;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropertyMode;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.ServiceTypeExists;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.SpecifiedServiceTypes;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.TypeStruct;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.ValueTypeRedefinition;

public class RepositoryImpl
extends ServiceTypeRepositoryPOA {
    private TypeDatabase m_database;
    private Repository m_interfaceRepos;

    public RepositoryImpl(TypeDatabase typeDatabase, Repository repository) {
        this.m_database = typeDatabase;
        this.m_interfaceRepos = repository;
    }

    public IncarnationNumber add_type(String string, String string2, PropStruct[] propStructArray, String[] stringArray) throws IllegalServiceType, ServiceTypeExists, InterfaceTypeMismatch, IllegalPropertyName, DuplicatePropertyName, ValueTypeRedefinition, UnknownServiceType, DuplicateServiceTypeName {
        IncarnationNumber incarnationNumber = null;
        try {
            this.m_database.begin(1);
            this.checkTypeName(string);
            if (this.m_database.describeType(string) != null) {
                throw new ServiceTypeExists(string);
            }
            Hashtable<String, TypeStruct> hashtable = new Hashtable<String, TypeStruct>();
            int n = 0;
            while (n < stringArray.length) {
                TypeStruct typeStruct = this.findType(stringArray[n]);
                if (hashtable.containsKey(stringArray[n])) {
                    throw new DuplicateServiceTypeName(stringArray[n]);
                }
                hashtable.put(stringArray[n], typeStruct);
                ++n;
            }
            int n2 = 0;
            while (n2 < stringArray.length) {
                String[] stringArray2 = this.m_database.getAllSuperTypes(stringArray[n2]);
                int n3 = 0;
                while (n3 < stringArray2.length) {
                    if (!hashtable.containsKey(stringArray2[n3])) {
                        TypeStruct typeStruct = this.findType(stringArray2[n3]);
                        if (typeStruct == null) {
                            throw new UnknownServiceType(stringArray2[n3]);
                        }
                        hashtable.put(stringArray2[n3], typeStruct);
                    }
                    ++n3;
                }
                ++n2;
            }
            this.validateInterface(string, string2, stringArray, hashtable);
            this.validateProperties(string, propStructArray, stringArray, hashtable);
            incarnationNumber = this.m_database.createType(string, string2, propStructArray, stringArray);
        }
        finally {
            Object var7_13 = null;
            this.m_database.end();
        }
        return incarnationNumber;
    }

    protected void checkTypeName(String string) throws IllegalServiceType {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalServiceType("");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":", true);
        boolean bl = false;
        String string2 = null;
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals(":")) {
                if (++n > 2) {
                    throw new IllegalServiceType(string);
                }
            } else {
                n = 0;
                bl = true;
                if (!Character.isLetter(string3.charAt(0))) {
                    throw new IllegalServiceType(string);
                }
                int n2 = 1;
                while (n2 < string3.length()) {
                    char c = string3.charAt(n2);
                    if (!Character.isLetterOrDigit(c) && c != '_') {
                        throw new IllegalServiceType(string);
                    }
                    ++n2;
                }
            }
            string2 = string3;
        }
        if (!bl) {
            throw new IllegalServiceType(string);
        }
        if (string2.equals(":")) {
            throw new IllegalServiceType(string);
        }
    }

    public TypeStruct describe_type(String string) throws IllegalServiceType, UnknownServiceType {
        TypeStruct typeStruct;
        try {
            this.m_database.begin(0);
            this.checkTypeName(string);
            typeStruct = this.findType(string);
        }
        finally {
            Object var4_3 = null;
            this.m_database.end();
        }
        return typeStruct;
    }

    protected void findProperties(TypeStruct typeStruct, String string, Vector vector, Hashtable hashtable) {
        PropStruct propStruct = this.findProperty(typeStruct, string);
        if (propStruct != null) {
            vector.addElement(propStruct);
        } else {
            int n = 0;
            while (n < typeStruct.super_types.length) {
                TypeStruct typeStruct2 = (TypeStruct)hashtable.get(typeStruct.super_types[n]);
                this.findProperties(typeStruct2, string, vector, hashtable);
                ++n;
            }
        }
    }

    protected PropStruct findProperty(TypeStruct typeStruct, String string) {
        PropStruct propStruct = null;
        int n = 0;
        while (n < typeStruct.props.length && propStruct == null) {
            if (string.equals(typeStruct.props[n].name)) {
                propStruct = typeStruct.props[n];
            }
            ++n;
        }
        return propStruct;
    }

    protected TypeStruct findType(String string) throws UnknownServiceType {
        TypeStruct typeStruct = this.m_database.describeType(string);
        if (typeStruct == null) {
            throw new UnknownServiceType(string);
        }
        return typeStruct;
    }

    public TypeStruct fully_describe_type(String string) throws IllegalServiceType, UnknownServiceType {
        TypeStruct typeStruct = null;
        try {
            Serializable serializable;
            this.m_database.begin(0);
            this.checkTypeName(string);
            typeStruct = this.findType(string);
            String[] stringArray = this.m_database.getAllSuperTypes(string);
            typeStruct.super_types = stringArray;
            Vector<Serializable> vector = new Vector<Serializable>();
            int n = 0;
            while (n < stringArray.length) {
                serializable = this.findType(stringArray[n]);
                vector.addElement(serializable);
                ++n;
            }
            serializable = new Vector();
            int n2 = 0;
            while (n2 < typeStruct.props.length) {
                ((Vector)serializable).addElement(typeStruct.props[n2]);
                ++n2;
            }
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                TypeStruct typeStruct2 = (TypeStruct)enumeration.nextElement();
                int n3 = 0;
                while (n3 < typeStruct2.props.length) {
                    boolean bl = false;
                    Enumeration enumeration2 = ((Vector)serializable).elements();
                    while (enumeration2.hasMoreElements() && !bl) {
                        PropStruct propStruct = (PropStruct)enumeration2.nextElement();
                        if (!typeStruct2.props[n3].name.equals(propStruct.name)) continue;
                        bl = true;
                    }
                    if (!bl) {
                        ((Vector)serializable).addElement(typeStruct2.props[n3]);
                    }
                    ++n3;
                }
            }
            typeStruct.props = new PropStruct[((Vector)serializable).size()];
            ((Vector)serializable).copyInto(typeStruct.props);
        }
        finally {
            Object var5_14 = null;
            this.m_database.end();
        }
        return typeStruct;
    }

    public IncarnationNumber incarnation() {
        this.m_database.begin(0);
        IncarnationNumber incarnationNumber = this.m_database.getIncarnation();
        this.m_database.end();
        return incarnationNumber;
    }

    public String[] list_types(SpecifiedServiceTypes specifiedServiceTypes) {
        String[] stringArray;
        block3: {
            stringArray = null;
            try {
                this.m_database.begin(0);
                if (specifiedServiceTypes.discriminator() == ListOption.all) {
                    stringArray = this.m_database.getTypes();
                    break block3;
                }
                IncarnationNumber incarnationNumber = specifiedServiceTypes.incarnation();
                stringArray = this.m_database.getTypesSince(incarnationNumber);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.m_database.end();
                throw throwable;
            }
        }
        Object var4_4 = null;
        this.m_database.end();
        return stringArray;
    }

    public void mask_type(String string) throws IllegalServiceType, UnknownServiceType, AlreadyMasked {
        try {
            this.m_database.begin(1);
            this.checkTypeName(string);
            TypeStruct typeStruct = this.findType(string);
            if (typeStruct.masked) {
                throw new AlreadyMasked(string);
            }
            if (!this.m_database.maskType(string)) {
                throw new UnknownServiceType(string);
            }
            Object var3_3 = null;
            this.m_database.end();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.m_database.end();
            throw throwable;
        }
    }

    public void remove_type(String string) throws IllegalServiceType, UnknownServiceType, HasSubTypes {
        try {
            this.m_database.begin(1);
            this.checkTypeName(string);
            String string2 = this.m_database.findSubType(string);
            if (string2 != null) {
                throw new HasSubTypes(string, string2);
            }
            if (!this.m_database.removeType(string)) {
                throw new UnknownServiceType(string);
            }
            Object var3_3 = null;
            this.m_database.end();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.m_database.end();
            throw throwable;
        }
    }

    public void unmask_type(String string) throws IllegalServiceType, UnknownServiceType, NotMasked {
        try {
            this.m_database.begin(1);
            this.checkTypeName(string);
            TypeStruct typeStruct = this.findType(string);
            if (!typeStruct.masked) {
                throw new NotMasked(string);
            }
            if (!this.m_database.unmaskType(string)) {
                throw new UnknownServiceType(string);
            }
            Object var3_3 = null;
            this.m_database.end();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.m_database.end();
            throw throwable;
        }
    }

    protected void validateInterface(String string, String string2, String[] stringArray, Hashtable hashtable) throws InterfaceTypeMismatch {
        if (this.m_interfaceRepos != null) {
            InterfaceDef interfaceDef = null;
            try {
                Contained contained = this.m_interfaceRepos.lookup(string2);
                if (contained != null) {
                    interfaceDef = InterfaceDefHelper.narrow(contained);
                }
            }
            catch (SystemException systemException) {}
            if (interfaceDef != null) {
                int n = 0;
                while (n < stringArray.length) {
                    try {
                        String string3;
                        TypeStruct typeStruct = (TypeStruct)hashtable.get(stringArray[n]);
                        Contained contained = this.m_interfaceRepos.lookup(typeStruct.if_name);
                        if (contained != null && !interfaceDef.is_a(string3 = contained.id())) {
                            throw new InterfaceTypeMismatch(stringArray[n], typeStruct.if_name, string, string2);
                        }
                    }
                    catch (SystemException systemException) {}
                    ++n;
                }
            }
        }
    }

    protected boolean validateMode(PropertyMode propertyMode, PropertyMode propertyMode2) {
        boolean bl = false;
        if (propertyMode2 == propertyMode) {
            bl = true;
        } else if (propertyMode2 == PropertyMode.PROP_NORMAL) {
            bl = true;
        } else if (propertyMode2 == PropertyMode.PROP_READONLY && (propertyMode == PropertyMode.PROP_READONLY || propertyMode == PropertyMode.PROP_MANDATORY_READONLY)) {
            bl = true;
        } else if (propertyMode2 == PropertyMode.PROP_MANDATORY && (propertyMode == PropertyMode.PROP_MANDATORY || propertyMode == PropertyMode.PROP_MANDATORY_READONLY)) {
            bl = true;
        } else if (propertyMode2 == PropertyMode.PROP_MANDATORY_READONLY && propertyMode == PropertyMode.PROP_MANDATORY_READONLY) {
            bl = true;
        }
        return bl;
    }

    protected void validateProperties(String string, PropStruct[] propStructArray, String[] stringArray, Hashtable hashtable) throws IllegalPropertyName, DuplicatePropertyName, ValueTypeRedefinition {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < propStructArray.length) {
            if (vector.contains(propStructArray[n].name)) {
                throw new DuplicatePropertyName(propStructArray[n].name);
            }
            int n2 = 0;
            while (n2 < stringArray.length) {
                TypeStruct typeStruct = (TypeStruct)hashtable.get(stringArray[n2]);
                Vector vector2 = new Vector();
                this.findProperties(typeStruct, propStructArray[n].name, vector2, hashtable);
                Enumeration enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    PropStruct propStruct = (PropStruct)enumeration.nextElement();
                    if (propStructArray[n].value_type.equal(propStruct.value_type) && this.validateMode(propStructArray[n].mode, propStruct.mode)) continue;
                    throw new ValueTypeRedefinition(string, propStructArray[n], stringArray[n2], propStruct);
                }
                ++n2;
            }
            vector.addElement(propStructArray[n].name);
            ++n;
        }
    }
}

