/*
 * Decompiled with CFR 0.152.
 */
package jacorb.orb.dsi;

import jacorb.orb.CDRInputStream;
import jacorb.orb.Connection;
import jacorb.orb.NVList;
import jacorb.orb.NamedValue;
import jacorb.orb.ORB;
import jacorb.orb.ServerSideConnection;
import jacorb.orb.SystemExceptionHelper;
import jacorb.orb.giop.ReplyOutputStream;
import jacorb.orb.giop.RequestInputStream;
import jacorb.orb.http.ServerConnection;
import jacorb.orb.portableInterceptor.ServerInterceptorIterator;
import jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import jacorb.poa.util.POAUtil;
import jacorb.util.Debug;
import java.util.Enumeration;
import org.omg.CORBA.Any;
import org.omg.CORBA.Context;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.ParameterMode;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.Dynamic.Parameter;
import org.omg.GIOP.ReplyStatusType;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;

public class ServerRequest
extends org.omg.CORBA.ServerRequest
implements ResponseHandler {
    protected RequestInputStream in;
    protected ReplyOutputStream out;
    protected Connection connection;
    protected int status = 0;
    protected byte[] oid;
    protected Object reference = null;
    protected String[] rest_of_name = null;
    protected boolean stream_based;
    protected SystemException sys_ex;
    protected org.omg.PortableServer.ForwardRequest location_forward;
    protected Any ex;
    protected Any result;
    protected NVList args;
    private ORB orb;
    private ServerRequestInfoImpl info = null;

    protected ServerRequest() {
    }

    protected ServerRequest(ORB oRB, Connection connection) {
        this.orb = oRB;
        this.connection = connection;
    }

    public ServerRequest(ORB oRB, byte[] byArray, Connection connection) {
        this.orb = oRB;
        this.in = new RequestInputStream(connection, byArray);
        this.connection = connection;
        this.oid = POAUtil.extractOID(this.in.req_hdr.object_key);
    }

    public org.omg.CORBA.NVList arguments() {
        if (this.stream_based) {
            throw new RuntimeException("This ServerRequest is stream-based!");
        }
        return this.args;
    }

    public void arguments(org.omg.CORBA.NVList nVList) {
        if (this.stream_based) {
            throw new RuntimeException("This ServerRequest is stream-based!");
        }
        this.args = (NVList)nVList;
        if (this.args != null) {
            Parameter[] parameterArray;
            this.in.mark(0);
            Enumeration enumeration = this.args.enumerate();
            while (enumeration.hasMoreElements()) {
                parameterArray = (Parameter[])enumeration.nextElement();
                if (parameterArray.flags() == 2) continue;
                try {
                    parameterArray.value().read_value(this.in, parameterArray.value().type());
                }
                catch (Exception exception) {
                    throw new MARSHAL("Couldn't unmarshal object of type " + parameterArray.value().type() + " in ServerRequest.");
                }
            }
            try {
                this.in.reset();
            }
            catch (Exception exception) {
                throw new UNKNOWN("Could not reset input stream");
            }
            if (this.info != null) {
                java.lang.Object object;
                parameterArray = new Parameter[this.args.count()];
                int n = 0;
                while (n < parameterArray.length) {
                    try {
                        object = this.args.item(n);
                        ParameterMode parameterMode = null;
                        if (((org.omg.CORBA.NamedValue)object).flags() == 1) {
                            parameterMode = ParameterMode.PARAM_IN;
                        } else if (((org.omg.CORBA.NamedValue)object).flags() == 2) {
                            parameterMode = ParameterMode.PARAM_OUT;
                        } else if (((org.omg.CORBA.NamedValue)object).flags() == 3) {
                            parameterMode = ParameterMode.PARAM_INOUT;
                        }
                        parameterArray[n] = new Parameter(((org.omg.CORBA.NamedValue)object).value(), parameterMode);
                    }
                    catch (Exception exception) {
                        Debug.output(2, exception);
                    }
                    ++n;
                }
                this.info.arguments = parameterArray;
                object = this.orb.getInterceptorManager().getServerIterator();
                try {
                    ((ServerInterceptorIterator)object).iterate(this.info, (short)1);
                }
                catch (UserException userException) {
                    if (userException instanceof ForwardRequest) {
                        ForwardRequest forwardRequest = (ForwardRequest)userException;
                        this.setLocationForward(new org.omg.PortableServer.ForwardRequest(forwardRequest.forward));
                    }
                }
                catch (SystemException systemException) {
                    this.setSystemException(systemException);
                }
                this.info = null;
            }
        }
    }

    public OutputStream createExceptionReply() {
        this.stream_based = true;
        this.status = 1;
        ServiceContext[] serviceContextArray = null;
        serviceContextArray = this.out != null ? this.out.getServiceContexts() : new ServiceContext[]{};
        this.out = new ReplyOutputStream(this.connection, serviceContextArray, this.requestId(), ReplyStatusType.USER_EXCEPTION, this.orb.hasServerRequestInterceptors());
        return this.out;
    }

    public OutputStream createReply() {
        this.stream_based = true;
        if (this.out != null) {
            throw new Error("Internal: reply already created!");
        }
        if (!this.stream_based) {
            throw new Error("Internal: ServerRequest not stream-based!");
        }
        this.out = new ReplyOutputStream(this.connection, new ServiceContext[0], this.requestId(), ReplyStatusType.NO_EXCEPTION, this.orb.hasServerRequestInterceptors());
        return this.out;
    }

    public Context ctx() {
        return null;
    }

    public Any except() {
        if (this.stream_based) {
            throw new RuntimeException("This ServerRequest is stream-based!");
        }
        return this.ex;
    }

    public byte[] getBuffer() {
        return this.in.getBuffer();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Object getForwardReference() {
        if (this.location_forward != null) {
            return this.location_forward.forward_reference;
        }
        return null;
    }

    public CDRInputStream getInputStream() {
        this.stream_based = true;
        return this.in;
    }

    public Object getReference() {
        return this.reference;
    }

    public ReplyOutputStream getReplyOutputStream() {
        if (this.out == null) {
            this.createReply();
        }
        this.stream_based = true;
        return this.out;
    }

    public ServiceContext[] getServiceContext() {
        return this.in.req_hdr.service_context;
    }

    public SystemException getSystemException() {
        return this.sys_ex;
    }

    public RequestInputStream get_in() {
        return this.in;
    }

    public ReplyOutputStream get_out() {
        if (this.out == null) {
            this.out = new ReplyOutputStream(this.connection, new ServiceContext[0], this.requestId(), ReplyStatusType.NO_EXCEPTION, this.orb.hasServerRequestInterceptors());
        }
        return this.out;
    }

    public byte[] objectId() {
        return this.oid;
    }

    public byte[] objectKey() {
        return this.in.req_hdr.object_key;
    }

    public String operation() {
        return this.in.req_hdr.operation;
    }

    public String[] remainingPOAName() {
        return this.rest_of_name;
    }

    public void reply() {
        block17: {
            block16: {
                if (!this.in.req_hdr.response_expected) break block16;
                Debug.output(6, "ServerRequest: reply to " + this.operation());
                try {
                    if (this.out == null) {
                        this.out = new ReplyOutputStream(this.connection, new ServiceContext[0], this.requestId(), ReplyStatusType.from_int(this.status), this.orb.hasServerRequestInterceptors());
                    }
                    if (!this.stream_based) {
                        if (this.status == 1) {
                            this.out.write_string(this.ex.type().id());
                            this.ex.write_value(this.out);
                        } else if (this.status == 0) {
                            this.result.write_value(this.out);
                            if (this.args != null) {
                                Enumeration enumeration = this.args.enumerate();
                                while (enumeration.hasMoreElements()) {
                                    NamedValue namedValue = (NamedValue)enumeration.nextElement();
                                    if (namedValue.flags() == 1) continue;
                                    try {
                                        namedValue.send(this.out);
                                    }
                                    catch (Exception exception) {
                                        throw new MARSHAL("Couldn't return (in)out arg of type " + namedValue.value().type() + " in ServerRequest.");
                                    }
                                }
                            }
                        }
                    }
                    if (this.status == 3) {
                        this.out.write_Object(this.location_forward.forward_reference);
                    } else if (this.status == 2) {
                        SystemExceptionHelper.write(this.out, this.sys_ex);
                    }
                    this.out.close();
                    ((ServerSideConnection)((java.lang.Object)this.connection)).sendReply(this.out);
                }
                catch (Exception exception) {
                    Debug.output(2, exception);
                    System.err.println("ServerRequest: Error replying to request!");
                }
                break block17;
            }
            if (!(this.connection instanceof ServerConnection)) break block17;
            try {
                ((ServerSideConnection)((java.lang.Object)this.connection)).sendReply(null);
            }
            catch (Exception exception) {
                Debug.output(2, exception);
                System.err.println("ServerRequest: Error replying to oneway HTTP request!");
            }
        }
    }

    public void reply(byte[] byArray) {
        this.reply(byArray, byArray.length);
    }

    public void reply(byte[] byArray, int n) {
        if (this.out == null) {
            this.out = new ReplyOutputStream(this.connection, new ServiceContext[0], this.requestId(), ReplyStatusType.from_int(this.status));
        }
        this.out.setBuffer(byArray);
        this.out.setGIOPRequestId(this.requestId());
        this.out.setSize(n);
        try {
            ((ServerSideConnection)((java.lang.Object)this.connection)).sendReply(this.out);
        }
        catch (Exception exception) {
            Debug.output(2, exception);
            exception.printStackTrace();
            System.out.println("ServerRequest: Error replying to request!");
        }
        this.in.req_hdr.response_expected = false;
    }

    public int requestId() {
        return this.in.req_hdr.request_id;
    }

    public boolean responseExpected() {
        return this.in.req_hdr.response_expected;
    }

    public Any result() {
        if (this.stream_based) {
            throw new RuntimeException("This ServerRequest is stream-based!");
        }
        return this.result;
    }

    public void setLocationForward(org.omg.PortableServer.ForwardRequest forwardRequest) {
        Debug.output(2, "Location Forward");
        this.status = 3;
        ServiceContext[] serviceContextArray = null;
        serviceContextArray = this.out != null ? this.out.getServiceContexts() : new ServiceContext[]{};
        this.out = new ReplyOutputStream(this.connection, serviceContextArray, this.requestId(), ReplyStatusType.LOCATION_FORWARD, this.orb.hasServerRequestInterceptors());
        this.location_forward = forwardRequest;
    }

    public void setReference(Object object) {
        this.reference = object;
    }

    public void setRemainingPOAName(String[] stringArray) {
        this.rest_of_name = stringArray;
    }

    public void setServerRequestInfo(ServerRequestInfoImpl serverRequestInfoImpl) {
        this.info = serverRequestInfoImpl;
    }

    public void setSystemException(SystemException systemException) {
        Debug.output(2, systemException);
        this.status = 2;
        ServiceContext[] serviceContextArray = null;
        serviceContextArray = this.out != null ? this.out.getServiceContexts() : new ServiceContext[]{};
        this.out = new ReplyOutputStream(this.connection, serviceContextArray, this.requestId(), ReplyStatusType.SYSTEM_EXCEPTION, this.orb.hasServerRequestInterceptors());
        this.sys_ex = systemException;
    }

    public void set_exception(Any any) {
        if (this.stream_based) {
            throw new RuntimeException("This ServerRequest is stream-based!");
        }
        this.ex = any;
        this.status = 1;
    }

    public void set_result(Any any) {
        if (this.stream_based) {
            throw new RuntimeException("This ServerRequest is stream-based!");
        }
        this.result = any;
    }

    public ReplyStatusType status() {
        return ReplyStatusType.from_int(this.status);
    }

    public boolean streamBased() {
        return this.stream_based;
    }

    public void updateBuffer(byte[] byArray) {
        RequestInputStream requestInputStream;
        this.in = requestInputStream = new RequestInputStream(this.connection, byArray);
    }
}

