package demo.ac;

import org.omg.CORBA.*;
import org.omg.CosNaming.*;
import jacorb.orb.domain.*;

import java.io.*;
/**
 * DomainSetup.java
 *
 *
 * Created: Wed Jul 12 14:22:22 2000
 *
 * @author Nicolas Noffke
 * @version
 */

public class DomainSetup 
{
    
    public static void main(String[] args) 
    {
        try
        {
            ORB orb = ORB.init(args, null);

            Domain dm = null;
            //            Domain orb_dm = null;
            if (args.length == 0)
            {
                dm = DomainHelper.narrow
                    (orb.resolve_initial_references("DomainService"));

//                  Domain[] childs = dm.getChilds();
//                  for (int i = 0; i < childs.length; i++)
//                      try
//                      {
//                          if (childs[i].description().startsWith("orb domain"))
//                              orb_dm = childs[i];
//                      }catch (COMM_FAILURE cf)
//                      {
//                          //ignore
//                      }
            }
            else
            {
                try
                {
                    BufferedReader f_in = new BufferedReader
                        (new FileReader(args[0]));
                    
                    dm = DomainHelper.narrow
                        (orb.string_to_object(f_in.readLine()));
                    
                    f_in.close();
                }catch (Exception e)
                {
                    e.printStackTrace();
                }
            }

            PropertyPolicy pp = dm.createPropertyPolicy();
            pp.name("AccessControl Policy");
            pp.put("AccessControl", "AccessAllowed");
            pp.setPolicyType(2);//SecTargetInvocationAccess
            
            Domain hype_inc = dm.createDomain(new org.omg.CORBA.Object[0], 
                                              new Policy[] {pp}, 
                                              "Hype Inc.");

            dm.insertChild(hype_inc);
            //outer.set_domain_policy(pp);


            pp = dm.createPropertyPolicy();
            pp.name("AccessControl Policy");
            pp.put("AccessControl", "AccessAllowed");
            pp.setPolicyType(2);//SecTargetInvocationAccess


            Domain e_branch = dm.createDomain(new org.omg.CORBA.Object[0], 
                                              new Policy[] {pp}, 
                                              "European Branch");

            hype_inc.insertChild(e_branch);

            Domain us_branch = dm.createDomain(new org.omg.CORBA.Object[0], 
                                               new Policy[0], 
                                               "US Branch");

            hype_inc.insertChild(us_branch);

            pp = dm.createPropertyPolicy();
            pp.name("AccessControl Policy");
            pp.put("AccessControl", "AccessDenied");
            pp.setPolicyType(2);//SecTargetInvocationAccess
            
            PropertyPolicy meta = dm.createMetaPropertyPolicy();
            meta.short_description("AccessControl Meta Policy");
            meta.put("ResolverClass", "demo.ac.BooleanConflictResolver");
            meta.put("Operation", "AND");
            meta.setPolicyType(200);

            Domain acc = dm.createDomain(new org.omg.CORBA.Object[0], 
                                         new Policy[] {pp, meta}, 
                                         "R&D");

            e_branch.insertChild(acc);
            //acc.insertChild(orb_dm);

            NamingContextExt nc = NamingContextExtHelper.narrow
                (orb.resolve_initial_references("NameService"));
            acc.insertMemberWithName("Braille Printer",
                                     nc.resolve(nc.to_name("grid.example")));

            pp = dm.createPropertyPolicy();
            pp.name("AccessControl Policy");
            pp.put("AccessControl", "AccessAllowed");
            pp.setPolicyType(2);//SecTargetInvocationAccess

            Domain sales = dm.createDomain(new org.omg.CORBA.Object[0], 
                                           new Policy[] {pp}, 
                                           "Sales");

            e_branch.insertChild(sales);                           
            orb.shutdown(true);
        }catch (Exception e)
        {
            e.printStackTrace();
        }
    }    
} // DomainSetup
