/*
 * Decompiled with CFR 0.152.
 */
package jacorb.trading.constraint;

import jacorb.trading.constraint.ExprNode;
import jacorb.trading.constraint.MissingPropertyException;
import jacorb.trading.constraint.PropertySource;
import jacorb.trading.constraint.Value;
import jacorb.trading.constraint.ValueFactory;
import jacorb.trading.constraint.ValueType;
import java.io.PrintStream;

public class EqNode
extends ExprNode {
    private ExprNode m_left;
    private ExprNode m_right;

    private EqNode() {
    }

    public EqNode(ExprNode exprNode, ExprNode exprNode2) {
        this.m_left = exprNode;
        this.m_right = exprNode2;
        this.setType(new ValueType(0));
    }

    public Value evaluate(PropertySource propertySource) throws MissingPropertyException {
        Value value = null;
        int n = ValueType.promote(this.m_left.getType().getId(), this.m_right.getType().getId());
        Value value2 = this.m_left.evaluate(propertySource);
        Value value3 = value2.convert(n);
        value2 = this.m_right.evaluate(propertySource);
        Value value4 = value2.convert(n);
        value = ValueFactory.createBoolean(value3.equals(value4));
        return value;
    }

    public void print(PrintStream printStream) {
        printStream.println("EqNode: type = " + this.getType());
        printStream.println("Left node:");
        this.m_left.print(printStream);
        printStream.println("Right node:");
        this.m_right.print(printStream);
    }
}

