/*
 * Decompiled with CFR 0.152.
 */
package jacorb.orb;

import jacorb.imr.ImRInfo;
import jacorb.imr.ImplementationRepository;
import jacorb.imr.ImplementationRepositoryImpl;
import jacorb.imr.Registration;
import jacorb.imr.RegistrationHelper;
import jacorb.orb.BasicAdapter;
import jacorb.orb.BufferManager;
import jacorb.orb.CDROutputStream;
import jacorb.orb.ConnectionManager;
import jacorb.orb.Current;
import jacorb.orb.Delegate;
import jacorb.orb.ORBSingleton;
import jacorb.orb.ParsedIOR;
import jacorb.orb.Reference;
import jacorb.orb.ServantDelegate;
import jacorb.orb.TypeCode;
import jacorb.orb.domain.Domain;
import jacorb.orb.domain.DomainHelper;
import jacorb.orb.domain.GraphNodePackage.ClosesCycle;
import jacorb.orb.domain.InvalidName;
import jacorb.orb.domain.NameAlreadyDefined;
import jacorb.orb.domain.ORBDomain;
import jacorb.orb.domain.ORBDomainHelper;
import jacorb.orb.domain.ORBDomainImpl;
import jacorb.orb.domain.ORBDomainPOATie;
import jacorb.orb.domain.PolicyFactoryHelper;
import jacorb.orb.domain.PolicyFactoryImpl;
import jacorb.orb.dynany.DynAnyFactoryImpl;
import jacorb.orb.portableInterceptor.CodecFactoryImpl;
import jacorb.orb.portableInterceptor.IORInfoImpl;
import jacorb.orb.portableInterceptor.InterceptorManager;
import jacorb.orb.portableInterceptor.ORBInitInfoImpl;
import jacorb.poa.POA;
import jacorb.poa.POAConstants;
import jacorb.poa.POAListener;
import jacorb.transaction.TransactionCurrentImpl;
import jacorb.util.Debug;
import jacorb.util.Environment;
import jacorb.util.ObjectUtil;
import java.applet.Applet;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.Request;
import org.omg.CORBA.ServiceInformationHolder;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosTrading.TraderComponentsHelper;
import org.omg.IIOP.ProfileBody_1_0;
import org.omg.IIOP.ProfileBody_1_0Helper;
import org.omg.IIOP.ProfileBody_1_1;
import org.omg.IIOP.ProfileBody_1_1Helper;
import org.omg.IIOP.Version;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.MultipleComponentProfileHelper;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedProfile;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;

public final class ORB
extends ORBSingleton
implements POAListener {
    private Hashtable initial_references = new Hashtable();
    private POA rootpoa;
    private jacorb.poa.Current poaCurrent;
    private BasicAdapter basicAdapter;
    private Current current;
    private org.omg.SecurityLevel2.Current securityCurrent = null;
    private InterceptorManager interceptor_manager = null;
    private Hashtable knownReferences = null;
    private ConnectionManager connectionManager;
    private BufferManager bufferManager = new BufferManager();
    private Properties _props;
    public String[] _args;
    protected Version IIOPVersion = new Version(1, 1);
    public Applet applet;
    private java.lang.Object orb_synch = new java.lang.Object();
    private boolean run = true;
    private boolean wait = true;
    private boolean shutdown_in_progress = false;
    private boolean destroyed = false;
    private java.lang.Object shutdown_synch = new java.lang.Object();
    private static boolean ORBDomainCreationInProgress = false;
    private Registration imr = null;
    private ImRInfo imr_info = null;
    private int persistentPOACount;
    public static String orb_id = "jacorb:1.0";
    private Hashtable policy_factories = null;
    private static TCKind kind;
    static /* synthetic */ Class class$org$omg$CORBA$ORB;

    public ORB() {
        this.connectionManager = new ConnectionManager(this);
        try {
            this.knownReferences = (Hashtable)Class.forName(Environment.getProperty("jacorb.hashtable_class")).newInstance();
        }
        catch (Exception exception) {
            Debug.output(514, exception);
            this.knownReferences = new Hashtable();
        }
    }

    synchronized Object _getObject(ParsedIOR parsedIOR) {
        Delegate delegate;
        String string = parsedIOR.getIORString();
        ObjectImpl objectImpl = (ObjectImpl)this.knownReferences.get(string);
        if (objectImpl != null) {
            Debug.output(5, "Found a reference for key " + string + " in cache ");
            delegate = (Delegate)objectImpl._get_delegate();
            if (delegate != null) {
                ParsedIOR parsedIOR2 = delegate.getParsedIOR();
                if (parsedIOR2 == null) {
                    this.knownReferences.remove(string);
                    Debug.output(4, "Removing an invalid reference from cache.");
                } else if (parsedIOR.getAddress().equals(parsedIOR2.getAddress())) {
                    return objectImpl._duplicate();
                }
            } else {
                Debug.output(3, "remove stale reference for key " + string + " from cache ");
                this.knownReferences.remove(string);
            }
        }
        delegate = new Delegate((org.omg.CORBA.ORB)this, parsedIOR);
        objectImpl = delegate.getReference(null);
        if (Environment.cacheReferences()) {
            Debug.output(5, "Caching reference for key " + string);
            this.knownReferences.put(string, objectImpl);
        }
        return objectImpl;
    }

    synchronized void _release(Delegate delegate) {
        this.knownReferences.remove(delegate.pior.getIORString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected IOR createIOR(String string, byte[] byArray, boolean bl, POA pOA) {
        java.lang.Object object;
        IDLEntity iDLEntity;
        boolean bl2 = false;
        TaggedProfile[] taggedProfileArray = null;
        String string2 = this.basicAdapter.getAddress();
        int n = this.basicAdapter.getPort();
        if (!bl && Environment.useImR()) {
            try {
                if (this.imr == null) {
                    ImplementationRepository implementationRepository = ImplementationRepositoryImpl.getImR(this);
                    this.imr = RegistrationHelper.narrow(implementationRepository);
                }
                if (this.imr_info == null) {
                    this.imr_info = this.imr.get_imr_info();
                }
                string2 = this.imr_info.host;
                n = this.imr_info.port;
                Debug.output(2, "New persistent IOR created with ImR at " + string2 + ":" + n);
            }
            catch (Exception exception) {
                Debug.output(6, exception);
            }
        }
        boolean bl3 = Environment.charsetUpdateMulti();
        TaggedComponent[] taggedComponentArray = null;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        if (this.interceptor_manager != null && this.interceptor_manager.hasIORInterceptors()) {
            iDLEntity = new IORInfoImpl(this, pOA, vector, vector2);
            try {
                this.interceptor_manager.getIORIterator().iterate((IORInfoImpl)iDLEntity);
            }
            catch (Exception exception) {
                Debug.output(2, exception);
            }
        }
        switch (this.IIOPVersion.minor) {
            case 1: {
                taggedComponentArray = new TaggedComponent[vector.size()];
                int n2 = 0;
                while (n2 < vector.size()) {
                    taggedComponentArray[n2] = (TaggedComponent)vector.elementAt(n2);
                    ++n2;
                }
                iDLEntity = new ProfileBody_1_1(this.IIOPVersion, string2, (short)n, byArray, taggedComponentArray);
                CDROutputStream cDROutputStream = new CDROutputStream(this);
                cDROutputStream.write_boolean(bl2);
                ProfileBody_1_1Helper.write(cDROutputStream, (ProfileBody_1_1)iDLEntity);
                taggedProfileArray = new TaggedProfile[bl3 ? 3 : 2];
                taggedProfileArray[1] = new TaggedProfile(0, cDROutputStream.getBufferCopy());
            }
            case 0: {
                object = new ProfileBody_1_0(new Version(1, 0), string2, (short)n, byArray);
                CDROutputStream cDROutputStream = new CDROutputStream(this);
                cDROutputStream.write_boolean(bl2);
                ProfileBody_1_0Helper.write(cDROutputStream, (ProfileBody_1_0)object);
                if (taggedProfileArray == null) {
                    taggedProfileArray = new TaggedProfile[bl3 ? 2 : 1];
                }
                taggedProfileArray[0] = new TaggedProfile(0, cDROutputStream.getBufferCopy());
                if (!bl3) break;
                taggedComponentArray = new TaggedComponent[vector2.size()];
                int n3 = 0;
                while (n3 < vector2.size()) {
                    taggedComponentArray[n3] = (TaggedComponent)vector2.elementAt(n3);
                    ++n3;
                }
                cDROutputStream = new CDROutputStream(this);
                cDROutputStream.write_boolean(bl2);
                MultipleComponentProfileHelper.write(cDROutputStream, taggedComponentArray);
                taggedProfileArray[taggedProfileArray.length - 1] = new TaggedProfile(1, cDROutputStream.getBufferCopy());
            }
        }
        iDLEntity = new IOR(string, taggedProfileArray);
        if (this.isApplet()) {
            try {
                object = new CDROutputStream(this);
                ((CDROutputStream)object).write_boolean(bl2);
                IORHelper.write((org.omg.CORBA.portable.OutputStream)object, (IOR)iDLEntity);
                byte[] byArray2 = ((CDROutputStream)object).getBufferCopy();
                StringBuffer stringBuffer = new StringBuffer("IOR:");
                int n4 = 0;
                while (n4 < byArray2.length) {
                    int n5 = byArray2[n4];
                    if (n5 < 0) {
                        n5 += 256;
                    }
                    int n6 = (n5 & 0xFF) / 16;
                    int n7 = (n5 & 0xFF) % 16;
                    int n8 = n6 < 10 ? 48 + n6 : 97 + (n6 - 10);
                    int n9 = n7 < 10 ? 48 + n7 : 97 + (n7 - 10);
                    stringBuffer.append((char)n8);
                    stringBuffer.append((char)n9);
                    ++n4;
                }
                String string3 = stringBuffer.toString();
                Debug.output(4, "ORB.createIOR, proxifying original ior " + iDLEntity.hashCode());
                IOR iOR = this.getConnectionManager().proxyfy(string3);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        return iDLEntity;
    }

    public ContextList create_context_list() {
        return null;
    }

    public org.omg.CORBA.Environment create_environment() {
        return null;
    }

    public org.omg.CORBA.portable.OutputStream create_output_stream() {
        return new CDROutputStream(this);
    }

    public Policy create_policy(int n, Any any) throws PolicyError {
        Integer n2 = new Integer(n);
        if (this.policy_factories == null || !this.policy_factories.containsKey(n2)) {
            throw new PolicyError();
        }
        PolicyFactory policyFactory = (PolicyFactory)this.policy_factories.get(n2);
        return policyFactory.create_policy(n, any);
    }

    public org.omg.CORBA.TypeCode create_struct_tc(String string, String string2, StructMember[] structMemberArray) {
        TypeCode typeCode = new TypeCode(15, string, string2, structMemberArray);
        typeCode.resolve_recursion(0, typeCode);
        return typeCode;
    }

    public org.omg.CORBA.TypeCode create_union_tc(String string, String string2, org.omg.CORBA.TypeCode typeCode, UnionMember[] unionMemberArray) {
        return new TypeCode(16, string, string2, typeCode, unionMemberArray);
    }

    public org.omg.CORBA.TypeCode create_wstring_tc(int n) {
        return new TypeCode(27, n);
    }

    public void destroy() {
        if (this.destroyed) {
            throw new OBJECT_NOT_EXIST();
        }
        if (this.run) {
            this.shutdown(true);
        }
        this.destroyed = true;
    }

    Applet getApplet() {
        return this.applet;
    }

    public BasicAdapter getBasicAdapter() {
        if (this.basicAdapter == null) {
            throw new RuntimeException("Adapters not initialized, call POA.init() first");
        }
        return this.basicAdapter;
    }

    public BufferManager getBufferManager() {
        return this.bufferManager;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public String getDefaultContextURLString() {
        if (this.applet == null) {
            return Environment.rootNsURL();
        }
        return String.valueOf(this.applet.getCodeBase().toString()) + "_JacORB_NS";
    }

    public InterceptorManager getInterceptorManager() {
        return this.interceptor_manager;
    }

    public jacorb.poa.Current getPOACurrent() {
        if (this.poaCurrent == null) {
            this.poaCurrent = jacorb.poa.Current._Current_init();
        }
        return this.poaCurrent;
    }

    public Object getReference(POA pOA, byte[] byArray, String string, boolean bl, BooleanHolder booleanHolder) {
        try {
            if (string == null) {
                string = "IDL:org.omg/CORBA/Object:1.0";
            }
            IOR iOR = this.createIOR(string, byArray, bl, pOA);
            Delegate delegate = new Delegate((org.omg.CORBA.ORB)this, iOR);
            ObjectImpl objectImpl = delegate.getReference(pOA);
            ParsedIOR parsedIOR = new ParsedIOR(iOR);
            Object object = (Object)this.knownReferences.get(parsedIOR.getIORString());
            if (object != null) {
                Debug.output(517, "ORB.getReference: returning cashed reference");
                booleanHolder.value = true;
                return object._duplicate();
            }
            if (Environment.cacheReferences()) {
                this.knownReferences.put(parsedIOR.getIORString(), objectImpl);
            }
            booleanHolder.value = false;
            return objectImpl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public POA getRootPOA() {
        if (this.rootpoa == null) {
            this.rootpoa = POA._POA_init(this);
            this.rootpoa._addPOAEventListener(this);
            this.basicAdapter = new BasicAdapter(this, this.rootpoa);
        }
        return this.rootpoa;
    }

    public org.omg.CORBA.Current get_current() {
        return this.current;
    }

    public Context get_default_context() {
        return null;
    }

    public Request get_next_response() {
        return null;
    }

    public boolean get_service_information(short s, ServiceInformationHolder serviceInformationHolder) {
        return false;
    }

    public boolean hasClientRequestInterceptors() {
        return this.interceptor_manager != null && this.interceptor_manager.hasClientRequestInterceptors();
    }

    public boolean hasPolicyFactoryForType(int n) {
        return this.policy_factories != null && this.policy_factories.containsKey(new Integer(n));
    }

    public boolean hasServerRequestInterceptors() {
        return this.interceptor_manager != null && this.interceptor_manager.hasServerRequestInterceptors();
    }

    private void initialReferencesInit() {
        try {
            java.lang.Object object;
            String string;
            java.lang.Object object2;
            if (!this.isApplet() && this._args != null) {
                int n = 0;
                while (n < this._args.length) {
                    if (this._args[n].equals("-ORBInitRef")) {
                        if (this._args[n + 1].indexOf("=") == -1) {
                            throw new org.omg.CORBA.ORBPackage.InvalidName();
                        }
                        object2 = this._args[n + 1].substring(0, this._args[n + 1].indexOf("="));
                        string = this._args[n + 1].substring(this._args[n + 1].indexOf("=") + 1);
                        object = this.string_to_object(string);
                        if (object != null) {
                            this.register_initial_reference((String)object2, (Object)object);
                        } else {
                            Debug.output(1, "Illegal URL : " + string);
                        }
                        ++n;
                    }
                    ++n;
                }
            }
            Hashtable hashtable = Environment.getProperties("ORBInitRef.");
            object2 = hashtable.keys();
            while (object2.hasMoreElements()) {
                string = (String)object2.nextElement();
                object = string.substring(string.indexOf(46) + 1);
                this.register_initial_reference((String)object, this.string_to_object((String)hashtable.get(string)));
                Debug.output(3, "ORBInitRef " + (String)object + " string: " + (String)hashtable.get(string));
            }
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName invalidName) {
            System.err.println("usage: -ORBInitRef <name>=<Object_URL>");
            System.exit(1);
        }
        catch (Exception exception) {
            Debug.output(3, exception);
        }
    }

    private void interceptorInit() {
        Vector vector = Environment.getORBInitializers();
        if (vector.size() > 0) {
            Serializable serializable;
            ORBInitInfoImpl oRBInitInfoImpl = new ORBInitInfoImpl(this);
            int n = 0;
            while (n < vector.size()) {
                try {
                    ORBInitializer oRBInitializer = (ORBInitializer)vector.elementAt(n);
                    oRBInitializer.pre_init(oRBInitInfoImpl);
                }
                catch (Exception exception) {
                    Debug.output(0, exception);
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < vector.size()) {
                try {
                    serializable = (ORBInitializer)vector.elementAt(n2);
                    serializable.post_init(oRBInitInfoImpl);
                }
                catch (Exception exception) {
                    Debug.output(0, exception);
                }
                ++n2;
            }
            oRBInitInfoImpl.setInvalid();
            serializable = oRBInitInfoImpl.getClientInterceptors();
            Vector vector2 = oRBInitInfoImpl.getServerInterceptors();
            Vector vector3 = oRBInitInfoImpl.getIORInterceptors();
            if (vector2.size() > 0 || ((Vector)serializable).size() > 0 || vector3.size() > 0) {
                this.interceptor_manager = new InterceptorManager((Vector)serializable, vector2, vector3, oRBInitInfoImpl.getSlotCount(), this);
                Enumeration enumeration = this.knownReferences.elements();
                while (enumeration.hasMoreElements()) {
                    Reference reference = (Reference)enumeration.nextElement();
                    if (reference == null) continue;
                    ((Delegate)reference._get_delegate()).initInterceptors();
                }
            }
            this.policy_factories = oRBInitInfoImpl.getPolicyFactories();
        }
    }

    public boolean isApplet() {
        return this.applet != null;
    }

    public String[] list_initial_services() {
        String[] stringArray = new String[]{"NameService", "TradingService", "RootPOA", "POACurrent", "DynAnyFactory", "DomainService", "LocalDomainService", "PICurrent", "CodecFactory", "TransactionCurrent"};
        return stringArray;
    }

    public void mountORBDomain() {
        this.mountORBDomain("orb domain");
    }

    public void mountORBDomain(String string) {
        Domain domain = null;
        Domain domain2 = null;
        try {
            domain = DomainHelper.narrow(this.resolve_initial_references("DomainService"));
            domain2 = DomainHelper.narrow(this.resolve_initial_references("LocalDomainService"));
            if (string == null || string.equals("")) {
                string = "orb domain";
            }
            if (domain.hasChild(domain2)) {
                Debug.output(2, "ORB.mountORBDomain: rename from \"" + domain2.name() + "\" to \"" + string + "\".");
                domain.renameChildDomain(domain2.name(), string);
                domain2.name(string);
                return;
            }
            domain2.name(string);
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName invalidName) {
            Debug.output(1, invalidName);
        }
        catch (NameAlreadyDefined nameAlreadyDefined) {
            return;
        }
        catch (InvalidName invalidName) {
            return;
        }
        int n = 0;
        while (true) {
            try {
                domain.insertChild(domain2);
                return;
            }
            catch (ClosesCycle closesCycle) {
                Debug.output(1, closesCycle);
                return;
            }
            catch (NameAlreadyDefined nameAlreadyDefined) {
                Debug.output(1, "ORB.mountORBDomain: name " + nameAlreadyDefined.name + " already used in domain server scope");
                domain2.name(String.valueOf(string) + "#" + Integer.toString(++n));
                continue;
            }
            break;
        }
    }

    public String object_to_string(Object object) {
        return object.toString();
    }

    public void perform_work() {
    }

    public void poaCreated(POA pOA) {
        block6: {
            java.lang.Object object;
            pOA._addPOAEventListener(this);
            if (!pOA.isPersistent()) break block6;
            ++this.persistentPOACount;
            if (this.imr == null && Environment.useImR()) {
                object = ImplementationRepositoryImpl.getImR(this);
                this.imr = RegistrationHelper.narrow((Object)object);
                if (this.imr == null || this.imr._non_existent()) {
                    Debug.output(3, "No connection to ImplementationRepository");
                    return;
                }
            }
            if (this.imr != null) {
                try {
                    object = new String(Environment.implName());
                    this.imr.register_poa(String.valueOf(object) + "/" + pOA._getQualifiedName(), (String)object, this.basicAdapter.getAddress(), this.basicAdapter.getPort());
                }
                catch (UserException userException) {
                    Debug.output(1, userException);
                }
                catch (Exception exception) {
                    Debug.output(4, exception);
                }
            }
        }
    }

    public void poaStateChanged(POA pOA, int n) {
        block2: {
            if (n != POAConstants.DESTROYED && n != POAConstants.INACTIVE || !pOA.isPersistent() || this.imr == null || --this.persistentPOACount != 0) break block2;
            try {
                this.imr.set_server_down(new String(Environment.implName()));
            }
            catch (Exception exception) {
                Debug.output(2, exception);
            }
        }
    }

    public boolean poll_next_response() {
        return false;
    }

    public void referenceCreated(Object object) {
    }

    public void register_initial_reference(String string, Object object) throws org.omg.CORBA.ORBPackage.InvalidName {
        if (string == null || string.length() == 0 || this.initial_references.containsKey(string)) {
            throw new org.omg.CORBA.ORBPackage.InvalidName();
        }
        this.initial_references.put(string, object);
    }

    public Object resolve_initial_references(String string) throws org.omg.CORBA.ORBPackage.InvalidName {
        if (this.isApplet()) {
            this.getConnectionManager().initProxy();
        }
        if (this.initial_references.containsKey(string)) {
            return (Object)this.initial_references.get(string);
        }
        IDLEntity iDLEntity = null;
        if (string.equals("NameService")) {
            String string2 = null;
            String string3 = Environment.rootNsURL();
            string2 = string3 == null ? ObjectUtil.readURL("http://" + this.applet.getCodeBase().getHost() + "/" + "NameService.ior") : (string3.indexOf(":", 4) < 0 ? ObjectUtil.readURL("http://" + this.applet.getCodeBase().getHost() + "/" + string3) : ObjectUtil.readURL(string3));
            iDLEntity = NamingContextHelper.narrow(this.string_to_object(string2));
        } else if (string.equals("TradingService")) {
            String string4 = ObjectUtil.readURL(Environment.tradingServiceURL());
            iDLEntity = TraderComponentsHelper.narrow(this.string_to_object(string4));
        } else {
            if (string.equals("RootPOA")) {
                return this.getRootPOA();
            }
            if (string.equals("POACurrent")) {
                return this.getPOACurrent();
            }
            if (string.equals("DomainService")) {
                if (!Environment.useDomain()) {
                    throw new org.omg.CORBA.ORBPackage.InvalidName("domain service is not configured for usage. To configure domain service set property \"jacorb.use_domain\" to \"on\".");
                }
                String string5 = ObjectUtil.readURL(Environment.DomainServiceURL());
                iDLEntity = DomainHelper.narrow(this.string_to_object(string5));
            } else if (string.equals("LocalDomainService")) {
                java.lang.Object object;
                java.lang.Object object2;
                java.lang.Object object3;
                if (!Environment.useDomain()) {
                    throw new org.omg.CORBA.ORBPackage.InvalidName("domain service is not configured for usage. To configure domain service set property \"jacorb.use_domain\" to \"on\".");
                }
                ORBDomain oRBDomain = null;
                if (ORBDomainCreationInProgress) {
                    throw new org.omg.CORBA.ORBPackage.InvalidName("second call");
                }
                ORBDomainCreationInProgress = true;
                try {
                    object3 = new PolicyFactoryImpl();
                    try {
                        this.getRootPOA().the_POAManager().activate();
                    }
                    catch (AdapterInactive adapterInactive) {
                        Debug.output(1, adapterInactive);
                    }
                    object2 = PolicyFactoryHelper.narrow(this.getRootPOA().servant_to_reference((Servant)object3));
                    object = new Policy[]{object2.createConflictResolutionPolicy((short)2)};
                    ORBDomainImpl oRBDomainImpl = new ORBDomainImpl(null, (Policy[])object, "orb domain");
                    ORBDomainPOATie oRBDomainPOATie = new ORBDomainPOATie(oRBDomainImpl);
                    oRBDomainImpl.setTie(oRBDomainPOATie);
                    oRBDomain = ORBDomainHelper.narrow(this.getRootPOA().servant_to_reference(oRBDomainPOATie));
                    iDLEntity = oRBDomain;
                    ORBDomainCreationInProgress = false;
                    oRBDomain.insertLocalDomain(oRBDomain);
                }
                catch (WrongPolicy wrongPolicy) {
                    Debug.output(1, "the root poa of this orb has the wrong policies for \"servant_to_reference\".");
                }
                catch (ServantNotActive servantNotActive) {
                    Debug.output(1, servantNotActive);
                }
                if (Environment.mountORBDomain()) {
                    this.initial_references.put(string, iDLEntity);
                    this.mountORBDomain();
                }
                if ((object3 = Environment.ORBDomainFilename()) != null && !((String)object3).equals("")) {
                    Debug.output(32770, "writing IOR of local domain service to file " + (String)object3);
                    try {
                        object2 = new FileOutputStream((String)object3);
                        object = new PrintWriter((OutputStream)object2);
                        ((PrintWriter)object).println(this.object_to_string(oRBDomain));
                        ((PrintWriter)object).flush();
                        ((FileOutputStream)object2).close();
                    }
                    catch (IOException iOException) {
                        Debug.output(1, "Unable to write IOR to file " + (String)object3);
                    }
                }
            } else if (string.equals("SecurityCurrent")) {
                if (this.securityCurrent == null) {
                    try {
                        Class<?> clazz = Class.forName("jacorb.security.level2.CurrentImpl");
                        Constructor<?> constructor = clazz.getConstructor(class$org$omg$CORBA$ORB != null ? class$org$omg$CORBA$ORB : (class$org$omg$CORBA$ORB = ORB.class$("org.omg.CORBA.ORB")));
                        this.securityCurrent = (org.omg.SecurityLevel2.Current)constructor.newInstance(this);
                    }
                    catch (Exception exception) {
                        Debug.output(513, exception);
                    }
                    iDLEntity = this.securityCurrent;
                }
            } else if (string.equals("DynAnyFactory")) {
                iDLEntity = new DynAnyFactoryImpl(this)._this();
            } else {
                if (string.equals("PICurrent")) {
                    if (this.interceptor_manager == null) {
                        return InterceptorManager.EMPTY_CURRENT;
                    }
                    return this.interceptor_manager.getCurrent();
                }
                if (string.equals("CodecFactory")) {
                    iDLEntity = new CodecFactoryImpl(this);
                } else if (string.equals("TransactionCurrent")) {
                    iDLEntity = new TransactionCurrentImpl();
                } else {
                    throw new org.omg.CORBA.ORBPackage.InvalidName();
                }
            }
        }
        if (iDLEntity != null) {
            this.initial_references.put(string, iDLEntity);
            return iDLEntity;
        }
        return null;
    }

    public void run() {
        Debug.output(4, "ORB run");
        try {
            java.lang.Object object = this.orb_synch;
            synchronized (object) {
                while (this.run) {
                    this.orb_synch.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        Debug.output(4, "ORB run, exit");
    }

    public void send_multiple_requests_deferred(Request[] requestArray) {
    }

    public void send_multiple_requests_oneway(Request[] requestArray) {
    }

    public void set_delegate(java.lang.Object object) {
        if (!(object instanceof Servant)) {
            throw new BAD_PARAM("Argument must be of type org.omg.PortableServer.Servant");
        }
        ServantDelegate servantDelegate = new ServantDelegate(this);
        ((Servant)object)._set_delegate(servantDelegate);
    }

    protected void set_parameters(Applet applet, Properties properties) {
        this.applet = applet;
        this._props = properties;
        Environment.addProperties(properties);
        this.initialReferencesInit();
        this.interceptorInit();
    }

    protected void set_parameters(String[] stringArray, Properties properties) {
        this._args = stringArray;
        this._props = properties;
        Environment.addProperties(properties);
        this.initialReferencesInit();
        this.interceptorInit();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown(boolean bl) {
        Debug.output(2, "prepare ORB for going down...");
        java.lang.Object object = this.shutdown_synch;
        synchronized (object) {
            Debug.output(2, "ORB going down...");
            if (this.shutdown_in_progress && bl) {
                java.lang.Object object2 = this.shutdown_synch;
                synchronized (object2) {
                    try {
                        this.shutdown_synch.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    Debug.output(2, "ORB shutdown complete (1)");
                    return;
                }
            }
            if (this.shutdown_in_progress && !bl) {
                Debug.output(2, "ORB shutdown complete (2)");
                return;
            }
            this.shutdown_in_progress = true;
        }
        if (this.rootpoa != null) {
            this.rootpoa.destroy(true, bl);
        }
        Debug.output(3, "ORB shutdown (cleaning up ORB...)");
        this.connectionManager.shutdown();
        this.knownReferences.clear();
        this.bufferManager.release();
        Debug.output(3, "ORB shutdown (all tables cleared)");
        object = this.shutdown_synch;
        synchronized (object) {
            this.shutdown_synch.notifyAll();
        }
        Debug.output(3, "ORB shutdown (threads notified)");
        object = this.orb_synch;
        synchronized (object) {
            this.run = false;
            this.orb_synch.notifyAll();
        }
        Debug.output(2, "ORB shutdown complete");
    }

    public Object string_to_object(String string) {
        if (string == null) {
            return null;
        }
        ParsedIOR parsedIOR = new ParsedIOR(string);
        if (parsedIOR.isNull()) {
            return null;
        }
        return this._getObject(parsedIOR);
    }

    IOR unproxyfy(IOR iOR) {
        return this.getConnectionManager().unproxyfy(iOR);
    }

    public void useProxy() {
        this.applet = new Applet();
    }

    public boolean work_pending() {
        return false;
    }
}

