/*
 * Decompiled with CFR 0.152.
 */
package jacorb.imr;

import jacorb.imr.HostInfo;
import jacorb.imr.ServerStartupDaemon;
import jacorb.imr.ServerStartupDaemonHelper;
import jacorb.imr.ServerStartupFailed;
import jacorb.orb.ORB;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ImRHostInfo
implements Serializable {
    protected String host;
    private ServerStartupDaemon ssd_ref;
    private String object_string;
    private boolean reconnect = false;

    public ImRHostInfo(HostInfo hostInfo) {
        this.host = hostInfo.name;
        this.ssd_ref = hostInfo.ssd_ref;
        this.object_string = hostInfo.ior_string;
    }

    public void startServer(String string, ORB oRB) throws ServerStartupFailed {
        if (this.reconnect) {
            this.ssd_ref = ServerStartupDaemonHelper.narrow(oRB.string_to_object(this.object_string));
        }
        this.ssd_ref.start_server(string);
    }

    public HostInfo toHostInfo() {
        return new HostInfo(this.host, null, this.object_string);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.reconnect = true;
        objectOutputStream.defaultWriteObject();
    }
}

